/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.WsConst;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;

public class TileImages
implements WsConst {
    private static final String[] h = new String[]{"            ", "            ", "jjjjjjjjjjjj", "            ", "xxxxxxxxxxxx", "............", "xxxxxxxxxxxx", "            ", "jjjjjjjjjjjj", "            ", "            ", "            "};
    private static final String[] v = new String[]{"  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] hCross = new String[]{"            ", "            ", "jjjjjj   jjj", "            ", "xxxxxx   xxx", "......   ...", "xxxxxx   xxx", "            ", "jjjjjj   jjj", "            ", "            ", "            "};
    private static final String[] vCross = new String[]{"  j x.x j   ", "  j x.x j   ", "   j x.x j  ", "    j x.x j ", "    j x.x j ", "    j x.x j ", "    j x.x j ", "    j x.x j ", "   j x.x j  ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] right2down = new String[]{"            ", "            ", "        jjjj", "       j    ", "      j  xxx", "     j xx...", "    j x..xxx", "   j x..x   ", "   j x.x jjj", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] right2up = new String[]{"  j x.x j   ", "  j x.x j   ", "   j x.x jjj", "   j x..x   ", "    j x..xxx", "     j xx...", "      j  xxx", "       jj   ", "         jjj", "            ", "            ", "            "};
    private static final String[] left2down = new String[]{"            ", "            ", "jj          ", "  jj        ", "xx  j       ", "..xx j      ", "xx..x j     ", "  x..x j    ", "jj x.x j    ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] left2up = new String[]{"  j x.x j   ", "  j x.x j   ", "jj x.x j    ", "  x..x j    ", "xx..x j     ", "..xx j      ", "xx  j       ", "  jj        ", "jj          ", "            ", "            ", "            "};
    private static final String[] stubSource = new String[]{"    jjjjj   ", "   j     j  ", "jjj xxxxx j ", "   x.....x j", "xxxx.....x j", ".........x j", "xxxx.....x j", "   x.....x j", "jjj xxxxx j ", "   j     j  ", "    jjjjj   ", "            "};
    private static final String[] stubTarget = new String[]{"   jjjjj    ", "  j     j   ", " j xxxxx jjj", "j x.....x   ", "j x.....xxxx", "j x.........", "j x.....xxxx", "j x.....x   ", " j xxxxx jjj", "  j     j   ", "   jjjjj    ", "            "};
    private static Wimages tiles;
    private static Wimages greenTiles;
    private static Wimages selectedTiles;
    private static final ImageDecoder stdImageDecoder;
    private static final ImageDecoder highlightImageDecoder;
    private static final Map hlWimagesMap;
    private static final BColor[] hlColors;

    public static Wimages get(int n, int n2, boolean bl) {
        if (tiles == null) {
            TileImages.loadDefaults();
        }
        Wimages wimages = bl ? selectedTiles : (n == 1 ? greenTiles : tiles);
        if (n2 > -1) {
            wimages = new CompositeWimages(TileImages.getHighlightWimages(n2), wimages);
        }
        return wimages;
    }

    private static final void loadDefaults() {
        tiles = TileImages.makeWimages(stdImageDecoder, BColor.make((int)64, (int)64, (int)64), BColor.make((int)128, (int)128, (int)128));
        greenTiles = TileImages.makeWimages(stdImageDecoder, BColor.make((int)0, (int)128, (int)0), BColor.make((int)0, (int)200, (int)0));
        selectedTiles = tiles.makeHighlighted();
    }

    private static final Wimages getHighlightWimages(int n) {
        Integer n2;
        Wimages wimages;
        if (n >= hlColors.length) {
            n %= hlColors.length;
        }
        if ((wimages = (Wimages)hlWimagesMap.get(n2 = new Integer(n))) == null) {
            wimages = TileImages.makeWimages(highlightImageDecoder, hlColors[n]);
            hlWimagesMap.put(n2, wimages);
        }
        return wimages;
    }

    private static final Wimages makeWimages(ImageDecoder imageDecoder, BColor bColor) {
        return TileImages.makeWimages(imageDecoder, bColor, BColor.white);
    }

    private static final Wimages makeWimages(ImageDecoder imageDecoder, BColor bColor, BColor bColor2) {
        BImage[] bImageArray = new BImage[11];
        bImageArray[1] = imageDecoder.make(h, bColor, bColor2);
        bImageArray[2] = imageDecoder.make(v, bColor, bColor2);
        bImageArray[3] = imageDecoder.make(stubTarget, bColor, bColor2);
        bImageArray[4] = imageDecoder.make(stubSource, bColor, bColor2);
        bImageArray[5] = imageDecoder.make(hCross, bColor, bColor2);
        bImageArray[6] = imageDecoder.make(vCross, bColor, bColor2);
        bImageArray[7] = imageDecoder.make(left2up, bColor, bColor2);
        bImageArray[8] = imageDecoder.make(left2down, bColor, bColor2);
        bImageArray[9] = imageDecoder.make(right2up, bColor, bColor2);
        bImageArray[10] = imageDecoder.make(right2down, bColor, bColor2);
        return new StdWimages(bImageArray);
    }

    private static final BColor loadColor(int n, BColor bColor) {
        return BColor.make((String)System.getProperty("niagara.wiresheet.linkHighlightColor" + n, bColor.toHtmlString()));
    }

    static {
        stdImageDecoder = new StdImageDecoder();
        highlightImageDecoder = new HighlightImageDecoder();
        hlWimagesMap = new HashMap();
        hlColors = new BColor[]{TileImages.loadColor(1, WsConst.selectionFg), TileImages.loadColor(2, BColor.green), TileImages.loadColor(3, BColor.purple), TileImages.loadColor(4, BColor.orange), TileImages.loadColor(5, BColor.blue), TileImages.loadColor(6, BColor.brown), TileImages.loadColor(7, BColor.magenta), TileImages.loadColor(8, BColor.midnightBlue), TileImages.loadColor(9, BColor.darkGreen), TileImages.loadColor(10, BColor.darkOrange), TileImages.loadColor(11, BColor.darkGoldenrod), TileImages.loadColor(12, BColor.indigo), TileImages.loadColor(13, BColor.cadetBlue), TileImages.loadColor(14, BColor.grey), TileImages.loadColor(15, BColor.peru), TileImages.loadColor(16, BColor.darkKhaki), TileImages.loadColor(17, BColor.firebrick), TileImages.loadColor(18, BColor.black), TileImages.loadColor(19, BColor.hotPink), TileImages.loadColor(20, BColor.slateBlue)};
    }

    private static final class CompositeWimages
    extends Wimages {
        private Wimages wimgs1;
        private Wimages wimgs2;

        public final void paint(Graphics graphics, int n, int n2, double d, double d2) {
            this.wimgs1.paint(graphics, n, n2, d, d2);
            this.wimgs2.paint(graphics, n, n2, d, d2);
        }

        protected final Wimages makeHighlighted() {
            return new CompositeWimages(this.wimgs1, this.wimgs2.makeHighlighted());
        }

        private CompositeWimages(Wimages wimages, Wimages wimages2) {
            this.wimgs1 = wimages;
            this.wimgs2 = wimages2;
        }
    }

    public static abstract class Wimages {
        public abstract void paint(Graphics var1, int var2, int var3, double var4, double var6);

        protected abstract Wimages makeHighlighted();

        protected Wimages() {
        }
    }

    private static abstract class ImageDecoder {
        abstract BImage make(String[] var1, BColor var2, BColor var3);

        private ImageDecoder() {
        }
    }

    private static final class StdWimages
    extends Wimages {
        private BImage[] imgs;

        public final void paint(Graphics graphics, int n, int n2, double d, double d2) {
            BImage bImage = this.imgs[n2].transform(BTransform.makeScale((double)((double)n / 12.0), (double)((double)n / 12.0)));
            graphics.drawImage(bImage, d, d2);
        }

        protected final Wimages makeHighlighted() {
            BImage[] bImageArray = new BImage[this.imgs.length];
            int n = 1;
            while (n < bImageArray.length) {
                bImageArray[n] = this.imgs[n].getHighlightedImage();
                ++n;
            }
            return new StdWimages(bImageArray);
        }

        private StdWimages(BImage[] bImageArray) {
            this.imgs = bImageArray;
        }
    }

    private static class StdImageDecoder
    extends ImageDecoder {
        BImage make(String[] stringArray, BColor bColor, BColor bColor2) {
            BImage bImage = BImage.make((double)12.0, (double)12.0);
            Graphics graphics = bImage.getGraphics();
            int n = 0;
            while (n < 12) {
                int n2 = 0;
                while (n2 < 12) {
                    char c = stringArray[n2].charAt(n);
                    if (c != ' ' && c != 'j') {
                        BColor bColor3 = c == 'x' ? bColor : bColor2;
                        graphics.setBrush(bColor3);
                        graphics.strokeLine((double)n, (double)n2, (double)n, (double)n2);
                    }
                    ++n2;
                }
                ++n;
            }
            graphics.dispose();
            return bImage;
        }

        private StdImageDecoder() {
        }
    }

    private static class HighlightImageDecoder
    extends ImageDecoder {
        BImage make(String[] stringArray, BColor bColor, BColor bColor2) {
            BImage bImage = BImage.make((double)12.0, (double)12.0);
            Graphics graphics = bImage.getGraphics();
            graphics.setBrush(bColor);
            int n = 0;
            while (n < 12) {
                int n2 = 0;
                while (n2 < 12) {
                    char c = stringArray[n2].charAt(n);
                    if (c == 'j') {
                        graphics.strokeLine((double)n, (double)n2, (double)n, (double)n2);
                    }
                    ++n2;
                }
                ++n;
            }
            graphics.dispose();
            return bImage;
        }

        private HighlightImageDecoder() {
        }
    }
}

