/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsPrinting;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.BWsTextBlock;

public class TextBlockGlyph
extends ComponentGlyph {
    String[] text;
    BColor fg;
    BColor bg;
    BFont font;
    boolean border;
    boolean hasText;

    public boolean isSelectable() {
        return ((BWsTextBlock)this.component).getSelectable();
    }

    protected void fillGrid() {
        if (this.isSelectable()) {
            super.fillGrid();
        }
    }

    protected void doLayout(Glyph[] glyphArray) {
        this.setWixelBounds(this.p, this.q, this.ww, this.wh);
    }

    public void paint(Graphics graphics) {
        if (this.bg.getAlpha() == 0 && !this.hasText && !this.border) {
            graphics.setBrush(WsConst.hatchFg);
            graphics.strokeRect(0.0, 0.0, (double)(this.pw - 1), (double)(this.ph - 1));
            PaintUtil.fillHatched((Graphics)graphics, (int)0, (int)0, (int)this.pw, (int)this.ph);
            return;
        }
        graphics.setBrush(this.bg);
        graphics.fillRect(0.0, 0.0, (double)this.pw, (double)this.ph);
        graphics.setBrush(this.fg);
        if (this.border) {
            graphics.strokeRect(0.0, 0.0, (double)(this.pw - 1), (double)(this.ph - 1));
        }
        double d = this.font.getSize() - this.font.getSize() * ((12.0 - (double)this.ws.grid.wixel) / 12.0);
        BFont bFont = WsController.getFont(this.font, (int)d);
        graphics.setFont(bFont);
        double d2 = bFont.getHeight();
        double d3 = Math.max(0.0, ((double)this.ph - d2 * (double)this.text.length) / (double)2) + d2 - bFont.getDescent();
        int n = 0;
        while (n < this.text.length) {
            graphics.drawString(this.text[n], (double)5, d3);
            d3 += d2;
            ++n;
        }
    }

    public void paintSelection(Graphics graphics) {
        double d = this.pw;
        double d2 = this.ph;
        WiresheetTheme wiresheetTheme = Theme.wiresheet();
        graphics.setBrush(wiresheetTheme.glyph().getSelectionForeground((IStylable)this));
        graphics.strokeRect(-1.0, -1.0, d + 1.0, d2 + 1.0);
        graphics.fillRect(-3.0, -3.0, (double)5, (double)5);
        graphics.fillRect(d - (double)2, -3.0, (double)5, (double)5);
        graphics.fillRect(-3.0, d2 - (double)2, (double)5, (double)5);
        graphics.fillRect(d - (double)2, d2 - (double)2, (double)5, (double)5);
        graphics.setBrush(wiresheetTheme.glyph().getSelectionBackground((IStylable)this));
        graphics.strokeRect(-4.0, -4.0, 6.0, 6.0);
        graphics.strokeRect(d - (double)3, -4.0, 6.0, 6.0);
        graphics.strokeRect(-4.0, d2 - (double)3, 6.0, 6.0);
        graphics.strokeRect(d - (double)3, d2 - (double)3, 6.0, 6.0);
    }

    public ResizeZone getResizeAt(double d, double d2) {
        return ResizeZone.make(this, d, d2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print(WsPrinting wsPrinting) {
        block7: {
            block6: {
                Graphics graphics = wsPrinting.graphics;
                double d = (double)this.ww * wsPrinting.wixel;
                double d2 = (double)this.wh * wsPrinting.wixel;
                wsPrinting.graphics.push();
                try {
                    wsPrinting.graphics.clip(0.0, 0.0, d - 1.0, d2 - 1.0);
                    if (this.border) {
                        graphics.strokeRect(0.0, 0.0, d - 1.0, d2 - 1.0);
                    }
                    if (!this.hasText) {
                        Object var8_5 = null;
                        break block6;
                    }
                    double d3 = this.font.getHeight();
                    double d4 = Math.max(0.0, (d2 - d3 * (double)this.text.length) / (double)2) + d3 - this.font.getDescent();
                    int n = 0;
                    while (n < this.text.length) {
                        graphics.setBrush(this.fg.isNull() ? BColor.black : this.fg);
                        graphics.setFont(this.font);
                        graphics.drawString(this.text[n], (double)5, d4 - d3 + this.font.getAscent());
                        d4 += d3;
                        ++n;
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    wsPrinting.graphics.pop();
                    throw throwable;
                }
            }
            wsPrinting.graphics.pop();
            return;
        }
        Object var8_7 = null;
        wsPrinting.graphics.pop();
    }

    public void changed(String string) {
        super.changed(string);
        this.mapConfig();
        this.repaint();
    }

    private final void mapConfig() {
        try {
            BWsTextBlock bWsTextBlock = (BWsTextBlock)this.component;
            this.text = TextUtil.splitAndTrim((String)bWsTextBlock.getText(), (char)'\n');
            this.hasText = false;
            int n = 0;
            while (n < this.text.length) {
                if (this.text[n].length() > 0) {
                    this.hasText = true;
                    break;
                }
                ++n;
            }
            this.border = bWsTextBlock.getBorder();
            this.fg = BColor.make((String)bWsTextBlock.getForeground());
            this.bg = BColor.make((String)bWsTextBlock.getBackground());
            this.font = (BFont)BFont.DEFAULT.decodeFromString(bWsTextBlock.getFont());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BWsAnnotation toAnnotation() {
        return BWsAnnotation.make((int)this.p, (int)this.q, (int)this.ww, (int)this.wh);
    }

    public TextBlockGlyph(BWireSheetPane bWireSheetPane, BComponent bComponent, BWsAnnotation bWsAnnotation) {
        super(bWireSheetPane, bComponent, bWsAnnotation);
        this.mapConfig();
    }
}

