/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.FooterBarGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.PropertyBarGlyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.TitleBarGlyph;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.WsSelectedState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BWsAnnotation;
import javax.baja.wiresheet.BWireSheet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StdComponentGlyph
extends ComponentGlyph {
    final TitleBarGlyph titleBar;
    final FooterBarGlyph footerBar;
    private HashMap slotBars;
    private boolean autoCalcWixelWidth;
    private int selectionIndex;

    public Slot[] getPotentialSlots(boolean bl) {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        SlotCursor slotCursor = this.component.loadSlots().getSlots();
        while (slotCursor.next()) {
            BObject bObject;
            Slot slot = slotCursor.slot();
            if (Flags.isHidden((BComplex)this.component, (Slot)slot) || slot.isProperty() && ((bObject = slotCursor.get()).isComponent() && !(bObject instanceof BVector) || !bl && bObject instanceof BLink)) continue;
            arrayList.add(slot);
        }
        return arrayList.toArray(new Slot[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SlotBarGlyph addSlotBar(Slot slot) {
        HashMap hashMap = this.slotBars;
        synchronized (hashMap) {
            SlotBarGlyph slotBarGlyph = (SlotBarGlyph)this.slotBars.get(slot.getName());
            if (slotBarGlyph == null) {
                slotBarGlyph = SlotBarGlyph.make(this.ws, this, this.component, slot);
                this.slotBars.put(slot.getName(), slotBarGlyph);
                this.add(slotBarGlyph);
            }
            return slotBarGlyph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SlotBarGlyph getVisibleSlotBar(String string) {
        HashMap hashMap = this.slotBars;
        synchronized (hashMap) {
            SlotBarGlyph slotBarGlyph = (SlotBarGlyph)this.slotBars.get(string);
            if (slotBarGlyph != null) {
                slotBarGlyph.visible = true;
            }
            return slotBarGlyph;
        }
    }

    public void loadLinks() {
        super.loadLinks();
        Iterator iterator = this.slotBars.values().iterator();
        while (iterator.hasNext()) {
            SlotBarGlyph slotBarGlyph = (SlotBarGlyph)iterator.next();
            if (!(slotBarGlyph instanceof PropertyBarGlyph)) continue;
            PropertyBarGlyph propertyBarGlyph = (PropertyBarGlyph)slotBarGlyph;
            if (!propertyBarGlyph.isLink || propertyBarGlyph.linkGlyph != null) continue;
            BLink bLink = (BLink)this.component.get(propertyBarGlyph.property);
            propertyBarGlyph.linkGlyph = this.ws.controller.addLinkGlyph(this, bLink);
        }
    }

    public void loadKnobs() {
        super.loadKnobs();
        Iterator iterator = this.slotBars.values().iterator();
        while (iterator.hasNext()) {
            SlotBarGlyph slotBarGlyph = (SlotBarGlyph)iterator.next();
            Knob[] knobArray = this.component.getKnobs(slotBarGlyph.slot);
            int n = 0;
            while (n < knobArray.length) {
                this.ws.controller.addKnobGlyph(this, knobArray[n]);
                ++n;
            }
        }
    }

    public void checkForSubscribe(BWireSheet bWireSheet, Array array) {
        super.checkForSubscribe(bWireSheet, array);
        Iterator iterator = this.slotBars.values().iterator();
        while (iterator.hasNext()) {
            BComponent bComponent;
            SlotBarGlyph slotBarGlyph = (SlotBarGlyph)iterator.next();
            if (!slotBarGlyph.visible || !(slotBarGlyph instanceof PropertyBarGlyph)) continue;
            PropertyBarGlyph propertyBarGlyph = (PropertyBarGlyph)slotBarGlyph;
            if (!propertyBarGlyph.isComponent || bWireSheet.isRegisteredForComponentEvents(bComponent = (BComponent)this.component.get(propertyBarGlyph.property))) continue;
            array.add((Object)bComponent);
        }
    }

    public void postSubscribe() {
        Iterator iterator = this.slotBars.values().iterator();
        while (iterator.hasNext()) {
            SlotBarGlyph slotBarGlyph = (SlotBarGlyph)iterator.next();
            if (!slotBarGlyph.visible || !(slotBarGlyph instanceof PropertyBarGlyph)) continue;
            PropertyBarGlyph propertyBarGlyph = (PropertyBarGlyph)slotBarGlyph;
            propertyBarGlyph.updateValueString();
        }
    }

    public void changed(String string) {
        super.changed(string);
        Object v = this.slotBars.get(string);
        if (v instanceof PropertyBarGlyph) {
            ((PropertyBarGlyph)v).updateValueString();
        }
    }

    protected void doLayout(Glyph[] glyphArray) {
        if (this.autoCalcWixelWidth) {
            this.autoCalculateWixelWidth();
        }
        int n = 2;
        this.titleBar.setWixelBounds(0, 0, this.ww, 2);
        int n2 = 2;
        while (n2 < glyphArray.length) {
            SlotBarGlyph slotBarGlyph = (SlotBarGlyph)glyphArray[n2];
            if (slotBarGlyph.visible) {
                slotBarGlyph.setWixelBounds(0, n++, this.ww, 1);
            }
            ++n2;
        }
        this.footerBar.setWixelBounds(0, n, this.ww, 1);
        ++n;
        if (this.p + this.ww > BWsOptions.make().getMaxWidth()) {
            this.p = BWsOptions.make().getMaxWidth() - this.ww;
        }
        if (this.q + n > BWsOptions.make().getMaxHeight()) {
            this.q = BWsOptions.make().getMaxHeight() - n;
        }
        this.setWixelBounds(this.p, this.q, this.ww, n);
    }

    public void paint(Graphics graphics) {
        WiresheetTheme wiresheetTheme = Theme.wiresheet();
        int n = this.pw;
        int n2 = this.ph;
        graphics.setBrush(wiresheetTheme.glyph().getBackground((IStylable)this));
        graphics.fillRect(1.0, 1.0, (double)(n - 2), (double)(n2 - 2));
        this.paintChildren(graphics);
        graphics.setBrush(wiresheetTheme.glyph().getOutline((IStylable)this));
        graphics.strokeLine((double)2, 0.0, (double)(n - 3), 0.0);
        graphics.strokeLine((double)2, (double)(n2 - 1), (double)(n - 3), (double)(n2 - 1));
        graphics.strokeLine(0.0, (double)2, 0.0, (double)(n2 - 3));
        graphics.strokeLine((double)(n - 1), (double)2, (double)(n - 1), (double)(n2 - 3));
        graphics.strokeLine(0.0, (double)2, (double)2, 0.0);
        graphics.strokeLine((double)(n - 3), 0.0, (double)(n - 1), (double)2);
        graphics.strokeLine(0.0, (double)(n2 - 3), (double)2, (double)(n2 - 1));
        graphics.strokeLine((double)(n - 1), (double)(n2 - 3), (double)(n - 3), (double)(n2 - 1));
        graphics.strokeLine(0.0, (double)(n2 - this.ws.grid.wixel), (double)n, (double)(n2 - this.ws.grid.wixel));
    }

    public ResizeZone getResizeAt(double d, double d2) {
        int n = (int)(d2 / (double)this.ws.grid.wixel);
        if (this.q == n || this.q + 1 == n) {
            if (ResizeZone.onLeft(this, d, d2)) {
                return new ResizeZone(this, 4);
            }
            if (ResizeZone.onRight(this, d, d2)) {
                return new ResizeZone(this, 8);
            }
        }
        return null;
    }

    public void print(WsPrinting wsPrinting) {
        double d = (double)this.ww * wsPrinting.wixel;
        double d2 = (double)this.wh * wsPrinting.wixel;
        Graphics graphics = wsPrinting.graphics;
        graphics.setBrush(BColor.make((int)0xEEEEEE));
        graphics.fillRect(0.5, 0.5, d - 1.0, d2 - 1.0);
        this.printChildren(wsPrinting);
        graphics.setBrush(BColor.black.toBrush());
        graphics.strokeRect(0.0, 0.0, d, d2);
    }

    public BWsAnnotation toAnnotation() {
        return BWsAnnotation.make((int)this.p, (int)this.q, (int)this.ww);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void autoCalculateWixelWidth() {
        int n = (int)Math.floor((this.titleBar.calcWidth() + (double)this.ws.grid.wixel / (double)2) / (double)this.ws.grid.wixel);
        HashMap hashMap = this.slotBars;
        synchronized (hashMap) {
            Iterator iterator = this.slotBars.values().iterator();
            while (true) {
                int n2;
                if (!iterator.hasNext()) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (n < BWsAnnotation.DEFAULT.wixelWidth) {
                        n = BWsAnnotation.DEFAULT.wixelWidth;
                    }
                    this.ww = n;
                    return;
                }
                SlotBarGlyph slotBarGlyph = (SlotBarGlyph)iterator.next();
                if (!slotBarGlyph.visible || (n2 = (int)Math.floor((slotBarGlyph.calcWidth() + (double)this.ws.grid.wixel / (double)2) / (double)this.ws.grid.wixel)) <= n) continue;
                n = n2;
            }
        }
    }

    WsSelectedState saveSelectedState() {
        return new SelectedState(this.getSelectionKey(), this.selectionIndex);
    }

    void restoreSelectedState(WsSelectedState wsSelectedState) {
        if (this.selectionIndex != -1) {
            this.ws.selection.unregisterStdSelectionIndex(this.selectionIndex);
        }
        this.selectionIndex = ((SelectedState)wsSelectedState).selectionIndex;
        this.ws.selection.registerStdSelectionIndex(this.selectionIndex);
    }

    void setSelected(boolean bl) {
        super.setSelected(bl);
        if (bl) {
            if (this.selectionIndex == -1) {
                this.selectionIndex = this.ws.selection.registerNewStdSelectionIndex();
            }
        } else {
            this.ws.selection.unregisterStdSelectionIndex(this.selectionIndex);
            this.selectionIndex = -1;
        }
    }

    int getSelectionIndex() {
        return this.selectionIndex;
    }

    private final /* synthetic */ void this() {
        this.slotBars = new HashMap(21);
        this.autoCalcWixelWidth = false;
        this.selectionIndex = -1;
    }

    public StdComponentGlyph(BWireSheetPane bWireSheetPane, BComponent bComponent, BWsAnnotation bWsAnnotation) {
        super(bWireSheetPane, bComponent, bWsAnnotation);
        this.this();
        this.titleBar = new TitleBarGlyph(bWireSheetPane, bComponent);
        this.add(this.titleBar);
        this.footerBar = new FooterBarGlyph(bWireSheetPane, bComponent);
        this.add(this.footerBar);
        Slot[] slotArray = this.getPotentialSlots(true);
        int n = 0;
        while (n < slotArray.length) {
            this.addSlotBar(slotArray[n]);
            ++n;
        }
        try {
            if (System.getProperty("nsedona.autoSizeWiresheetComponents", "true").equals("true")) {
                this.autoCalcWixelWidth = bComponent.getType().is(Sys.getType((String)"nsedona:SedonaComponent"));
            }
        }
        catch (Exception exception) {}
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SelectedState
    extends WsSelectedState {
        private int selectionIndex;

        void cancelRestore() {
            if (this.selectionIndex > -1) {
                StdComponentGlyph.this.ws.selection.unregisterStdSelectionIndex(this.selectionIndex);
            }
        }

        protected SelectedState(Object object, int n) {
            super(object);
            this.selectionIndex = n;
        }
    }
}

