/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.ActionBarGlyph;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.PropertyBarGlyph;
import com.tridium.wiresheet.TopicBarGlyph;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.workbench.util.SlotBarUtil;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public abstract class SlotBarGlyph
extends Glyph {
    protected static final int nameX = 3;
    final ComponentGlyph parent;
    final BComponent component;
    final Slot slot;
    final String name;
    final String statusMessage;
    protected double nameWidth;
    protected BColor statusBg;
    protected BColor statusFg;

    public static SlotBarGlyph make(BWireSheetPane bWireSheetPane, ComponentGlyph componentGlyph, BComponent bComponent, Slot slot) {
        if (slot.isAction()) {
            return new ActionBarGlyph(bWireSheetPane, componentGlyph, bComponent, slot.asAction());
        }
        if (slot.isTopic()) {
            return new TopicBarGlyph(bWireSheetPane, componentGlyph, bComponent, slot.asTopic());
        }
        return new PropertyBarGlyph(bWireSheetPane, componentGlyph, bComponent, slot.asProperty());
    }

    public int getLinkHotSpot(int n, int n2) {
        if (n2 == 0) {
            if (n >= this.ww - this.getLinkHotSpotWidth()) {
                return 1;
            }
            if (n < this.getLinkHotSpotWidth()) {
                return 2;
            }
        }
        return 0;
    }

    public BComponent getLinkComponent() {
        return this.component;
    }

    public Slot getLinkSlot() {
        return this.slot;
    }

    protected void doLayout(Glyph[] glyphArray) {
        WiresheetTheme wiresheetTheme = Theme.wiresheet();
        BFont bFont = wiresheetTheme.glyph().getFont((IStylable)this);
        this.nameWidth = WsController.getFont(bFont, this.ws.grid.wixel - 2).width(this.name);
    }

    public void paint(Graphics graphics) {
        WiresheetTheme wiresheetTheme = Theme.wiresheet();
        BFont bFont = wiresheetTheme.glyph().getFont((IStylable)this);
        bFont = WsController.getFont(bFont, this.ws.grid.wixel - 2);
        graphics.setFont(bFont);
        if (this.component.isPendingMove()) {
            graphics.setBrush(WsConst.cutComponentFg);
            graphics.drawString(this.name, (double)3, (double)(this.ws.grid.wixel - 2));
            this.paintValue(graphics);
            graphics.strokeLine(1.0, 0.0, (double)this.pw, 0.0);
            return;
        }
        if (this.statusBg == null) {
            graphics.drawImage(SlotBarUtil.getSlotBar((BWidget)this.ws, (Slot)this.slot, (int)this.ww).transform(BTransform.makeScale((double)((double)this.ws.grid.wixel / 12.0), (double)((double)this.ws.grid.wixel / 12.0))), 0.0, 0.0);
        } else {
            graphics.setBrush(this.statusBg);
            graphics.fillRect(0.0, 0.0, (double)this.pw, (double)this.ph);
        }
        if (this.getLinkOver() != 0) {
            int n = this.getLinkHotSpotWidth() * this.ws.grid.wixel;
            if (this.getLinkOver() == 2) {
                graphics.setBrush(WsConst.linkOverTarget);
                graphics.fillRect(0.0, 0.0, (double)n, (double)this.ph);
            } else {
                graphics.setBrush(WsConst.linkOverSource);
                graphics.fillRect((double)(this.pw - n), 0.0, (double)n, (double)this.ph);
            }
        }
        if (this.statusFg != null) {
            graphics.setBrush(this.statusFg);
        } else {
            graphics.setBrush(WsConst.componentFg);
        }
        graphics.setFont(bFont);
        graphics.drawString(this.name, (double)3, (double)(this.ws.grid.wixel - 2));
        this.paintValue(graphics);
        graphics.setBrush(wiresheetTheme.glyph().getOutline((IStylable)this));
        graphics.strokeLine(1.0, 0.0, (double)this.pw, 0.0);
    }

    protected void paintValue(Graphics graphics) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print(WsPrinting wsPrinting) {
        Graphics graphics = wsPrinting.graphics;
        graphics.push();
        try {
            double d = (double)this.ww * wsPrinting.wixel;
            double d2 = (double)this.wh * wsPrinting.wixel;
            graphics.clip(0.0, 0.0, d, d2);
            graphics.setBrush(BColor.black.toBrush());
            graphics.setFont(wsPrinting.plain);
            graphics.drawString(this.name, 1.0, wsPrinting.plain.getAscent());
            graphics.strokeLine(0.0, d2, d, d2);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        graphics.pop();
    }

    public void mouseEntered() {
        this.repaint();
        this.showStatus(this.statusMessage);
    }

    public void mouseExited() {
        this.repaint();
    }

    public String toString() {
        return super.toString() + ' ' + this.name;
    }

    double calcWidth() {
        BFont bFont = Theme.wiresheet().glyph().getFont((IStylable)this);
        return 6.0 + WsController.getFont(bFont, this.ws.grid.wixel - 2).width(this.name);
    }

    protected SlotBarGlyph(BWireSheetPane bWireSheetPane, ComponentGlyph componentGlyph, BComponent bComponent, Slot slot) {
        super(bWireSheetPane);
        this.parent = componentGlyph;
        this.component = bComponent;
        this.slot = slot;
        this.name = bComponent.getDisplayName(slot, null);
        this.statusMessage = slot.toString();
        this.visible = Flags.isSummary((BComplex)bComponent, (Slot)slot);
    }
}

