/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LayerGlyph;
import com.tridium.wiresheet.LinkLayerGlyph;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.style.IStylable;

public class RootGlyph
extends Glyph {
    public final LayerGlyph componentLayer;
    public final LinkLayerGlyph linkLayer;

    public Glyph getSelectableGlyphAt(int n, int n2) {
        Glyph glyph = this.componentLayer.getSelectableGlyphAt(n, n2);
        if (glyph == null) {
            glyph = this.linkLayer.getSelectableGlyphAt(n, n2);
        }
        return glyph;
    }

    public Glyph descendentAt(int n, int n2) {
        Glyph glyph = this.componentLayer.descendentAt(n, n2);
        if (glyph == null) {
            glyph = this.linkLayer.descendentAt(n, n2);
        }
        return glyph;
    }

    public void selectAllInPixelRect(RectGeom rectGeom) {
        this.componentLayer.selectAllInPixelRect(rectGeom);
        this.linkLayer.selectAllInPixelRect(rectGeom);
    }

    public void removeAll() {
        this.componentLayer.removeAll();
        this.linkLayer.removeAll();
    }

    public RectGeom getPrintBounds() {
        RectGeom rectGeom = new RectGeom(0.0, 0.0, 0.0, 0.0);
        RectGeom.bounds((IRectGeom)rectGeom, (IRectGeom)this.componentLayer.getPrintBounds(), (RectGeom)rectGeom);
        RectGeom.bounds((IRectGeom)rectGeom, (IRectGeom)this.linkLayer.getPrintBounds(), (RectGeom)rectGeom);
        return rectGeom;
    }

    public void paint(Graphics graphics) {
        BWsCanvas bWsCanvas = this.ws.getCanvas();
        WiresheetTheme wiresheetTheme = Theme.wiresheet();
        graphics.setBrush(wiresheetTheme.canvas().getBackground((IStylable)this));
        graphics.fillRect(0.0, 0.0, bWsCanvas.getWidth(), bWsCanvas.getHeight());
        BWsOptions bWsOptions = BWsOptions.make();
        double d = bWsOptions.getMaxWidth() * this.ws.grid.wixel;
        double d2 = bWsOptions.getMaxHeight() * this.ws.grid.wixel;
        if (bWsOptions.getShowGrid()) {
            double d3 = Math.min(bWsCanvas.getWidth(), d);
            double d4 = Math.min(bWsCanvas.getHeight(), d2);
            graphics.setBrush(wiresheetTheme.canvas().getGridColor((IStylable)this));
            int n = this.ws.grid.wixel;
            while ((double)n < d3) {
                graphics.strokeLine((double)n, 0.0, (double)n, d4);
                n += this.ws.grid.wixel;
            }
            n = this.ws.grid.wixel;
            while ((double)n < d4) {
                graphics.strokeLine(0.0, (double)n, d3, (double)n);
                n += this.ws.grid.wixel;
            }
        }
        graphics.setBrush(wiresheetTheme.canvas().getOutline((IStylable)this));
        graphics.strokeLine(0.0, d2, d, d2);
        graphics.strokeLine(d, 0.0, d, d2);
        this.linkLayer.paint(graphics);
        this.componentLayer.paint(graphics);
    }

    public String getStyleSelector() {
        return "wire-sheet";
    }

    RootGlyph(BWireSheetPane bWireSheetPane) {
        super(bWireSheetPane);
        this.componentLayer = new LayerGlyph(bWireSheetPane);
        this.add(this.componentLayer);
        this.linkLayer = new LinkLayerGlyph(bWireSheetPane);
        this.add(this.linkLayer);
    }
}

