/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.sys.engine.NKnob;
import com.tridium.util.LinkUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.commands.DeleteLinksCommand;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.Knob;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public class LinkKnobGlyph
extends LinkGlyph {
    NKnob knob;
    StdComponentGlyph sourceComp;
    SlotBarGlyph sourceSlot;
    int linkColorCode;

    public StdComponentGlyph getSourceComponentGlyph() {
        return this.sourceComp;
    }

    public StdComponentGlyph getTargetComponentGlyph() {
        return null;
    }

    public SlotBarGlyph getSourceSlotGlyph() {
        return this.sourceSlot;
    }

    public SlotBarGlyph getTargetSlotGlyph() {
        return null;
    }

    public String getStatusMessage() {
        return LinkUtil.toDisplay((Knob)this.knob);
    }

    public int getLinkColorCode() {
        return this.linkColorCode;
    }

    BOrd getGotoOrd() {
        return this.knob.getTargetOrd();
    }

    public void popup(double d, double d2) {
        BMenu bMenu = new BMenu();
        bMenu.add(null, (Command)new LinkGlyph.GotoLinkCommand());
        bMenu.add(null, (Command)new LinkGlyph.GotoCommand());
        bMenu.add(null, (Command)new DeleteLinksCommand(this.ws));
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        this.ws.controller.addLinkSelection(bMenu, n, n2);
        bMenu.open((BWidget)this.ws.getCanvas(), d, d2);
    }

    protected String getGotoLinkSourceHandle() {
        return this.getHandleFromOrd(this.knob.getSourceOrd());
    }

    protected String getGotoLinkSourceSlotName() {
        return this.knob.getSourceSlotName();
    }

    protected String getGotoLinkTargetHandle() {
        return this.getHandleFromOrd(this.knob.getTargetOrd());
    }

    protected String getGotoLinkTargetSlotName() {
        return this.knob.getTargetSlotName();
    }

    public void doubleClicked(BMouseEvent bMouseEvent) {
        new LinkGlyph.GotoLinkCommand().invoke(new CommandEvent((BInputEvent)bMouseEvent));
    }

    public void findLinks(WsPrinting wsPrinting) {
        this.linkName = wsPrinting.addKnobLink(LinkUtil.toDisplaySource((Knob)this.knob), LinkUtil.toDisplayTarget((Knob)this.knob));
    }

    public LinkGlyph.Tile[] buildTiles() {
        if (this.sourceSlot == null) {
            System.out.println("ERROR: LinkKnobGlyph.noSourceSlot: " + this.knob);
            return new LinkGlyph.Tile[0];
        }
        int n = this.sourceSlot.absP() + this.sourceSlot.ww;
        int n2 = this.sourceSlot.absQ();
        return new LinkGlyph.Tile[]{new LinkGlyph.Tile(n, n2, 4, this.ws)};
    }

    public BLink getLink() {
        BComponent bComponent = (BComponent)this.knob.getTargetOrd().get((BObject)this.sourceComp.component);
        bComponent.lease();
        BLink[] bLinkArray = bComponent.getLinks();
        int n = 0;
        while (n < bLinkArray.length) {
            if (bLinkArray[n].getTargetSlotName().equals(this.knob.getTargetSlotName()) && bLinkArray[n].getSourceOrd().equals((Object)this.knob.getSourceOrd()) && bLinkArray[n].getSourceSlotName().equals(this.knob.getSourceSlotName())) {
                return bLinkArray[n];
            }
            ++n;
        }
        return null;
    }

    protected LinkKnobGlyph(BWireSheetPane bWireSheetPane, Knob knob, StdComponentGlyph stdComponentGlyph) {
        super(bWireSheetPane, "Knob:" + stdComponentGlyph.handle + '.' + ((NKnob)knob).id);
        this.knob = (NKnob)knob;
        this.sourceComp = stdComponentGlyph;
        this.sourceSlot = stdComponentGlyph.getVisibleSlotBar(knob.getSourceSlotName());
        this.linkColorCode = BWsOptions.make().toLinkColorCode(knob);
    }
}

