/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.BRoundedPopup;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.commands.PinSlotsCommand;
import com.tridium.workbench.shell.WbMain;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BWsAnnotation;
import javax.baja.wiresheet.BWireSheet;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.popup.BIPopupEditor;

public abstract class ComponentGlyph
extends Glyph {
    static AgentFilter PopupAgentFilter = AgentFilter.is((Type)BIPopupEditor.TYPE);
    public final BComponent component;
    public final Object handle;

    public boolean isSelectable() {
        return true;
    }

    public final Object getSelectionKey() {
        return "Comp:" + this.handle;
    }

    public void popup(double d, double d2) {
        boolean bl = this instanceof StdComponentGlyph;
        Subject subject = this.ws.controller.selection.getSubject();
        BMenu bMenu = NavMenuUtil.makeMenu((BWidget)this.ws.getCanvas(), (Subject)subject);
        this.remove(bMenu, "new");
        if (bl) {
            if (subject.size() == 1) {
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add("pinSlots", (Command)new PinSlotsCommand(this.ws, (StdComponentGlyph)this));
            }
        } else {
            this.remove(bMenu, "actions");
            this.remove(bMenu, "linkFrom");
            this.remove(bMenu, "linkTo");
            this.remove(bMenu, "reorder");
            this.remove(bMenu, "composite");
        }
        bMenu = this.ws.getView().makeComponentPopup(bMenu, this.component);
        if (bMenu != null) {
            bMenu.removeConsecutiveSeparators();
            bMenu.open((BWidget)this.ws.getCanvas(), d, d2);
        }
    }

    private final void remove(BMenu bMenu, String string) {
        Property property = bMenu.getProperty(string);
        if (property != null) {
            bMenu.remove(property);
        }
    }

    public void doubleClicked(BMouseEvent bMouseEvent) {
        AgentList agentList = this.component.getAgents();
        AgentList agentList2 = agentList.filter(ComponentGlyph.getAgentFilter(this.ws.getWbShell()));
        if (agentList2.size() > 0) {
            this.displayPopup(bMouseEvent.getX(), bMouseEvent.getY(), agentList2);
        } else {
            BWbShell bWbShell = this.ws.getWbShell();
            if (bWbShell != null) {
                bWbShell.hyperlink(new HyperlinkInfo(this.component.getNavOrd(), (BInputEvent)bMouseEvent));
            }
        }
    }

    private final void displayPopup(double d, double d2, AgentList agentList) {
        AgentInfo agentInfo = agentList.get(0);
        BIPopupEditor bIPopupEditor = (BIPopupEditor)agentInfo.getInstance();
        BWbEditor bWbEditor = bIPopupEditor.getEditor();
        bWbEditor.loadValue((BObject)this.component);
        BRoundedPopup bRoundedPopup = new BRoundedPopup((BWidget)this.ws.getWbShell(), (BWidget)bWbEditor, this.component.getName(), 15.0f, 15.0f, 3);
        Point point = this.ws.translateToScreen(new Point(d, d2));
        RectGeom rectGeom = new RectGeom(point.x, point.y, (double)this.pw, (double)this.ph);
        bRoundedPopup.setBoundsCenteredOn((IRectGeom)rectGeom);
        bRoundedPopup.open();
        int n = bRoundedPopup.getResult();
        if (n != 2) {
            try {
                bWbEditor.saveValue();
            }
            catch (CannotSaveException cannotSaveException) {
                cannotSaveException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void loadLinks() {
    }

    public void loadKnobs() {
    }

    public void checkForSubscribe(BWireSheet bWireSheet, Array array) {
        if (!bWireSheet.isRegisteredForComponentEvents(this.component)) {
            array.add((Object)this.component);
        }
    }

    public void postSubscribe() {
    }

    public void changed(String string) {
    }

    protected void fillGrid() {
        this.ws.grid.setComponent(this.absP(), this.absQ(), this.ww, this.wh);
    }

    public RectGeom getGeom() {
        return new RectGeom((double)this.p, (double)this.q, (double)this.ww, (double)this.wh);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        SlotCursor slotCursor = this.component.getProperties();
        while (slotCursor.next()) {
            BStatus bStatus;
            Property property = slotCursor.property();
            Type type = property.getType();
            if (!type.is(BStatus.TYPE) || !(bStatus = (BStatus)this.component.get(property)).isFault()) continue;
            this.paintFaultIndicator(graphics);
            break;
        }
    }

    protected void paintFaultIndicator(Graphics graphics) {
        BImage bImage = BImage.make((BIcon)BIcon.std((String)"warning.png"));
        RectGeom rectGeom = this.getGeom();
        double d = rectGeom.x + rectGeom.width - bImage.getWidth();
        double d2 = rectGeom.y + rectGeom.height - bImage.getHeight();
        graphics.drawImage(bImage, d, d2);
    }

    public String getStyleClasses() {
        String string = super.getStyleClasses();
        string = this.component.isPendingMove() ? StyleUtils.addStyleClass((String)string, (String)"cut") : StyleUtils.removeStyleClass((String)string, (String)"cut");
        return string;
    }

    public void paintSelection(Graphics graphics) {
        int n = this.pw;
        int n2 = this.ph;
        WiresheetTheme wiresheetTheme = Theme.wiresheet();
        graphics.setBrush(wiresheetTheme.glyph().getSelectionForeground((IStylable)this));
        graphics.strokeLine(-1.0, (double)2, -1.0, (double)(n2 - 3));
        graphics.strokeLine((double)n, (double)2, (double)n, (double)(n2 - 3));
        graphics.strokeLine((double)2, -1.0, (double)(n - 3), -1.0);
        graphics.strokeLine((double)2, (double)n2, (double)(n - 3), (double)n2);
        graphics.strokeLine(0.0, 1.0, 1.0, 0.0);
        graphics.strokeLine(0.0, (double)(n2 - 2), 1.0, (double)(n2 - 1));
        graphics.strokeLine((double)(n - 2), 0.0, (double)(n - 1), 1.0);
        graphics.strokeLine((double)(n - 1), (double)(n2 - 2), (double)(n - 2), (double)(n2 - 1));
        graphics.fillRect(-3.0, (double)(this.ws.grid.wixel - 2), (double)5, (double)5);
        graphics.fillRect((double)(n - 2), (double)(this.ws.grid.wixel - 2), (double)5, (double)5);
        graphics.setBrush(wiresheetTheme.glyph().getSelectionBackground((IStylable)this));
        graphics.strokeRect(-4.0, (double)(this.ws.grid.wixel - 3), 6.0, 6.0);
        graphics.strokeRect((double)(n - 3), (double)(this.ws.grid.wixel - 3), 6.0, 6.0);
    }

    public abstract BWsAnnotation toAnnotation();

    public static AgentFilter getAgentFilter(BWbShell bWbShell) {
        BWbProfile bWbProfile = null;
        if (bWbShell != null) {
            bWbProfile = bWbShell.getProfile();
        } else {
            try {
                bWbProfile = BWbProfile.make(null, (Type)WbMain.defaultProfileType);
            }
            catch (Exception exception) {
                return PopupAgentFilter;
            }
        }
        return AgentFilter.and((AgentFilter)new BWbFieldEditor.ProfileFilter(bWbProfile), (AgentFilter)PopupAgentFilter);
    }

    public ComponentGlyph(BWireSheetPane bWireSheetPane, BComponent bComponent, BWsAnnotation bWsAnnotation) {
        super(bWireSheetPane);
        this.component = bComponent;
        this.handle = bComponent.getHandle();
        this.setWixelBounds(bWsAnnotation.p, bWsAnnotation.q, bWsAnnotation.wixelWidth, bWsAnnotation.wixelHeight);
    }
}

