/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.gx.util.PointMap;
import com.tridium.gx.util.RectangleMap;
import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LinkSnakeGlyph;
import com.tridium.wiresheet.RootGlyph;
import com.tridium.wiresheet.WsConst;
import com.tridium.workbench.commands.PasteSpecialCommand;
import com.tridium.workbench.transfer.TransferUtil;
import java.util.ArrayList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.space.Mark;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWsCanvas
extends BTransferWidget
implements WsConst {
    public static final Type TYPE;
    static final int DRAG_LINE = 50;
    private RectGeom dragRect;
    private TransferContext dragOverContext;
    RootGlyph rootGlyph;
    RectangleMap componentGlyphMap;
    PointMap scaleMap;
    static /* synthetic */ Class class$com$tridium$wiresheet$BWsCanvas;

    public Type getType() {
        return TYPE;
    }

    public RootGlyph getRootGlyph() {
        if (this.rootGlyph == null) {
            this.rootGlyph = new RootGlyph(this.getWireSheet());
            return this.rootGlyph;
        }
        return this.rootGlyph;
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.getWireSheet().grid.getWixelWidth() * this.getWireSheet().grid.wixel, this.getWireSheet().grid.getWixelHeight() * this.getWireSheet().grid.wixel);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.getWireSheet().controller.doLayout();
        this.getRootGlyph().layout();
    }

    void preLoad() {
        this.getRootGlyph().removeAll();
        this.componentGlyphMap = null;
        this.scaleMap = null;
    }

    void postLoad() {
        this.needsLayout();
        this.createLinkCrossings();
    }

    public Object[] getComponentGlyphs(int n, int n2) {
        if (this.componentGlyphMap == null) {
            this.componentGlyphMap = new RectangleMap(0, 0, this.getWireSheet().grid.getWixelWidth(), this.getWireSheet().grid.getWixelHeight(), 20, 20);
            this.fillComponentGlyphMap(this.getRootGlyph());
        }
        return this.componentGlyphMap.get(n, n2);
    }

    private final void fillComponentGlyphMap(Glyph glyph) {
        int n;
        if (glyph instanceof ComponentGlyph) {
            int n2 = glyph.absP();
            n = glyph.absQ();
            int n3 = glyph.ww;
            int n4 = glyph.wh;
            if (n2 > 0) {
                --n2;
                ++n3;
            }
            if (n2 + n3 + 1 < this.getWireSheet().grid.getWixelWidth()) {
                ++n3;
            }
            this.componentGlyphMap.put(n2, n, n3, n4, (Object)glyph);
        }
        Glyph[] glyphArray = glyph.getChildGlyphs();
        n = 0;
        while (n < glyphArray.length) {
            if (glyphArray[n].visible) {
                this.fillComponentGlyphMap(glyphArray[n]);
            }
            ++n;
        }
    }

    private final void createLinkCrossings() {
        if (this.scaleMap == null) {
            return;
        }
        IPoint[] iPointArray = this.scaleMap.getKeys();
        int n = 0;
        while (n < iPointArray.length) {
            block12: {
                ArrayList arrayList = (ArrayList)this.scaleMap.get((double)((int)iPointArray[n].x()), (double)((int)iPointArray[n].y()));
                if (arrayList.size() >= 2) {
                    LinkSnakeGlyph.Scale scale;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < arrayList.size()) {
                        scale = (LinkSnakeGlyph.Scale)arrayList.get(n4);
                        if (scale.type == 1) {
                            ++n3;
                        } else {
                            if (scale.type != 2) break block12;
                            ++n2;
                        }
                        ++n4;
                    }
                    if (n2 != 0 && n3 != 0) {
                        n4 = 0;
                        while (n4 < arrayList.size()) {
                            scale = (LinkSnakeGlyph.Scale)arrayList.get(n4);
                            if (scale.type == 2) {
                                scale.getOwner().replaceTilesAt((int)iPointArray[n].x(), (int)iPointArray[n].y(), 6);
                            } else if (scale.type == 1) {
                                scale.getOwner().replaceTilesAt((int)iPointArray[n].x(), (int)iPointArray[n].y(), 5);
                            }
                            ++n4;
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void addScale(int n, int n2, LinkSnakeGlyph.Scale scale) {
        ArrayList<LinkSnakeGlyph.Scale> arrayList;
        if (this.scaleMap == null) {
            this.scaleMap = new PointMap(0);
        }
        if ((arrayList = (ArrayList<LinkSnakeGlyph.Scale>)this.scaleMap.get((double)n, (double)n2)) == null) {
            arrayList = new ArrayList<LinkSnakeGlyph.Scale>();
            this.scaleMap.put((double)n, (double)n2, arrayList);
        }
        arrayList.add(scale);
    }

    public ArrayList getScales(int n, int n2) {
        if (this.scaleMap == null) {
            this.scaleMap = new PointMap(0);
        }
        return (ArrayList)this.scaleMap.get((double)n, (double)n2);
    }

    public void paint(Graphics graphics) {
        this.rootGlyph.paint(graphics);
        this.paintSelection(graphics);
        this.getWireSheet().controller.getState().paintFx(graphics);
        if (this.dragOverContext != null) {
            double d = this.dragOverContext.getX();
            double d2 = this.dragOverContext.getY();
            graphics.setBrush(Theme.widget().getDropOkBackground());
            graphics.strokeLine(d, d2, d + 50.0, d2);
            graphics.strokeLine(d, d2, d, d2 + 50.0);
        }
    }

    private final void paintSelection(Graphics graphics) {
        Glyph[] glyphArray = this.getWireSheet().selection.get();
        int n = 0;
        while (n < glyphArray.length) {
            Glyph glyph = glyphArray[n];
            graphics.translate((double)glyph.x, (double)glyph.y);
            glyph.paintSelection(graphics);
            graphics.translate((double)(-glyph.x), (double)(-glyph.y));
            ++n;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent bFocusEvent) {
    }

    public void focusLost(BFocusEvent bFocusEvent) {
    }

    public final void keyPressed(BKeyEvent bKeyEvent) {
        this.getWireSheet().controller.keyPressed(bKeyEvent);
    }

    public final void keyReleased(BKeyEvent bKeyEvent) {
        this.getWireSheet().controller.keyReleased(bKeyEvent);
    }

    public final void keyTyped(BKeyEvent bKeyEvent) {
        this.getWireSheet().controller.keyTyped(bKeyEvent);
    }

    public final void mousePressed(BMouseEvent bMouseEvent) {
        this.requestFocus();
        this.getWireSheet().controller.mousePressed(bMouseEvent);
    }

    public final void mouseReleased(BMouseEvent bMouseEvent) {
        this.getWireSheet().controller.mouseReleased(bMouseEvent);
    }

    public final void mouseEntered(BMouseEvent bMouseEvent) {
        this.getWireSheet().controller.mouseEntered(bMouseEvent);
    }

    public final void mouseExited(BMouseEvent bMouseEvent) {
        this.getWireSheet().controller.mouseExited(bMouseEvent);
    }

    public final void mouseMoved(BMouseEvent bMouseEvent) {
        this.getWireSheet().controller.mouseMoved(bMouseEvent);
    }

    public final void mouseDragged(BMouseEvent bMouseEvent) {
        this.getWireSheet().controller.mouseDragged(bMouseEvent);
    }

    public final void mousePulsed(BMouseEvent bMouseEvent) {
        this.getWireSheet().controller.mousePulsed(bMouseEvent);
    }

    public final void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        this.getWireSheet().controller.mouseWheel(bMouseWheelEvent);
    }

    public TransferEnvelope getTransferData() throws Exception {
        Mark mark = this.getWireSheet().controller.getSelectionAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public final TransferContext makeTransferContext(Context context, int n, TransferEnvelope transferEnvelope) {
        return this.getWireSheet().controller.makeTransferContext(context, n, transferEnvelope);
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return this.getWireSheet().controller.insertTransferData(transferContext);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doPasteSpecial() throws Exception {
        return new PasteSpecialCommand((BTransferWidget)this, this.getWireSheet().controller.container).doInvoke();
    }

    public CommandArtifact doDelete() throws Exception {
        Mark mark = this.getWireSheet().controller.getSelectionAsMark();
        return TransferUtil.delete((BWidget)this, (Mark)mark);
    }

    public CommandArtifact doRename() throws Exception {
        Mark mark = this.getWireSheet().controller.getSelectionAsMark();
        return TransferUtil.rename((BWidget)this, (Mark)mark);
    }

    public int dragOver(TransferContext transferContext) {
        this.dragOverContext = transferContext;
        this.repaintDragOver();
        int n = 48;
        if (transferContext.isPulse()) {
            this.getWireSheet().controller.pulseViewport(transferContext.getX(), transferContext.getY());
        }
        return n;
    }

    public void dragExit(TransferContext transferContext) {
        this.dragOverContext = null;
        this.repaintDragOver();
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        this.dragOverContext = null;
        this.repaintDragOver();
        this.getWireSheet().controller.dropPoint = new Point(transferContext.getX(), transferContext.getY());
        return this.getWireSheet().controller.insertTransferData(transferContext);
    }

    private final void repaintDragOver() {
        RectGeom rectGeom = this.dragRect;
        TransferContext transferContext = this.dragOverContext;
        if (transferContext == null) {
            rectGeom = this.dragRect;
            this.dragRect = null;
        } else {
            RectGeom rectGeom2 = new RectGeom(transferContext.getX(), transferContext.getY(), 52.0, 52.0);
            RectGeom rectGeom3 = this.dragRect == null ? rectGeom2 : this.dragRect;
            rectGeom = RectGeom.bounds((IRectGeom)rectGeom2, (IRectGeom)rectGeom3, null);
            this.dragRect = rectGeom2;
        }
        if (rectGeom != null) {
            this.repaint(rectGeom.x, rectGeom.y, rectGeom.width, rectGeom.height);
        }
    }

    private final BWireSheetPane getWireSheet() {
        return (BWireSheetPane)this.getParent().getParent();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.componentGlyphMap = null;
        this.scaleMap = null;
    }

    public BWsCanvas() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$wiresheet$BWsCanvas;
        if (clazz == null) {
            clazz = class$com$tridium$wiresheet$BWsCanvas = BWsCanvas.class("[Lcom.tridium.wiresheet.BWsCanvas;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

