/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmRdb;

import com.tridium.alarmRdb.BAlarmDbResultSetTable;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.alarmRdb.BRdbAlarmService;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDriverContainer;
import javax.baja.naming.BOrdList;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.rdb.sql.SqlQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BRdbAlarmDatabase
extends BAlarmDatabase {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$alarmRdb$BRdbAlarmDatabase == null ? (class$javax$baja$alarmRdb$BRdbAlarmDatabase = BRdbAlarmDatabase.class$("javax.baja.alarmRdb.BRdbAlarmDatabase")) : class$javax$baja$alarmRdb$BRdbAlarmDatabase));
    BRdbAlarmService alarmService = (BRdbAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmClass;
    static /* synthetic */ Class class$javax$baja$rdb$BRdbmsNetwork;
    static /* synthetic */ Class class$javax$baja$alarmRdb$BRdbAlarmDatabase;

    public BRdbAlarmDatabase() {
        this.alarmService.setSchemaVersion(this.getSchemaVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpen() throws IOException {
        this.init();
        String string = this.getType().getTypeSpec().toString();
        int n = this.getSchemaVersion();
        Statement statement = null;
        Connection connection = null;
        if (this.alarmService.getInitRdb()) {
            block21: {
                try {
                    connection = this.getConnection();
                    statement = connection.createStatement();
                    int n2 = this.getDbSchemaVersion(statement, string);
                    if (n2 == -1) {
                        this.createAlarmRecordTable(statement);
                        this.setDbSchemaVersion(statement, string, n);
                        break block21;
                    }
                    if (n2 == n) break block21;
                    this.convert(statement, n2, connection);
                    this.setDbSchemaVersion(statement, string, n);
                }
                catch (Exception exception) {
                    try {
                        exception.printStackTrace();
                        throw new IOException(exception.toString());
                    }
                    catch (Throwable throwable) {
                        BRdbAlarmDatabase.closeStatement(statement);
                        this.closeConnection(connection);
                        throw throwable;
                    }
                }
            }
            BRdbAlarmDatabase.closeStatement(statement);
            this.closeConnection(connection);
        }
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            resultSet = connection.createStatement().executeQuery("SELECT ALARMCLASS, SOURCESTATE, ACKSTATE FROM " + this.alarmService.getAlarmTableName());
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(string2);
                BSourceState bSourceState = BSourceState.make((String)resultSet.getString(2));
                BAckState bAckState = BAckState.make((String)resultSet.getString(3));
                if (!bAlarmClass.getName().equals(string2)) continue;
                bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() + 1);
                if (bAckState != BAckState.acked) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() + 1);
                }
                if (bSourceState != BSourceState.normal || bAckState == BAckState.unacked) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() + 1);
                }
                if (bSourceState == BSourceState.normal) continue;
                bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.closeConnection(connection);
        }
    }

    protected void doSave() throws IOException {
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.isClosed()) return;
            return;
        }
        catch (Exception exception) {
            try {
                try {
                    connection.close();
                    connection = null;
                    return;
                }
                catch (Exception exception2) {
                    log.error("Cannot close database connection.", (Throwable)exception2);
                    return;
                }
            }
            finally {
                connection = null;
            }
        }
        finally {
            try {
                try {
                    connection.close();
                    connection = null;
                }
                catch (Exception exception) {
                    log.error("Cannot close database connection.", (Throwable)exception);
                    return;
                }
            }
            catch (Throwable throwable) {
                connection = null;
                throw throwable;
            }
        }
    }

    protected Connection getConnection() throws Exception {
        return this.getRdbms().getConnection(this.getRdbms().getUserName(), this.getRdbms().getPassword());
    }

    public void append(BAlarmRecord bAlarmRecord) throws IOException, AlarmException {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            BRdbmsDeprecatedDialect bRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.make((BRdbms)this.getRdbms());
            Property[] propertyArray = new BAlarmRecord().getPropertiesArray();
            String string = bRdbmsDeprecatedDialect.makeInsertSql(this.alarmService.getAlarmTableName(), false, propertyArray, new String[0]);
            statement = connection.prepareStatement(string);
            statement.clearBatch();
            bRdbmsDeprecatedDialect.insertRecord((PreparedStatement)statement, (BComplex)bAlarmRecord, propertyArray, new BObject[0], new BFacets[0]);
            statement.executeBatch();
            BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (bAlarmClass.getName().equals(bAlarmRecord.getAlarmClass())) {
                bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() + 1);
                if (!bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() + 1);
                }
                if (!bAlarmRecord.isNormal()) {
                    bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() + 1);
                }
                if (bAlarmRecord.isOpen()) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() + 1);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = TYPE.getModule().getVendorVersion().toString();
            throw new AlarmException("alarmRdb module " + string + " requires rdb module " + string, (Throwable)noSuchMethodException);
        }
        catch (Exception exception) {
            throw new AlarmException("Cannot append alarm", (Throwable)exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(connection);
        }
    }

    public void update(BAlarmRecord bAlarmRecord) throws IOException, AlarmException {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            BAlarmRecord bAlarmRecord2 = this.getRecord(bAlarmRecord.getUuid(), connection);
            BRdbmsDeprecatedDialect bRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.make((BRdbms)this.getRdbms());
            Property[] propertyArray = new BAlarmRecord().getPropertiesArray();
            String string = bRdbmsDeprecatedDialect.makeUpdateSql(this.alarmService.getAlarmTableName(), propertyArray, new String[0], "UUID");
            statement = connection.prepareStatement(string);
            statement.clearBatch();
            bRdbmsDeprecatedDialect.updateRecord((PreparedStatement)statement, (BComplex)bAlarmRecord, propertyArray, new BObject[0], new BFacets[0], "UUID", (BObject)bAlarmRecord.getUuid());
            statement.executeBatch();
            BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (bAlarmClass.getName().equals(bAlarmRecord.getAlarmClass())) {
                if (!bAlarmRecord2.isAcknowledged() && bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
                } else if (bAlarmRecord2.isAcknowledged() && !bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() + 1);
                }
                if (bAlarmRecord2.isOpen() && !bAlarmRecord.isOpen()) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
                }
                if (!bAlarmRecord2.isNormal() && bAlarmRecord.isNormal()) {
                    bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AlarmException("Cannot update alarm", (Throwable)exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordCount() {
        int n = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = "SELECT count(*) FROM " + this.alarmService.getAlarmTableName();
            log.trace(string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            log.error("Could not get AlarmRecord count", (Throwable)exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(connection);
        }
        return n;
    }

    public BAlarmRecord getRecord(BUuid bUuid) throws IOException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            BAlarmRecord bAlarmRecord = this.getRecord(bUuid, connection);
            return bAlarmRecord;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    public BAlarmRecord getRecord(BUuid bUuid, Connection connection) throws IOException {
        BAlarmRecord bAlarmRecord = null;
        try {
            String string = "SELECT * FROM " + this.alarmService.getAlarmTableName() + " WHERE UUID='" + bUuid.encodeToString() + "'";
            log.trace(string);
            BAlarmDbResultSetTable bAlarmDbResultSetTable = new BAlarmDbResultSetTable(connection, new SqlQuery(string));
            if (bAlarmDbResultSetTable.size() > 0) {
                bAlarmRecord = (BAlarmRecord)bAlarmDbResultSetTable.get(0);
            }
        }
        catch (Exception exception) {
            log.error("Could not read AlarmRecord " + bUuid, (Throwable)exception);
        }
        return bAlarmRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor getOpenAlarms() throws IOException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = "SELECT * FROM " + this.alarmService.getAlarmTableName() + " WHERE (SOURCESTATE = 'alert' AND ACKSTATE != 'acked') OR ((ACKSTATE != 'acked' AND ACKREQUIRED=1) OR (SOURCESTATE != 'normal' AND SOURCESTATE != 'alert'))";
            log.trace(string);
            BAlarmDbResultSetTable bAlarmDbResultSetTable = new BAlarmDbResultSetTable(connection, new SqlQuery(string));
            Cursor cursor = bAlarmDbResultSetTable.cursor();
            return cursor;
        }
        catch (Exception exception) {
            log.error("Could not read Open AlarmRecords", (Throwable)exception);
        }
        finally {
            this.closeConnection(connection);
        }
        return this.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor getAckPendingAlarms() throws IOException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = "SELECT * FROM " + this.alarmService.getAlarmTableName() + " WHERE ACKSTATE = 'ackPending'";
            log.trace(string);
            BAlarmDbResultSetTable bAlarmDbResultSetTable = new BAlarmDbResultSetTable(connection, new SqlQuery(string));
            Cursor cursor = bAlarmDbResultSetTable.cursor();
            return cursor;
        }
        catch (Exception exception) {
            log.error("Could not read AckPending AlarmRecords", (Throwable)exception);
        }
        finally {
            this.closeConnection(connection);
        }
        return this.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor getAlarmsForSource(BOrdList bOrdList) throws IOException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = "SELECT * FROM " + this.alarmService.getAlarmTableName() + " WHERE SOURCE = '" + bOrdList + "'";
            log.trace(string);
            BAlarmDbResultSetTable bAlarmDbResultSetTable = new BAlarmDbResultSetTable(connection, new SqlQuery(string));
            Cursor cursor = bAlarmDbResultSetTable.cursor();
            return cursor;
        }
        catch (Exception exception) {
            log.error("Could not read AckPending AlarmRecords", (Throwable)exception);
        }
        finally {
            this.closeConnection(connection);
        }
        return this.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor scan() throws IOException, AlarmException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = "SELECT * FROM " + this.alarmService.getAlarmTableName();
            log.trace(string);
            BAlarmDbResultSetTable bAlarmDbResultSetTable = new BAlarmDbResultSetTable(connection, new SqlQuery(string));
            Cursor cursor = bAlarmDbResultSetTable.cursor();
            return cursor;
        }
        catch (Exception exception) {
            log.error("Could not read Open AlarmRecords", (Throwable)exception);
        }
        finally {
            this.closeConnection(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor timeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws IOException, AlarmException {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            BRdbmsDeprecatedDialect bRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.make((BRdbms)this.getRdbms());
            statement = connection.prepareStatement("SELECT * FROM " + this.alarmService.getAlarmTableName() + " where TIMESTAMP >= ? AND TIMESTAMP <= ?");
            bRdbmsDeprecatedDialect.loadField((PreparedStatement)statement, 1, (BObject)bAbsTime, BFacets.NULL);
            bRdbmsDeprecatedDialect.loadField((PreparedStatement)statement, 2, (BObject)bAbsTime2, BFacets.NULL);
            BAlarmDbResultSetTable bAlarmDbResultSetTable = new BAlarmDbResultSetTable((PreparedStatement)statement);
            Cursor cursor = bAlarmDbResultSetTable.cursor();
            return cursor;
        }
        catch (Exception exception) {
            log.error("Could not read Open AlarmRecords", (Throwable)exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(connection);
        }
        return null;
    }

    public void clearAllRecords(Context context) throws IOException {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = "DELETE FROM " + this.alarmService.getAlarmTableName();
            statement = connection.createStatement();
            statement.executeUpdate(string);
            BAlarmClass[] bAlarmClassArray = (BAlarmClass[])this.alarmService.getChildren(class$javax$baja$alarm$BAlarmClass == null ? (class$javax$baja$alarm$BAlarmClass = BRdbAlarmDatabase.class$("javax.baja.alarm.BAlarmClass")) : class$javax$baja$alarm$BAlarmClass);
            for (int i = 0; i < bAlarmClassArray.length; ++i) {
                bAlarmClassArray[i].setTotalAlarmCount(0);
                bAlarmClassArray[i].setUnackedAlarmCount(0);
                bAlarmClassArray[i].setOpenAlarmCount(0);
                bAlarmClassArray[i].setInAlarmCount(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AlarmException("Cannot delete alarm records", (Throwable)exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(connection);
        }
    }

    public void clearOldRecords(BAbsTime bAbsTime, Context context) throws IOException {
        Statement statement = null;
        Statement statement2 = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            BRdbmsDeprecatedDialect bRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.make((BRdbms)this.getRdbms());
            String string = "SELECT * FROM " + this.alarmService.getAlarmTableName() + " WHERE TIMESTAMP < ?";
            statement = connection.prepareStatement(string);
            bRdbmsDeprecatedDialect.loadField((PreparedStatement)statement, 1, (BObject)bAbsTime, BFacets.NULL);
            BAlarmDbResultSetTable bAlarmDbResultSetTable = new BAlarmDbResultSetTable((PreparedStatement)statement);
            int n = bAlarmDbResultSetTable.size();
            String string2 = "DELETE FROM " + this.alarmService.getAlarmTableName() + " WHERE TIMESTAMP < ?";
            statement2 = connection.prepareStatement(string2);
            bRdbmsDeprecatedDialect.loadField((PreparedStatement)statement2, 1, (BObject)bAbsTime, BFacets.NULL);
            statement2.executeUpdate();
            for (int i = 0; i < n; ++i) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)bAlarmDbResultSetTable.get(i);
                BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
                if (!bAlarmClass.getName().equals(bAlarmRecord.getAlarmClass())) continue;
                bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() - 1);
                if (!bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
                }
                if (bAlarmRecord.isOpen()) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
                }
                if (bAlarmRecord.isNormal()) continue;
                bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AlarmException("Cannot delete alarm records", (Throwable)exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(connection);
        }
    }

    /*
     * Exception decompiling
     */
    public void clearRecord(BUuid var1_1, Context var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BRdbms getRdbms() {
        String string = this.alarmService.getDriver();
        BDriverContainer bDriverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
        BRdbmsNetwork[] bRdbmsNetworkArray = (BRdbmsNetwork[])bDriverContainer.getChildren(class$javax$baja$rdb$BRdbmsNetwork == null ? (class$javax$baja$rdb$BRdbmsNetwork = BRdbAlarmDatabase.class$("javax.baja.rdb.BRdbmsNetwork")) : class$javax$baja$rdb$BRdbmsNetwork);
        for (int i = 0; i < bRdbmsNetworkArray.length; ++i) {
            BDevice[] bDeviceArray = bRdbmsNetworkArray[i].getDevices();
            for (int j = 0; j < bDeviceArray.length; ++j) {
                if (!bDeviceArray[j].getName().equals(string)) continue;
                return (BRdbms)bDeviceArray[j];
            }
        }
        return null;
    }

    public int getSchemaVersion() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDbSchemaVersion(Statement statement, String string) throws SQLException {
        ResultSet resultSet = null;
        try {
            String string2 = "SELECT VERSION FROM " + this.alarmService.getSchemaTableName() + " WHERE ID = '" + string + "'";
            log.trace(string2);
            resultSet = statement.executeQuery(string2);
            int n = -1;
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setDbSchemaVersion(Statement statement, String string, int n) throws SQLException {
        String string2 = null;
        int n2 = this.getDbSchemaVersion(statement, string);
        string2 = n2 == -1 ? "INSERT INTO " + this.alarmService.getSchemaTableName() + " (ID, VERSION) " + "VALUES ('" + string + "', " + n + ")" : "UPDATE " + this.alarmService.getSchemaTableName() + " SET VERSION = " + n + " WHERE ID = '" + string + "'";
        statement.executeUpdate(string2);
    }

    public static void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            log.error("Cannot close statement.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getRdbms().getConnection(this.getRdbms().getUserName(), this.getRdbms().getPassword());
            statement = connection.createStatement();
            BRdbmsDeprecatedDialect bRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.make((BRdbms)this.getRdbms());
            try {
                String string = "SELECT count(*) FROM " + this.alarmService.getSchemaTableName();
                log.trace(string);
                ResultSet resultSet = statement.executeQuery(string);
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (SQLException sQLException) {
                if (this.alarmService.getInitRdb()) {
                    String string = "CREATE TABLE " + this.alarmService.getSchemaTableName() + " (ID " + bRdbmsDeprecatedDialect.getSqlType(BString.TYPE, null) + " PRIMARY KEY NOT NULL, VERSION " + bRdbmsDeprecatedDialect.getSqlType(BInteger.TYPE, null) + ")";
                    log.trace(string);
                    statement.executeUpdate(string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    public void createAlarmRecordTable(Statement statement) throws SQLException {
        BRdbmsDeprecatedDialect bRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.make((BRdbms)this.getRdbms());
        Property[] propertyArray = new BAlarmRecord().getPropertiesArray();
        String string = this.alarmService.getAlarmTableName();
        String string2 = bRdbmsDeprecatedDialect.makeCreateTableSql(string, false, propertyArray, new String[0], new Type[0], new BFacets[0]);
        statement.executeUpdate(string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE INDEX ");
        stringBuffer.append("IDX_").append(string).append("_UUID ON ");
        stringBuffer.append(string);
        stringBuffer.append("(UUID)");
        statement.executeUpdate(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE INDEX ");
        stringBuffer.append("IDX_").append(string).append("_TIMESTAMP ON ");
        stringBuffer.append(string);
        stringBuffer.append("(TIMESTAMP)");
        statement.executeUpdate(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE INDEX ");
        stringBuffer.append("IDX_").append(string).append("_ACKSTATE ON ");
        stringBuffer.append(string);
        stringBuffer.append("(ACKSTATE)");
        statement.executeUpdate(stringBuffer.toString());
    }

    public void convert(Statement statement, int n, Connection connection) throws Exception {
        int n2 = n;
        SchemaConverter[] schemaConverterArray = this.getSchemaConverters();
        SchemaConverter schemaConverter = null;
        while (true) {
            for (int i = 0; i < schemaConverterArray.length; ++i) {
                if (schemaConverterArray[i].getFromVersion() != n2 || schemaConverterArray[i].getFromVersion() == schemaConverterArray[i].getToVersion() || schemaConverter != null && schemaConverterArray[i].getToVersion() <= schemaConverter.getToVersion()) continue;
                schemaConverter = schemaConverterArray[i];
            }
            if (schemaConverter == null) break;
            log.message(this.getType() + ": converting schema: " + schemaConverter.getFromVersion() + " -> " + schemaConverter.getToVersion());
            schemaConverter.convert(statement, connection);
            n2 = schemaConverter.getToVersion();
            schemaConverter = null;
        }
        if (n2 != this.getSchemaVersion()) {
            throw new Exception("Cannot convert from version " + n2 + " to version " + this.getSchemaVersion());
        }
    }

    protected SchemaConverter[] getSchemaConverters() {
        return new SchemaConverter[0];
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface SchemaConverter {
        public int getFromVersion();

        public int getToVersion();

        public void convert(Statement var1, Connection var2) throws Exception;
    }
}

