/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmRdb;

import com.tridium.alarmRdb.ResultSetColumnList;
import com.tridium.alarmRdb.ResultSetCursor;
import com.tridium.collection.BISortableTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.collection.BIList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.naming.BOrdList;
import javax.baja.rdb.sql.SqlQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BUuid;
import javax.baja.util.IFilter;

public class BAlarmDbResultSetTable
extends BObject
implements BISortableTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarmRdb$BAlarmDbResultSetTable == null ? (class$com$tridium$alarmRdb$BAlarmDbResultSetTable = BAlarmDbResultSetTable.class$("com.tridium.alarmRdb.BAlarmDbResultSetTable")) : class$com$tridium$alarmRdb$BAlarmDbResultSetTable));
    private Connection conn = null;
    private SqlQuery sql = null;
    private PreparedStatement ps = null;
    private Array array = null;
    private ColumnList columnList = null;
    private boolean loaded = false;
    private boolean supportsTimestamp = true;
    static /* synthetic */ Class class$com$tridium$alarmRdb$BAlarmDbResultSetTable;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public Type getType() {
        return TYPE;
    }

    public BAlarmDbResultSetTable(Connection connection, SqlQuery sqlQuery) {
        this.conn = connection;
        this.sql = sqlQuery;
        this.ps = null;
        this.loaded = false;
        this.array = null;
        this.columnList = null;
    }

    public BAlarmDbResultSetTable(PreparedStatement preparedStatement) {
        this.conn = null;
        this.sql = null;
        this.ps = preparedStatement;
        this.loaded = false;
        this.array = null;
        this.columnList = null;
    }

    private BAlarmDbResultSetTable(Array array, ColumnList columnList) {
        this.conn = null;
        this.sql = null;
        this.ps = null;
        this.array = array;
        this.columnList = columnList;
        this.loaded = true;
    }

    public Cursor cursor() {
        this.load();
        return new ResultSetCursor(this.array);
    }

    public BICollection filter(IFilter iFilter) {
        this.load();
        return new BAlarmDbResultSetTable(this.array.filter(iFilter), this.columnList);
    }

    public BIList toList() {
        this.load();
        return this;
    }

    public int size() {
        this.load();
        return this.array.size();
    }

    public BObject get(int n) {
        this.load();
        return (BComplex)this.array.get(n);
    }

    public BObject[] list() {
        this.load();
        BComplex[] bComplexArray = new BComplex[this.array.size()];
        for (int i = 0; i < this.array.size(); ++i) {
            bComplexArray[i] = (BComplex)this.array.get(i);
        }
        return bComplexArray;
    }

    public BObject[] list(BObject[] bObjectArray) {
        return this.list();
    }

    public BITable toTable() {
        this.load();
        return this;
    }

    public ColumnList getColumns() {
        this.load();
        return this.columnList;
    }

    public BObject get(int n, Column column) {
        this.load();
        BComplex bComplex = (BComplex)this.array.get(n);
        return bComplex.get(column.getName());
    }

    public String getString(int n, Column column) {
        this.load();
        BComplex bComplex = (BComplex)this.array.get(n);
        return bComplex.get(column.getName()).toString();
    }

    public double getDouble(int n, Column column) {
        this.load();
        BComplex bComplex = (BComplex)this.array.get(n);
        BNumber bNumber = (BNumber)bComplex.get(column.getName());
        return bNumber.getDouble();
    }

    public float getFloat(int n, Column column) {
        this.load();
        BComplex bComplex = (BComplex)this.array.get(n);
        BNumber bNumber = (BNumber)bComplex.get(column.getName());
        return bNumber.getFloat();
    }

    public int getInt(int n, Column column) {
        this.load();
        BComplex bComplex = (BComplex)this.array.get(n);
        BNumber bNumber = (BNumber)bComplex.get(column.getName());
        return bNumber.getInt();
    }

    public long getLong(int n, Column column) {
        this.load();
        BComplex bComplex = (BComplex)this.array.get(n);
        BNumber bNumber = (BNumber)bComplex.get(column.getName());
        return bNumber.getLong();
    }

    public boolean getBoolean(int n, Column column) {
        this.load();
        BComplex bComplex = (BComplex)this.array.get(n);
        BBoolean bBoolean = (BBoolean)bComplex.get(column.getName());
        return bBoolean.getBoolean();
    }

    public int getFlags(int n, Column column) {
        return 0;
    }

    public BFacets getFacets(int n, Column column) {
        return BFacets.NULL;
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    public BITable sort(Column column, boolean bl) {
        if (this.array.size() == 0) {
            return this;
        }
        return new BAlarmDbResultSetTable(this.array.sort((Comparator)new ResultSetTableComparator(column, bl)), this.columnList);
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            if (this.sql != null) {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(this.sql.getBody());
            } else if (this.ps != null) {
                resultSet = this.ps.executeQuery();
            }
            if (resultSet == null) {
                return;
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.checkFieldTypes(resultSetMetaData);
            this.array = new Array(class$javax$baja$alarm$BAlarmRecord == null ? (class$javax$baja$alarm$BAlarmRecord = BAlarmDbResultSetTable.class$("javax.baja.alarm.BAlarmRecord")) : class$javax$baja$alarm$BAlarmRecord);
            while (resultSet.next()) {
                this.array.add((Object)this.makeAlarmRecord(resultSetMetaData, resultSet));
            }
            this.columnList = this.array.size() == 0 ? new ResultSetColumnList() : new ResultSetColumnList((BComplex)((BAlarmRecord)this.array.get(0)));
            this.loaded = true;
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void checkFieldTypes(ResultSetMetaData resultSetMetaData) throws SQLException {
        block3: for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            Object var3_3 = null;
            switch (resultSetMetaData.getColumnType(i)) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 12: 
                case 91: 
                case 93: {
                    continue block3;
                }
                default: {
                    System.out.println("WARNING: Column " + resultSetMetaData.getColumnName(i) + ": " + "Converting unknown SQL Type '" + resultSetMetaData.getColumnTypeName(i) + "' (" + resultSetMetaData.getColumnType(i) + ") to String.");
                }
            }
        }
    }

    private BAbsTime getAbsTime(ResultSet resultSet, int n) throws SQLException {
        if (this.array.size() == 0) {
            try {
                resultSet.getTimestamp(n);
            }
            catch (SQLException sQLException) {
                this.supportsTimestamp = false;
            }
        }
        if (this.supportsTimestamp) {
            return BAbsTime.make((long)resultSet.getTimestamp(n).getTime());
        }
        return BAbsTime.make((long)resultSet.getLong(n));
    }

    protected BAlarmRecord makeAlarmRecord(ResultSetMetaData resultSetMetaData, ResultSet resultSet) throws SQLException {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String string;
            String string2 = resultSetMetaData.getColumnName(i);
            if (string2.equals("UUID")) {
                string = resultSet.getString(i);
                bAlarmRecord.setUuid(BUuid.make((String)(string == null ? "" : string)));
                continue;
            }
            if (string2.equals("TIMESTAMP")) {
                bAlarmRecord.setTimestamp(this.getAbsTime(resultSet, i));
                continue;
            }
            if (string2.equals("NORMALTIME")) {
                bAlarmRecord.setNormalTime(this.getAbsTime(resultSet, i));
                continue;
            }
            if (string2.equals("ACKTIME")) {
                bAlarmRecord.setAckTime(this.getAbsTime(resultSet, i));
                continue;
            }
            if (string2.equals("LASTUPDATE")) {
                bAlarmRecord.setLastUpdate(this.getAbsTime(resultSet, i));
                continue;
            }
            if (string2.equals("PRIORITY")) {
                bAlarmRecord.setPriority(resultSet.getInt(i));
                continue;
            }
            if (string2.equals("ACKREQUIRED")) {
                bAlarmRecord.setAckRequired(resultSet.getBoolean(i));
                continue;
            }
            if (string2.equals("SOURCE")) {
                string = resultSet.getString(i);
                bAlarmRecord.setSource(BOrdList.make((String)(string == null ? "" : string)));
                continue;
            }
            if (string2.equals("USER")) {
                bAlarmRecord.setUser(resultSet.getString(i));
                continue;
            }
            if (string2.equals("ALARMCLASS")) {
                bAlarmRecord.setAlarmClass(resultSet.getString(i));
                continue;
            }
            if (string2.equals("ACKSTATE")) {
                string = resultSet.getString(i);
                try {
                    bAlarmRecord.setAckState(BAckState.make((String)(string == null ? "" : string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (string2.equals("SOURCESTATE")) {
                string = resultSet.getString(i);
                try {
                    bAlarmRecord.setSourceState(BSourceState.make((String)(string == null ? "" : string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (string2.equals("ALARMTRANSITION")) {
                string = resultSet.getString(i);
                try {
                    bAlarmRecord.setAlarmTransition(BSourceState.make((String)(string == null ? "" : string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (!string2.equals("ALARMDATA")) continue;
            string = resultSet.getString(i);
            try {
                bAlarmRecord.setAlarmData(BFacets.make((String)(string == null ? "" : string)));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bAlarmRecord;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ResultSetTableComparator
    implements Comparator {
        Column col;
        boolean ascending;

        ResultSetTableComparator(Column column, boolean bl) {
            this.col = column;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            BComplex bComplex = (BComplex)object;
            BComplex bComplex2 = (BComplex)object2;
            BValue bValue = bComplex.get(this.col.getName());
            BValue bValue2 = bComplex2.get(this.col.getName());
            if (bValue instanceof Comparable) {
                return this.ascending ? ((Comparable)bValue).compareTo(bValue2) : -((Comparable)bValue).compareTo(bValue2);
            }
            return this.ascending ? bValue.toString().compareTo(bValue2.toString()) : -bValue.toString().compareTo(bValue2.toString());
        }
    }
}

