/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point;

import java.util.Comparator;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.Tuning;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTuningPolicyMap
extends BComponent {
    public static final Property defaultPolicy = BTuningPolicyMap.newProperty((int)0, (BValue)new BTuningPolicy(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    static long minScan;
    static long maxScan;
    BackgroundThread thread;
    Object lock;
    Tuning[] tunings;
    long scanFrequency;
    int scanCount;
    long lastScanDuration;
    static /* synthetic */ Class class$javax$baja$driver$point$BTuningPolicyMap;
    static /* synthetic */ Class class$javax$baja$driver$point$BTuningPolicy;
    static /* synthetic */ Class class$javax$baja$driver$point$Tuning;

    public BTuningPolicy getDefaultPolicy() {
        return (BTuningPolicy)this.get(defaultPolicy);
    }

    public void setDefaultPolicy(BTuningPolicy bTuningPolicy) {
        this.set(defaultPolicy, (BValue)bTuningPolicy, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BDeviceNetwork getNetwork() {
        return (BDeviceNetwork)this.getParent();
    }

    public final BTuningPolicy[] getPolicies() {
        Class clazz = class$javax$baja$driver$point$BTuningPolicy;
        if (clazz == null) {
            clazz = class$javax$baja$driver$point$BTuningPolicy = BTuningPolicyMap.class("[Ljavax.baja.driver.point.BTuningPolicy;", false);
        }
        return (BTuningPolicy[])this.getChildren(clazz);
    }

    public boolean isChildLegal(BComponent bComponent) {
        return bComponent instanceof BTuningPolicy;
    }

    public void started() throws Exception {
        super.started();
        this.startThread();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int register(Tuning tuning) {
        Object object = this.lock;
        synchronized (object) {
            int n = 1;
            while (true) {
                if (n >= this.tunings.length) {
                    n = this.tunings.length;
                    Tuning[] tuningArray = new Tuning[n * 2];
                    System.arraycopy(this.tunings, 0, tuningArray, 0, n);
                    this.tunings = tuningArray;
                    this.tunings[n] = tuning;
                    return n;
                }
                if (this.tunings[n] == null) {
                    this.tunings[n] = tuning;
                    return n;
                }
                ++n;
            }
        }
    }

    void startThread() {
        this.stopThread();
        this.thread = new BackgroundThread(this.getNetwork());
        this.thread.start();
    }

    void stopThread() {
        if (this.thread != null) {
            this.thread.kill();
        }
        this.thread = null;
    }

    long computeScanFrequency() {
        long l = maxScan;
        BTuningPolicy[] bTuningPolicyArray = this.getPolicies();
        int n = 0;
        while (n < bTuningPolicyArray.length) {
            BTuningPolicy bTuningPolicy = bTuningPolicyArray[n];
            long l2 = bTuningPolicy.getMinWriteTime().getMillis();
            long l3 = bTuningPolicy.getMaxWriteTime().getMillis();
            long l4 = bTuningPolicy.getStaleTime().getMillis();
            if (l2 > 0L) {
                l = Math.min(l, l2 / (long)2);
            }
            if (l3 > 0L) {
                l = Math.min(l, l3 / (long)2);
            }
            if (l4 > 0L) {
                l = Math.min(l, l4 / (long)2);
            }
            ++n;
        }
        l = Math.max(l, minScan);
        return l;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        Class clazz = class$javax$baja$driver$point$Tuning;
        if (clazz == null) {
            clazz = class$javax$baja$driver$point$Tuning = BTuningPolicyMap.class("[Ljavax.baja.driver.point.Tuning;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < this.tunings.length) {
            if (this.tunings[n] != null) {
                array.add((Object)this.tunings[n]);
            }
            ++n;
        }
        spyWriter.startProps("Tuning Performance");
        spyWriter.prop((Object)"scanFrequency", (Object)BRelTime.toString((long)this.scanFrequency));
        spyWriter.prop((Object)"scanCount", (Object)("" + this.scanCount));
        spyWriter.prop((Object)"lastScanDuration", (Object)BRelTime.toString((long)this.lastScanDuration));
        spyWriter.prop((Object)"proxyPointCount", (Object)("" + array.size()));
        spyWriter.endProps();
        super.spy(spyWriter);
        n = 1000;
        if (array.size() < n) {
            array = array.sort(new Comparator(){

                public final int compare(Object object, Object object2) {
                    BComponent bComponent = (BComponent)((Tuning)object).getTunable();
                    BComponent bComponent2 = (BComponent)((Tuning)object2).getTunable();
                    String string = bComponent.toPathString();
                    String string2 = bComponent2.toPathString();
                    return string.compareTo(string2);
                }
            });
        }
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)("Proxy Point List [" + array.size() + ']'), 3);
        spyWriter.w((Object)"<tr>").th((Object)"Id").th((Object)"Path").th((Object)"Type").w((Object)"</tr>\n");
        int n2 = 0;
        while (n2 < array.size() && n2 < n) {
            Tuning tuning = (Tuning)array.get(n2);
            BComponent bComponent = (BComponent)tuning.getTunable();
            spyWriter.tr((Object)("" + tuning.processId()), (Object)bComponent.toPathString(), (Object)bComponent.getType());
            ++n2;
        }
        if (array.size() >= n) {
            spyWriter.tr((Object)(array.size() - n + " more points..."), (Object)"");
        }
        spyWriter.endTable();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
        this.tunings = new Tuning[100];
        this.scanFrequency = 1000L;
    }

    public BTuningPolicyMap() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$point$BTuningPolicyMap;
        if (clazz == null) {
            clazz = class$javax$baja$driver$point$BTuningPolicyMap = BTuningPolicyMap.class("[Ljavax.baja.driver.point.BTuningPolicyMap;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"wrench.png");
        minScan = 200L;
        maxScan = 20000L;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BackgroundThread
    extends Thread {
        BDeviceNetwork network;
        boolean isAlive;

        void kill() {
            this.isAlive = false;
            this.interrupt();
        }

        public void run() {
            while (this.isAlive) {
                try {
                    BTuningPolicyMap.this.scanFrequency = BTuningPolicyMap.this.computeScanFrequency();
                    Thread.sleep(BTuningPolicyMap.this.scanFrequency);
                    if (!this.network.isDescendantsStarted()) continue;
                    long l = Clock.ticks();
                    Tuning[] tuningArray = BTuningPolicyMap.this.tunings;
                    int n = 0;
                    while (n < tuningArray.length) {
                        this.process(tuningArray, n);
                        ++n;
                    }
                    long l2 = Clock.ticks();
                    ++BTuningPolicyMap.this.scanCount;
                    BTuningPolicyMap.this.lastScanDuration = l2 - l;
                }
                catch (Throwable throwable) {
                    if (!this.isAlive) continue;
                    throwable.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void process(Tuning[] tuningArray, int n) {
            Tuning tuning = tuningArray[n];
            if (tuning == null) {
                return;
            }
            try {
                boolean bl = tuning.process();
                if (bl) return;
                Object object = BTuningPolicyMap.this.lock;
                synchronized (object) {
                    BTuningPolicyMap.this.tunings[n] = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        private final /* synthetic */ void this() {
            this.isAlive = true;
        }

        BackgroundThread(BDeviceNetwork bDeviceNetwork) {
            super("Tuning:" + bDeviceNetwork.getName());
            this.this();
            this.network = bDeviceNetwork;
        }
    }
}

