/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point;

import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BITunable;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.Tuning;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnitConversion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BProxyExt
extends BAbstractProxyExt
implements BIStatus,
BITunable {
    public static final Property status = BProxyExt.newProperty((int)3, (BValue)BStatus.stale, null);
    public static final Property faultCause = BProxyExt.newProperty((int)3, (String)"", null);
    public static final Property enabled = BProxyExt.newProperty((int)0, (boolean)true, null);
    public static final Property deviceFacets = BProxyExt.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property conversion = BProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:ProxyConversionFE"));
    public static final Property tuningPolicyName = BProxyExt.newProperty((int)0, (String)"defaultPolicy", (BFacets)BITunable.TUNING_POLICY_NAME_FACETS);
    public static final Property readValue = BProxyExt.newProperty((int)3, (BValue)new BStatusString("-"), null);
    public static final Property writeValue = BProxyExt.newProperty((int)3, (BValue)new BStatusString("-"), null);
    public static final Type TYPE;
    static final int FATAL_FAULT = 1;
    static final int STALE = 2;
    static final int FORCE_WRITE = 4;
    static final int CONV_ERR_D2P = 8;
    static final int CONV_ERR_P2D = 16;
    private BDevice device;
    private BPointDeviceExt deviceExt;
    private int flags;
    private int oldStatus;
    private String readFault;
    private String writeFault;
    private BStatusValue lastWorking;
    private Tuning tuning;
    static /* synthetic */ Class class$javax$baja$driver$point$BProxyExt;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BFacets getDeviceFacets() {
        return (BFacets)this.get(deviceFacets);
    }

    public void setDeviceFacets(BFacets bFacets) {
        this.set(deviceFacets, (BValue)bFacets, null);
    }

    public BProxyConversion getConversion() {
        return (BProxyConversion)this.get(conversion);
    }

    public void setConversion(BProxyConversion bProxyConversion) {
        this.set(conversion, (BValue)bProxyConversion, null);
    }

    public String getTuningPolicyName() {
        return this.getString(tuningPolicyName);
    }

    public void setTuningPolicyName(String string) {
        this.setString(tuningPolicyName, string, null);
    }

    public BStatusValue getReadValue() {
        return (BStatusValue)this.get(readValue);
    }

    public void setReadValue(BStatusValue bStatusValue) {
        this.set(readValue, (BValue)bStatusValue, null);
    }

    public BStatusValue getWriteValue() {
        return (BStatusValue)this.get(writeValue);
    }

    public void setWriteValue(BStatusValue bStatusValue) {
        this.set(writeValue, (BValue)bStatusValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract Type getDeviceExtType();

    public abstract BReadWriteMode getMode();

    public final BDeviceNetwork getNetwork() {
        return this.getDevice().getNetwork();
    }

    public final BDevice getDevice() {
        if (this.device != null) {
            return this.device;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BPointDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)readValue) || slot.equals((Object)writeValue)) {
            return BFacets.make((BFacets)this.getDeviceFacets(), (String)"unitConversion", (BIDataValue)BDynamicEnum.make((BEnum)BUnitConversion.none));
        }
        return super.getSlotFacets(slot);
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isUnoperational() {
        boolean bl = false;
        if (this.isDown() || this.isDisabled() || this.isFatalFault()) {
            bl = true;
        }
        return bl;
    }

    public final void updateStatus() {
        BStatus bStatus;
        int n = this.getStatus().getBits();
        BStatus bStatus2 = bStatus = this.device == null ? BStatus.ok : this.device.getStatus();
        n = !this.getEnabled() || bStatus.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = bStatus.isDown() ? (n |= 4) : (n &= 0xFFFFFFFB);
        n = this.fatalFault() || this.readFault != null || this.writeFault != null || bStatus.isFault() ? (n |= 2) : (n &= 0xFFFFFFFD);
        n = this.stale() ? (n |= 0x10) : (n &= 0xFFFFFFEF);
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
        this.updateFaultCause();
        this.getTuning().transition();
        this.executePoint();
    }

    private final void updateFaultCause() {
        if (this.fatalFault()) {
            return;
        }
        String string = this.readFault != null && this.writeFault != null ? "Read fault: " + this.readFault + "; Write fault: " + this.writeFault : (this.readFault != null ? "Read fault: " + this.readFault : (this.writeFault != null ? "Write fault: " + this.writeFault : (this.convErrD2P() || this.convErrP2D() ? "Conversion Error" : "")));
        this.setFaultCause(string);
    }

    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    public final void configFatal(String string) {
        this.fatalFault(true);
        this.setFaultCause(string);
        this.updateStatus();
    }

    private final void checkFatalFault(String string) {
        Object object;
        if (string != null) {
            this.configFatal("Exceeded point limit for " + string);
            return;
        }
        BPointDeviceExt bPointDeviceExt = null;
        BDevice bDevice = null;
        BDeviceNetwork bDeviceNetwork = null;
        if (this.fatalFault()) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BPointDeviceExt) {
                bPointDeviceExt = (BPointDeviceExt)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bPointDeviceExt == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under PointDeviceExt");
            return;
        }
        if (!bPointDeviceExt.getType().is(this.getDeviceExtType())) {
            this.fatalFault(true);
            this.setFaultCause("Parent PointDeviceExt " + bPointDeviceExt.getType() + " is not " + this.getDeviceExtType());
            return;
        }
        bDevice = bPointDeviceExt.getDevice();
        if (bDevice == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under Device");
            return;
        }
        if (!bDevice.getType().is(bPointDeviceExt.getDeviceType())) {
            this.fatalFault(true);
            this.setFaultCause("Parent Device " + bDevice.getType() + " is not " + bPointDeviceExt.getDeviceType());
            return;
        }
        if (bDevice.isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + bDevice.getFaultCause());
            return;
        }
        bDeviceNetwork = bDevice.getNetwork();
        if (bDeviceNetwork == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under DeviceNetwork");
            return;
        }
        if (bDeviceNetwork.isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + bDeviceNetwork.getFaultCause());
            return;
        }
        if (this.getType().is(bPointDeviceExt.getProxyExtType()) && (object = bDeviceNetwork.fw(501, "point.limit", null, null, null)) != null) {
            this.fatalFault(true);
            this.setFaultCause(object.toString());
            return;
        }
        this.device = bDevice;
        this.deviceExt = bPointDeviceExt;
        this.setFaultCause("");
        if (this.device == null || this.deviceExt == null) {
            throw new IllegalStateException();
        }
    }

    public void checkStatusValueTypes() {
        BControlPoint bControlPoint = this.getParentPoint();
        if (bControlPoint == null) {
            return;
        }
        BStatusValue bStatusValue = bControlPoint.getOutStatusValue();
        if (bStatusValue.getType() != this.getReadValue().getType()) {
            this.set(readValue, (BValue)((BStatusValue)bStatusValue.getType().getInstance()));
        }
        if (bStatusValue.getType() != this.getWriteValue().getType()) {
            this.set(writeValue, (BValue)((BStatusValue)bStatusValue.getType().getInstance()));
        }
    }

    public final void onExecute(BStatusValue bStatusValue, Context context) {
        if (this.getMode().isWrite() && (this.hasWorkingChanged(bStatusValue) || this.forceWrite())) {
            this.forceWrite(false);
            this.convertProxyToDevice(bStatusValue, this.getWriteValue());
            this.getTuning().writeDesired();
        }
        BStatus bStatus = bStatusValue.getStatus();
        this.convertDeviceToProxy(this.getReadValue(), bStatusValue);
        BStatus bStatus2 = bStatusValue.getStatus();
        int n = bStatus.getBits() & 0xFFFFFFBF;
        int n2 = bStatus2.getBits();
        int n3 = this.getStatus().getBits();
        int n4 = n | n2 | n3;
        BStatus bStatus3 = bStatus2.getFacets().isNull() ? BStatus.make((BStatus)bStatus, (int)n4) : BStatus.make((int)n4, (BFacets)BFacets.make((BFacets)bStatus.getFacets(), (BFacets)bStatus2.getFacets()));
        bStatusValue.setStatus(bStatus3);
    }

    public void pointFacetsChanged() {
        this.forceWrite(true);
    }

    public void writablePointActionInvoked() {
        this.forceWrite(true);
    }

    private final boolean hasWorkingChanged(BStatusValue bStatusValue) {
        if (this.lastWorking == null) {
            this.lastWorking = (BStatusValue)bStatusValue.newCopy();
            this.convertProxyToDevice(bStatusValue, this.getWriteValue());
            return false;
        }
        if (this.lastWorking.equivalent((Object)bStatusValue)) {
            return false;
        }
        this.lastWorking.copyFrom((BComplex)bStatusValue);
        return true;
    }

    public final Tuning getTuning() {
        return this.tuning;
    }

    public void setStale(boolean bl, Context context) {
        if (this.stale() != bl) {
            this.stale(bl);
            this.updateStatus();
        }
    }

    public final BTuningPolicy getTuningPolicy() {
        return this.getTuning().getPolicy();
    }

    public boolean isSubscribedDesired() {
        return this.getParentPoint().isSubscribed();
    }

    public final void pointSubscribed() {
        this.getTuning().transition();
    }

    public final void pointUnsubscribed() {
        this.getTuning().transition();
    }

    public abstract void readSubscribed(Context var1) throws Exception;

    public abstract void readUnsubscribed(Context var1) throws Exception;

    public abstract boolean write(Context var1) throws Exception;

    public void readOk(BStatusValue bStatusValue) {
        this.setReadValue((BStatusValue)bStatusValue.newCopy());
        this.getTuning().readOk();
        this.readFault = null;
        this.stale(false);
        this.updateStatus();
        this.executePoint();
    }

    public void readReset() {
        this.readFault = null;
        this.stale(true);
        this.updateStatus();
        this.executePoint();
    }

    public void readFail(String string) {
        this.getTuning().readFail();
        this.readFault = string;
        this.oldStatus = -1;
        this.updateStatus();
        this.executePoint();
    }

    public void writeOk(BStatusValue bStatusValue) {
        if (this.getMode().isWriteonly()) {
            this.setReadValue((BStatusValue)bStatusValue.newCopy());
            this.stale(false);
        }
        this.getTuning().writeOk();
        this.writeFault = null;
        this.updateStatus();
        if (this.getMode().isWriteonly()) {
            this.executePoint();
        }
    }

    public void writeReset() {
        this.getTuning().writeFail();
        this.writeFault = null;
        this.oldStatus = -1;
        this.updateStatus();
    }

    public void writeFail(String string) {
        this.getTuning().writeFail();
        this.writeFault = string;
        this.oldStatus = -1;
        this.updateStatus();
    }

    protected void convertDeviceToProxy(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        boolean bl;
        boolean bl2 = this.convErrD2P();
        try {
            this.getConversion().convertDeviceToProxy(this, bStatusValue, bStatusValue2);
            bl = false;
        }
        catch (Exception exception) {
            bStatusValue2.setValueValue(bStatusValue.getValueValue());
            bStatusValue2.setStatusFault(true);
            bl = true;
        }
        if (bl2 != bl) {
            this.convErrD2P(bl);
            this.updateFaultCause();
        }
    }

    protected void convertProxyToDevice(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        boolean bl;
        boolean bl2 = this.convErrP2D();
        try {
            this.getConversion().convertProxyToDevice(this, bStatusValue, bStatusValue2);
            bl = false;
        }
        catch (Exception exception) {
            bStatusValue2.setValueValue(bStatusValue.getValueValue());
            bStatusValue2.setStatusFault(true);
            bl = true;
        }
        if (bl2 != bl) {
            this.convErrP2D(bl);
            this.updateFaultCause();
        }
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 20: {
                this.fwAtSteadyState();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 14: {
                this.fwDescendantsStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)object);
                break;
            }
            case 21: {
                ((ResourceReport)object).add("proxyExt", 250);
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        this.checkFatalFault(Metrics.incrementPoint((BComplex)this));
        this.updateStatus();
        this.getTuning().transition();
    }

    private final void fwAtSteadyState() {
        this.getTuning().transition();
    }

    private final void fwStopped() {
        this.getTuning().transition();
    }

    private final void fwDescendantsStopped() {
        this.device = null;
        this.deviceExt = null;
    }

    private final void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled)) {
            this.updateStatus();
        } else if (property.equals((Object)deviceFacets) || property.equals((Object)conversion)) {
            this.forceWrite(true);
            this.executePoint();
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("ProxyExt");
        spyWriter.prop((Object)"fatalFault", (Object)("" + this.fatalFault()));
        spyWriter.prop((Object)"stale", (Object)("" + this.stale()));
        spyWriter.prop((Object)"readFault", (Object)this.readFault);
        spyWriter.prop((Object)"writeFault", (Object)this.writeFault);
        spyWriter.prop((Object)"lastWorking", (Object)this.lastWorking);
        spyWriter.prop((Object)"convErrP2D", this.convErrP2D());
        spyWriter.prop((Object)"convErrD2P", this.convErrD2P());
        spyWriter.prop((Object)"tuning.subscribed", (Object)("" + this.tuning.subscribed()));
        spyWriter.prop((Object)"tuning.readTicks", (Object)BProxyExt.timestr(this.tuning.readTicks));
        spyWriter.prop((Object)"tuning.writeTicks", (Object)BProxyExt.timestr(this.tuning.writeTicks));
        spyWriter.prop((Object)"tuning.wrieDesiredTicks", (Object)BProxyExt.timestr(this.tuning.writeTicks));
        spyWriter.prop((Object)"tuning.writePending", (Object)("" + this.tuning.writePending()));
        spyWriter.prop((Object)"tuning.state", (Object)Tuning.toString(this.tuning.state()));
        spyWriter.prop((Object)"tuning.processId", (Object)("" + this.tuning.processId()));
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    static String timestr(long l) {
        if (l == 0L) {
            return "null";
        }
        long l2 = Clock.ticks();
        long l3 = l2 - l;
        if (l3 < 1000L) {
            return l3 + "ms";
        }
        return l3 / 1000L + "sec";
    }

    private final boolean fatalFault() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void fatalFault(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    private final boolean stale() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void stale(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    private final boolean forceWrite() {
        boolean bl = false;
        if ((this.flags & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void forceWrite(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    private final boolean convErrD2P() {
        boolean bl = false;
        if ((this.flags & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void convErrD2P(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    private final boolean convErrP2D() {
        boolean bl = false;
        if ((this.flags & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void convErrP2D(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.flags = 2;
        this.oldStatus = 16;
        this.tuning = new Tuning(this);
    }

    public BProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$point$BProxyExt;
        if (clazz == null) {
            clazz = class$javax$baja$driver$point$BProxyExt = BProxyExt.class("[Ljavax.baja.driver.point.BProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

