/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.file.history;

import com.tridium.driver.file.BFileDevice;
import com.tridium.driver.file.enums.BRecordTypeEnum;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.file.history.BFileHistoryImport;
import javax.baja.file.BIFile;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDelimitedFileImport
extends BFileHistoryImport {
    static Lexicon lex = Lexicon.make((String)"driver");
    public static final Property fullImportOnExecute = BDelimitedFileImport.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)lex.getText("import.fullImport.enabled"), (String)lex.getText("import.fullImport.disabled")));
    public static final Property rowStart = BDelimitedFileImport.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property rowEnd = BDelimitedFileImport.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.makeInt(null, (int)-1, (int)Integer.MAX_VALUE), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:OptionalPositiveIntegerFE")));
    public static final Property delimiter = BDelimitedFileImport.newProperty((int)0, (String)",", null);
    public static final Property timestampColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property timestampFormat = BDelimitedFileImport.newProperty((int)0, (String)"d-MMM-yy h:mm a z", (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:TimestampFormatFE"));
    public static final Property valueColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property valueFormat = BDelimitedFileImport.newProperty((int)0, (BValue)BRecordTypeEnum.numericType, null);
    public static final Property statusColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.makeInt(null, (int)-1, (int)Integer.MAX_VALUE), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:OptionalPositiveIntegerFE")));
    public static final Property identifierColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.makeInt(null, (int)-1, (int)Integer.MAX_VALUE), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:OptionalPositiveIntegerFE")));
    public static final Property identifierPattern = BDelimitedFileImport.newProperty((int)0, (String)"*", null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final char ONE_CHAR = '\u0000';
    Pattern rowPattern;
    static /* synthetic */ Class class$com$tridium$driver$file$history$BDelimitedFileImport;

    public boolean getFullImportOnExecute() {
        return this.getBoolean(fullImportOnExecute);
    }

    public void setFullImportOnExecute(boolean bl) {
        this.setBoolean(fullImportOnExecute, bl, null);
    }

    public int getRowStart() {
        return this.getInt(rowStart);
    }

    public void setRowStart(int n) {
        this.setInt(rowStart, n, null);
    }

    public int getRowEnd() {
        return this.getInt(rowEnd);
    }

    public void setRowEnd(int n) {
        this.setInt(rowEnd, n, null);
    }

    public String getDelimiter() {
        return this.getString(delimiter);
    }

    public void setDelimiter(String string) {
        this.setString(delimiter, string, null);
    }

    public int getTimestampColumnIndex() {
        return this.getInt(timestampColumnIndex);
    }

    public void setTimestampColumnIndex(int n) {
        this.setInt(timestampColumnIndex, n, null);
    }

    public String getTimestampFormat() {
        return this.getString(timestampFormat);
    }

    public void setTimestampFormat(String string) {
        this.setString(timestampFormat, string, null);
    }

    public int getValueColumnIndex() {
        return this.getInt(valueColumnIndex);
    }

    public void setValueColumnIndex(int n) {
        this.setInt(valueColumnIndex, n, null);
    }

    public BRecordTypeEnum getValueFormat() {
        return (BRecordTypeEnum)this.get(valueFormat);
    }

    public void setValueFormat(BRecordTypeEnum bRecordTypeEnum) {
        this.set(valueFormat, (BValue)bRecordTypeEnum, null);
    }

    public int getStatusColumnIndex() {
        return this.getInt(statusColumnIndex);
    }

    public void setStatusColumnIndex(int n) {
        this.setInt(statusColumnIndex, n, null);
    }

    public int getIdentifierColumnIndex() {
        return this.getInt(identifierColumnIndex);
    }

    public void setIdentifierColumnIndex(int n) {
        this.setInt(identifierColumnIndex, n, null);
    }

    public String getIdentifierPattern() {
        return this.getString(identifierPattern);
    }

    public void setIdentifierPattern(String string) {
        this.setString(identifierPattern, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected IFuture postExecute(Action action, BValue bValue, Context context) {
        BFileDevice bFileDevice = (BFileDevice)this.getDevice();
        if (bFileDevice != null) {
            bFileDevice.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return null;
    }

    public void changed(Property property, Context context) {
        if (property == identifierPattern) {
            this.rowPattern = null;
        } else {
            super.changed(property, context);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeFileImport(BIFile bIFile) {
        FilterInputStream filterInputStream;
        InputStream inputStream;
        block48: {
            block46: {
                block45: {
                    block43: {
                        block44: {
                            inputStream = null;
                            filterInputStream = null;
                            this.executeInProgress();
                            int n = -1;
                            try {
                                try {
                                    Object object;
                                    Object object2;
                                    Object object3;
                                    DelimitedRow[] delimitedRowArray;
                                    BHistoryId bHistoryId = this.getHistoryId();
                                    if (bHistoryId.isNull()) {
                                        this.executeFail(lex.getText("import.error.nullId"));
                                        Object var6_7 = null;
                                        if (filterInputStream == null) break block43;
                                        break block44;
                                    }
                                    BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                                    if (bHistoryDatabase == null) {
                                        this.executeFail(lex.getText("import.error.dbNotAvailable"));
                                        break block45;
                                    }
                                    BTypeSpec bTypeSpec = BDelimitedFileImport.getRecordType(this.getValueFormat());
                                    if (bTypeSpec == null) {
                                        Object[] objectArray = new Object[]{this.getValueFormat()};
                                        this.executeFail(lex.getText("import.error.invalidRecordType", objectArray));
                                        break block46;
                                    }
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getTimestampFormat());
                                    inputStream = bIFile.getInputStream();
                                    filterInputStream = new DataInputStream(inputStream);
                                    int n2 = this.getRowStart();
                                    n = n2 + 1;
                                    int n3 = this.getRowEnd();
                                    int n4 = this.getTimestampColumnIndex();
                                    int n5 = this.getValueColumnIndex();
                                    int n6 = this.getStatusColumnIndex();
                                    int n7 = this.getIdentifierColumnIndex();
                                    if (this.rowPattern == null) {
                                        this.rowPattern = new Pattern(this.getIdentifierPattern());
                                    }
                                    Pattern pattern = this.rowPattern;
                                    boolean bl = false;
                                    if (n7 >= 0 && pattern != null) {
                                        bl = true;
                                    }
                                    boolean bl2 = bl;
                                    Vector<DelimitedRow> vector = new Vector<DelimitedRow>();
                                    String string = "";
                                    String string2 = this.getDelimiter();
                                    int n8 = 0;
                                    while ((string = ((DataInputStream)filterInputStream).readLine()) != null) {
                                        block47: {
                                            if (n8 >= n2 && (n3 < 0 || n8 <= n3)) {
                                                String string3;
                                                delimitedRowArray = null;
                                                object3 = null;
                                                object2 = null;
                                                boolean bl3 = bl2 ^ true;
                                                object = new StringTokenizer(string, string2);
                                                int n9 = 0;
                                                while (true) {
                                                    if (!((StringTokenizer)object).hasMoreTokens()) {
                                                        if (bl3) {
                                                            string3 = null;
                                                            string3 = n4 >= 0 ? BAbsTime.make((long)simpleDateFormat.parse((String)delimitedRowArray, new ParsePosition(0)).getTime()) : BAbsTime.now();
                                                        }
                                                        break block47;
                                                    }
                                                    string3 = ((StringTokenizer)object).nextToken();
                                                    if (n9 == n7 && bl2) {
                                                        bl3 = pattern.isMatch(string3);
                                                    }
                                                    if (n9 == n4) {
                                                        delimitedRowArray = string3;
                                                    }
                                                    if (n9 == n5) {
                                                        object3 = string3;
                                                    }
                                                    if (n9 == n6) {
                                                        object2 = string3;
                                                    }
                                                    ++n9;
                                                }
                                                BStatus bStatus = BStatus.ok;
                                                if (n6 >= 0) {
                                                    bStatus = BStatus.make((int)Integer.parseInt((String)object2));
                                                }
                                                vector.addElement(new DelimitedRow((BAbsTime)string3, (String)object3, bStatus));
                                            }
                                        }
                                        ++n;
                                        if (n3 < 0 || ++n8 <= n3) continue;
                                    }
                                    n = -1;
                                    delimitedRowArray = BDelimitedFileImport.sortByTimestamp(vector);
                                    object3 = null;
                                    object2 = null;
                                    BAbsTime bAbsTime = null;
                                    if (!bHistoryDatabase.exists(bHistoryId)) {
                                        object3 = this.makeLocalConfig(this.makeLocalHistoryFileConfig(bHistoryId, bTypeSpec));
                                        bHistoryDatabase.createHistory(object3);
                                        object2 = bHistoryDatabase.getHistory(bHistoryId);
                                    } else {
                                        if (this.getFullImportOnExecute()) {
                                            bHistoryDatabase.clearAllRecords(bHistoryId, null);
                                        }
                                        object3 = this.makeLocalConfig(bHistoryDatabase.getHistory(bHistoryId).getConfig());
                                        bHistoryDatabase.reconfigureHistory(object3);
                                        object2 = bHistoryDatabase.getHistory(bHistoryId);
                                        if (!this.getFullImportOnExecute()) {
                                            bAbsTime = object2.getLastTimestamp();
                                        }
                                    }
                                    bTypeSpec = object3.getRecordType();
                                    object = bTypeSpec.getTypeName();
                                    BHistoryRecord bHistoryRecord = object3.makeRecord();
                                    this.appendToHistory((BIHistory)object2, bHistoryRecord, bAbsTime, delimitedRowArray, (String)object);
                                    this.executeOk();
                                }
                                catch (Exception exception) {
                                    if (n >= 0) {
                                        System.out.println("File import failed on file line " + n + '.');
                                    }
                                    exception.printStackTrace();
                                    if (n >= 0) {
                                        Object[] objectArray = new Integer[]{new Integer(n)};
                                        this.executeFail(lex.getText("import.fileError.lineNumber", objectArray));
                                        break block48;
                                    }
                                    if (exception instanceof LocalizableRuntimeException) {
                                        this.executeFail(((LocalizableRuntimeException)exception).toString(null));
                                        break block48;
                                    }
                                    this.executeFail(exception);
                                }
                                break block48;
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                if (filterInputStream != null) {
                                    try {
                                        filterInputStream.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                if (inputStream == null) throw throwable;
                                try {
                                    inputStream.close();
                                    throw throwable;
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                        }
                        try {}
                        catch (Exception exception) {}
                        filterInputStream.close();
                    }
                    if (inputStream == null) return;
                    try {}
                    catch (Exception exception) {}
                    inputStream.close();
                    return;
                }
                Object var6_8 = null;
                if (filterInputStream != null) {
                    try {}
                    catch (Exception exception) {}
                    filterInputStream.close();
                }
                if (inputStream == null) return;
                try {}
                catch (Exception exception) {}
                inputStream.close();
                return;
            }
            Object var6_9 = null;
            if (filterInputStream != null) {
                try {}
                catch (Exception exception) {}
                filterInputStream.close();
            }
            if (inputStream == null) return;
            try {}
            catch (Exception exception) {}
            inputStream.close();
            return;
        }
        Object var6_11 = null;
        if (filterInputStream != null) {
            try {}
            catch (Exception exception) {}
            filterInputStream.close();
        }
        if (inputStream == null) return;
        try {}
        catch (Exception exception) {
            return;
        }
        inputStream.close();
    }

    void appendToHistory(BIHistory bIHistory, BHistoryRecord bHistoryRecord, BAbsTime bAbsTime, DelimitedRow[] delimitedRowArray, String string) throws Exception {
        BAbsTime bAbsTime2 = null;
        int n = 0;
        while (n < delimitedRowArray.length) {
            if (bAbsTime == null || bAbsTime.isBefore(delimitedRowArray[n].timestamp)) {
                if (n > 0 && bHistoryRecord.getTimestamp().equals((Object)delimitedRowArray[n].timestamp)) {
                    bAbsTime2 = delimitedRowArray[n].timestamp;
                } else if (string.equals("NumericTrendRecord")) {
                    bIHistory.append((BIHistoryRecordSet)((BNumericTrendRecord)bHistoryRecord).set(delimitedRowArray[n].timestamp, Double.valueOf(delimitedRowArray[n].value).doubleValue(), delimitedRowArray[n].status));
                } else if (string.equals("BooleanTrendRecord")) {
                    boolean bl = false;
                    try {
                        boolean bl2 = false;
                        if (Integer.valueOf(delimitedRowArray[n].value) != 0) {
                            bl2 = true;
                        }
                        bl = bl2;
                    }
                    catch (Exception exception) {
                        bl = Boolean.valueOf(delimitedRowArray[n].value);
                    }
                    bIHistory.append((BIHistoryRecordSet)((BBooleanTrendRecord)bHistoryRecord).set(delimitedRowArray[n].timestamp, bl, delimitedRowArray[n].status));
                } else if (string.equals("StringTrendRecord")) {
                    bIHistory.append((BIHistoryRecordSet)((BStringTrendRecord)bHistoryRecord).set(delimitedRowArray[n].timestamp, delimitedRowArray[n].value, delimitedRowArray[n].status));
                }
            }
            ++n;
        }
        if (bAbsTime2 != null) {
            Object[] objectArray = new BAbsTime[]{bAbsTime2};
            throw new LocalizableRuntimeException("driver", "import.error.duplicateTimestamp", objectArray);
        }
    }

    BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getSlotPathOrd());
    }

    BHistoryConfig makeLocalHistoryFileConfig(BHistoryId bHistoryId, BTypeSpec bTypeSpec) {
        BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, bTypeSpec);
        bHistoryConfig.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        bHistoryConfig.setSourceHandle(this.getHandleOrd());
        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
        return bHistoryConfig;
    }

    static BTypeSpec getRecordType(BRecordTypeEnum bRecordTypeEnum) {
        if (bRecordTypeEnum == BRecordTypeEnum.numericType) {
            return BNumericTrendRecord.TYPE.getTypeSpec();
        }
        if (bRecordTypeEnum == BRecordTypeEnum.stringType) {
            return BStringTrendRecord.TYPE.getTypeSpec();
        }
        if (bRecordTypeEnum == BRecordTypeEnum.booleanType) {
            return BBooleanTrendRecord.TYPE.getTypeSpec();
        }
        return null;
    }

    static DelimitedRow[] sortByTimestamp(Vector vector) {
        int n = vector.size();
        DelimitedRow[] delimitedRowArray = new DelimitedRow[n];
        int n2 = 0;
        while (n2 < n) {
            delimitedRowArray[n2] = (DelimitedRow)vector.elementAt(n2);
            ++n2;
        }
        n2 = -1;
        DelimitedRow delimitedRow = null;
        int n3 = 0;
        while (n3 < n) {
            n2 = n3 - 1;
            delimitedRow = delimitedRowArray[n3];
            while (n2 >= 0 && delimitedRow.timestamp.isBefore(delimitedRowArray[n2].timestamp)) {
                delimitedRowArray[n2 + 1] = delimitedRowArray[n2];
                delimitedRowArray[n2] = delimitedRow;
                --n2;
            }
            ++n3;
        }
        return delimitedRowArray;
    }

    static /* synthetic */ char access$0() {
        return '\u0000';
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BDelimitedFileImport() {
        this.setExecutionTime(new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()));
    }

    static {
        Class clazz = class$com$tridium$driver$file$history$BDelimitedFileImport;
        if (clazz == null) {
            clazz = class$com$tridium$driver$file$history$BDelimitedFileImport = BDelimitedFileImport.class("[Lcom.tridium.driver.file.history.BDelimitedFileImport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"propertySheet.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    }

    static class Pattern {
        private char[][] pattern;
        private boolean matchAll;

        private final void init(char[] cArray) {
            char c;
            this.matchAll = true;
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] != '*' && cArray[n] != '%') {
                    this.matchAll = false;
                    break;
                }
                ++n;
            }
            if (this.matchAll) {
                return;
            }
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(16);
            while (true) {
                if (n2 == cArray.length) {
                    if (stringBuffer.length() <= 0) break;
                    vector.addElement(stringBuffer.toString());
                    break;
                }
                if (cArray[n2] == '\\') {
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append(' ');
                    }
                    if (n2 < cArray.length - 1) {
                        c = cArray[n2 + 1];
                        if (c == '%' || c == '*' || c == '_' || c == '\\') {
                            stringBuffer.append(c);
                        } else if (c == 'n') {
                            stringBuffer.append('\n');
                        } else if (c == 'r') {
                            stringBuffer.append('\r');
                        } else if (c == 't') {
                            stringBuffer.append('\t');
                        } else {
                            throw new IllegalArgumentException("Invalid escape sequence: \\" + c);
                        }
                        n2 += 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid escape sequence: \\");
                }
                if (cArray[n2] == '%' || cArray[n2] == '*' || cArray[n2] == '_') {
                    if (cArray[n2] == '_') {
                        if (stringBuffer.length() == 0) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append('\u0000');
                        ++n2;
                        continue;
                    }
                    if (stringBuffer.length() > 0) {
                        vector.addElement(stringBuffer.toString());
                    }
                    vector.addElement("*");
                    while (n2 < cArray.length && (cArray[n2] == '%' || cArray[n2] == '*')) {
                        ++n2;
                    }
                    stringBuffer.setLength(0);
                    continue;
                }
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(cArray[n2++]);
            }
            this.pattern = new char[vector.size()][];
            c = '\u0000';
            while (c < vector.size()) {
                this.pattern[c] = ((String)vector.elementAt(c)).toCharArray();
                ++c;
            }
        }

        /*
         * Unable to fully structure code
         */
        public boolean isMatch(String var1_1) {
            if (this.matchAll) {
                return true;
            }
            var2_2 = var1_1.toCharArray();
            var3_3 = 0;
            var4_4 = false;
            var5_5 = var2_2.length;
            if (var5_5 == 0) {
                v0 = false;
                if (this.pattern.length == 0) {
                    v0 = true;
                }
                return v0;
            }
            var6_6 = false;
            var7_7 = 0;
            while (var7_7 < this.pattern.length) {
                block13: {
                    if (this.pattern[var7_7][0] != '*') ** GOTO lbl43
                    if (var7_7 == this.pattern.length - 1) {
                        return true;
                    }
                    var6_6 = true;
                    break block13;
lbl-1000:
                    // 1 sources

                    {
                        var8_8 = var3_3;
                        var9_9 = 1;
                        while (var3_3 < var5_5 && var9_9 < this.pattern[var7_7].length && (this.pattern[var7_7][var9_9] == '\u0000' || this.pattern[var7_7][var9_9] == var2_2[var3_3])) {
                            ++var3_3;
                            ++var9_9;
                        }
                        if (var9_9 == this.pattern[var7_7].length) {
                            if (var7_7 == this.pattern.length - 1) {
                                if (var3_3 == var5_5) {
                                    return true;
                                }
                                if (var6_6) {
                                    var3_3 = var5_5 - (this.pattern[var7_7].length - 1);
                                    continue;
                                }
                                return false;
                            }
                            var6_6 = false;
                            break;
                        }
                        if (var3_3 == var5_5) {
                            return false;
                        }
                        if (!var6_6) {
                            return false;
                        }
                        var3_3 = var8_8 + 1;
                        if (var3_3 != var5_5) continue;
                        return false;
lbl43:
                        // 3 sources

                        ** while (var3_3 < var5_5)
                    }
                }
                ++var7_7;
            }
            return false;
        }

        public Pattern(String string) {
            this.init(string.toCharArray());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DelimitedRow {
        BAbsTime timestamp;
        String value;
        BStatus status;

        public DelimitedRow(BAbsTime bAbsTime, String string, BStatus bStatus) {
            this.timestamp = bAbsTime;
            this.value = string;
            this.status = bStatus;
        }
    }
}

