/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.js.test;

import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimerThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private Object monitor = new Object();
    private volatile long count = 0L;

    public TimerThreadPoolExecutor() {
        super(1);
        super.setMaximumPoolSize(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        ISyncTask iSyncTask;
        if (runnable instanceof ISyncTask && (iSyncTask = (ISyncTask)runnable).isSync()) {
            try {
                this.incrementCount();
                iSyncTask.run();
            }
            finally {
                this.decrementCount();
            }
            return;
        }
        super.execute(runnable);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, final RunnableScheduledFuture<V> runnableScheduledFuture) {
        if (!runnableScheduledFuture.isPeriodic()) {
            this.incrementCount();
        }
        return new RunnableScheduledFuture<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnableScheduledFuture.run();
                }
                finally {
                    if (!runnableScheduledFuture.isPeriodic()) {
                        TimerThreadPoolExecutor.this.decrementCount();
                    }
                }
            }

            @Override
            public boolean cancel(boolean bl) {
                return runnableScheduledFuture.cancel(bl);
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                return runnableScheduledFuture.get();
            }

            @Override
            public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return runnableScheduledFuture.get(l, timeUnit);
            }

            @Override
            public boolean isCancelled() {
                return runnableScheduledFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return runnableScheduledFuture.isDone();
            }

            @Override
            public long getDelay(TimeUnit timeUnit) {
                return runnableScheduledFuture.getDelay(timeUnit);
            }

            @Override
            public int compareTo(Delayed delayed) {
                return runnableScheduledFuture.compareTo(delayed);
            }

            @Override
            public boolean isPeriodic() {
                return runnableScheduledFuture.isPeriodic();
            }
        };
    }

    public boolean isEmpty() {
        return this.count == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBeEmpty() {
        do {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    this.monitor.wait(20L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } while (!this.isEmpty());
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long l) {
        return this.schedule(runnable, l, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedulePeriodically(Runnable runnable, long l) {
        return this.scheduleAtFixedRate(runnable, l, l, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementCount() {
        Object object = this.monitor;
        synchronized (object) {
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementCount() {
        Object object = this.monitor;
        synchronized (object) {
            --this.count;
            if (this.count == 0L) {
                this.monitor.notifyAll();
            }
        }
    }

    public static interface ISyncTask
    extends Runnable {
        public boolean isSync();
    }
}

