/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.js.test;

import com.tridium.js.rhino.JavaScriptSession;
import com.tridium.js.test.TimerThreadPoolExecutor;
import com.tridium.testng.BTestNg;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class BTestJs
extends BTestNg {
    public static final Type TYPE = Sys.loadType(BTestJs.class);
    private JavaScriptSession session;
    private TimerThreadPoolExecutor executor;

    public Type getType() {
        return TYPE;
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() throws Exception {
        this.session = JavaScriptSession.make();
        this.session.start();
        this.runJs(BOrd.make((String)"module://js/com/tridium/js/ext/jslint/fulljslint.js"));
        this.addJavaMethodToJs(BTestJs.class.getMethod("bajaJsPrint", String.class));
        this.addJavaToJsProp("test", (Object)this);
        this.executor = new TimerThreadPoolExecutor();
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        this.session.stop();
        this.executor.shutdown();
    }

    public final JavaScriptSession getSession() {
        return this.session;
    }

    public final Context getContext() {
        return this.session.getContext();
    }

    public final Scriptable getScope() {
        return this.session.getScope();
    }

    public static void bajaJsPrint(String string) {
        System.out.println(string);
    }

    public final void runJs(File file) throws IOException {
        this.session.runJs(file);
    }

    public final void runJs(BIFile bIFile) throws IOException {
        this.session.runJs(bIFile);
    }

    public final void runJs(BOrd bOrd) throws IOException {
        this.session.runJs(bOrd);
    }

    public final void runJs(String string, String string2) throws IOException {
        this.session.runJs(string, string2);
    }

    public final void addJavaToJsProp(String string, Object object) {
        this.session.addJavaToJsProp(string, object);
    }

    public final void addJavaClsToJs(Class clazz) {
        this.session.addJavaClsToJs(clazz);
    }

    public final void addJavaMethodToJs(Method method) {
        this.session.addJavaMethodToJs(method);
    }

    public final TimerThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public final void checkWithJsLint(String string) throws IOException, JsLintException {
        Object object;
        this.addJavaToJsProp("jsInput", string);
        String string2 = "JSLINT(jsInput, { bitwise: true,eqeqeq: true, immed: true,newcap: true, nomen: true, onevar: true, plusplus: true,regexp: false, rhino: false, undef: true, white: true})";
        this.runJs(string2, "jslint");
        Scriptable scriptable = this.session.getScope();
        Object object2 = scriptable.get("JSLINT", scriptable);
        if (object2 != Scriptable.NOT_FOUND && object2 instanceof ScriptableObject && (object = ((ScriptableObject)object2).get("errors", scriptable)) != Scriptable.NOT_FOUND) {
            NativeArray nativeArray = (NativeArray)object;
            long l = nativeArray.getLength();
            int n = 0;
            while ((long)n < l) {
                Object object3 = nativeArray.get(n, scriptable);
                if (object3 != null && object3 instanceof ScriptableObject) {
                    ScriptableObject scriptableObject = (ScriptableObject)object3;
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = (Number)scriptableObject.get("line", scriptable);
                    stringBuffer.append("Lint line ").append((int)number.doubleValue());
                    Number number2 = (Number)scriptableObject.get("character", scriptable);
                    stringBuffer.append(" col ").append((int)number2.doubleValue());
                    stringBuffer.append(": ").append(scriptableObject.get("reason", scriptable).toString());
                    Object object4 = scriptableObject.get("evidence", scriptable);
                    if (object4 != Scriptable.NOT_FOUND) {
                        stringBuffer.append(" -> ").append(object4.toString());
                    }
                    if (n == 0) {
                        System.out.println("*** Start JSLint Error Output ***");
                    }
                    System.out.println(stringBuffer.toString());
                }
                ++n;
            }
            if (l > 0L) {
                System.out.println("*** End JSLint Error Output ***");
                throw new JsLintException("JSLint Errors: " + l);
            }
            System.out.println("*** JSLint OK ***");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void runTest(String string, boolean bl, boolean bl2) throws Exception {
        if (!bl && !bl2) {
            throw new BajaRuntimeException("Both runJs and runJsLint can't be false");
        }
        String string2 = FileUtil.readString((File)new File(string));
        BTestJs bTestJs = new BTestJs();
        try {
            bTestJs.beforeMethod();
            if (bl2) {
                bTestJs.checkWithJsLint(string2);
            }
            if (bl) {
                bTestJs.runJs(string2, "test");
            }
        }
        finally {
            bTestJs.afterMethod();
        }
    }

    public static final void main(String[] stringArray) throws Exception {
        if (stringArray.length <= 0) {
            System.out.println();
            System.out.println("usage: [path] [options]");
            System.out.println("  path    Full file path of the JavaScript file to use for testing");
            System.out.println("options:");
            System.out.println("  js      Run JavaScript Rhino engine");
            System.out.println("  jslint  Run JsLint");
            System.out.println("By specifying no options, both Rhino and JsLint will be run");
        } else {
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray.length > 1) {
                for (int i = 1; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("js")) {
                        bl = true;
                    }
                    if (!stringArray[i].equals("jslint")) continue;
                    bl2 = true;
                }
            }
            if (!bl && !bl2) {
                bl = true;
                bl2 = true;
            }
            System.out.println("Running Js: " + bl);
            System.out.println("Running JsLint: " + bl2);
            BTestJs.runTest(stringArray[0], bl, bl2);
            System.out.println("*** Success: " + stringArray[0] + " ***");
        }
    }

    public static final class JsLintException
    extends Exception {
        public JsLintException(String string) {
            super(string);
        }
    }
}

