/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.px;

import com.tridium.ui.Binder;
import com.tridium.workbench.px.BWbPxMedia;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.naming.BRootContainer;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.XmlParser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BWbPxView
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$px$BWbPxView == null ? (class$javax$baja$workbench$px$BWbPxView = BWbPxView.class$("javax.baja.workbench.px.BWbPxView")) : class$javax$baja$workbench$px$BWbPxView));
    static boolean useCache = new Boolean(System.getProperty("wbPxView.useCache", "false"));
    static HashMap cache = new HashMap();
    static Log log = Log.getLog((String)"wbPxView");
    protected PxProperty[] pxProperties = null;
    protected PxLayer[] pxLayers = null;
    private final UiLexicon lex = UiLexicon.bajaui();
    private final String errTitle = this.lex.getText("pxview.error.title");
    private final String errNull = this.lex.getText("pxview.error.null");
    private final String errUnresolved = this.lex.getText("pxview.error.unresolved");
    private final String errXml = this.lex.getText("pxview.error.xml");
    private final String errCast = this.lex.getText("pxview.error.cast");
    private final BAbstractPxView agent;
    private BPxMedia media = BWbPxMedia.INSTANCE;
    private BWidget widget = null;
    private boolean fileBased = false;
    private boolean dynamic = false;
    private BIFile pxFile = null;
    private BOrd pxOrd = BOrd.NULL;
    private String pxSource = null;
    private Command cmdViewSource = new ViewSource(this);
    private Command cmdGotoSource = new GotoSource(this);
    private ToggleCommand cmdToggleMode = new ToggleMode(this);
    static /* synthetic */ Class class$javax$baja$workbench$px$BWbPxView;

    public Type getType() {
        return TYPE;
    }

    public BWbPxView(BAbstractPxView agent) {
        this.agent = agent;
    }

    public BWbPxView() {
        this(null);
    }

    public boolean isEditor() {
        return false;
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(this.lex.getText("menu.px.label"));
        menu.add(null, (Command)this.cmdToggleMode);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, this.cmdViewSource);
        menu.add(null, this.cmdGotoSource);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        bar.add(null, (Command)this.cmdToggleMode);
        return bar;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.setContent((BWidget)new BRootContainer(this.loadPx(value, cx)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BWidget loadPx(BObject value, Context cx) {
        String errMsg = "";
        PxDecoder decoder = null;
        TypeInfo pxViewMedia = null;
        try {
            if (value instanceof BPxInclude) {
                value = ((BPxInclude)value).getOrd().resolve(value).get();
            }
            if (this.agent != null) {
                if (this.agent instanceof BPxView) {
                    errMsg = this.errNull;
                    BPxView view = (BPxView)this.agent;
                    this.pxOrd = view.getPxFile();
                    if (this.pxOrd.isNull()) {
                        throw new Exception();
                    }
                    pxViewMedia = view.getMedia().getTypeInfo();
                    errMsg = this.errUnresolved;
                    this.pxFile = (BIFile)this.pxOrd.get(this.getCurrentValue());
                    decoder = this.loadPxFile(cx);
                } else {
                    if (!(this.agent instanceof BDynamicPxView)) throw new IllegalStateException("Don't know how to load from agent " + this.agent.getType());
                    this.dynamic = true;
                    BComponent target = (BComponent)value;
                    BDynamicPxView view = (BDynamicPxView)this.agent;
                    Property p = view.getPropertyInParent();
                    String key = "reflectProperty:" + p.getName() + ":generateXml";
                    BString xml = (BString)target.getComponentSpace().fw(109, (Object)target, (Object)key, null, (Object)cx);
                    this.pxSource = xml.toString();
                    ByteArrayInputStream in = new ByteArrayInputStream(this.pxSource.getBytes());
                    decoder = new PxDecoder(target.getNavOrd(), (InputStream)in, cx);
                }
            } else {
                if (!(value instanceof BIFile)) throw new IllegalStateException("Don't know how to load from " + value.getType());
                this.fileBased = true;
                this.pxFile = (BIFile)value;
                this.pxOrd = this.pxFile.getNavOrd();
                decoder = this.loadPxFile(cx);
            }
            if (this.widget != null) return this.widget;
            errMsg = this.errXml;
            this.widget = decoder.decodeDocument();
            this.pxProperties = decoder.getPxProperties();
            this.pxLayers = decoder.getPxLayers();
            for (int i = 0; i < this.pxProperties.length; ++i) {
                this.pxProperties[i].apply((BComponent)this.widget);
            }
            this.media = decoder.getMedia() == null ? (pxViewMedia != null ? (BPxMedia)pxViewMedia.getInstance() : BWbPxMedia.INSTANCE) : (BPxMedia)decoder.getMedia().getInstance();
            if (!useCache) return this.widget;
            cache.put(this.pxOrd, new CacheItem(this.widget, this.media, this.pxProperties, this.pxLayers));
            return this.widget;
        }
        catch (Exception e) {
            this.widget = null;
            return new BErrorPanel(this.getWbShell(), this.errTitle, errMsg, this.pxOrd, e);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        Binder binder = (Binder)this.fw(302);
        BBinding[] bindings = binder.getAllBindings();
        for (int i = 0; i < bindings.length; ++i) {
            bindings[i].save(cx);
        }
        return value;
    }

    PxDecoder loadPxFile(Context cx) throws Exception {
        PxProperty p;
        int i;
        CacheItem item = (CacheItem)cache.get(this.pxOrd);
        if (item == null) {
            if (log.isTraceOn()) {
                log.trace("not cached: " + this.pxOrd);
            }
            return new PxDecoder(this.pxFile, cx);
        }
        if (log.isTraceOn()) {
            log.trace("cached: " + this.pxOrd);
        }
        this.widget = (BWidget)item.widget.newCopy(true);
        this.media = item.media;
        this.pxProperties = new PxProperty[item.props.length];
        for (i = 0; i < this.pxProperties.length; ++i) {
            p = item.props[i];
            this.pxProperties[i] = new PxProperty(p.getName(), p.getTypeSpec(), p.getValue(), p.getTargets());
        }
        this.pxLayers = new PxLayer[item.layers.length];
        for (i = 0; i < this.pxLayers.length; ++i) {
            p = item.layers[i];
            this.pxLayers[i] = new PxLayer(p.getName());
        }
        this.setBaseOrd(item.widget, this.widget, cx);
        return null;
    }

    void setBaseOrd(BWidget master, BWidget copy, Context cx) {
        if (master instanceof BPxInclude) {
            BOrd ord = ((BPxInclude)master).getBaseOrd();
            BPxInclude copyInclude = (BPxInclude)copy;
            copyInclude.fw(205, (Object)ord, (Object)cx, null, null);
            copyInclude.remove("root");
            return;
        }
        BWidget[] masterKids = master.getChildWidgets();
        BWidget[] copyKids = copy.getChildWidgets();
        for (int i = 0; i < masterKids.length; ++i) {
            this.setBaseOrd(masterKids[i], copyKids[i], cx);
        }
    }

    public boolean isEditable() {
        return !this.isDynamic() && this.getPxFile() != null && !this.getPxFile().isReadonly();
    }

    public BWidget getWidget() {
        return this.widget;
    }

    public PxProperty[] getPxProperties() {
        return this.pxProperties;
    }

    public PxLayer[] getPxLayers() {
        return this.pxLayers;
    }

    public BPxMedia getMedia() {
        return this.media;
    }

    public BAbstractPxView getPxAgent() {
        return this.agent;
    }

    public void setWidget(BWidget widget) {
        this.widget = widget;
    }

    public void setMedia(BPxMedia media) {
        this.media = media;
    }

    public BIFile getPxFile() {
        return this.pxFile;
    }

    public boolean isFileBased() {
        return this.fileBased;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Command getViewSource() {
        return this.cmdViewSource;
    }

    public Command getGotoSource() {
        return this.cmdGotoSource;
    }

    public ToggleCommand getToggleMode() {
        return this.cmdToggleMode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CacheItem {
        BWidget widget;
        BPxMedia media;
        PxProperty[] props;
        PxLayer[] layers;

        public CacheItem(BWidget widget, BPxMedia media, PxProperty[] props, PxLayer[] layers) {
            this.widget = widget;
            this.media = media;
            this.props = props;
            this.layers = layers;
        }
    }

    public class ToggleMode
    extends ToggleCommand {
        public ToggleMode(BWbPxView owner) {
            super((BWidget)owner, (Lexicon)BWbPxView.this.lex, "commands.px.editMode");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbPxView owner = (BWbPxView)this.getOwner();
            BNiagaraWbShell shell = (BNiagaraWbShell)this.getShell();
            if (owner == null || shell == null) {
                return null;
            }
            String from = shell.tab().getViewAgent().getAgentId();
            if (owner.isEditor() && shell.getSaveCommand().isEnabled()) {
                shell.getSaveCommand().invoke();
            }
            String to = from.equals("workbench:WbPxView") ? "pxEditor:PxEditor" : (from.equals("pxEditor:PxEditor") ? "workbench:WbPxView" : (from.indexOf(47) > 0 ? from.substring(0, from.indexOf(47)) : from + "/editor"));
            BOrd ord = shell.getActiveOrd();
            shell.hyperlink(BOrd.make((BOrd)ord, (String)("view:" + to)));
            return null;
        }
    }

    public class GotoSource
    extends Command {
        public GotoSource(BWbPxView owner) {
            super((BWidget)owner, (Lexicon)BWbPxView.this.lex, "commands.px.gotoSource");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbShell shell = (BWbShell)this.getShell();
            shell.hyperlink(BOrd.make((String)(BWbPxView.this.pxOrd.toString() + "|view:workbench:TextFileEditor")));
            return null;
        }
    }

    public class ViewSource
    extends Command {
        public ViewSource(BWbPxView owner) {
            super((BWidget)owner, (Lexicon)BWbPxView.this.lex, "commands.px.viewSource");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BWbPxView.this.pxSource == null) {
                BWbPxView.this.pxSource = FileUtil.readString((BIFile)BWbPxView.this.pxFile);
            }
            BTextEditor editor = new BTextEditor();
            editor.setEditable(false);
            editor.setParser((TextParser)new XmlParser());
            editor.setText(BWbPxView.this.pxSource);
            BTextEditorPane pane = new BTextEditorPane(editor, 40, 100);
            BDialog.open((BWidget)this.getOwner(), (String)this.getLabel(), (Object)pane, (int)1);
            return null;
        }
    }
}

