/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeSubject;

public class NavTreeController
extends TreeController {
    protected void doSelectAction(TreeNode target, double x, double y) {
        this.getTree().setExpanded(target, true);
        BWidgetShell shell = this.getShell();
        NavTreeNode n = (NavTreeNode)target;
        BOrd ord = n.navNode.getNavOrd();
        if (shell instanceof BWbShell && ord != null) {
            ((BWbShell)shell).hyperlink(new HyperlinkInfo(ord, BHyperlinkMode.DEFAULT));
        }
    }

    public void keyPressed(BKeyEvent event) {
        super.keyPressed(event);
        if (event.getKeyCode() == 121) {
            ((NavTreeModel)this.getModel()).dumpOrdMap();
        }
    }

    protected final BMenu makePopup(TreeSubject subject) {
        return this.makePopup((NavTreeSubject)subject);
    }

    protected BMenu makePopup(NavTreeSubject subject) {
        BTree tree = this.getTree();
        BMenu menu = NavMenuUtil.makeMenu((BWidget)tree, (Subject)subject);
        if (subject.size() == 1) {
            if (menu == null) {
                menu = new BMenu();
            } else {
                menu.add(null, (BValue)new BSeparator());
            }
            menu.add(null, (Command)new RefreshCommand((BWidget)tree, (NavTreeNode)subject.getNode(0)));
        }
        return menu;
    }

    public void nodeDoubleClicked(BMouseEvent event, TreeNode node) {
        BWidgetShell shell = this.getShell();
        NavTreeNode n = (NavTreeNode)node;
        BOrd ord = n.navNode.getNavOrd();
        if (shell instanceof BWbShell && ord != null) {
            ((BWbShell)shell).hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
        }
    }

    class RefreshCommand
    extends Command {
        NavTreeNode node;

        RefreshCommand(BWidget owner, NavTreeNode node) {
            super(owner, UiLexicon.bajaui().module, "tree.refresh");
            this.node = node;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.node.refresh();
            return null;
        }
    }
}

