/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import java.util.ArrayList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.table.BTable;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BMixinMgrAgent;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrModel
extends MgrSupport {
    boolean built;
    MgrColumn[] cols;
    MgrColumn[] editable;
    BMgrTable table;

    public MgrModel(BAbstractManager manager) {
        super(manager);
    }

    public void init() {
        this.cols = (MgrColumn[])this.makeColumns().clone();
        this.columnsModified();
    }

    public final BMgrTable getTable() {
        return this.table;
    }

    public final MgrColumn[] getColumns() {
        return (MgrColumn[])this.cols.clone();
    }

    public final void setColumns(MgrColumn[] cols) {
        this.cols = cols;
    }

    public final int getColumnCount() {
        return this.cols.length;
    }

    public final MgrColumn getColumn(int index) {
        return this.cols[index];
    }

    public final MgrColumn[] getEditableColumns() {
        return (MgrColumn[])this.editable.clone();
    }

    public final void columnsModified() {
        ArrayList<MgrColumn> editable = new ArrayList<MgrColumn>();
        for (int i = 0; i < this.cols.length; ++i) {
            MgrColumn col = this.cols[i];
            col.init(this.manager);
            if (!col.isEditable()) continue;
            editable.add(col);
        }
        this.editable = editable.toArray(new MgrColumn[editable.size()]);
        BMgrTable table = this.getTable();
        if (table != null) {
            table.columnsModified();
        }
    }

    public BWidget makePane() {
        this.table = this.makeTable();
        this.manager.attach(this.table);
        this.manager.setTransferWidget((BTransferWidget)this.table);
        return BTitlePane.makePane((String)this.makeTableTitle(), (BTable)this.table);
    }

    protected BMgrTable makeTable() {
        return new BMgrTable(this);
    }

    protected String makeTableTitle() {
        return this.manager.lexDatabaseObjects;
    }

    public MgrTypeInfo[] getNewTypes() {
        return null;
    }

    public MgrTypeInfo toType(BComponent c) {
        return MgrTypeInfo.make(c);
    }

    public BComponent newInstance(MgrTypeInfo type) throws Exception {
        return type.newInstance();
    }

    public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
        String[] names = new String[rows.length];
        BComponent[] values = new BComponent[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            names[i] = rows[i].getName();
            values[i] = rows[i].getTarget();
        }
        Mark mark = new Mark((BObject[])values, names);
        BComponent container = rows[0].getEdit().getAddContainer();
        mark.moveTo((BObject)container, null);
        return null;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Type()};
    }

    public MgrColumn[] appendMixInColumns(MgrColumn[] cols, Type mixInParentType) {
        try {
            Type[] mixIns = this.manager.target.getComponentSpace().getEnabledMixIns();
            Array result = new Array((Object[])cols);
            for (int i = 0; i < mixIns.length; ++i) {
                Type mixIn = mixIns[i];
                if (!Sys.getRegistry().isAgent(mixIn.getTypeInfo(), mixInParentType.getTypeInfo())) continue;
                AgentList mixinAgents = Sys.getRegistry().getAgents(mixIn.getTypeInfo());
                mixinAgents = mixinAgents.filter(AgentFilter.is((Type)BMixinMgrAgent.TYPE));
                mixinAgents = mixinAgents.filter(new AgentFilter(){

                    public boolean include(AgentInfo agent) {
                        return !agent.getAgentType().isInterface() && !agent.getAgentType().isAbstract();
                    }
                });
                for (int j = 0; j < mixinAgents.size(); ++j) {
                    BMixinMgrAgent mixInCols = (BMixinMgrAgent)mixinAgents.get(j).getInstance();
                    if (mixInCols.requireExactTypeMatch()) {
                        boolean isSpecific = Sys.getRegistry().isSpecificAgent(mixInCols.getType().getTypeInfo(), mixIn.getTypeInfo());
                        if (!isSpecific) continue;
                        result.addAll((Object[])mixInCols.getColumns());
                        continue;
                    }
                    result.addAll((Object[])mixInCols.getColumns());
                }
            }
            return (MgrColumn[])result.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return cols;
        }
    }

    public void load(BComponent target) {
        super.load(target);
        this.table.reload();
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BComponent.TYPE};
    }

    public boolean accept(BComponent component) {
        return true;
    }

    public int getSubscribeDepth() {
        return 1;
    }
}

