/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrEditRow {
    BComponent target;
    Object discovery;
    MgrTypeInfo[] types;
    MgrEdit edit;
    int nameColumn = -1;
    int typeColumn = -1;
    BValue[] cells;
    String userDefinedName;

    public MgrEditRow(BComponent target, Object discovery, MgrTypeInfo[] types) {
        this.target = target;
        this.discovery = discovery;
        this.types = types;
    }

    public final BAbstractManager getManager() {
        if (this.edit != null) {
            return this.edit.manager;
        }
        return null;
    }

    public final MgrModel getModel() {
        return this.getManager().model;
    }

    public final MgrLearn getLearn() {
        return this.getManager().getLearn();
    }

    public MgrEdit getEdit() {
        return this.edit;
    }

    public BComponent getTarget() {
        return this.target;
    }

    public BComponent getTargetParent() {
        BComponent parent = (BComponent)this.target.getParent();
        if (parent != null) {
            return parent;
        }
        return this.edit.getAddContainer();
    }

    public Object getDiscovery() {
        return this.discovery;
    }

    public MgrTypeInfo[] getAvailableTypes() {
        return this.types;
    }

    public int getNameColumnIndex() {
        return this.nameColumn;
    }

    public String getName() {
        if (this.nameColumn < 0) {
            return null;
        }
        BValue val = this.getCell(this.nameColumn);
        if (val == null) {
            return null;
        }
        String name = val.toString();
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    public void setName(String name) {
        if (this.nameColumn < 0) {
            return;
        }
        this.setCell(this.nameColumn, (BValue)BString.make((String)name));
    }

    public void setDefaultName(String name) {
        if (this.nameColumn < 0) {
            return;
        }
        if (this.getName() == null) {
            this.setName(this.getEdit().getUniqueName(this, name));
        }
    }

    public int getTypeColumnIndex() {
        return this.typeColumn;
    }

    public MgrTypeInfo getType() {
        if (this.typeColumn < 0) {
            return null;
        }
        BFacets dummy = (BFacets)this.getCell(this.typeColumn);
        return (MgrTypeInfo)dummy.getPickle();
    }

    public void setType(MgrTypeInfo type) throws Exception {
        if (this.typeColumn < 0) {
            return;
        }
        BFacets dummy = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BBoolean.TRUE), (Object)type);
        this.setCell(this.typeColumn, (BValue)dummy);
        if (this.target.isMounted()) {
            throw new IllegalStateException("Cannot change type of mounted component");
        }
        this.target = this.getManager().getModel().newInstance(type);
        this.loadCells();
        if (this.discovery != null) {
            this.getLearn().toRow(this.discovery, this);
        }
        if (this.userDefinedName != null) {
            this.setName(this.userDefinedName);
        } else if (this.getName() == null) {
            this.setName(this.edit.getUniqueName(this));
        }
    }

    public final MgrColumn[] getColumns() {
        return this.edit.getColumns();
    }

    public final int getColumnIndex(MgrColumn col) {
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (col != cols[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("MgrColumn not found in getManager().getEditableColumns()");
    }

    public BValue getCell(int col) {
        return this.cells[col];
    }

    public BValue getCell(MgrColumn col) {
        return this.cells[this.getColumnIndex(col)];
    }

    public void setCell(int col, BValue val) {
        this.cells[col] = val;
    }

    public void setCell(MgrColumn col, BValue val) {
        this.setCell(this.getColumnIndex(col), val);
    }

    public void loadCells() throws Exception {
        MgrColumn[] cols = this.getColumns();
        this.nameColumn = -1;
        this.typeColumn = -1;
        this.cells = new BValue[cols.length];
        for (int i = 0; i < this.cells.length; ++i) {
            MgrColumn col = cols[i];
            if (col instanceof MgrColumn.Name) {
                this.nameColumn = i;
            }
            if (col instanceof MgrColumn.Type) {
                this.typeColumn = i;
            }
            this.cells[i] = col.load(this);
        }
    }

    public void saveCells(Context cx) throws Exception {
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            cols[i].save(this, this.cells[i], cx);
        }
    }

    public void commit(Context cx) throws Exception {
        this.saveCells((Context)(this.target.isMounted() ? cx : null));
        BComponent parent = this.getTargetParent();
        String name = this.getName();
        if (this.target.isMounted() && name != null && !name.equals(this.target.getName())) {
            parent.rename(this.target.getPropertyInParent(), name, cx);
        }
    }

    public void dumpCells() {
        System.out.println("MgrEditRow " + this.target.getType());
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < this.cells.length; ++i) {
            System.out.println("  " + cols[i].getDisplayName() + " = " + this.cells[i].toString());
        }
    }
}

