/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.theme.Theme;
import java.awt.event.KeyEvent;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;

public class BMgrEditDialog
extends BDialog {
    public static final Action editorModified = BMgrEditDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$mgr$BMgrEditDialog == null ? (class$javax$baja$workbench$mgr$BMgrEditDialog = BMgrEditDialog.class$("javax.baja.workbench.mgr.BMgrEditDialog")) : class$javax$baja$workbench$mgr$BMgrEditDialog));
    static BImage objectIcon = BImage.make((String)"module://icons/x16/object.png");
    static BImage disabledIcon = objectIcon.getDisabledImage();
    static BImage highlightedIcon = objectIcon.getHighlightedImage();
    Lexicon lex = Lexicon.make((Class)(class$javax$baja$workbench$mgr$BMgrEditDialog == null ? (class$javax$baja$workbench$mgr$BMgrEditDialog = BMgrEditDialog.class$("javax.baja.workbench.mgr.BMgrEditDialog")) : class$javax$baja$workbench$mgr$BMgrEditDialog));
    String lexCannotEdit = this.lex.getText("mgr.cannotEdit");
    BAbstractManager manager;
    Command ok;
    Command cancel;
    MgrEdit edit;
    BTable table;
    BGridPane inputPane;
    ColumnInput[] inputs;
    MgrEditRow[] oldSelection;
    int result;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$BMgrEditDialog;

    public void editorModified(BWidgetEvent event) {
        this.invoke(editorModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMgrEditDialog() {
        throw new IllegalStateException();
    }

    public BMgrEditDialog(MgrEdit edit, boolean selectAll) throws Exception {
        super((BWidget)edit.getManager(), edit.getTitle(), true);
        this.manager = edit.manager;
        this.edit = edit;
        this.table = new BTable((TableModel)edit, (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        this.makeInputPane();
        this.ok = new Ok((BWidget)this);
        this.cancel = new Cancel((BWidget)this);
        BGridPane actions = new BGridPane();
        actions.setColumnAlign(BHalign.fill);
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton(this.ok));
        actions.add(null, (BValue)new BButton(this.cancel));
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setBottom((BWidget)new BBorderPane((BWidget)this.inputPane, 10.0, 5.0, 5.0, 5.0));
        BScrollPane scrollPane = new BScrollPane((BWidget)pane);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)new BBorderPane((BWidget)scrollPane));
        content.setBottom((BWidget)new BBorderPane((BWidget)actions, 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)content);
        this.setupKeyEvents();
        if (selectAll) {
            this.table.getSelection().selectAll();
        }
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrEdit getEdit() {
        return this.edit;
    }

    public int getResult() {
        return this.result;
    }

    public MgrEditRow[] getSelectedRows() {
        int[] sel = this.table.getSelection().getRows();
        MgrEditRow[] rows = new MgrEditRow[sel.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.edit.getRow(sel[i]);
        }
        return rows;
    }

    private void makeInputPane() throws Exception {
        int i;
        MgrEditRow[] rows = new MgrEditRow[]{this.edit.getRow(0)};
        MgrColumn[] cols = this.edit.getColumns();
        this.inputs = new ColumnInput[cols.length];
        for (i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = new ColumnInput(cols[i], i);
        }
        this.inputPane = new BGridPane(2);
        this.inputPane.setColumnGap(10.0);
        this.inputPane.setHalign(BHalign.left);
        for (i = 0; i < this.inputs.length; ++i) {
            ColumnInput input = this.inputs[i];
            input.installLabel();
            input.installEditor(cols[i].toEditor(rows, i, null), rows);
        }
    }

    public boolean syncInputPane() {
        try {
            this.saveInputPane(this.oldSelection);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (this.isShowing()) {
                BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)"Cannot save to table", (Throwable)e);
            }
            return false;
        }
        MgrEditRow[] newSelection = this.getSelectedRows();
        try {
            this.loadInputPane(newSelection);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (this.isShowing()) {
                BDialog.error((BWidget)this, (String)"Cannot load from table", (Object)e);
            }
            return false;
        }
        this.oldSelection = newSelection;
        this.table.repaint();
        return true;
    }

    protected void loadInputPane(MgrEditRow[] selection) throws Exception {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i].load(selection);
        }
    }

    protected void saveInputPane(MgrEditRow[] selection) throws Exception {
        if (selection == null || selection.length == 0) {
            return;
        }
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i].save(selection);
        }
        this.edit.validate(selection);
    }

    public void doEditorModified(BWidgetEvent event) {
        String name = event.getWidget().getName();
        int index = Integer.parseInt(name.substring("editor".length()));
        this.inputs[index].modified(this.getSelectedRows());
    }

    void typeChanged() throws Exception {
        MgrEditRow[] selection = this.getSelectedRows();
        for (int i = 0; i < this.inputs.length; ++i) {
            ColumnInput input = this.inputs[i];
            if (input.col instanceof MgrColumn.Type) continue;
            input.load(selection);
        }
    }

    public boolean checkNames() {
        MgrEditRow[] rows = this.edit.getRows();
        for (int i = 0; i < rows.length; ++i) {
            String name = rows[i].getName();
            if (name == null || this.edit.isNameUnique(rows[i], name)) continue;
            String msg = this.lex.getText("mgr.duplicateName", new Object[]{name});
            BDialog.error((BWidget)this, (Object)msg);
            return false;
        }
        return true;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double pw = this.getPreferredWidth() + 20.0;
        double ph = this.getPreferredHeight() + 20.0;
        IRectGeom screen = UiEnv.get().getScreenBounds((BWidget)this);
        double sw = screen.width() - 50.0;
        double sh = screen.height() - 50.0;
        if (pw > sw) {
            pw = sw;
        }
        if (ph > sh) {
            ph = sh;
        }
        this.setPreferredSize(pw, ph);
    }

    public void handleEnter() {
        this.syncInputPane();
    }

    static boolean hasSelectionChanged(int[] a, int[] b) {
        if (a.length != b.length) {
            return true;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return true;
        }
        return false;
    }

    private void setupKeyEvents() {
        AwtShellManager manager = (AwtShellManager)this.widgetSupport(null);
        manager.addKeyListener((java.awt.event.KeyListener)new KeyListener());
    }

    void updateTableSelection(KeyEvent event, int code) {
        BKeyEvent e = new BKeyEvent(401, (BWidget)this.table, event.getModifiers(), code, event.getKeyChar());
        this.table.getController().keyPressed(e);
        BWidget focus = this.getCurrentFocus();
        if (focus instanceof BTextField) {
            ((BTextField)focus).getSelection().selectAll();
        }
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancel.invoke();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Cancel
    extends Command {
        Cancel(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BMgrEditDialog.this.result = 2;
            BMgrEditDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        Ok(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            if (!BMgrEditDialog.this.syncInputPane()) {
                return null;
            }
            if (!BMgrEditDialog.this.checkNames()) {
                return null;
            }
            BMgrEditDialog.this.result = 1;
            BMgrEditDialog.this.close();
            return null;
        }
    }

    class KeyListener
    implements java.awt.event.KeyListener {
        KeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (BMgrEditDialog.this.getCurrentFocus() == BMgrEditDialog.this.table) {
                return;
            }
            if (event.isConsumed()) {
                return;
            }
            int code = event.getKeyCode();
            switch (code) {
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    BMgrEditDialog.this.updateTableSelection(event, code);
                    break;
                }
                case 10: {
                    if (event.isControlDown()) {
                        BMgrEditDialog.this.ok.invoke();
                        break;
                    }
                    BMgrEditDialog.this.updateTableSelection(event, 40);
                }
            }
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyTyped(KeyEvent event) {
        }
    }

    class Selection
    extends TableSelection {
        int[] oldSel = new int[0];

        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int[] curSel = this.getRows();
            if (BMgrEditDialog.hasSelectionChanged(curSel, this.oldSel)) {
                this.oldSel = curSel;
                BMgrEditDialog.this.syncInputPane();
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }
    }

    class ColumnInput {
        MgrColumn col;
        int colIndex;
        String labelKey;
        String editorKey;
        BLabel label;
        BWbEditor editor;
        BLink linkFromEditor;

        ColumnInput(MgrColumn col, int colIndex) {
            this.col = col;
            this.colIndex = colIndex;
            this.labelKey = "label" + colIndex;
            this.editorKey = "editor" + colIndex;
            this.label = new BLabel(objectIcon, col.getDisplayName());
            this.label.setFont(Theme.widget().getBoldText());
        }

        void installLabel() {
            BMgrEditDialog.this.inputPane.add(this.labelKey, (BValue)this.label);
        }

        void installEditor(BWbEditor editor, MgrEditRow[] selectedRows) {
            Property editorProp;
            BWbEditor widget;
            BWbEditor oldEditor = this.editor;
            this.editor = editor;
            if (editor == null) {
                this.label.setImage(disabledIcon);
                this.label.setEnabled(false);
            } else {
                this.label.setImage(objectIcon);
                this.label.setEnabled(true);
            }
            this.label.repaint();
            if (editor != null) {
                widget = editor;
                editor.setReadonly(BMgrEditDialog.this.edit.isReadonly(selectedRows, this.col));
            } else if (oldEditor != null) {
                widget = oldEditor;
                oldEditor.setReadonly(true);
            } else {
                widget = new BLabel(BMgrEditDialog.this.lexCannotEdit);
            }
            if (this.linkFromEditor != null) {
                BMgrEditDialog.this.remove((BComplex)this.linkFromEditor);
            }
            if (editor != null) {
                BMgrEditDialog.this.linkTo((BComponent)editor, (Slot)BWbEditor.pluginModified, (Slot)editorModified);
            }
            if ((editorProp = BMgrEditDialog.this.inputPane.getProperty(this.editorKey)) == null) {
                BMgrEditDialog.this.inputPane.add(this.editorKey, (BValue)widget);
            } else if (BMgrEditDialog.this.inputPane.get(editorProp) != widget) {
                BMgrEditDialog.this.inputPane.set(editorProp, (BValue)widget);
            }
        }

        void load(MgrEditRow[] selection) throws Exception {
            if (selection == null || selection.length == 0) {
                this.installEditor(null, new MgrEditRow[0]);
            } else {
                this.installEditor(this.col.toEditor(selection, this.colIndex, this.editor), selection);
            }
        }

        void save(MgrEditRow[] selection) throws Exception {
            if (this.editor != null && this.editor.isModified()) {
                this.col.fromEditor(selection, this.colIndex, this.editor);
                if (this.col instanceof MgrColumn.Type) {
                    BMgrEditDialog.this.typeChanged();
                }
            }
        }

        void modified(MgrEditRow[] selection) {
            BLabel label = (BLabel)BMgrEditDialog.this.inputPane.get(this.labelKey);
            try {
                if (selection != null && selection.length > 0) {
                    this.save(selection);
                    label.setImage(objectIcon);
                    BMgrEditDialog.this.repaint();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            label.setImage(highlightedIcon);
            label.repaint();
        }
    }
}

