/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.component.table;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;

public class ComponentTableModel
extends TableModel {
    ArrayList rows = new ArrayList();
    Column[] columns = new Column[0];

    public ComponentTableModel(Column[] columns) {
        this.columns = columns;
    }

    public ComponentTableModel() {
        this.columns = new Column[]{new DisplayNameColumn()};
    }

    public BComponent getComponentAt(int row) {
        return ((Row)this.rows.get((int)row)).component;
    }

    public BComponent[] getRows() {
        int size = this.rows.size();
        BComponent[] c = new BComponent[size];
        for (int i = 0; i < size; ++i) {
            c[i] = this.getComponentAt(i);
        }
        return c;
    }

    public int getRowByName(String name) {
        return this.getRowsByName(new String[]{name})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRowsByName(String[] names) {
        int[] indices = new int[this.rows.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = -1;
        }
        int count = 0;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            block4: for (int i = 0; i < this.rows.size(); ++i) {
                BComponent component = ((Row)this.rows.get((int)i)).component;
                for (int j = 0; j < names.length; ++j) {
                    if (!component.getName().equals(names[j])) continue;
                    indices[count++] = i;
                    continue block4;
                }
            }
        }
        int[] result = new int[count];
        System.arraycopy(indices, 0, result, 0, count);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(BComponent component) {
        boolean wasEmpty = this.rows.size() == 0;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.rows.add(new Row(component));
        }
        this.updateTable(wasEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRows(BComponent[] components) {
        boolean wasEmpty = this.rows.size() == 0;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            for (int i = 0; i < components.length; ++i) {
                this.rows.add(new Row(components[i]));
            }
        }
        this.updateTable(wasEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRow(String name) {
        boolean found = false;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            for (int i = 0; i < this.rows.size(); ++i) {
                Row row = (Row)this.rows.get(i);
                if (!row.name.equals(name)) continue;
                this.rows.remove(i);
                found = true;
                break;
            }
        }
        if (found) {
            this.updateTable();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRow(BComponent component) {
        boolean found = false;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            for (int i = 0; i < this.rows.size(); ++i) {
                Row row = (Row)this.rows.get(i);
                if (row.component != component) continue;
                this.rows.remove(i);
                found = true;
                break;
            }
        }
        if (found) {
            this.updateTable();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRows() {
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.rows = new ArrayList();
        }
        this.updateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRows(BComponent[] components) {
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.rows = new ArrayList(Math.max(components.length * 2, 10));
            for (int i = 0; i < components.length; ++i) {
                this.rows.add(new Row(components[i]));
            }
        }
        this.updateTable(true);
    }

    public synchronized boolean renameRow(String oldName, String newName) {
        boolean found = false;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.get(i);
            if (!row.name.equals(oldName)) continue;
            row.name = newName;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumns(Column[] columns) {
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.columns = columns;
        }
        this.updateTable();
    }

    public void reorderRows(int[] origIndices) {
        ArrayList temp = new ArrayList();
        ArrayList orig = this.rows;
        if (origIndices.length != orig.size()) {
            throw new IllegalArgumentException("invalid length");
        }
        for (int i = 0; i < origIndices.length; ++i) {
            temp.add(orig.get(origIndices[i]));
        }
        this.rows = temp;
        this.updateTable();
    }

    public synchronized int getRowCount() {
        return this.rows.size();
    }

    public synchronized int getColumnCount() {
        try {
            return this.columns.length;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public synchronized String getColumnName(int index) {
        return this.columns[index].getName();
    }

    public synchronized BImage getRowIcon(int row) {
        return ((Row)this.rows.get(row)).getIcon();
    }

    public Object getSubject(int row) {
        return this.getComponentAt(row);
    }

    public Object getValueAt(int row, int col) {
        BComponent component = ((Row)this.rows.get((int)row)).component;
        return this.columns[col].getValue(component);
    }

    public boolean isColumnSortable(int col) {
        return true;
    }

    public synchronized void sortByColumn(int col, boolean ascending) {
        Object[] keys = this.getColumnValues(col);
        Object[] temp = this.rows.toArray(new Row[this.rows.size()]);
        SortUtil.sort((Object[])keys, (Object[])temp, (boolean)ascending);
        this.rows = new ArrayList();
        for (int i = 0; i < temp.length; ++i) {
            this.rows.add(temp[i]);
        }
    }

    static class Row {
        String name;
        BImage icon;
        BComponent component;

        Row(BComponent component) {
            this.component = component;
            this.name = component.getName();
            this.icon = BImage.make((BIcon)component.getIcon());
        }

        BImage getIcon() {
            if (this.component.isPendingMove()) {
                return this.icon.getDisabledImage();
            }
            return this.icon;
        }
    }

    public static class PropertyColumn
    implements Column {
        protected String name;
        protected Property prop;

        public PropertyColumn(Property prop) {
            this(prop.getDefaultDisplayName(null), prop);
        }

        public PropertyColumn(String name, Property prop) {
            this.name = name;
            this.prop = prop;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue(BComponent c) {
            return c.get(this.prop);
        }
    }

    public static class DisplayNameColumn
    implements Column {
        String name = UiLexicon.bajaui().getText("name");

        public String getName() {
            return this.name;
        }

        public Object getValue(BComponent c) {
            return c.getDisplayName(null);
        }
    }

    public static interface Column {
        public String getName();

        public Object getValue(BComponent var1);
    }
}

