/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.component.table;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.status.BIStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.workbench.component.table.BComponentTable;

public class ComponentTableCellRenderer
extends TableCellRenderer {
    static final BBrush cutFg = BColor.make((int)100, (int)100, (int)100).toBrush();

    public BBrush getForeground(TableCellRenderer.Cell cell) {
        BBrush fg = super.getForeground(cell);
        try {
            BColor c;
            BComponent component = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
            if (component.isPendingMove()) {
                return cutFg;
            }
            if (component instanceof BIStatus && (c = (BColor)((BIStatus)component).getStatus().getForegroundColor(null)) != null) {
                return c.toBrush();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return fg;
    }

    public BBrush getBackground(TableCellRenderer.Cell cell) {
        BBrush bg = super.getBackground(cell);
        try {
            BColor c;
            BComponent component = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
            if (component instanceof BIStatus && (c = (BColor)((BIStatus)component).getStatus().getBackgroundColor(null)) != null) {
                return c.toBrush();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return bg;
    }

    public String getCellText(TableCellRenderer.Cell cell) {
        if (cell.value instanceof BObject) {
            return ((BObject)cell.value).toString(((BComponentTable)this.getTable()).context);
        }
        return String.valueOf(cell.value);
    }

    protected BComponentTable getComponentTable() {
        return (BComponentTable)this.getTable();
    }
}

