/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.component.table;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.ArrayList;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.component.table.ComponentTableController;
import javax.baja.workbench.component.table.ComponentTableHeaderRenderer;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.component.table.ComponentTableSelection;
import javax.baja.workbench.view.BWbComponentView;

public class BComponentTable
extends BTable
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$component$table$BComponentTable == null ? (class$javax$baja$workbench$component$table$BComponentTable = BComponentTable.class$("javax.baja.workbench.component.table.BComponentTable")) : class$javax$baja$workbench$component$table$BComponentTable));
    BComponent container;
    BWbComponentView view;
    Class[] loadClasses = new Class[]{class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BComponentTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent};
    int loadDepth = 0;
    Context context;
    protected boolean dropActive;
    ComponentTableModel model;
    static /* synthetic */ Class class$javax$baja$workbench$component$table$BComponentTable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BComponentTable() {
        this(new ComponentTableModel(null));
    }

    public BComponentTable(ComponentTableModel.Column[] columns) {
        this(new ComponentTableModel(columns));
    }

    public BComponentTable(ComponentTableModel model) {
        super((TableModel)model);
        this.setController(new ComponentTableController());
        this.setHeaderRenderer(new ComponentTableHeaderRenderer());
        this.setCellRenderer(new ComponentTableCellRenderer());
        this.setSelection(new ComponentTableSelection());
        this.setCutEnabled(true);
        this.setCopyEnabled(true);
        this.setPasteEnabled(true);
        this.setPasteSpecialEnabled(true);
        this.setDuplicateEnabled(true);
        this.setDeleteEnabled(true);
        this.setRenameEnabled(true);
    }

    public void setModel(TableModel m) {
        super.setModel(m);
        while (m instanceof WrapperTableModel) {
            m = ((WrapperTableModel)m).getRootModel();
        }
        this.model = (ComponentTableModel)m;
    }

    public final ComponentTableModel getComponentModel() {
        return this.model;
    }

    public void attached(BWbComponentView view) {
        this.view = view;
    }

    public void detached(BWbComponentView view) {
        this.view = null;
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.container == null) {
            return;
        }
        ComponentTableModel model = this.getComponentModel();
        int id = event.getId();
        Object containerHandle = this.container.getHandle();
        Object eventHandle = event.getSourceComponent().getHandle();
        String slot = event.getSlotName();
        if (containerHandle.equals(eventHandle)) {
            switch (id) {
                case 1: {
                    this.container.loadSlots();
                    BValue obj = this.container.get(slot);
                    if (obj == null || !obj.isComponent()) break;
                    BComponent comp = obj.asComponent();
                    if (!this.include(comp)) {
                        return;
                    }
                    WbViewEventWorker.getInstance().registerForComponentEventsLater(this.view, comp, Math.max(this.loadDepth - 1, 0));
                    model.addRow(comp);
                    this.getSelection().deselectAll();
                    break;
                }
                case 2: {
                    if (!model.removeRow(slot)) break;
                    this.getSelection().deselectAll();
                    break;
                }
                case 3: {
                    String oldName = event.getValue().toString();
                    model.renameRow(oldName, slot);
                    break;
                }
                case 4: {
                    this.handleReorder();
                }
            }
        }
        this.repaint();
    }

    private void handleReorder() {
        ComponentTableModel model = this.getComponentModel();
        int[] indices = new int[model.getRowCount()];
        int n = 0;
        SlotCursor c = this.container.getProperties();
        while (c.nextComponent()) {
            int index = model.getRowByName(c.property().getName());
            if (index == -1) continue;
            indices[n++] = index;
        }
        model.reorderRows(indices);
    }

    public BComponent getContainer() {
        return this.container;
    }

    public void setContainer(BComponent container) {
        this.container = container;
    }

    public Context getCurrentContext() {
        return this.context;
    }

    public final void load(BComponent container, Context cx) {
        this.load(container, new Class[]{class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BComponentTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent}, cx);
    }

    public final void load(BComponent container, Class cls, Context cx) {
        this.load(container, new Class[]{cls}, 1, cx);
    }

    public final void load(BComponent container, Class[] classes, Context cx) {
        this.load(container, classes, 1, cx);
    }

    public final void load(BComponent container, Class cls, int depth, Context cx) {
        this.load(container, new Class[]{cls}, depth, cx);
    }

    public void load(BComponent container, Class[] classes, int depth, Context cx) {
        if (this.view == null) {
            throw new IllegalStateException("Use BWbComponentEvent.addComponentEventListener() before calling load()");
        }
        this.setContainer(container);
        this.loadClasses = classes;
        this.loadDepth = depth;
        this.context = cx;
        this.view.registerForComponentEvents(container, depth);
        ArrayList<BComponent> toAdd = new ArrayList<BComponent>();
        container.loadSlots();
        BComponent[] kids = container.getChildComponents();
        for (int i = 0; i < kids.length; ++i) {
            BComponent kid = kids[i];
            if (Flags.isHidden((BComplex)container, (Slot)kid.getPropertyInParent()) || !this.include(kid)) continue;
            kid.loadSlots();
            toAdd.add(kid);
        }
        BComponent[] rows = toAdd.toArray(new BComponent[toAdd.size()]);
        ComponentTableModel model = this.getComponentModel();
        model.setRows(rows);
    }

    public void reload() {
        if (this.view == null) {
            throw new IllegalStateException("Must call load before calling reload.");
        }
        this.getSelection().deselectAll();
        this.view.unregisterForAllComponentEvents();
        this.load(this.container, this.loadClasses, this.loadDepth, this.context);
    }

    public BComponent getComponentAt(int row) {
        return this.getComponentModel().getComponentAt(row);
    }

    public BComponent getSelectedComponent() {
        int row = this.getSelection().getRow();
        if (row == -1) {
            return null;
        }
        return this.getComponentModel().getComponentAt(row);
    }

    public BComponent[] getSelectedComponents() {
        int[] rows = this.getSelection().getRows();
        BComponent[] components = new BComponent[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            components[i] = this.getComponentModel().getComponentAt(rows[i]);
        }
        return components;
    }

    public Mark getSelectedComponentsAsMark() {
        BComponent[] c = this.getSelectedComponents();
        if (c.length == 0) {
            return null;
        }
        return new Mark((BObject[])c);
    }

    public void selectByName(String name) {
        this.selectByName(new String[]{name});
    }

    public void selectByName(String[] names) {
        ComponentTableModel model = this.getComponentModel();
        int[] rows = model.getRowsByName(names);
        this.getSelection().select(rows);
        if (rows.length > 0) {
            this.ensureRowIsVisible(rows[rows.length - 1]);
        }
    }

    public TransferEnvelope getTransferData() throws Exception {
        Mark mark = this.getSelectedComponentsAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return TransferUtil.insert((BWidget)this, cx, (BObject)this.container, null);
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        if (this.container == null) {
            return null;
        }
        BComponent[] selection = this.getSelectedComponents();
        if (selection.length == 0) {
            return null;
        }
        Mark mark = new Mark((BObject[])selection);
        return TransferUtil.delete((BWidget)this, mark);
    }

    public CommandArtifact doRename() throws Exception {
        if (this.container == null) {
            return null;
        }
        BComponent[] selection = this.getSelectedComponents();
        if (selection.length == 0) {
            return null;
        }
        Mark mark = new Mark((BObject[])selection);
        return TransferUtil.rename((BWidget)this, mark);
    }

    public void mouseDragStarted(BMouseEvent event) {
        int[] rows = this.getSelection().getRows();
        BComponent[] components = this.getSelectedComponents();
        if (components.length == 0) {
            return;
        }
        int row = this.getRowAt(event.getY());
        boolean found = false;
        for (int i = 0; i < rows.length; ++i) {
            if (row != rows[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(components);
        dragRenderer.font = Theme.table().getCellFont();
        this.startDrag(event, TransferEnvelope.make((Mark)new Mark((BObject[])components)), (DragRenderer)dragRenderer);
    }

    public void dragEnter(TransferContext cx) {
        if (this.container == null) {
            return;
        }
        this.dropActive = true;
        this.repaint();
    }

    public int dragOver(TransferContext cx) {
        if (this.container == null) {
            return 0;
        }
        int mask = 48;
        return mask;
    }

    public void dragExit(TransferContext cx) {
        if (this.container == null) {
            return;
        }
        this.dropActive = false;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (this.container == null) {
            return null;
        }
        this.dropActive = false;
        this.repaint();
        return this.insertTransferData(cx);
    }

    protected boolean include(BComponent c) {
        for (int i = 0; i < this.loadClasses.length; ++i) {
            if (!this.loadClasses[i].isInstance(c)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

