/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.commands;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.util.WbUtil;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class FileRenameCommand
extends Command {
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexTitle = this.lex.getText("commands.rename.label");
    BIFile[] files;
    String[] oldNames;
    String[] newNames;

    public FileRenameCommand(BWidget owner, BIFile[] files, String[] newNames) {
        super(owner, UiLexicon.bajaui().module, "commands.rename");
        if (newNames != null) {
            if (files.length != newNames.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < newNames.length; ++i) {
                if (newNames[i] != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.files = files;
        this.newNames = newNames;
    }

    public FileRenameCommand(BWidget owner, BIFile[] files) {
        this(owner, files, null);
    }

    public FileRenameCommand(BWidget owner, BIFile file, String newName) {
        this(owner, new BIFile[]{file}, new String[]{newName});
    }

    public FileRenameCommand(BWidget owner, BIFile file) {
        this(owner, new BIFile[]{file}, null);
    }

    public CommandArtifact doInvoke() throws Exception {
        int i;
        BFileSpace fs = this.files[0].getFileSpace();
        int len = this.files.length;
        this.oldNames = new String[len];
        for (i = 0; i < len; ++i) {
            this.oldNames[i] = this.files[i].getFileName();
        }
        if (this.newNames == null) {
            if (this.files.length == 1) {
                this.promptSingle();
            } else {
                this.promptList();
            }
            if (this.newNames == null) {
                return null;
            }
        }
        for (i = 0; i < len; ++i) {
            this.newNames[i] = this.newNames[i].trim();
            FilePath.verifyValidName((String)this.newNames[i]);
        }
        for (i = 0; i < len; ++i) {
            FilePath oldPath = this.files[i].getFilePath();
            FilePath newPath = new FilePath(this.newNames[i]);
            fs.move(oldPath, newPath);
        }
        return null;
    }

    void promptSingle() {
        String s = BOptionDialog.promptFileName((BWidget)this.getShell(), (String)this.getLabel(), (String)this.oldNames[0]);
        if (s == null) {
            return;
        }
        this.newNames = new String[]{s};
    }

    void promptList() {
        WbUtil.BatchReplace batch = new WbUtil.BatchReplace(this.getOwner(), this.oldNames);
        this.newNames = batch.prompt(this.lexTitle);
    }
}

