/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.bql.table;

import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableSubject;
import javax.baja.workbench.bql.table.BBqlTable;
import javax.baja.workbench.bql.table.BqlTableColumn;
import javax.baja.workbench.bql.table.BqlTableModel;

public class BqlTableSubject
extends TableSubject {
    private BObject[] resolved;

    public BqlTableSubject(BBqlTable table, int[] rows) {
        this(table, rows, -1);
    }

    public BqlTableSubject(BBqlTable table, int[] rows, int activeRow) {
        super((BTable)table, rows, activeRow);
    }

    public Object[] get() {
        return this.resolve();
    }

    public Object get(int index) {
        return this.resolve(index);
    }

    public BObject[] resolve() {
        if (this.resolved == null) {
            BqlTableModel model = ((BBqlTable)this.getTable()).getBqlModel();
            BqlTableColumn.Nav nav = model.getNavColumn();
            if (nav == null) {
                return null;
            }
            BOrd[] ords = new BOrd[this.size()];
            for (int i = 0; i < ords.length; ++i) {
                String ordString = ((BString)nav.getValueAt(this.getRow(i))).getString();
                ords[i] = BOrd.make((String)ordString);
            }
            this.resolved = new BatchResolve(ords).resolve(model.getBase()).getTargetObjects();
        }
        return (BObject[])this.resolved.clone();
    }

    public BObject resolve(int index) {
        BObject[] resolved = this.resolve();
        if (resolved == null) {
            return null;
        }
        if (index < 0 || index > resolved.length) {
            return null;
        }
        return resolved[index];
    }
}

