/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.bql.table;

import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.gx.BImage;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;

public class BqlTableColumn {
    public static final int HIDDEN = 1;
    public static final int UNSEEN = 2;
    public static final int UNESCAPE = 4;
    protected String name;
    protected String displayName;
    protected int flags = 0;
    protected BITable table;
    protected Column column;

    public BqlTableColumn(String name) {
        this(name, null, 0);
    }

    public BqlTableColumn(String name, String displayName, int flags) {
        this.name = name;
        this.displayName = displayName;
        this.flags = flags;
    }

    public void load(BITable table, Column column) {
        this.table = table;
        this.column = column;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getProjection() {
        if (this.displayName == null || this.displayName.length() == 0) {
            return this.name;
        }
        return this.name + " as '" + this.displayName + "'";
    }

    public Object getValueAt(int row) {
        return this.table.get(row, this.column);
    }

    public static class Nav
    extends BqlTableColumn {
        public Nav() {
            this("ordInSession");
        }

        public Nav(String name) {
            super(name, null, 2);
        }

        public Nav(String name, String displayName, int flags) {
            super(name, displayName, flags);
        }
    }

    public static class Icon
    extends Simple {
        public Icon() {
            this("icon");
        }

        public Icon(String name) {
            super(name, null, 1, (BSimple)BIcon.DEFAULT);
        }

        public Icon(String name, String displayName, int flags) {
            super(name, displayName, flags, (BSimple)BIcon.DEFAULT);
        }

        public BSimple parse(String s) {
            BIcon icon = (BIcon)super.parse(s);
            return BImage.make((BIcon)icon);
        }
    }

    public static class Status
    extends Simple {
        public Status() {
            this("status");
        }

        public Status(int flags) {
            this("status");
        }

        public Status(String name) {
            this(name, "%lexicon(workbench:bqlTable.status)%", 0);
        }

        public Status(String name, String displayName, int flags) {
            super(name, displayName, flags, (BSimple)BStatus.DEFAULT);
        }
    }

    public static class Simple
    extends BqlTableColumn {
        BSimple def;
        BSimple[] columnValues;

        public Simple(String name, BSimple def) {
            super(name);
            this.def = def;
        }

        public Simple(String name, String displayName, int flags, BSimple def) {
            super(name, displayName, flags);
            this.def = def;
        }

        public String getProjection() {
            if (this.displayName == null || this.displayName.length() == 0) {
                return this.name + ".encodeToString as '" + this.name + "'";
            }
            return this.name + ".encodeToString as '" + this.displayName + "'";
        }

        public void load(BITable table, Column column) {
            super.load(table, column);
            int rowCount = table.size();
            this.columnValues = new BSimple[rowCount];
            for (int row = 0; row < rowCount; ++row) {
                this.columnValues[row] = this.parse(table.getString(row, column));
            }
        }

        protected BSimple parse(String s) {
            try {
                return (BSimple)this.def.decodeFromString(s);
            }
            catch (Exception ex) {
                return this.def;
            }
        }

        public Object getValueAt(int row) {
            return this.columnValues[row];
        }
    }
}

