/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.ArrayList;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BIValidator;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BWbEditor
extends BWbPlugin {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$BWbEditor == null ? (class$javax$baja$workbench$BWbEditor = BWbEditor.class$("javax.baja.workbench.BWbEditor")) : class$javax$baja$workbench$BWbEditor));
    private BObject value;
    private Context context;
    private BIValidator[] validators = new BIValidator[0];
    private boolean readonly;
    private Throwable loadError;
    static /* synthetic */ Class class$javax$baja$workbench$BWbEditor;

    public Type getType() {
        return TYPE;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public final void setReadonly(boolean readonly) {
        if (this.readonly == readonly) {
            return;
        }
        this.readonly = readonly;
        this.doSetReadonly(readonly);
        if (readonly) {
            StyleUtils.addStyleClass((IStylable)this, (String)"readonly");
        } else {
            StyleUtils.removeStyleClass((IStylable)this, (String)"readonly");
        }
    }

    protected void doSetReadonly(boolean readonly) {
    }

    public final BObject getCurrentValue() {
        return this.value;
    }

    public final Context getCurrentContext() {
        return this.context;
    }

    public BHost getCurrentValueHost() {
        BObject cur = this.getCurrentValue();
        BHost host = BOrd.toHost((BObject)cur);
        if (host != null) {
            return host;
        }
        BWbShell shell = this.getWbShell();
        if (shell != null && (host = BOrd.toHost((BObject)(cur = shell.getActiveOrdTarget().get()))) != null) {
            return host;
        }
        return null;
    }

    public BISession getCurrentValueSession() {
        BObject cur = this.getCurrentValue();
        BISession session = BOrd.toSession((BObject)cur);
        if (session != null) {
            return session;
        }
        BWbShell shell = this.getWbShell();
        if (shell != null && (session = BOrd.toSession((BObject)(cur = shell.getActiveOrdTarget().get()))) != null) {
            return session;
        }
        return null;
    }

    public BSpace getCurrentValueSpace() {
        BObject cur = this.getCurrentValue();
        BSpace space = BOrd.toSpace((BObject)cur);
        if (space != null) {
            return space;
        }
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            cur = shell.getActiveOrdTarget().get();
            space = BOrd.toSpace((BObject)cur);
            if (space != null) {
                return space;
            }
        } else {
            System.out.println("drat!");
        }
        return null;
    }

    public Throwable getLoadError() {
        return this.loadError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadValue(BObject value, Context context) {
        Object object = this.monitor;
        synchronized (object) {
            this.loadError = null;
            BObject oldValue = this.value;
            this.lockModifiedState();
            this.value = value;
            this.context = context;
            try {
                BWbComponentView view;
                if (value instanceof BComponent && this instanceof BWbComponentView && (view = (BWbComponentView)this).isAutoRegisterForComponentEvents()) {
                    view.registerForComponentEvents((BComponent)value);
                }
                this.loadValidators();
                this.doLoadValue(this.value, context);
            }
            catch (Throwable e) {
                this.loadError = e;
                e.printStackTrace();
                String msg = UiLexicon.bajaui().getText("plugin.load.error");
                if (e instanceof LocalizableException) {
                    msg = msg + "\n" + ((LocalizableException)e).toString(null);
                }
                if (e instanceof LocalizableRuntimeException) {
                    msg = msg + "\n" + ((LocalizableRuntimeException)e).toString(null);
                }
                this.setContent((BWidget)new BLabel(msg));
            }
            this.unlockModifiedState();
            this.modified = false;
        }
    }

    public final void loadValue(BObject value) {
        this.loadValue(value, null);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BObject saveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.isModified()) {
                return value;
            }
            BObject result = null;
            try {
                result = this.doSaveValue(value, cx);
                this.doValidation(result, cx);
            }
            catch (CannotValidateException e) {
                throw new CannotSaveException(e.getMessage(), e);
            }
            if (value != null && !value.isSimple() && value.getType() == result.getType() && value != result) {
                throw new IllegalStateException("Complex editors must support edit-by-ref semantics");
            }
            this.modified = false;
            this.value = result;
            return this.value;
        }
    }

    public final BObject saveValue(Context cx) throws CannotSaveException, Exception {
        return this.saveValue(this.value, cx);
    }

    public final BObject saveValue() throws CannotSaveException, Exception {
        return this.saveValue(this.value, null);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        return value;
    }

    private void loadValidators() {
        ArrayList<BObject> arr = new ArrayList<BObject>();
        if (this.context != null && this instanceof BWbFieldEditor) {
            String[] keys = this.context.getFacets().list();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].startsWith("validator")) continue;
                String spec = this.context.getFacets().gets(keys[i], "");
                BObject candidate = null;
                try {
                    candidate = BTypeSpec.make((String)spec).getInstance();
                }
                catch (Exception e) {
                    throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "wbEditor.badValidatorSpec", new Object[]{keys[i], spec}, (Throwable)e);
                }
                if (!candidate.getType().is(BIValidator.TYPE)) {
                    throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "wbEditor.badValidatorType", new Object[]{keys[i], spec});
                }
                arr.add(candidate);
            }
        }
        this.validators = arr.toArray(new BIValidator[arr.size()]);
    }

    private void doValidation(BObject value, Context saveCx) throws Exception {
        BFacets vFacets;
        BFacets bFacets = vFacets = this.context == null ? BFacets.NULL : this.context.getFacets();
        if (saveCx != null) {
            vFacets = BFacets.make((BFacets)vFacets, (BFacets)saveCx.getFacets());
        }
        BasicContext vContext = new BasicContext(saveCx, vFacets);
        for (int i = 0; i < this.validators.length; ++i) {
            this.validators[i].validate(value, (Context)vContext);
        }
        if (this instanceof BWbFieldEditor && this instanceof BIValidator) {
            ((BIValidator)this).validate(value, (Context)vContext);
        }
        if (value instanceof BIValidator) {
            ((BIValidator)value).validate(value, (Context)vContext);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

