/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BFindPane;
import com.tridium.workbench.propsheet.BPropertyEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrEditDialog;

public class WbUtil {
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static Log log = Log.getLog((String)"wb.util");

    public static void loadWithMacros(InputStream in, OutputStream out, Properties macros) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (c != 36) {
                out.write(c);
                continue;
            }
            c = in.read();
            if (c != 40) {
                out.write(c);
                continue;
            }
            StringBuffer s = new StringBuffer();
            while ((c = in.read()) != 41) {
                s.append((char)c);
            }
            String key = s.toString();
            String val = macros.getProperty(key, key);
            for (int i = 0; i < val.length(); ++i) {
                out.write(val.charAt(i));
            }
        }
    }

    public static BColor mixColors(BColor colorA, BColor colorB, float mix) {
        if (mix <= 0.0f) {
            return colorA;
        }
        if (mix >= 1.0f) {
            return colorB;
        }
        int red = (int)((float)colorA.getRed() + (float)(colorB.getRed() - colorA.getRed()) * mix);
        int green = (int)((float)colorA.getGreen() + (float)(colorB.getGreen() - colorA.getGreen()) * mix);
        int blue = (int)((float)colorA.getBlue() + (float)(colorB.getBlue() - colorA.getBlue()) * mix);
        int alpha = (int)((float)colorA.getAlpha() + (float)(colorB.getAlpha() - colorA.getAlpha()) * mix);
        return BColor.make((int)red, (int)green, (int)blue, (int)alpha);
    }

    public static BColor floatToColor(float value, BColor lowColor, BColor midColor, BColor highColor, float min, float max) {
        int blue;
        int green;
        int red;
        float delta = Math.abs(max - min) / 2.0f;
        float mid = min + delta;
        if (value < mid) {
            if (value < min) {
                return lowColor;
            }
            float mRed = (float)(midColor.getRed() - lowColor.getRed()) / delta;
            float bRed = (float)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            float mGreen = (float)(midColor.getGreen() - lowColor.getGreen()) / delta;
            float bGreen = (float)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            float mBlue = (float)(midColor.getBlue() - lowColor.getBlue()) / delta;
            float bBlue = (float)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
        } else {
            if (value > max) {
                return highColor;
            }
            float mRed = (float)(highColor.getRed() - midColor.getRed()) / delta;
            float bRed = (float)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            float mGreen = (float)(highColor.getGreen() - midColor.getGreen()) / delta;
            float bGreen = (float)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            float mBlue = (float)(highColor.getBlue() - midColor.getBlue()) / delta;
            float bBlue = (float)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
        }
        return BColor.make((int)red, (int)green, (int)blue);
    }

    public static int compositeDeletionWarning(BWidget parentWidget, BComplex[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            int result = WbUtil.compositeDeletionWarning(parentWidget, (BIPropertyContainer)slots[i].getParent().asComponent(), (Slot)slots[i].getPropertyInParent());
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    public static int compositeDeletionWarning(BWidget parentWidget, BIPropertyContainer parent, Slot slot) {
        return WbUtil.compositeDeletionWarning(parentWidget, parent, new Slot[]{slot});
    }

    public static int compositeDeletionWarning(BWidget parentWidget, BIPropertyContainer parent, Slot[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            if ((parent.getFlags(slots[i]) & 0x1000) == 0) continue;
            return BDialog.open((BWidget)parentWidget, (String)lex.getText("compositeDelete.warning.title"), (Object)lex.getText("compositeDelete.warning.message"), (int)3, (BImage)BDialog.WARNING_ICON);
        }
        return -1;
    }

    public static boolean isRemoteModuleAvailable(String moduleName, BISession session) {
        BObject oSession = (BObject)session;
        Version version = (Version)oSession.fw(404, (Object)moduleName, null, null, null);
        if (version == null) {
            try {
                BOrd.make((String)("file:!modules/" + moduleName + ".jar")).resolve(oSession).get();
                return true;
            }
            catch (Exception e) {}
        } else if (!version.isNull()) {
            return true;
        }
        return false;
    }

    public static BObject findService(BWidget fieldEditor, Type serviceType, BWbShell shell) {
        if (shell != null) {
            try {
                BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)("service:" + serviceType));
                return ord.get();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (fieldEditor != null) {
            BObject result = WbUtil.findAncenstorViaWidgetTree(fieldEditor, serviceType);
            if (result != null) {
                return result;
            }
            BComponent firstComponent = (BComponent)WbUtil.findAncenstorViaWidgetTree(fieldEditor, BComponent.TYPE);
            if (firstComponent != null) {
                return WbUtil.findAncenstorViaComponentTree(firstComponent, serviceType);
            }
        }
        return null;
    }

    public static BObject findAncenstorViaComponentTree(BComponent c, Type ancestorType) {
        while (c != null) {
            if (c.getType().is(ancestorType)) {
                return c;
            }
            c = (BComponent)c.getParent();
        }
        return null;
    }

    public static BObject findService(BWidget fieldEditor, Type serviceType) {
        if (fieldEditor != null) {
            return WbUtil.findService(fieldEditor, serviceType, BWbShell.getWbShell(fieldEditor));
        }
        return null;
    }

    public static BObject findAncenstorViaWidgetTree(BWidget fieldEditor, Type ancestorType) {
        if (log.isTraceOn()) {
            log.trace("Looking for:" + ancestorType + " starting with " + fieldEditor.getType());
        }
        try {
            for (BWidget iterator = fieldEditor; iterator != null; iterator = iterator.getParent()) {
                BMgrEditDialog dialog;
                BAbstractManager manager;
                BObject val;
                if (log.isTraceOn()) {
                    log.trace("ancestor iterator: " + iterator.getType());
                }
                if (iterator instanceof BWbEditor) {
                    BWbEditor editor = (BWbEditor)iterator;
                    BObject val2 = editor.getCurrentValue();
                    if (val2 != null && val2.getType().is(ancestorType)) {
                        if (log.isTraceOn()) {
                            log.trace("Found ancestor via BWbEditor widget ancestory:" + ancestorType);
                        }
                        return val2;
                    }
                    BBinding[] bindings = editor.getBindings();
                    for (int i = 0; i < bindings.length; ++i) {
                        if (bindings[i].getTarget() == null || bindings[i].getTarget().getSecurityTarget() == null || !bindings[i].getTarget().getSecurityTarget().getType().is(ancestorType)) continue;
                        if (log.isTraceOn()) {
                            log.trace("Found ancestor via Binding");
                        }
                        return (BObject)bindings[i].getTarget().getSecurityTarget();
                    }
                    continue;
                }
                if (iterator instanceof BPropertyEntry) {
                    Mark mark;
                    TransferEnvelope envelope = ((BPropertyEntry)iterator).getTransferData();
                    if (envelope == null || (mark = (Mark)envelope.getData(TransferFormat.mark)).size() != 1 || mark.getValue(0) == null || !mark.getValue(0).getType().is(ancestorType)) continue;
                    if (log.isTraceOn()) {
                        log.trace("Found ancestor via PropertySheet");
                    }
                    return mark.getValue(0);
                }
                if (!(iterator instanceof BMgrEditDialog) || (val = (manager = (dialog = (BMgrEditDialog)iterator).getManager()).getCurrentValue()) == null || !val.getType().is(ancestorType)) continue;
                if (log.isTraceOn()) {
                    log.trace("Found ancestor via BMgrEditDialog");
                }
                return val;
            }
        }
        catch (Exception e) {
            log.error("Problem searching for widget tree based ancestor", (Throwable)e);
        }
        return null;
    }

    static class BatchReplaceRenderer
    extends TableCellRenderer {
        BatchReplaceRenderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell c) {
            return this.getForeground(c);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell c) {
            return this.getBackground(c);
        }
    }

    static class BatchReplaceController
    extends TableController {
        BatchReplaceController() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    public static class BatchReplace
    extends TableModel
    implements BFindPane.Listener {
        BWidget owner;
        BFindPane find;
        BTable table;
        String[] oldNames;
        String[] newNames;
        String lexOld = UiLexicon.bajaui().getText("old");
        String lexNew = UiLexicon.bajaui().getText("new");

        public BatchReplace(BWidget owner, String[] oldNames) {
            this.owner = owner;
            this.oldNames = oldNames;
            this.newNames = (String[])oldNames.clone();
            this.find = new BFindPane(owner, true, true, (BFindPane.Listener)this);
            this.table = new BTable((TableModel)this, (TableController)new BatchReplaceController());
            this.table.setCellRenderer((TableCellRenderer)new BatchReplaceRenderer());
        }

        public String[] prompt(String title) {
            BEdgePane edge = new BEdgePane();
            edge.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
            edge.setBottom((BWidget)new BBorderPane((BWidget)this.find, 10.0, 0.0, 0.0, 0.0));
            BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)edge));
            pane.setMinSize(400.0, 200.0);
            pane.setMaxSize(500.0, 600.0);
            int r = BDialog.open((BWidget)this.owner, (String)title, (Object)pane, (int)3);
            if (r != 1) {
                return null;
            }
            this.find.save();
            return this.newNames;
        }

        public void findPatternModified(FindPattern pattern, String replace) {
            for (int i = 0; i < this.newNames.length; ++i) {
                this.newNames[i] = pattern.replace(this.oldNames[i], replace);
            }
            this.updateTable();
        }

        public int getRowCount() {
            return this.oldNames.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return col == 0 ? this.lexOld : this.lexNew;
        }

        public Object getValueAt(int row, int col) {
            return col == 0 ? this.oldNames[row] : this.newNames[row];
        }
    }
}

