/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Slot;
import javax.baja.ui.BWidget;

public class SlotBarUtil {
    public static final int wixel = 12;
    public static final BColor propertyBg1 = BColor.make((int)167, (int)167, (int)213);
    public static final BColor propertyBg2 = BColor.make((int)210, (int)210, (int)234);
    public static final BColor actionBg1 = BColor.make((int)30, (int)211, (int)30);
    public static final BColor actionBg2 = BColor.make((int)210, (int)254, (int)210);
    public static final BColor topicBg1 = BColor.make((int)181, (int)182, (int)59);
    public static final BColor topicBg2 = BColor.make((int)227, (int)227, (int)193);
    public static final BBrush propertyGradient = SlotBarUtil.makeGradient(propertyBg2, propertyBg1);
    public static final BBrush actionGradient = SlotBarUtil.makeGradient(actionBg2, actionBg1);
    public static final BBrush topicGradient = SlotBarUtil.makeGradient(topicBg2, topicBg1);
    public static final BBrush propertyHighlightGradient = SlotBarUtil.makeGradient(BColor.white, propertyBg2);
    public static final BBrush actionHighlightGradient = SlotBarUtil.makeGradient(BColor.white, actionBg2);
    public static final BBrush topicHighlightGradient = SlotBarUtil.makeGradient(BColor.white, topicBg2);
    private static BImage[] propertyBars = new BImage[256];
    private static BImage[] actionBars = new BImage[256];
    private static BImage[] topicBars = new BImage[256];
    private static BImage[] highlightPropertyBars = new BImage[256];
    private static BImage[] highlightActionBars = new BImage[256];
    private static BImage[] highlightTopicBars = new BImage[256];

    private static BBrush makeGradient(BColor a, BColor b) {
        BBrush.Stop[] stops = new BBrush.Stop[]{BBrush.stop((double)0.0, (BColor)a), BBrush.stop((double)100.0, (BColor)b)};
        return BBrush.makeLinearGradient((BBrush.Stop[])stops);
    }

    public static BImage getSlotBar(BWidget w, Slot slot, int wixelWidth) {
        if (slot.isAction()) {
            return SlotBarUtil.getActionBar(w, wixelWidth);
        }
        if (slot.isTopic()) {
            return SlotBarUtil.getTopicBar(w, wixelWidth);
        }
        return SlotBarUtil.getPropertyBar(w, wixelWidth);
    }

    public static BImage getHighlightSlotBar(BWidget w, Slot slot, int wixelWidth) {
        if (slot.isAction()) {
            return SlotBarUtil.getHighlightActionBar(w, wixelWidth);
        }
        if (slot.isTopic()) {
            return SlotBarUtil.getHighlightTopicBar(w, wixelWidth);
        }
        return SlotBarUtil.getHighlightPropertyBar(w, wixelWidth);
    }

    public static BImage getPropertyBar(BWidget w, int wixelWidth) {
        BImage image = propertyBars[wixelWidth];
        if (image == null) {
            image = SlotBarUtil.propertyBars[wixelWidth] = SlotBarUtil.makeBar(w, wixelWidth, propertyGradient);
        }
        return image;
    }

    public static BImage getActionBar(BWidget w, int wixelWidth) {
        BImage image = actionBars[wixelWidth];
        if (image == null) {
            image = SlotBarUtil.actionBars[wixelWidth] = SlotBarUtil.makeBar(w, wixelWidth, actionGradient);
        }
        return image;
    }

    public static BImage getTopicBar(BWidget w, int wixelWidth) {
        BImage image = topicBars[wixelWidth];
        if (image == null) {
            image = SlotBarUtil.topicBars[wixelWidth] = SlotBarUtil.makeBar(w, wixelWidth, topicGradient);
        }
        return image;
    }

    public static BImage getHighlightPropertyBar(BWidget w, int wixelWidth) {
        BImage image = highlightPropertyBars[wixelWidth];
        if (image == null) {
            image = SlotBarUtil.highlightPropertyBars[wixelWidth] = SlotBarUtil.makeBar(w, wixelWidth, propertyHighlightGradient);
        }
        return image;
    }

    public static BImage getHighlightActionBar(BWidget w, int wixelWidth) {
        BImage image = highlightActionBars[wixelWidth];
        if (image == null) {
            image = SlotBarUtil.highlightActionBars[wixelWidth] = SlotBarUtil.makeBar(w, wixelWidth, actionHighlightGradient);
        }
        return image;
    }

    public static BImage getHighlightTopicBar(BWidget w, int wixelWidth) {
        BImage image = highlightTopicBars[wixelWidth];
        if (image == null) {
            image = SlotBarUtil.highlightTopicBars[wixelWidth] = SlotBarUtil.makeBar(w, wixelWidth, topicHighlightGradient);
        }
        return image;
    }

    private static BImage makeBar(BWidget w, int wixelWidth, BBrush brush) {
        int pw = wixelWidth * 12;
        int ph = 24;
        BImage image = BImage.make((double)pw, (double)ph);
        Graphics g = image.getGraphics();
        g.setBrush(brush);
        g.fillRect(0.0, 0.0, (double)pw, (double)ph);
        g.dispose();
        return image;
    }
}

