/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BOptionDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ILambda;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.PatternFilter;

public abstract class FileFinder {
    private static UiLexicon lexicon = new UiLexicon(class$com$tridium$workbench$util$FileFinder == null ? (class$com$tridium$workbench$util$FileFinder = FileFinder.class$("com.tridium.workbench.util.FileFinder")) : class$com$tridium$workbench$util$FileFinder);
    static final File INDEX = new File(Sys.getBajaHome(), "workbench/fileIndex.properties");
    private static boolean loaded = false;
    private static Tag[] tags;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$com$tridium$workbench$util$FileFinder$Tag;
    static /* synthetic */ Class class$com$tridium$workbench$util$FileFinder;

    public static boolean isValid() {
        return INDEX.exists();
    }

    public static BOrd findOrd(BWidget owner, String pattern) {
        BOrd[] ords;
        if (!FileFinder.isValid()) {
            throw new IllegalStateException();
        }
        if (!loaded) {
            try {
                FileFinder.load();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if ((ords = FileFinder.searchTags(pattern)).length == 0) {
            ords = FileFinder.searchTags(pattern + ".java");
        }
        switch (ords.length) {
            case 0: {
                return null;
            }
            case 1: {
                return ords[0];
            }
        }
        return FileFinder.selectOrd(owner, ords);
    }

    static void reload() {
        loaded = false;
    }

    private static BOrd selectOrd(BWidget owner, BOrd[] ords) {
        BList list = new BList();
        list.setMultipleSelection(false);
        list.setModel((ListModel)new Model(ords));
        list.setController((ListController)new Controller());
        BConstrainedPane cons = new BConstrainedPane((BWidget)list);
        cons.setMaxHeight(300.0);
        BBorderPane pane = new BBorderPane((BWidget)cons, BBorder.inset, BInsets.DEFAULT);
        pane.setMargin(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        String title = lexicon.getText("gotoFile.selectFile");
        int result = BDialog.open((BWidget)owner, (String)title, (Object)pane, (int)3);
        if (result == 2) {
            return null;
        }
        int idx = list.getSelectedIndex();
        return idx == -1 ? null : ords[idx];
    }

    private static BOrd[] searchTags(String pattern) {
        PatternFilter filter = new PatternFilter(pattern);
        Array arr = new Array(class$java$lang$String == null ? (class$java$lang$String = FileFinder.class$("java.lang.String")) : class$java$lang$String);
        for (int i = 0; i < tags.length; ++i) {
            if (!filter.accept(FileFinder.tags[i].name)) continue;
            for (int j = 0; j < FileFinder.tags[i].dirs.length; ++j) {
                arr.add((Object)(FileFinder.tags[i].dirs[j] + "/" + FileFinder.tags[i].name));
            }
        }
        return (BOrd[])arr.sort().apply(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = FileFinder.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd, new ILambda(){

            public Object eval(Object obj) {
                return BOrd.make((String)("local:|file:/" + obj));
            }
        }).trim();
    }

    private static void load() throws IOException {
        Array arr = new Array(class$com$tridium$workbench$util$FileFinder$Tag == null ? (class$com$tridium$workbench$util$FileFinder$Tag = FileFinder.class$("com.tridium.workbench.util.FileFinder$Tag")) : class$com$tridium$workbench$util$FileFinder$Tag);
        BufferedReader in = new BufferedReader(new FileReader(INDEX));
        String str = in.readLine();
        while (str != null) {
            int n = str.indexOf(61);
            String name = str.substring(0, n);
            String[] dirs = TextUtil.split((String)str.substring(n + 1), (char)',');
            arr.add((Object)new Tag(name, dirs));
            str = in.readLine();
        }
        in.close();
        tags = (Tag[])arr.trim();
        loaded = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Tag {
        String name;
        String[] dirs;

        Tag(String name, String[] dirs) {
            this.name = name;
            this.dirs = dirs;
        }
    }

    private static class Controller
    extends ListController {
        private Controller() {
        }

        void ok() {
            ((BOptionDialog)this.getList().getShell()).close(1);
        }

        protected void handleEnter(BKeyEvent event) {
            event.consume();
            this.ok();
        }

        protected void itemDoubleClicked(BMouseEvent event, int i) {
            this.ok();
        }
    }

    private static class Model
    extends ListModel {
        private BOrd[] ords;

        private Model(BOrd[] ords) {
            this.ords = ords;
        }

        public int getItemCount() {
            return this.ords.length;
        }

        public Object getItem(int idx) {
            return this.ords[idx];
        }
    }
}

