/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BLabelPaneContainer;

public class BMiniTabbedPane
extends BLabelPaneContainer {
    public static final Property tabPlacement = BMiniTabbedPane.newProperty((int)0, (BValue)BValign.top, null);
    public static final Topic selectionModified = BMiniTabbedPane.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BMiniTabbedPane == null ? (class$com$tridium$workbench$util$BMiniTabbedPane = BMiniTabbedPane.class$("com.tridium.workbench.util.BMiniTabbedPane")) : class$com$tridium$workbench$util$BMiniTabbedPane));
    private static WidgetTheme theme = Theme.widget();
    private static BFont textFont = theme.getTextFont();
    private static BBrush textBrush = theme.getTextBrush();
    private ArrayList mousingRectGeoms = new ArrayList();
    private int idx = 0;
    private double totalWidth = 0.0;
    private double tabListY = 0.0;
    private double xOffset = 0.0;
    private boolean tooLong = false;
    private boolean leftEnabled = false;
    private boolean rightEnabled = false;
    static /* synthetic */ Class class$com$tridium$workbench$util$BMiniTabbedPane;

    public BValign getTabPlacement() {
        return (BValign)this.get(tabPlacement);
    }

    public void setTabPlacement(BValign v) {
        this.set(tabPlacement, (BValue)v, null);
    }

    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMiniTabbedPane() {
    }

    public BMiniTabbedPane(BValign placement) {
        this.setTabPlacement(placement);
    }

    public Point translateToChild(BWidget child, Point pt) {
        return super.translateToChild(child, this.getTabPlacement().equals((Object)BValign.bottom) ? pt : new Point(pt.x, pt.y + BMiniTabbedPane.getTabHeight()));
    }

    public void paint(Graphics g) {
        BWidget[] children = this.getChildWidgets();
        if (children.length == 0) {
            return;
        }
        this.paintChild(g, ((BLabelPane)children[this.idx]).getContent());
        BValign placement = this.getTabPlacement();
        if (placement.equals((Object)BValign.center)) {
            placement = BValign.top;
        }
        g.translate(0.0, this.tabListY);
        try {
            g.translate(-this.xOffset, 0.0);
            try {
                this.paintLabels(g, children, placement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            g.translate(this.xOffset, 0.0);
            if (this.tooLong) {
                this.paintArrows(g, this.getWidth() - 18.0, placement.equals((Object)BValign.top) ? 9.0 : 8.0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        g.translate(0.0, -this.tabListY);
    }

    private void paintLabels(Graphics g, BWidget[] children, BValign placement) {
        double tabHeight = BMiniTabbedPane.getTabHeight();
        double x = 3.0;
        g.setBrush(BColor.black);
        g.setFont(textFont);
        for (int i = 0; i < children.length; ++i) {
            String text = ((BLabelPane)children[i]).getLabel().getText();
            double n = textFont.width(text) + 12.0;
            if (placement.equals((Object)BValign.top)) {
                if (i == this.idx) {
                    g.setBrush(theme.getControlHighlight());
                    g.fillRect(x, 3.0, n, tabHeight - 3.0);
                    g.setBrush(BColor.black);
                    g.strokeLine(x, 3.0, x, tabHeight);
                    g.strokeLine(x + n, 3.0, x + n, tabHeight);
                    g.strokeLine(x, 3.0, x + n, 3.0);
                } else {
                    g.setBrush(theme.getControlShadow());
                    g.strokeLine(x + n, 4.0, x + n, textFont.getHeight() + 2.0);
                }
                g.setBrush(textBrush);
                g.drawString(text, x + 6.0, textFont.getAscent() + 4.0);
            } else {
                if (i == this.idx) {
                    g.setBrush(theme.getControlHighlight());
                    g.fillRect(x, 1.0, n, tabHeight - 3.0);
                    g.setBrush(BColor.black);
                    g.strokeLine(x, 1.0, x, tabHeight - 3.0);
                    g.strokeLine(x + n, 1.0, x + n, tabHeight - 3.0);
                    g.strokeLine(x, tabHeight - 3.0, x + n, tabHeight - 3.0);
                } else {
                    g.setBrush(theme.getControlShadow());
                    g.strokeLine(x + n, 3.0, x + n, textFont.getHeight());
                }
                g.setBrush(textBrush);
                g.drawString(text, x + 6.0, textFont.getAscent() + 1.0);
            }
            x += n;
        }
    }

    private void paintArrows(Graphics g, double x, double y) {
        double tabHeight = BMiniTabbedPane.getTabHeight();
        g.setBrush(theme.getControlBackground());
        g.fillRect(x, 1.0, 18.0, tabHeight - 1.0);
        g.setBrush(theme.getControlShadow());
        if (this.leftEnabled) {
            g.strokeLine(x + 3.0, y, x + 3.0, y);
            g.strokeLine(x + 4.0, y - 1.0, x + 4.0, y + 1.0);
            g.strokeLine(x + 5.0, y - 2.0, x + 5.0, y + 2.0);
            g.strokeLine(x + 6.0, y - 3.0, x + 6.0, y + 3.0);
            g.strokeLine(x + 7.0, y - 4.0, x + 7.0, y + 4.0);
        } else {
            g.strokeLine(x + 3.0, y, x + 3.0, y);
            g.strokeLine(x + 3.0, y, x + 3.0, y);
            g.strokeLine(x + 4.0, y - 1.0, x + 4.0, y - 1.0);
            g.strokeLine(x + 4.0, y + 1.0, x + 4.0, y + 1.0);
            g.strokeLine(x + 5.0, y - 2.0, x + 5.0, y - 2.0);
            g.strokeLine(x + 5.0, y + 2.0, x + 5.0, y + 2.0);
            g.strokeLine(x + 6.0, y - 3.0, x + 6.0, y - 3.0);
            g.strokeLine(x + 6.0, y + 3.0, x + 6.0, y + 3.0);
            g.strokeLine(x + 7.0, y - 4.0, x + 7.0, y + 4.0);
        }
        if (this.rightEnabled) {
            g.strokeLine(x + 14.0, y, x + 14.0, y);
            g.strokeLine(x + 13.0, y - 1.0, x + 13.0, y + 1.0);
            g.strokeLine(x + 12.0, y - 2.0, x + 12.0, y + 2.0);
            g.strokeLine(x + 11.0, y - 3.0, x + 11.0, y + 3.0);
            g.strokeLine(x + 10.0, y - 4.0, x + 10.0, y + 4.0);
        } else {
            g.strokeLine(x + 14.0, y, x + 14.0, y);
            g.strokeLine(x + 14.0, y, x + 14.0, y);
            g.strokeLine(x + 13.0, y - 1.0, x + 13.0, y - 1.0);
            g.strokeLine(x + 13.0, y + 1.0, x + 13.0, y + 1.0);
            g.strokeLine(x + 12.0, y - 2.0, x + 12.0, y - 2.0);
            g.strokeLine(x + 12.0, y + 2.0, x + 12.0, y + 2.0);
            g.strokeLine(x + 11.0, y - 3.0, x + 11.0, y - 3.0);
            g.strokeLine(x + 11.0, y + 3.0, x + 11.0, y + 3.0);
            g.strokeLine(x + 10.0, y - 4.0, x + 10.0, y + 4.0);
        }
    }

    public void mousePulsed(BMouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        if (this.tooLong && x >= this.getWidth() - 18.0) {
            if (x >= this.getWidth() - 9.0) {
                if (this.rightEnabled) {
                    this.xOffset += 20.0;
                    if (this.xOffset > this.getMaxOffset()) {
                        this.xOffset = this.getMaxOffset();
                    }
                    this.leftEnabled = this.xOffset > 0.0;
                    this.rightEnabled = this.xOffset < this.getMaxOffset();
                    this.repaint();
                }
            } else if (this.leftEnabled) {
                this.xOffset -= 20.0;
                if (this.xOffset < 0.0) {
                    this.xOffset = 0.0;
                }
                this.leftEnabled = this.xOffset > 0.0;
                this.rightEnabled = this.xOffset < this.getMaxOffset();
                this.repaint();
            }
        }
    }

    public void mousePressed(BMouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        if (this.tooLong && x >= this.getWidth() - 18.0) {
            return;
        }
        for (int i = 0; i < this.mousingRectGeoms.size(); ++i) {
            RectGeom rect = (RectGeom)this.mousingRectGeoms.get(i);
            if (!rect.contains(x + this.xOffset, y) || this.idx == i) continue;
            this.idx = i;
            this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
            this.relayout();
            return;
        }
    }

    private double getMaxOffset() {
        return this.totalWidth - this.getWidth() + 24.0;
    }

    private void layoutRects(BWidget[] children, double tabHeight, BValign placement) {
        this.totalWidth = 3.0;
        this.mousingRectGeoms.clear();
        for (int i = 0; i < children.length; ++i) {
            String text = ((BLabelPane)children[i]).getLabel().getText();
            double n = textFont.width(text) + 12.0;
            if (placement.equals((Object)BValign.top)) {
                this.mousingRectGeoms.add(new RectGeom(this.totalWidth, 3.0, n, tabHeight - 3.0));
            } else {
                this.mousingRectGeoms.add(new RectGeom(this.totalWidth, 1.0, n, this.tabListY + tabHeight - 3.0));
            }
            this.totalWidth += n;
        }
        if (this.totalWidth > this.getWidth()) {
            if (this.xOffset > this.getMaxOffset()) {
                this.xOffset = this.getMaxOffset();
            }
            this.tooLong = true;
            this.leftEnabled = this.xOffset > 0.0;
            this.rightEnabled = this.xOffset < this.getMaxOffset();
        } else {
            this.tooLong = false;
            this.xOffset = 0.0;
        }
    }

    public void computePreferredSize() {
        BWidget[] kids = this.getChildWidgets();
        if (kids.length == 0) {
            this.setPreferredSize(10.0, BMiniTabbedPane.getTabHeight());
            return;
        }
        double w = 0.0;
        double h = 0.0;
        for (int i = 0; i < kids.length; ++i) {
            BLabelPane kid = (BLabelPane)kids[i];
            BWidget c = kid.getContent();
            c.computePreferredSize();
            w = Math.max(w, c.getPreferredWidth());
            h = Math.max(h, c.getPreferredHeight());
        }
        this.setPreferredSize(w, h += BMiniTabbedPane.getTabHeight());
    }

    public void doLayout(BWidget[] children) {
        double tabHeight = BMiniTabbedPane.getTabHeight();
        BValign placement = this.getTabPlacement();
        if (placement.equals((Object)BValign.center)) {
            System.out.println("WARNING: BMiniTabbedPane.aligment cannot be set to 'center'");
            placement = BValign.top;
        }
        this.tabListY = placement.equals((Object)BValign.top) ? 0.0 : this.getHeight() - tabHeight;
        this.layoutRects(children, tabHeight, placement);
        for (int i = 0; i < children.length; ++i) {
            BLabelPane kid = (BLabelPane)children[i];
            BWidget content = kid.getContent();
            if (i == this.idx) {
                double x = 0.0;
                double y = placement.equals((Object)BValign.top) ? tabHeight : 0.0;
                double w = this.getWidth();
                double h = this.getHeight() - tabHeight - 0.0;
                kid.setBounds(x, y, w, h);
                kid.setVisible(true);
                content.setBounds(x, y, w, h);
                content.setVisible(true);
                continue;
            }
            kid.setBounds(0.0, 0.0, 0.0, 0.0);
            kid.setVisible(false);
            content.setBounds(0.0, 0.0, 0.0, 0.0);
            content.setVisible(false);
        }
    }

    public BLabelPane getSelectedLabelPane() {
        BWidget[] children = this.getChildWidgets();
        if (children.length == 0) {
            return null;
        }
        return (BLabelPane)children[this.idx];
    }

    public void selectPane(BWidget content) {
        System.out.println("BMiniTabbedPane.selectPane: aaa " + content);
        BWidget[] children = this.getChildWidgets();
        if (children.length == 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < children.length; ++i) {
            System.out.println("BMiniTabbedPane.selectPane: bbb " + i + ", " + ((BLabelPane)children[i]).getContent());
            if (((BLabelPane)children[i]).getContent() != content) continue;
            this.idx = i;
            return;
        }
        throw new IllegalStateException();
    }

    private static double getTabHeight() {
        return textFont.getHeight() + 4.0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

