/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.WbUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BLinkSheet
extends BWbComponentView
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BLinkSheet == null ? (class$com$tridium$workbench$util$BLinkSheet = BLinkSheet.class$("com.tridium.workbench.util.BLinkSheet")) : class$com$tridium$workbench$util$BLinkSheet));
    private static Lexicon lex = Lexicon.make((String)"workbench");
    static final String[] cols = new String[]{lex.getText("linkSheet.mySlot"), lex.getText("linkSheet.direction"), lex.getText("linkSheet.otherPath"), lex.getText("linkSheet.otherSlot"), lex.getText("linkSheet.enabled"), lex.getText("linkSheet.type")};
    private static BImage iconIn = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static BImage iconOut = BImage.make((String)"module://icons/x16/arrowRight.png");
    private static BImage goTo = BImage.make((String)"module://icons/x16/arrowRight.png");
    private BComponent c;
    private BTable table;
    private Model model;
    private DeleteLinks deleteLinks;
    private EditLink editLink = new EditLink(this);
    private Hyperlink hyperlink;
    static /* synthetic */ Class class$com$tridium$workbench$util$BLinkSheet;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BLinkSheet() {
        this.editLink.setEnabled(false);
        this.deleteLinks = new DeleteLinks(this);
        this.deleteLinks.setEnabled(false);
        this.hyperlink = new Hyperlink(this);
        this.hyperlink.setEnabled(false);
        this.model = new Model();
        this.table = new BTable();
        this.table.setModel((TableModel)new DynamicTableModel((TableModel)this.model, new int[]{0, 1, 2, 3}));
        this.table.setSelection((TableSelection)new Selection());
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    public BMenu[] getViewMenus() {
        return new BMenu[]{this.buildMenu()};
    }

    public BToolBar getViewToolBar() {
        BToolBar toolbar = new BToolBar();
        toolbar.add(null, (Command)this.deleteLinks);
        return toolbar;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.c = (BComponent)value;
        this.refreshModel();
    }

    private void refreshModel() {
        int i;
        this.model.rows.clear();
        BLink[] links = this.c.getLinks();
        for (int i2 = 0; i2 < links.length; ++i2) {
            BLink link = links[i2];
            BComponent x = null;
            try {
                x = (BComponent)link.getSourceOrd().resolve((BObject)this.c.getComponentSpace()).get();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Row row = new Row();
            row.link = link;
            row.direction = 0;
            row.mySlot = link.getTargetSlotName();
            row.otherPath = x == null ? "Unresolved: " + link.getSourceOrd() : "" + x.getSlotPath();
            row.otherSlot = link.getSourceSlotName();
            row.enabled = String.valueOf(link.isEnabled());
            row.type = link.getType().toString();
            row.parent = this.c;
            row.prop = link.getPropertyInParent();
            this.model.rows.add(row);
        }
        Knob[] knobs = this.c.getKnobs();
        Array knobComps = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BLinkSheet.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        for (i = 0; i < knobs.length; ++i) {
            try {
                knobComps.add((Object)knobs[i].getTargetOrd().resolve((BObject)this.c.getComponentSpace()).get());
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (knobComps.size() > 0) {
            BComponent.lease((BComponent[])((BComponent[])knobComps.trim()), (int)0);
        }
        for (i = 0; i < knobComps.size(); ++i) {
            try {
                BComponent x = (BComponent)knobComps.get(i);
                Row row = new Row();
                row.direction = 1;
                row.mySlot = knobs[i].getSourceSlotName();
                row.otherPath = x.getSlotPath().toString();
                row.otherSlot = knobs[i].getTargetSlotName();
                row.parent = x;
                BLink[] lnk = x.getLinks();
                for (int j = 0; j < lnk.length; ++j) {
                    BLink link;
                    if (lnk[j].getSourceOrd().get((BObject)this.c) != this.c || !lnk[j].getSourceSlotName().equals(row.mySlot) || !lnk[j].getTargetSlotName().equals(row.otherSlot)) continue;
                    row.link = link = lnk[j];
                    row.enabled = String.valueOf(link.isEnabled());
                    row.type = link.getType().toString();
                    row.prop = link.getPropertyInParent();
                    break;
                }
                this.model.rows.add(row);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.table.sizeColumnsToFit();
        this.table.relayout();
    }

    private BMenu buildMenu() {
        BMenu menu = new BMenu(lex.get("linkSheet"));
        menu.add(null, (Command)this.editLink);
        menu.add(null, (Command)this.deleteLinks);
        menu.add(null, (Command)this.hyperlink);
        return menu;
    }

    public void attached(BWbComponentView view) {
    }

    public void detached(BWbComponentView view) {
    }

    public void handleComponentEvent(BComponentEvent event) {
        switch (event.getId()) {
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                this.refreshModel();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Hyperlink
    extends Command {
        public Hyperlink(BWidget owner) {
            super(owner, lex.getText("linkSheet.goTo"));
        }

        public CommandArtifact doInvoke() {
            int[] rows = BLinkSheet.this.table.getSelection().getRows();
            Row row = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(rows[0]);
            BLinkSheet.this.getWbShell().hyperlink(BOrd.make((String)("station:|" + row.otherPath)));
            return null;
        }

        public BImage getIcon() {
            return goTo;
        }
    }

    class DeleteLinks
    extends Command {
        public DeleteLinks(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.deleteLinks");
        }

        public CommandArtifact doInvoke() throws Exception {
            int i;
            Context tx = Transaction.start((BComponent)BLinkSheet.this.c, null);
            int[] sel = BLinkSheet.this.table.getSelection().getRows();
            Row[] rows = new Row[sel.length];
            int compositeWarningResult = -1;
            for (i = 0; i < rows.length; ++i) {
                rows[i] = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(sel[i]);
                if (compositeWarningResult == -1) {
                    compositeWarningResult = WbUtil.compositeDeletionWarning((BWidget)BLinkSheet.this, (BIPropertyContainer)rows[i].parent, (Slot)rows[i].prop);
                }
                if (compositeWarningResult != 2) continue;
                return null;
            }
            BLinkSheet.this.table.getSelection().deselectAll();
            for (i = 0; i < rows.length; ++i) {
                rows[i].parent.remove(rows[i].prop, tx);
            }
            Transaction.end((BComponent)BLinkSheet.this.c, (Context)tx);
            return null;
        }
    }

    class EditLink
    extends Command {
        public EditLink(BWidget owner) {
            super(owner, Lexicon.make((String)"workbench"), "edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            int index = BLinkSheet.this.table.getSelection().getRow();
            Row row = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(index);
            BLink link = row.link;
            link.getParent().asComponent().lease();
            BObject result = BWbFieldEditor.dialog(this.getOwner(), this.getLabel(), (BObject)link);
            if (result != null) {
                BLinkSheet.this.refreshModel();
            }
            return null;
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            BImage icon;
            TableModel model = this.getTable().getModel();
            this.paintCellBackground(g, cell);
            double x = 2.0;
            double y = (cell.height - 16.0) / 2.0;
            if (cell.column == 1 && (icon = model.getRowIcon(cell.row)) != null) {
                g.drawImage(icon, x, y);
                x += 18.0;
            }
            String s = this.getCellText(cell);
            BFont font = Theme.table().getCellFont();
            switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    x = cell.width - 2.0 - font.width(s);
                    break;
                }
                case 1: {
                    x = (cell.width - font.width(s)) / 2.0;
                }
            }
            g.setFont(font);
            g.drawString(s, x, font.getAscent() + 2.0);
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            Row r = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(row);
            if (BLinkSheet.this.editLink.isEnabled()) {
                BLinkSheet.this.editLink.invoke();
            }
        }

        protected BMenu makePopup(TableSubject subject) {
            return BLinkSheet.this.buildMenu();
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int n = this.getRows().length;
            BLinkSheet.this.editLink.setEnabled(n == 1);
            BLinkSheet.this.deleteLinks.setEnabled(n > 0);
            BLinkSheet.this.hyperlink.setEnabled(n == 1);
        }
    }

    class RowSorter
    implements Comparator {
        private int col = 0;
        private boolean ascending = true;

        public RowSorter(int col, boolean ascending) {
            this.col = col;
            this.ascending = ascending;
        }

        public int compare(Object o1, Object o2) {
            Row b;
            Row a;
            if (this.ascending) {
                a = (Row)o1;
                b = (Row)o2;
            } else {
                a = (Row)o2;
                b = (Row)o1;
            }
            switch (this.col) {
                case 0: {
                    if (a.direction < b.direction) {
                        return -1;
                    }
                    if (a.direction == b.direction) {
                        return 0;
                    }
                    return 1;
                }
                case 1: {
                    return a.mySlot.compareTo(b.mySlot);
                }
                case 2: {
                    return a.otherPath.compareTo(b.otherPath);
                }
                case 3: {
                    return a.otherSlot.compareTo(b.otherSlot);
                }
                case 4: {
                    return a.enabled.compareTo(b.enabled);
                }
                case 5: {
                    return a.type.compareTo(b.type);
                }
            }
            return 0;
        }
    }

    class Row {
        public BLink link;
        public int direction = 0;
        public String mySlot = "";
        public String otherPath = "";
        public String otherSlot = "";
        public String enabled = "";
        public String type = "";
        public Property prop = null;
        public BComponent parent = null;
        public static final int IN = 0;
        public static final int OUT = 1;

        Row() {
        }
    }

    class Model
    extends TableModel {
        ArrayList rows = new ArrayList();

        Model() {
        }

        public int getColumnCount() {
            return cols.length;
        }

        public String getColumnName(int col) {
            return cols[col];
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getSubject(int r) {
            return this.rows.get(r);
        }

        public Object getValueAt(int r, int col) {
            Row row = (Row)this.rows.get(r);
            switch (col) {
                case 0: {
                    return row.mySlot;
                }
                case 2: {
                    return row.otherPath;
                }
                case 3: {
                    return row.otherSlot;
                }
                case 4: {
                    return row.enabled;
                }
                case 5: {
                    return row.type;
                }
            }
            return "";
        }

        public BImage getRowIcon(int r) {
            Row row = (Row)this.rows.get(r);
            return row.direction == 0 ? iconIn : iconOut;
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Row[] temp = this.rows.toArray(new Row[this.rows.size()]);
            Arrays.sort(temp, new RowSorter(col, ascending));
            this.rows.clear();
            for (int i = 0; i < temp.length; ++i) {
                this.rows.add(temp[i]);
            }
        }
    }
}

