/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BOptionDialog;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.SlotBarUtil;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BValueBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

public class BLinkPad
extends BEdgePane {
    public static final Action labelMouseEvent = BLinkPad.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BLinkPad == null ? (class$com$tridium$workbench$util$BLinkPad = BLinkPad.class$("com.tridium.workbench.util.BLinkPad")) : class$com$tridium$workbench$util$BLinkPad));
    private static Context context = new BasicContext();
    private static BImage actionIcon = BImage.make((String)"module://icons/x16/action.png");
    private static BImage topicIcon = BImage.make((String)"module://icons/x16/topic.png");
    private static BImage objectIcon = BImage.make((String)"module://icons/x16/object.png");
    private static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$util$BLinkPad == null ? (class$com$tridium$workbench$util$BLinkPad = BLinkPad.class$("com.tridium.workbench.util.BLinkPad")) : class$com$tridium$workbench$util$BLinkPad));
    private IComponent source;
    private IComponent target;
    private String sourceSlotName;
    private String targetSlotName;
    private SlotModel sourceModel;
    private SlotModel targetModel;
    private BTable sourceTable;
    private BTable targetTable;
    private BLabel status;
    private BLabel sourceLabel;
    private BLabel targetLabel;
    private Command reverse = new Reverse((BWidget)this);
    static /* synthetic */ Class class$com$tridium$workbench$util$BLinkPad;
    static /* synthetic */ Class class$com$tridium$workbench$util$BLinkPad$SlotInfo;

    public void labelMouseEvent(BMouseEvent event) {
        this.invoke(labelMouseEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean openInDialog(BWidget owner, String s, String t) {
        String title = UiLexicon.bajaui().getText("linking.title");
        BOptionDialog dlg = new BOptionDialog(owner, title, (BWidget)this, 3, null, null);
        dlg.getOkButton().setEnabled(false);
        if (s != null) {
            this.selectSourceSlot(s);
        }
        if (t != null) {
            this.selectTargetSlot(t);
        }
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        if (dlg.getResult() == 1) {
            int srow = this.sourceTable.getSelection().getRow();
            int trow = this.targetTable.getSelection().getRow();
            if (srow != -1 && trow != -1) {
                this.sourceSlotName = this.sourceModel.slots[srow].slotName;
                this.targetSlotName = this.targetModel.slots[trow].slotName;
                return true;
            }
        }
        return false;
    }

    private void selectSourceSlot(String slotName) {
        for (int i = 0; i < this.sourceModel.slots.length; ++i) {
            if (!this.sourceModel.slots[i].slotName.equals(slotName)) continue;
            this.sourceTable.getSelection().select(i);
            return;
        }
    }

    private void selectTargetSlot(String slotName) {
        for (int i = 0; i < this.targetModel.slots.length; ++i) {
            if (!this.targetModel.slots[i].slotName.equals(slotName)) continue;
            this.targetTable.getSelection().select(i);
            return;
        }
    }

    public BLinkPad() {
        throw new IllegalStateException();
    }

    public BLinkPad(BComponent[] sources, BComponent[] targets) {
        this.source = sources.length == 1 ? new SingleComponent(sources[0]) : new MultiComponent(sources);
        this.target = targets.length == 1 ? new SingleComponent(targets[0]) : new MultiComponent(targets);
        this.build();
    }

    public void build() {
        String sourceTitle = this.source.getDisplayName() + " [" + UiLexicon.bajaui().getText("linking.source") + "]";
        String targetTitle = this.target.getDisplayName() + " [" + UiLexicon.bajaui().getText("linking.target") + "]";
        this.sourceLabel = new BLabel(sourceTitle, Theme.widget().getBoldText(), BHalign.left);
        this.targetLabel = new BLabel(targetTitle, Theme.widget().getBoldText(), BHalign.left);
        this.sourceLabel.add(null, (BValue)new BValueBinding());
        this.targetLabel.add(null, (BValue)new BValueBinding());
        this.linkTo((BComponent)this.sourceLabel, (Slot)BWidget.mouseEvent, (Slot)labelMouseEvent);
        this.linkTo((BComponent)this.targetLabel, (Slot)BWidget.mouseEvent, (Slot)labelMouseEvent);
        this.sourceModel = new SlotModel(this.source);
        this.targetModel = new SlotModel(this.target);
        this.sourceTable = this.newTable(this.sourceModel);
        this.targetTable = this.newTable(this.targetModel);
        String s = "Link \"" + sourceTitle + "\" -> \"" + targetTitle + "\"";
        this.status = new BLabel(s, BHalign.left);
        BEdgePane a = new BEdgePane();
        a.setTop((BWidget)new BBorderPane((BWidget)this.sourceLabel, 0.0, 0.0, 5.0, 0.0));
        a.setCenter((BWidget)new BBorderPane((BWidget)this.sourceTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BEdgePane b = new BEdgePane();
        b.setTop((BWidget)new BBorderPane((BWidget)this.targetLabel, 0.0, 0.0, 5.0, 0.0));
        b.setCenter((BWidget)new BBorderPane((BWidget)this.targetTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BButton reverseButton = new BButton(this.reverse, false, true);
        reverseButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane vg = new BGridPane();
        vg.add(null, (BValue)reverseButton);
        BEdgePane rb = new BEdgePane();
        rb.setLeft((BWidget)vg);
        rb.setCenter((BWidget)b);
        BSplitPane split = new BSplitPane();
        split.setMoveableDivider(false);
        split.setDividerPosition(47.0);
        split.setDividerWidth(0.0);
        split.setWidget1((BWidget)a);
        split.setWidget2((BWidget)rb);
        this.setCenter((BWidget)split);
        this.setBottom((BWidget)new BBorderPane((BWidget)this.status, 5.0, 0.0, 5.0, 0.0));
    }

    private BTable newTable(SlotModel model) {
        BTable table = new BTable((TableModel)model);
        table.setOptionsButtonVisible(false);
        table.setMultipleSelection(false);
        table.setCellRenderer((TableCellRenderer)new SlotRenderer());
        table.setSelection((TableSelection)new SlotSelection());
        table.setController((TableController)new SlotController());
        table.setHeaderVisible(false);
        return table;
    }

    private BOptionDialog getOptionDialog() {
        BWidget w = this.getParentWidget();
        while (!(w instanceof BDialog)) {
            w = w.getParentWidget();
        }
        return (BOptionDialog)w;
    }

    public void computePreferredSize() {
        this.setPreferredSize(500.0, 380.0);
    }

    private SlotRow[] makeRows(IComponent c, String[] slotNames) {
        ArrayList<SlotRow> result = new ArrayList<SlotRow>(slotNames.length);
        for (int i = 0; i < slotNames.length; ++i) {
            if (!c.isValidSlotRow(slotNames[i])) continue;
            result.add(new SlotRow(slotNames[i], c));
        }
        return result.toArray(new SlotRow[result.size()]);
    }

    private static BImage getIcon(BComponent comp, String slotName) {
        BImage icon;
        BImage bImage;
        Slot slot = comp.getSlot(slotName);
        if (slot.isAction()) {
            bImage = actionIcon;
        }
        if (slot.isTopic()) {
            bImage = topicIcon;
        }
        try {
            BValue val = comp.get((Property)slot);
            icon = BImage.make((BIcon)val.getIcon());
        }
        catch (Exception e) {
            icon = objectIcon;
        }
        return icon;
    }

    private static boolean isValidSlotRow(BComponent comp, String slotName) {
        Slot slot = comp.getSlot(slotName);
        if (Flags.isHidden((BComplex)comp, (Slot)slot)) {
            return false;
        }
        if (slot.isProperty()) {
            BValue v = comp.get(slot.asProperty());
            if (v.isComponent() && !(v instanceof BVector)) {
                return false;
            }
            if (v instanceof BLink) {
                return false;
            }
            return !(v instanceof BWsAnnotation);
        }
        return true;
    }

    private static LinkCheck checkLink(BComponent[] sourceComps, BComponent[] targetComps, String sourceSlotName, String targetSlotName) {
        for (int i = 0; i < targetComps.length; ++i) {
            Slot targetSlot = targetComps[i].getSlot(targetSlotName);
            for (int j = 0; j < sourceComps.length; ++j) {
                Slot sourceSlot = sourceComps[j].getSlot(sourceSlotName);
                LinkCheck chk = targetComps[i].checkLink(sourceComps[j], sourceSlot, targetSlot, context);
                if (!chk.isValid()) {
                    return chk;
                }
                if (j <= 0 || targetSlot.isAction() || targetSlot.isTopic() || !targetSlot.isProperty() || Flags.isFanIn((BComplex)targetComps[i], (Slot)targetSlot)) continue;
                return LinkCheck.makeInvalid((String)lex.getText("linkpad.propNoFanIn"));
            }
        }
        return LinkCheck.makeValid();
    }

    public void doLabelMouseEvent(BMouseEvent event) {
        if (event.getId() == 512) {
            BWidget widget = event.getWidget();
            BComponent[] comps = widget == this.sourceLabel ? this.source.getComponents() : this.target.getComponents();
            double x = event.getX();
            double y = event.getY();
            y = Math.max(widget.getHeight() + 1.0, y + 16.0);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < comps.length; ++i) {
                buff.append(comps[i].toPathString());
                buff.append(" (");
                buff.append(comps[i].getType());
                buff.append(")\n");
                if (i <= 50) continue;
                buff.append("...");
                break;
            }
            UiEnv.get().openBubbleHelp(widget, x, y, buff.toString());
        } else if (event.getId() == 505) {
            UiEnv.get().closeBubbleHelp();
            this.repaint();
        }
    }

    public BComponent[] getSourceArray() {
        return this.source.getComponents();
    }

    public BComponent[] getTargetArray() {
        return this.target.getComponents();
    }

    public String getSourceSlotName() {
        return this.sourceSlotName;
    }

    public String getTargetSlotName() {
        return this.targetSlotName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SlotInfo {
        String slotName;
        boolean isProperty;
        boolean isAction;

        SlotInfo(Slot slot) {
            this.slotName = slot.getName();
            this.isProperty = slot.isProperty();
            this.isAction = slot.isAction();
        }

        boolean isValidMatch(Slot slot) {
            return this.slotName.equals(slot.getName()) && this.isProperty == slot.isProperty() && this.isAction == slot.isAction();
        }
    }

    private static class MultiComponent
    implements IComponent {
        private SlotInfo[] slotInfos;
        private BComponent[] comps;

        MultiComponent(BComponent[] comps) {
            this.comps = comps;
            Array slotInfoArray = new Array(class$com$tridium$workbench$util$BLinkPad$SlotInfo == null ? (class$com$tridium$workbench$util$BLinkPad$SlotInfo = BLinkPad.class$("com.tridium.workbench.util.BLinkPad$SlotInfo")) : class$com$tridium$workbench$util$BLinkPad$SlotInfo);
            for (int i = 0; i < comps.length; ++i) {
                if (i == 0) {
                    Slot[] slots = comps[i].getSlotsArray();
                    for (int j = 0; j < slots.length; ++j) {
                        if (Flags.isHidden((BComplex)comps[i], (Slot)slots[j])) continue;
                        slotInfoArray.add((Object)new SlotInfo(slots[j]));
                    }
                    continue;
                }
                Array a = slotInfoArray.copy();
                ListIterator it = a.iterator();
                while (it.hasNext()) {
                    SlotInfo inf = (SlotInfo)it.next();
                    boolean valid = false;
                    Slot[] slots = comps[i].getSlotsArray();
                    for (int j = 0; j < slots.length; ++j) {
                        if (!inf.isValidMatch(slots[j])) continue;
                        valid = true;
                        break;
                    }
                    if (valid) continue;
                    slotInfoArray.remove((Object)inf);
                }
            }
            this.slotInfos = (SlotInfo[])slotInfoArray.trim();
        }

        public String getName() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.comps[0].getName());
            buff.append(" (");
            buff.append(this.comps.length);
            buff.append(")");
            return buff.toString();
        }

        public String getDisplayName() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.comps[0].getDisplayName(null));
            buff.append(" (");
            buff.append(this.comps.length);
            buff.append(")...");
            return buff.toString();
        }

        public String getDisplayName(Slot slot) {
            return this.comps[0].getDisplayName(this.comps[0].getSlot(slot.getName()), null);
        }

        public LinkCheck checkLink(IComponent source, String sourceSlotName, String targetSlotName) {
            return BLinkPad.checkLink(source.getComponents(), this.comps, sourceSlotName, targetSlotName);
        }

        public Slot getDefaultSlot(String slotName) {
            return this.comps[0].getSlot(slotName);
        }

        public String getDisplayName(String slotName) {
            Slot slot = this.comps[0].getSlot(slotName);
            return this.comps[0].getDisplayName(slot, null);
        }

        public BImage getIcon(String slotName) {
            return BLinkPad.getIcon(this.comps[0], slotName);
        }

        public String[] getSlotNamesArray() {
            String[] slotStrs = new String[this.slotInfos.length];
            for (int i = 0; i < this.slotInfos.length; ++i) {
                slotStrs[i] = this.slotInfos[i].slotName;
            }
            return slotStrs;
        }

        public boolean isValidSlotRow(String slotName) {
            for (int i = 0; i < this.comps.length; ++i) {
                if (BLinkPad.isValidSlotRow(this.comps[i], slotName)) continue;
                return false;
            }
            return true;
        }

        public BComponent[] getComponents() {
            return this.comps;
        }
    }

    private static class SingleComponent
    implements IComponent {
        BComponent comp;

        SingleComponent(BComponent comp) {
            this.comp = comp;
        }

        public String getName() {
            return this.comp.getName();
        }

        public String getDisplayName() {
            return this.comp.getDisplayName(null);
        }

        public String getDisplayName(String slotName) {
            Slot slot = this.comp.getSlot(slotName);
            return this.comp.getDisplayName(slot, null);
        }

        public String[] getSlotNamesArray() {
            Slot[] slots = this.comp.getSlotsArray();
            String[] slotNames = new String[slots.length];
            for (int i = 0; i < slotNames.length; ++i) {
                slotNames[i] = slots[i].getName();
            }
            return slotNames;
        }

        public LinkCheck checkLink(IComponent source, String sourceSlotName, String targetSlotName) {
            return BLinkPad.checkLink(source.getComponents(), this.getComponents(), sourceSlotName, targetSlotName);
        }

        public BComponent[] getComponents() {
            return new BComponent[]{this.comp};
        }

        public boolean isValidSlotRow(String slotName) {
            return BLinkPad.isValidSlotRow(this.comp, slotName);
        }

        public BImage getIcon(String slotName) {
            return BLinkPad.getIcon(this.comp, slotName);
        }

        public Slot getDefaultSlot(String slotName) {
            return this.comp.getSlot(slotName);
        }
    }

    private static interface IComponent {
        public String getName();

        public String getDisplayName();

        public String getDisplayName(String var1);

        public String[] getSlotNamesArray();

        public LinkCheck checkLink(IComponent var1, String var2, String var3);

        public BComponent[] getComponents();

        public boolean isValidSlotRow(String var1);

        public BImage getIcon(String var1);

        public Slot getDefaultSlot(String var1);
    }

    class Reverse
    extends Command {
        Reverse(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "linking.reverse");
        }

        public CommandArtifact doInvoke() {
            IComponent tempComp = BLinkPad.this.source;
            BLinkPad.this.source = BLinkPad.this.target;
            BLinkPad.this.target = tempComp;
            int srow = BLinkPad.this.sourceTable.getSelection().getRow();
            int trow = BLinkPad.this.targetTable.getSelection().getRow();
            BLinkPad.this.build();
            if (srow != -1) {
                BLinkPad.this.targetTable.getSelection().select(srow);
            }
            if (trow != -1) {
                BLinkPad.this.sourceTable.getSelection().select(trow);
            }
            return null;
        }
    }

    class SlotController
    extends TableController {
        SlotController() {
        }

        public void focusGained(BFocusEvent event) {
        }

        protected void cellPressed(BMouseEvent event, int row, int col) {
            if (event.getClickCount() == 2) {
                BButton b = BLinkPad.this.getOptionDialog().getOkButton();
                if (b.isEnabled()) {
                    b.invokeAction();
                }
                return;
            }
            SlotModel model = (SlotModel)this.getModel();
            if (this.getSelection().isSelected(row)) {
                this.getSelection().deselect(row);
            } else if (model.slots[row].link.isValid()) {
                this.getSelection().deselectAll();
                this.getSelection().select(row);
            }
            this.cellEntered(event, row, col);
        }

        protected void cellEntered(BMouseEvent event, int row, int column) {
            String ts;
            int srow = BLinkPad.this.sourceModel.getSelection().getRow();
            int trow = BLinkPad.this.targetModel.getSelection().getRow();
            String sn = BLinkPad.this.source.getName();
            String sc = row < ((BLinkPad)BLinkPad.this).sourceModel.slots.length ? ((BLinkPad)BLinkPad.this).sourceModel.slots[row].slotName : "";
            String ss = srow == -1 ? "" : ((BLinkPad)BLinkPad.this).sourceModel.slots[srow].slotName;
            String tn = BLinkPad.this.target.getName();
            String tc = row < ((BLinkPad)BLinkPad.this).targetModel.slots.length ? ((BLinkPad)BLinkPad.this).targetModel.slots[row].slotName : "";
            String string = ts = trow == -1 ? "" : ((BLinkPad)BLinkPad.this).targetModel.slots[trow].slotName;
            if (srow != -1 && trow != -1) {
                BLinkPad.this.status.setText("Link " + sn + "." + ss + " -> " + tn + "." + ts);
            } else if (srow != -1) {
                String s = "Link " + sn + "." + ss + " -> ";
                s = s + (this.getModel() == BLinkPad.this.sourceModel ? "?" : (((BLinkPad)BLinkPad.this).targetModel.slots[row].link.isValid() ? tn + "." + tc : "Invalid: " + ((BLinkPad)BLinkPad.this).targetModel.slots[row].link.getInvalidReason()));
                BLinkPad.this.status.setText(s);
            } else if (trow != -1) {
                String s = "Link ";
                s = s + (this.getModel() == BLinkPad.this.targetModel ? "?" : (((BLinkPad)BLinkPad.this).sourceModel.slots[row].link.isValid() ? sn + "." + sc : "Invalid: " + ((BLinkPad)BLinkPad.this).sourceModel.slots[row].link.getInvalidReason()));
                s = s + " -> " + tn + "." + ts;
                BLinkPad.this.status.setText(s);
            } else {
                String s = this.getModel() == BLinkPad.this.sourceModel ? "Link " + sn + "." + sc + " -> ?" : "Link ? -> " + tn + "." + tc;
                BLinkPad.this.status.setText(s);
            }
        }

        protected void cellExited(BMouseEvent event, int row, int column) {
            String ts;
            int srow = BLinkPad.this.sourceModel.getSelection().getRow();
            int trow = BLinkPad.this.targetModel.getSelection().getRow();
            String sn = BLinkPad.this.source.getName();
            String ss = srow == -1 ? "" : ((BLinkPad)BLinkPad.this).sourceModel.slots[srow].slotName;
            String tn = BLinkPad.this.target.getName();
            String string = ts = trow == -1 ? "" : ((BLinkPad)BLinkPad.this).targetModel.slots[trow].slotName;
            if (srow != -1 && trow != -1) {
                BLinkPad.this.status.setText("Link " + sn + "." + ss + " -> " + tn + "." + ts);
            } else if (srow != -1) {
                BLinkPad.this.status.setText("Link " + sn + "." + ss + " -> ?");
            } else if (trow != -1) {
                BLinkPad.this.status.setText("Link ? -> " + tn + "." + ts);
            } else {
                BLinkPad.this.status.setText("");
            }
        }
    }

    class SlotSelection
    extends TableSelection {
        SlotSelection() {
        }

        public void updateTable() {
            super.updateTable();
            int row = this.getRow();
            if (this.getModel() == BLinkPad.this.sourceModel) {
                if (row == -1) {
                    BLinkPad.this.targetModel.resetState();
                } else {
                    IComponent source = ((BLinkPad)BLinkPad.this).sourceModel.component;
                    String sourceSlotName = ((BLinkPad)BLinkPad.this).sourceModel.slots[row].slotName;
                    BLinkPad.this.targetModel.updateStateFrom(((BLinkPad)BLinkPad.this).sourceModel.component, sourceSlotName);
                }
                BLinkPad.this.targetTable.repaint();
            } else {
                if (row == -1) {
                    BLinkPad.this.sourceModel.resetState();
                } else {
                    IComponent target = ((BLinkPad)BLinkPad.this).targetModel.component;
                    String targetSlotName = ((BLinkPad)BLinkPad.this).targetModel.slots[row].slotName;
                    BLinkPad.this.sourceModel.updateStateTo(((BLinkPad)BLinkPad.this).targetModel.component, targetSlotName);
                }
                BLinkPad.this.sourceTable.repaint();
            }
            boolean b = BLinkPad.this.sourceModel.getSelection().getRow() != -1 && BLinkPad.this.targetModel.getSelection().getRow() != -1;
            BLinkPad.this.getOptionDialog().getOkButton().setEnabled(b);
        }
    }

    class SlotRenderer
    extends TableCellRenderer {
        SlotRenderer() {
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            return ((SlotRow)cell.value).displayName;
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            SlotRow slot = (SlotRow)cell.value;
            return slot.enabled ? BColor.black.toBrush() : BColor.gray.toBrush();
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return null;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            SlotRow slot = (SlotRow)cell.value;
            if (slot.enabled) {
                double wixelWidth = cell.width / 12.0 + 1.0;
                g.drawImage(SlotBarUtil.getSlotBar((BWidget)this.getTable(), slot.defaultSlot, (int)wixelWidth), 0.0, 0.0);
            }
            super.paintCell(g, cell);
            if (this.getSelection().isSelected(cell.row)) {
                g.setBrush(BColor.red);
                g.strokeRect(0.0, 0.0, cell.width - 3.0, cell.height - 2.0);
            }
        }
    }

    class SlotRow {
        Slot defaultSlot;
        String slotName;
        String displayName;
        BImage icon;
        boolean enabled = true;
        LinkCheck link = LinkCheck.makeValid();

        public SlotRow(String slotName, IComponent parent) {
            this.slotName = slotName;
            this.displayName = parent.getDisplayName(slotName);
            this.icon = parent.getIcon(slotName);
            this.defaultSlot = parent.getDefaultSlot(slotName);
        }
    }

    class SlotModel
    extends TableModel {
        IComponent component;
        SlotRow[] slots;

        public SlotModel(IComponent component) {
            this.component = component;
            this.slots = BLinkPad.this.makeRows(component, component.getSlotNamesArray());
        }

        public int getRowCount() {
            return this.slots.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "";
        }

        public Object getValueAt(int row, int col) {
            return this.slots[row];
        }

        public Object getSubject(int row) {
            return this.slots[row];
        }

        public BImage getRowIcon(int row) {
            BImage icon = this.slots[row].icon;
            return this.slots[row].enabled ? icon : icon.getDisabledImage();
        }

        public void updateStateFrom(IComponent source, String sourceSlotName) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].link = this.component.checkLink(source, sourceSlotName, this.slots[i].slotName);
                this.slots[i].enabled = this.slots[i].link.isValid();
                if (this.slots[i].link.isValid() || !this.getSelection().isSelected(i)) continue;
                this.getSelection().deselect(i);
            }
        }

        public void updateStateTo(IComponent source, String sourceSlotName) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].link = source.checkLink(this.component, this.slots[i].slotName, sourceSlotName);
                this.slots[i].enabled = this.slots[i].link.isValid();
                if (this.slots[i].link.isValid() || !this.getSelection().isSelected(i)) continue;
                this.getSelection().deselect(i);
            }
        }

        public void resetState() {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].enabled = true;
                this.slots[i].link = LinkCheck.makeValid();
            }
        }
    }
}

