/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.net.BHttpObject;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.file.BExportDialog;
import java.io.File;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.types.application.BApplicationFile;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BGenericAppFileView
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BGenericAppFileView == null ? (class$com$tridium$workbench$util$BGenericAppFileView = BGenericAppFileView.class$("com.tridium.workbench.util.BGenericAppFileView")) : class$com$tridium$workbench$util$BGenericAppFileView));
    static Lexicon lex = Lexicon.make((String)"workbench");
    static final String note1 = lex.getText("genericAppFileView.note1");
    static final String note2 = lex.getText("genericAppFileView.note2");
    static final String launch = lex.getText("genericAppFileView.launch");
    static /* synthetic */ Class class$com$tridium$workbench$util$BGenericAppFileView;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        if (value instanceof BApplicationFile) {
            this.doLoadApplicationFile((BApplicationFile)value);
        } else {
            this.doLoadHttpObject((BHttpObject)value);
        }
    }

    void doLoadApplicationFile(BApplicationFile file) {
        BImage icon = BImage.make((BIcon)file.getIcon());
        String name = file.getFileName();
        boolean local = file.getStore() instanceof BLocalFileStore;
        String note = note1;
        if (local) {
            note = note + " " + note2;
        }
        BLabel label = new BLabel(icon, name);
        label.setFont(Theme.widget().getBoldText());
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)label);
        grid.add(null, (BValue)new BLabel(note));
        BGridPane content = new BGridPane(1);
        content.setColumnAlign(BHalign.center);
        content.add(null, (BValue)new BBorderPane((BWidget)grid, 0.0, 0.0, 10.0, 0.0));
        if (local) {
            content.add(null, (BValue)new BButton((Command)new LaunchFile(this, (BIFile)file)));
        }
        this.setContent((BWidget)content);
    }

    void doLoadHttpObject(BHttpObject http) {
        BImage icon = BImage.make((String)"module://icons/x16/files/html.png");
        String name = http.getUri();
        String note = note1 + " " + note2;
        BLabel label = new BLabel(icon, name);
        label.setFont(Theme.widget().getBoldText());
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)label);
        grid.add(null, (BValue)new BLabel(note));
        BGridPane content = new BGridPane(1);
        content.setColumnAlign(BHalign.center);
        content.add(null, (BValue)new BBorderPane((BWidget)grid, 0.0, 0.0, 10.0, 0.0));
        content.add(null, (BValue)new BButton((Command)new LaunchUri(this, http.getUri())));
        this.setContent((BWidget)content);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LaunchUri
    extends Command {
        String uri;

        public LaunchUri(BWidget owner, String uri) {
            super(owner, launch);
            this.uri = uri;
        }

        public CommandArtifact doInvoke() throws Exception {
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                Runtime.getRuntime().exec("gnome-open " + this.uri);
            } else {
                Runtime.getRuntime().exec("cmd.exe /c start " + this.uri);
            }
            return null;
        }
    }

    class LaunchFile
    extends Command {
        BIFile file;

        public LaunchFile(BWidget owner, BIFile file) {
            super(owner, launch);
            this.file = file;
        }

        public CommandArtifact doInvoke() throws Exception {
            File local = ((BLocalFileStore)this.file.getStore()).getLocalFile();
            BExportDialog.launchExternal(local);
            return null;
        }
    }
}

