/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BFindPane;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.file.BTextFileEditor;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BMruOptions;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XInputStreamReader;

public class BFileSearch
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BFileSearch == null ? (class$com$tridium$workbench$util$BFileSearch = BFileSearch.class$("com.tridium.workbench.util.BFileSearch")) : class$com$tridium$workbench$util$BFileSearch));
    static BImage findIcon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static BFont bold = Theme.widget().getBoldText();
    static boolean lastFindText = true;
    static boolean lastSubFolders = true;
    static boolean lastMakeBackup = false;
    static String FILE_PATTERN_DEFAULT = "*.java *.xml *.txt *.html *.properties *.lexicon";
    static String DIR_DEFAULT = Sys.getBajaHome().toString();
    boolean isReplace;
    BCheckBox findText;
    BFindPane findPane;
    BMruTextDropDown filePattern;
    BMruTextDropDown dir;
    BCheckBox subFolders;
    BButton ok;
    BButton cancel;
    Criteria criteria;
    static /* synthetic */ Class class$com$tridium$workbench$util$BFileSearch;

    public Type getType() {
        return TYPE;
    }

    public static void findFiles(BNiagaraWbShell shell, String dir) {
        BMruOptions.make((String)"findFilesDir").save(dir);
        BFileSearch.findFiles(shell);
    }

    public static void findFiles(BNiagaraWbShell shell) {
        BFileSearch.doIt(shell, false);
    }

    public static void replaceInFiles(BNiagaraWbShell shell) {
        BFileSearch.doIt(shell, true);
    }

    private static void doIt(BNiagaraWbShell shell, boolean replace) {
        String title = replace ? BFileSearch.lex().getText("fileSearch.replace.title") : BFileSearch.lex().getText("fileSearch.find.title");
        BFileSearch d = new BFileSearch((BWidget)shell, title, replace);
        d.setBoundsCenteredOnOwner();
        d.open();
        if (d.criteria == null) {
            return;
        }
        if (shell != null) {
            shell.openConsole();
        }
        Worker worker = new Worker(shell, d.criteria);
        BProgressDialog.open((BWidget)shell, (String)title, (BProgressDialog.Worker)worker, (BImage)findIcon);
        if (replace) {
            BFileSearch.doReplace(shell, worker);
        }
    }

    public BFileSearch() {
        throw new IllegalStateException();
    }

    public BFileSearch(BWidget owner, String title, boolean isReplace) {
        super(owner, title, true);
        this.isReplace = isReplace;
        BGridPane pane = new BGridPane(1);
        pane.setHalign(BHalign.left);
        BWidget textPane = this.makeTextPane();
        BWidget filePane = this.makeFilePane();
        BWidget buttonsPane = this.makeButtonsPane();
        BEdgePane panes = new BEdgePane();
        panes.setTop((BWidget)new BBorderPane(textPane, 8.0, 8.0, 8.0, 8.0));
        panes.setBottom((BWidget)new BBorderPane(filePane, 8.0, 8.0, 8.0, 8.0));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(findIcon, title));
        edge.setCenter((BWidget)new BBorderPane((BWidget)panes));
        edge.setBottom((BWidget)new BBorderPane(buttonsPane, 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)edge);
        this.setDefaultButton(this.ok);
    }

    BWidget makeTextPane() {
        BWbShell shell;
        BWbView view;
        BWidget owner;
        BGridPane pane = new BGridPane(1);
        pane.setColumnAlign(BHalign.fill);
        pane.setStretchColumn(0);
        boolean isFindText = true;
        if (!this.isReplace) {
            this.findText = new BCheckBox((ToggleCommand)new FindTextToggle((BWidget)this));
            isFindText = this.findText.isSelected();
            BEdgePane findTextPane = new BEdgePane();
            findTextPane.setLeft((BWidget)this.findText);
            pane.add(null, (BValue)findTextPane);
        }
        if ((owner = this.getOwner()) instanceof BWbShell && (view = (shell = (BWbShell)owner).getActiveView()) instanceof BTextFileEditor) {
            owner = ((BTextFileEditor)view).text;
        }
        this.findPane = new BFindPane(owner, this.isReplace, true);
        this.findPane.setEnabled(isFindText);
        pane.add(null, (BValue)this.findPane);
        String title = BFileSearch.lex().getText("fileSearch.text." + (this.isReplace ? "replace" : "find"));
        return new BBorderPane((BWidget)pane, title);
    }

    BWidget makeFilePane() {
        String title = BFileSearch.lex().getText("fileSearch.file." + (this.isReplace ? "replace" : "find"));
        this.filePattern = new BMruTextDropDown("findFiles", 50);
        if (this.filePattern.getText().length() == 0) {
            this.filePattern.setText(FILE_PATTERN_DEFAULT);
        }
        this.dir = new BMruTextDropDown("findFilesDir", 50);
        if (this.dir.getText().length() == 0) {
            this.dir.setText(DIR_DEFAULT);
        }
        BButton browse = new BButton((Command)new DirBrowse((BWidget)this), false, true);
        browse.setButtonStyle(BButtonStyle.toolBar);
        this.subFolders = new BCheckBox(BFileSearch.lex().getText("fileSearch.subFolders"), lastSubFolders);
        BGridPane pane = new BGridPane(2);
        pane.setHalign(BHalign.left);
        pane.setColumnAlign(BHalign.fill);
        pane.setStretchColumn(0);
        pane.add(null, (BValue)new BLabel(title, BHalign.left));
        pane.add(null, (BValue)new BLabel());
        pane.add(null, (BValue)this.filePattern);
        pane.add(null, (BValue)new BLabel());
        pane.add(null, (BValue)new BLabel(BFileSearch.lex().getText("fileSearch.folder"), BHalign.left));
        pane.add(null, (BValue)new BLabel());
        pane.add(null, (BValue)this.dir);
        pane.add(null, (BValue)browse);
        pane.add(null, (BValue)this.subFolders);
        pane.add(null, (BValue)new BLabel());
        return new BBorderPane((BWidget)pane, title);
    }

    BWidget makeButtonsPane() {
        BGridPane pane = new BGridPane(2);
        pane.setColumnAlign(BHalign.fill);
        pane.setUniformColumnWidth(true);
        this.ok = new BButton((Command)new ReflectCommand((BWidget)this, BFileSearch.lex().getText("dialog.ok"), "ok"));
        this.cancel = new BButton((Command)new ReflectCommand((BWidget)this, BFileSearch.lex().getText("dialog.cancel"), "cancel"));
        pane.add(null, (BValue)this.ok);
        pane.add(null, (BValue)this.cancel);
        return pane;
    }

    public Criteria save() {
        Criteria criteria = new Criteria();
        criteria.isReplace = this.isReplace;
        boolean bl = criteria.isFindText = this.isReplace ? true : this.findText.isSelected();
        if (criteria.isFindText) {
            criteria.textPattern = this.findPane.save();
            FindPattern.setCurrent((FindPattern)criteria.textPattern);
            if (this.isReplace) {
                criteria.replace = this.findPane.getReplaceWith();
            }
        }
        String files = this.filePattern.getTextAndSave();
        criteria.filePatterns = PatternFilter.parseList((String)files);
        criteria.subFolders = lastSubFolders = this.subFolders.isSelected();
        criteria.root = this.saveDirectory(true);
        if (criteria.root == null) {
            BDialog.error((BWidget)this, (Object)BFileSearch.lex().getText("fileSearch.folderNotFound", new Object[]{this.dir.getText()}));
            return null;
        }
        return criteria;
    }

    public File saveDirectory(boolean saveMru) {
        String d;
        File file = null;
        String string = d = saveMru ? this.dir.getTextAndSave() : this.dir.getText();
        if (d.startsWith("file:")) {
            try {
                file = BFileSystem.INSTANCE.pathToLocalFile(new FilePath(d.substring("file:".length())));
            }
            catch (Exception e) {
                return null;
            }
        } else {
            file = new File(d);
        }
        if (file != null && file.exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    public void ok() {
        this.criteria = this.save();
        if (this.criteria != null) {
            this.close();
        }
    }

    public void cancel() {
        this.close();
    }

    public void windowClosing(BWindowEvent event) {
        this.cancel();
    }

    static void scan(Worker worker, File dir) throws Exception {
        BFileSearch.updateScanProgress(worker);
        Criteria criteria = worker.criteria;
        File[] kids = dir.listFiles();
        if (kids == null) {
            kids = new File[]{};
        }
        for (int i = 0; worker.isAlive && i < kids.length; ++i) {
            BFileSearch.updateScanProgress(worker);
            File kid = kids[i];
            ++worker.totalFiles;
            if (kid.isDirectory()) {
                if (kid.getName().equals("libJar") || !criteria.subFolders) continue;
                BFileSearch.scan(worker, kid);
                continue;
            }
            if (!criteria.include(kid)) continue;
            if (!criteria.isFindText) {
                worker.found(kid, 1, 1, null);
            }
            worker.files.add(kid);
        }
    }

    static void updateScanProgress(Worker worker) {
        int total = worker.totalFiles;
        int found = worker.files.size();
        if (total - worker.lastScanUpdate >= 10) {
            worker.lastScanUpdate = total;
            Object[] args = new Object[]{String.valueOf(found), String.valueOf(total)};
            worker.updateProgress(0, BFileSearch.lex().getText("fileSearch.scanningFiles", args));
        }
    }

    static void search(Worker worker, File file) throws Exception {
        BFileSearch.readBuffer(worker, file);
        int lineNum = 0;
        int len = worker.len;
        char[] buf = worker.buf;
        int start = 0;
        int end = 0;
        for (int i = 0; i < len; ++i) {
            char c = buf[i];
            boolean dosNewline = false;
            if (c != '\r' && c != '\n') continue;
            if (c == '\r' && i + 1 < len && buf[i + 1] == '\n') {
                dosNewline = true;
            }
            end = ++i;
            BFileSearch.process(worker, file, ++lineNum, start, end);
            start = end + 1;
        }
    }

    static void process(Worker worker, File file, int lineNum, int start, int end) throws Exception {
        int col = 0;
        int len = end - start;
        FindPattern pattern = worker.criteria.textPattern;
        char[] buf = worker.buf;
        try {
            int x;
            while ((x = pattern.findNext(buf, start + col, len)) >= 0) {
                col = x - start + 1;
                worker.found(file, lineNum, col, new String(buf, start, end - start).trim());
                len = end - start - col;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + file + ":" + lineNum);
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readBuffer(Worker worker, File f) throws Exception {
        BufferedReader in = new BufferedReader((Reader)new XInputStreamReader((InputStream)new FileInputStream(f)));
        try {
            int c;
            worker.len = (int)f.length();
            if (worker.buf.length < worker.len) {
                worker.buf = new char[worker.len];
            }
            int n = 0;
            while ((c = in.read()) >= 0) {
                worker.buf[n++] = (char)c;
            }
            worker.len = n;
        }
        catch (IOException e) {
            System.out.println("WARNING: Invalid file: " + f);
            System.out.println("  " + e);
        }
        finally {
            in.close();
        }
    }

    static void doReplace(BNiagaraWbShell shell, Worker worker) {
        HashMap found = worker.found;
        Object[] files = found.keySet().toArray(new String[found.size()]);
        SortUtil.sort((Object[])files);
        if (files.length == 0) {
            BDialog.info((BWidget)shell, (Object)BFileSearch.lex().getText("fileSearch.noFilesFound"));
            return;
        }
        BCheckList list = new BCheckList();
        for (int i = 0; i < files.length; ++i) {
            list.addItem((Object)((String)files[i] + " (" + found.get(files[i]) + ")"));
        }
        BCheckBox backupBox = new BCheckBox(BFileSearch.lex().getText("fileSearch.makeBackup"), lastMakeBackup);
        BButton a = new BButton((Command)new SelectAll((BWidget)list));
        BButton b = new BButton((Command)new DeselectAll((BWidget)list));
        a.setButtonStyle(BButtonStyle.toolBar);
        b.setButtonStyle(BButtonStyle.toolBar);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)a);
        grid.add(null, (BValue)b);
        BEdgePane bottom = new BEdgePane();
        bottom.setLeft((BWidget)backupBox);
        bottom.setRight((BWidget)grid);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)new BBorderPane((BWidget)list, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        edge.setBottom((BWidget)new BBorderPane((BWidget)bottom, 10.0, 0.0, 0.0, 0.0));
        BConstrainedPane pane = new BConstrainedPane((BWidget)edge);
        pane.setMinWidth(400.0);
        pane.setMaxHeight(400.0);
        String title = BFileSearch.lex().getText("fileSearch.file.replace");
        int r = BDialog.open((BWidget)shell, (String)title, (Object)new BBorderPane((BWidget)pane, 10.0, 10.0, 10.0, 10.0), (int)3);
        if (r != 1) {
            return;
        }
        boolean backup = lastMakeBackup = backupBox.isSelected();
        for (int i = 0; i < files.length; ++i) {
            if (!list.getSelection().isSelected(i)) continue;
            File file = new File((String)files[i]);
            try {
                BFileSearch.replace(worker, file, backup);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                BDialog.error((BWidget)shell, (String)"Error", (Object)"Cannot replace", (Throwable)e);
                break;
            }
        }
    }

    static void replace(Worker worker, File file, boolean backup) throws Exception {
        Criteria c = worker.criteria;
        System.out.println("Replace " + c.textPattern.string + " -> " + c.replace + " " + file + "...");
        BFileSearch.readBuffer(worker, file);
        String newText = c.textPattern.replace(worker.buf, 0, worker.len, c.replace);
        if (backup) {
            FileUtil.renameToBackup((File)file);
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.print(newText);
        out.close();
    }

    static UiLexicon lex() {
        return UiLexicon.bajaui();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DeselectAll
    extends Command {
        public DeselectAll(BWidget owner) {
            super(owner, BFileSearch.lex().getText("fileSearch.deselectAll"));
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/deselectAll.png");
        }

        public CommandArtifact doInvoke() {
            BList list = (BList)this.getOwner();
            list.getSelection().deselectAll();
            return null;
        }
    }

    static class SelectAll
    extends Command {
        public SelectAll(BWidget owner) {
            super(owner, BFileSearch.lex().getText("fileSearch.selectAll"));
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/selectAll.png");
        }

        public CommandArtifact doInvoke() {
            BList list = (BList)this.getOwner();
            list.getSelection().selectAll();
            return null;
        }
    }

    static class Count {
        int count = 1;

        Count() {
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }

    static class Worker
    extends BProgressDialog.Worker {
        BNiagaraWbShell shell;
        Criteria criteria;
        int totalFiles;
        ArrayList files = new ArrayList();
        HashMap found = new HashMap();
        int lastScanUpdate = -1000;
        int count;
        char[] buf = new char[1024];
        int len;
        boolean isAlive = true;

        Worker(BNiagaraWbShell shell, Criteria criteria) {
            this.shell = shell;
            this.criteria = criteria;
        }

        public void doRun() throws Exception {
            BFileSearch.scan(this, this.criteria.root);
            if (this.criteria.isFindText) {
                this.getDialog().getProgressBar().setMax((double)this.files.size());
                for (int i = 0; this.isAlive && i < this.files.size(); ++i) {
                    File file = (File)this.files.get(i);
                    this.updateProgress(i, i + " of " + this.files.size() + ": " + file.getName());
                    BFileSearch.search(this, file);
                }
            }
            this.shell.showStatus("Found " + this.count);
        }

        public void doCancel() {
            this.isAlive = false;
        }

        public void found(File file, int line, int col, String text) {
            ++this.count;
            String filePath = file.toString();
            Count fileCount = (Count)this.found.get(filePath);
            if (fileCount != null) {
                ++fileCount.count;
            } else {
                this.found.put(filePath, new Count());
            }
            StringBuffer s = new StringBuffer();
            s.append(filePath).append(":").append(line).append(":").append(col);
            if (this.criteria.isFindText) {
                int endCol = col + this.criteria.textPattern.string.length();
                s.append(":").append(line).append(":").append(endCol).append(": ").append(text);
            } else {
                s.append(":1:1: ");
            }
            this.shell.getConsole().appendLine(s.toString());
            this.shell.repaint();
        }
    }

    public static class Criteria {
        boolean isReplace;
        public File root;
        public boolean subFolders;
        public boolean isFindText;
        public FindPattern textPattern;
        public String replace;
        public PatternFilter[] filePatterns;

        public boolean include(File file) {
            for (int i = 0; i < this.filePatterns.length; ++i) {
                if (!this.filePatterns[i].accept(file.getName())) continue;
                return true;
            }
            return false;
        }
    }

    class FindTextToggle
    extends ToggleCommand {
        FindTextToggle(BWidget owner) {
            super(owner, BFileSearch.lex().getText("fileSearch.findText"));
            this.setSelected(lastFindText);
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            lastFindText = sel;
            if (BFileSearch.this.findPane != null) {
                BFileSearch.this.findPane.setEnabled(BFileSearch.this.findText.isSelected());
            }
        }
    }

    class DirBrowse
    extends Command {
        DirBrowse(BWidget owner) {
            super(owner, BFileSearch.lex().module, "fileSearch.dirBrowse");
        }

        public CommandArtifact doInvoke() {
            BOrd result;
            BDirectoryChooser chooser = BDirectoryChooser.make((BWidget)this.getOwner());
            File cur = BFileSearch.this.saveDirectory(false);
            if (cur != null) {
                BIFile bdir = (BIFile)BFileSystem.INSTANCE.localFileToOrd(cur).get();
                chooser.setCurrentDirectory(bdir.getNavOrd());
            }
            if ((result = chooser.show()) == null) {
                return null;
            }
            BIFile bfile = (BIFile)result.resolve().get();
            File file = ((BLocalFileStore)bfile.getStore()).getLocalFile();
            BFileSearch.this.dir.setText(file.toString());
            return null;
        }
    }
}

