/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.workbench.ord.BDirectoryOrdChooser;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.BFileIndexerOptions;
import com.tridium.workbench.util.FileFinder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.PatternFilter;

public class BFileIndexer
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BFileIndexer == null ? (class$com$tridium$workbench$util$BFileIndexer = BFileIndexer.class$("com.tridium.workbench.util.BFileIndexer")) : class$com$tridium$workbench$util$BFileIndexer));
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$util$BFileIndexer == null ? (class$com$tridium$workbench$util$BFileIndexer = BFileIndexer.class$("com.tridium.workbench.util.BFileIndexer")) : class$com$tridium$workbench$util$BFileIndexer));
    static BImage buildIcon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static UiLexicon lex = new UiLexicon(class$com$tridium$workbench$util$BFileIndexer == null ? (class$com$tridium$workbench$util$BFileIndexer = BFileIndexer.class$("com.tridium.workbench.util.BFileIndexer")) : class$com$tridium$workbench$util$BFileIndexer);
    static String FILE_PATTERN_DEFAULT = "*.java *.xml *.txt *.html *.properties *.lexicon";
    static String IGNORE_FOLDERS_DEFAULT = "libJar";
    BFileIndexerOptions options;
    BList folderList = new BList();
    BMruTextDropDown filePattern;
    BButton ok;
    BButton cancel;
    boolean cancelled = true;
    static /* synthetic */ Class class$com$tridium$workbench$util$BFileIndexer;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;

    public Type getType() {
        return TYPE;
    }

    public static void index(BNiagaraWbShell shell) {
        String title = lex.getText("buildFileIndex.title");
        BFileIndexer d = new BFileIndexer((BWidget)shell, title);
        d.setBoundsCenteredOnOwner();
        d.open();
        if (d.cancelled) {
            return;
        }
        PatternFilter[] filePatterns = PatternFilter.parseList((String)d.filePattern.getTextAndSave());
        File[] directories = new File[d.folderList.getItemCount()];
        for (int i = 0; i < d.folderList.getItemCount(); ++i) {
            BOrd ord = (BOrd)d.folderList.getItem(i);
            BDirectory dir = (BDirectory)ord.resolve().get();
            directories[i] = BFileSystem.INSTANCE.pathToLocalFile(dir.getFilePath());
        }
        Worker worker = new Worker(filePatterns, directories);
        BProgressDialog.open((BWidget)shell, (String)title, (BProgressDialog.Worker)worker, (BImage)buildIcon);
    }

    public BFileIndexer() {
        throw new IllegalStateException();
    }

    public BFileIndexer(BWidget owner, String title) {
        super(owner, title, true);
        this.options = BFileIndexerOptions.make();
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(buildIcon, title));
        edge.setCenter((BWidget)new BBorderPane(this.makePane(), 8.0, 8.0, 8.0, 8.0));
        edge.setBottom((BWidget)new BBorderPane(this.makeButtonsPane(), 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)edge);
        this.setDefaultButton(this.ok);
    }

    BWidget makePane() {
        this.filePattern = new BMruTextDropDown("filesToIndex", 50);
        if (this.filePattern.getText().length() == 0) {
            this.filePattern.setText(FILE_PATTERN_DEFAULT);
        }
        BGridPane pane = new BGridPane(1);
        pane.setHalign(BHalign.left);
        pane.setColumnAlign(BHalign.fill);
        pane.setStretchColumn(0);
        pane.add(null, (BValue)new BLabel(lex.getText("buildFileIndex.filesToIndex"), BHalign.left));
        pane.add(null, (BValue)this.filePattern);
        pane.add(null, (BValue)new BLabel(lex.getText("buildFileIndex.startingFolders"), BHalign.left));
        pane.add(null, (BValue)this.makeStartingFolders());
        return pane;
    }

    BWidget makeButtonsPane() {
        BGridPane pane = new BGridPane(2);
        pane.setColumnAlign(BHalign.fill);
        pane.setUniformColumnWidth(true);
        this.ok = new BButton((Command)new ReflectCommand((BWidget)this, UiLexicon.bajaui().getText("dialog.ok"), "ok"));
        this.cancel = new BButton((Command)new ReflectCommand((BWidget)this, UiLexicon.bajaui().getText("dialog.cancel"), "cancel"));
        pane.add(null, (BValue)this.ok);
        pane.add(null, (BValue)this.cancel);
        return pane;
    }

    BWidget makeStartingFolders() {
        BOrd[] folders = (BOrd[])this.options.getChildren(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = BFileIndexer.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
        for (int i = 0; i < folders.length; ++i) {
            this.folderList.addItem((Object)folders[i]);
        }
        BGridPane buttons = new BGridPane(1);
        buttons.setValign(BValign.top);
        buttons.setColumnAlign(BHalign.fill);
        buttons.add(null, (BValue)BFileIndexer.newButton(new Add((BWidget)this)));
        buttons.add(null, (BValue)BFileIndexer.newButton(new Remove((BWidget)this)));
        BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.folderList, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setMinWidth(300.0);
        pane.setMaxWidth(300.0);
        pane.setMinHeight(100.0);
        pane.setMaxHeight(100.0);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)pane);
        edge.setRight((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 0.0, 10.0));
        return edge;
    }

    static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    public void ok() {
        this.cancelled = false;
        this.options.removeAll();
        for (int i = 0; i < this.folderList.getItemCount(); ++i) {
            this.options.add(null, (BValue)((BOrd)this.folderList.getItem(i)));
        }
        this.options.save();
        this.close();
    }

    public void cancel() {
        this.close();
    }

    public void windowClosing(BWindowEvent event) {
        this.cancel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Worker
    extends BProgressDialog.Worker {
        private Map tags = new TreeMap();
        private PatternFilter[] patterns;
        private File[] directories;
        private boolean isAlive;
        private int totalTasks;
        private int currentTask;

        Worker(PatternFilter[] patterns, File[] directories) {
            this.patterns = patterns;
            this.directories = directories;
        }

        public void doRun() {
            try {
                int i;
                this.isAlive = true;
                this.currentTask = 0;
                this.totalTasks = 1;
                for (i = 0; i < this.directories.length; ++i) {
                    this.countDirs(this.directories[i], 0);
                }
                if (!this.isAlive) {
                    return;
                }
                for (i = 0; i < this.directories.length; ++i) {
                    this.traverse(this.directories[i], 0);
                }
                if (!this.isAlive) {
                    return;
                }
                this.persist();
                FileFinder.reload();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void doCancel() {
            this.isAlive = false;
        }

        private void initProgress() throws Exception {
        }

        private void countDirs(File file, int depth) throws Exception {
            if (!this.isAlive) {
                return;
            }
            if (depth > 3) {
                return;
            }
            if (!file.isDirectory()) {
                return;
            }
            ++this.totalTasks;
            File[] kids = file.listFiles();
            for (int i = 0; i < kids.length; ++i) {
                this.countDirs(kids[i], depth + 1);
            }
        }

        private void updateProgressBar() {
            if (this.getDialog() == null) {
                return;
            }
            ++this.currentTask;
            double prog = (double)this.currentTask / (double)this.totalTasks;
            this.updateProgress((int)(prog * 100.0));
        }

        private void process(File file) throws Exception {
            if (!this.include(file)) {
                return;
            }
            String path = file.getCanonicalPath();
            int n = path.lastIndexOf(File.separatorChar);
            String name = path.substring(n + 1);
            path = path.substring(0, n);
            ArrayList<String> list = (ArrayList<String>)this.tags.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                this.tags.put(name, list);
            }
            list.add(path);
        }

        private boolean include(File file) {
            for (int i = 0; i < this.patterns.length; ++i) {
                if (!this.patterns[i].accept(file.getName())) continue;
                return true;
            }
            return false;
        }

        private final void traverse(File file, int depth) throws Exception {
            if (!this.isAlive) {
                return;
            }
            if (file.isDirectory()) {
                if (file.getName().equals("libJar")) {
                    return;
                }
                if (depth <= 3) {
                    this.updateProgressBar();
                }
                File[] kids = file.listFiles();
                for (int i = 0; i < kids.length; ++i) {
                    this.traverse(kids[i], depth + 1);
                }
            } else {
                this.process(file);
            }
        }

        private void persist() throws Exception {
            if (FileFinder.INDEX.exists()) {
                FileFinder.INDEX.delete();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(FileFinder.INDEX));
            Iterator it = this.tags.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                List list = (List)this.tags.get(key);
                out.write(key + "=");
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        out.write(",");
                    }
                    out.write(list.get(i).toString().replace(File.separatorChar, '/'));
                }
                out.write("\n");
            }
            out.close();
        }
    }

    private class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, module, "buildFileIndex.remove");
        }

        public CommandArtifact doInvoke() {
            BFileIndexer.this.folderList.removeSelectedItems();
            return null;
        }
    }

    private class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, module, "buildFileIndex.add");
        }

        public CommandArtifact doInvoke() {
            BDirectoryOrdChooser chooser = new BDirectoryOrdChooser();
            BOrd ord = chooser.openChooser((BWidget)BFileIndexer.this, null, BOrd.make((String)"file:"), null);
            if (ord != null) {
                BFileIndexer.this.folderList.addItem((Object)ord);
            }
            return null;
        }
    }
}

