/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BDateFE;
import java.text.DateFormatSymbols;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;

public class BDatePickerCalendar
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BDatePickerCalendar == null ? (class$com$tridium$workbench$util$BDatePickerCalendar = BDatePickerCalendar.class$("com.tridium.workbench.util.BDatePickerCalendar")) : class$com$tridium$workbench$util$BDatePickerCalendar));
    private static String[] weekdays;
    private static String[] months;
    private static BWeekday firstWeekday;
    private static final int BUTTON_SIZE = 16;
    private static BColor bg;
    private static BColor fg;
    static final BFont font;
    static final BFont bold;
    private int daysInMonth;
    private int first;
    private int startColumn;
    private int rowCount;
    private double headHeight;
    private double halfHead;
    private double rowHeight;
    private double colWidth;
    private int overDay = -1;
    private RectGeom incYear;
    private RectGeom incMonth;
    private RectGeom decYear;
    private RectGeom decMonth;
    private RectGeom overButton = null;
    private String text;
    BColor textColor = BColor.black;
    BColor overColor = BColor.green;
    public BMonth month;
    public int year;
    public int day;
    boolean selectionMade;
    static /* synthetic */ Class class$com$tridium$workbench$util$BDatePickerCalendar;

    public Type getType() {
        return TYPE;
    }

    public BDatePickerCalendar() {
        throw new IllegalStateException();
    }

    public static BDatePickerCalendar dialog(BWidget parent, int year, BMonth month) {
        BDatePickerCalendar picker = new BDatePickerCalendar(parent, year, month);
        picker.setBoundsCenteredOnOwner();
        picker.open();
        if (!picker.selectionMade) {
            return null;
        }
        return picker;
    }

    public BDatePickerCalendar(BWidget owner) {
        this(owner, Clock.time().getYear(), Clock.time().getMonth());
    }

    public BDatePickerCalendar(BWidget owner, int year, BMonth month) {
        super(owner, "", true);
        this.year = year;
        this.month = month;
    }

    public void computePreferredSize() {
        double pw = 7.0 * font.width("000") + 7.0;
        double ph = 6.0 * (font.getAscent() + 4.0) + 6.0 + 2.0 * bold.getHeight();
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.daysInMonth = BAbsTime.getDaysInMonth((int)this.year, (BMonth)this.month);
        this.first = BAbsTime.getWeekday((int)this.year, (BMonth)this.month, (int)1).getOrdinal();
        this.rowCount = BDatePickerCalendar.rows(this.daysInMonth, this.first);
        this.startColumn = 0;
        BWeekday current = firstWeekday;
        while (current.getOrdinal() != this.first) {
            current = current.next();
            ++this.startColumn;
        }
        this.headHeight = bold.getHeight() * 2.0;
        this.halfHead = this.headHeight / 2.0;
        this.rowHeight = (h - this.headHeight) / (double)this.rowCount;
        this.colWidth = w / 7.0;
        this.text = months[this.month.getOrdinal()] + " " + this.year;
        if (this.incYear == null) {
            this.incYear = new RectGeom();
            this.decYear = new RectGeom();
            this.incMonth = new RectGeom();
            this.decMonth = new RectGeom();
        }
        this.decYear.set(0.0, 0.0, 16.0, this.halfHead);
        this.decMonth.set(16.0, 0.0, 16.0, this.halfHead);
        this.incYear.set(w - 16.0, 0.0, 16.0, this.halfHead);
        this.incMonth.set(this.incYear.x - 16.0, 0.0, 16.0, this.halfHead);
    }

    private static int rows(int daysInMonth, int firstDayOfWeek) {
        BWeekday currentDay = BWeekday.make((int)firstDayOfWeek);
        BWeekday lastDay = firstWeekday.previous();
        int firstRowDays = 1;
        while (currentDay.getOrdinal() != lastDay.getOrdinal()) {
            ++firstRowDays;
            currentDay = currentDay.next();
        }
        int afterFirst = (daysInMonth - firstRowDays) / 7;
        if ((daysInMonth - firstRowDays) % 7 != 0) {
            ++afterFirst;
        }
        return afterFirst + 1;
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(bg);
        g.fillRect(0.0, 0.0, w, this.halfHead);
        g.setBrush(fg);
        if (this.overButton == this.decMonth) {
            g.fill((IGeom)this.decMonth);
            g.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)g, (double)this.decMonth.x, (double)(this.decMonth.y + 1.0), (double)this.decMonth.width, (double)this.decMonth.height, (BAlign)BAlign.left);
        g.setBrush(fg);
        if (this.overButton == this.decYear) {
            g.fill((IGeom)this.decYear);
            g.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)g, (double)(this.decYear.x + 2.0), (double)(this.decYear.y + 1.0), (double)this.decYear.width, (double)this.decYear.height, (BAlign)BAlign.left);
        PaintUtil.drawArrow((Graphics)g, (double)(this.decYear.x - 3.0), (double)(this.decYear.y + 1.0), (double)this.decYear.width, (double)this.decYear.height, (BAlign)BAlign.left);
        g.setBrush(fg);
        if (this.overButton == this.incMonth) {
            g.fill((IGeom)this.incMonth);
            g.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)g, (double)this.incMonth.x, (double)(this.incMonth.y + 1.0), (double)this.incMonth.width, (double)this.incMonth.height, (BAlign)BAlign.right);
        g.setBrush(fg);
        if (this.overButton == this.incYear) {
            g.fill((IGeom)this.incYear);
            g.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)g, (double)(this.incYear.x + 2.0), (double)(this.incYear.y + 1.0), (double)this.incYear.width, (double)this.incYear.height, (BAlign)BAlign.right);
        PaintUtil.drawArrow((Graphics)g, (double)(this.incYear.x - 3.0), (double)(this.incYear.y + 1.0), (double)this.incYear.width, (double)this.incYear.height, (BAlign)BAlign.right);
        g.setBrush(BColor.white);
        g.fillRect(0.0, this.headHeight, w, h - this.headHeight);
        g.setBrush(BColor.black);
        g.strokeLine(0.0, this.headHeight, w, this.headHeight);
        g.strokeLine(0.0, this.headHeight - 1.0, w, this.headHeight - 1.0);
        g.strokeLine(0.0, this.halfHead, w, this.halfHead);
        double x = this.colWidth;
        for (int i = 0; i < 6; ++i) {
            g.strokeLine(x, this.halfHead, x, h);
            x += this.colWidth;
        }
        double y = this.headHeight + this.rowHeight;
        for (int i = 0; i < this.rowCount - 1; ++i) {
            g.strokeLine(0.0, y, w, y);
            y += this.rowHeight;
        }
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        double baseline = this.halfHead - 3.0;
        g.setFont(bold);
        g.drawString(this.text, (w - bold.width(this.text)) / 2.0, baseline);
        baseline = this.headHeight - 3.0;
        double tx = 0.0;
        for (int i = 0; i < 7; ++i) {
            double cw = font.width(weekdays[i]);
            g.drawString(weekdays[i], tx + (this.colWidth - cw) / 2.0, baseline);
            tx += this.colWidth;
        }
        int col = this.startColumn;
        g.setFont(font);
        baseline = this.headHeight + (this.rowHeight - font.getAscent()) / 2.0 + font.getAscent() - 1.0;
        int row = 0;
        for (int i = 1; i <= this.daysInMonth; ++i) {
            String d = Integer.toString(i);
            double dx = (double)col * this.colWidth + (this.colWidth - font.width(d)) / 2.0 + 1.0;
            g.setBrush(fg);
            if (i == this.overDay) {
                g.fillRect((double)col * this.colWidth, this.headHeight + (double)row * this.rowHeight, this.colWidth, this.rowHeight);
                g.setBrush(bg);
            }
            g.drawString(d, dx, baseline);
            col = (col + 1) % 7;
            if (col != 0) continue;
            baseline += this.rowHeight;
            ++row;
        }
    }

    public void mousePressed(BMouseEvent evt) {
        double x = evt.getX();
        double y = evt.getY();
        if (y < this.halfHead) {
            if (this.decYear.contains(x, y)) {
                this.year = --this.year == 1969 ? 9999 : this.year;
            } else if (this.decMonth.contains(x, y)) {
                this.month = this.month.previous();
            } else if (this.incMonth.contains(x, y)) {
                this.month = this.month.next();
            } else if (this.incYear.contains(x, y)) {
                this.year = ++this.year > 9999 ? 1970 : this.year;
            }
            this.relayout();
        } else if (y > this.headHeight) {
            this.day = this.overDay;
            this.selectionMade = true;
            this.close();
        }
    }

    public void mouseMoved(BMouseEvent evt) {
        double x = evt.getX();
        double y = evt.getY();
        if (this.rowHeight < 0.0 || this.colWidth < 0.0) {
            return;
        }
        if (y < this.headHeight) {
            RectGeom newOver = null;
            if (this.decYear.contains(x, y)) {
                newOver = this.decYear;
            } else if (this.decMonth.contains(x, y)) {
                newOver = this.decMonth;
            } else if (this.incMonth.contains(x, y)) {
                newOver = this.incMonth;
            } else if (this.incYear.contains(x, y)) {
                newOver = this.incYear;
            }
            if (newOver == this.overButton && this.overDay == -1) {
                return;
            }
            this.overButton = newOver;
            this.overDay = -1;
            this.repaint();
            return;
        }
        int day = (int)((y - this.headHeight) / this.rowHeight) * 7 + (int)(x / this.colWidth) + 1 - this.startColumn;
        if (this.overDay == day && this.overButton == null) {
            return;
        }
        this.overDay = day;
        if (this.overDay > this.daysInMonth || this.overDay < 1) {
            this.overDay = -1;
        }
        this.overButton = null;
        this.repaint();
    }

    public void mouseExited(BMouseEvent evt) {
        this.overButton = null;
        this.overDay = -1;
        this.repaint();
    }

    public void windowClosing(BWindowEvent evt) {
        this.close();
    }

    public static void main(String[] args) throws Exception {
        BFrame f = new BFrame();
        BDateFE e = new BDateFE();
        BGridPane grid = new BGridPane();
        grid.add(null, (BValue)new BBorderPane((BWidget)e));
        e.loadValue((BObject)BAbsTime.make());
        f.setContent((BWidget)grid);
        f.setScreenBounds(100.0, 10.0, 200.0, 200.0);
        f.open();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DateFormatSymbols symbols = new DateFormatSymbols();
        months = symbols.getShortMonths();
        weekdays = new String[7];
        BWeekday current = firstWeekday = BWeekday.getFirstDayOfWeek(null);
        for (int i = 0; i < 7; ++i) {
            BDatePickerCalendar.weekdays[i] = current.getShortDisplayTag(null).substring(0, 1);
            current = current.next();
        }
        bg = BColor.white;
        fg = BColor.black;
        font = Theme.widget().getTextFont();
        bold = Theme.widget().getBoldText();
    }
}

