/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.transfer;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.sys.transfer.DeleteOp;
import com.tridium.sys.transfer.FileToFile;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.transfer.TransferArtifact;
import java.util.HashMap;
import java.util.HashSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferConst;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Version;
import javax.baja.workbench.commands.ComponentRenameCommand;
import javax.baja.workbench.commands.FileRenameCommand;

public class TransferUtil
implements TransferConst {
    public static final String PARAM_PROMPT_FOR_NAME = "promptForName";
    static final String TRASH_FILE_PATH = "!trash";
    static /* synthetic */ Class class$javax$baja$file$BIFile;
    static /* synthetic */ Class class$javax$baja$sys$BObject;

    public static TransferEnvelope getTransferData(BObject object) {
        if (object == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)new Mark(object));
    }

    public static boolean isComplex(Mark mark) {
        BObject[] v = mark.getValues();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] instanceof BComplex) continue;
            return false;
        }
        return true;
    }

    public static boolean isComponent(Mark mark) {
        BObject[] v = mark.getValues();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] instanceof BComponent) continue;
            return false;
        }
        return true;
    }

    public static boolean isFile(Mark mark) {
        BObject[] v = mark.getValues();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] instanceof BIFile) continue;
            return false;
        }
        return true;
    }

    public static CommandArtifact insert(BWidget owner, TransferContext cx, BObject target, BComponent params) throws Exception {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        return TransferUtil.insert(owner, cx.getAction(), mark, target, params, (Context)cx);
    }

    public static CommandArtifact insert(BWidget owner, int action, Mark mark, BObject target, BComponent params, Context cx) throws Exception {
        if (!TransferUtil.checkForMissingModules(owner, mark, target)) {
            return null;
        }
        if ((mark = TransferUtil.promptForName(owner, action, mark, target, params)) == null) {
            return null;
        }
        if (!TransferUtil.checkFileReplace(owner, mark, target)) {
            return null;
        }
        TransferArtifact art = new TransferArtifact(owner, action, mark, target, params, cx);
        art.redo();
        if (art.getResult() == null) {
            return null;
        }
        return art;
    }

    static Mark promptForName(BWidget owner, int action, Mark mark, BObject target, BComponent params) {
        if (action != 16) {
            return mark;
        }
        if (mark.size() != 1) {
            return mark;
        }
        if (!BGeneralOptions.make().getPromptForNameOnInsert() && !TransferUtil.isFile(mark)) {
            return mark;
        }
        if (params != null && params.get(PARAM_PROMPT_FOR_NAME) == BBoolean.FALSE) {
            return mark;
        }
        String name = mark.getNames()[0];
        BObject value = mark.getValues()[0];
        if ((target = TransferStrategy.toActualTarget((BObject)target)) instanceof BComponent) {
            BComponent c = (BComponent)target;
            BComponentSpace space = c.getComponentSpace();
            name = space != null ? (String)space.fw(111, (Object)name, (Object)new CompToComp.TargetNameContainer(c, new HashMap()), null, null) : CompToComp.getUniqueName((BComponent)c, (String)name);
        } else if (target instanceof BDirectory) {
            if (!(value instanceof BIFile)) {
                return mark;
            }
            if (!TransferUtil.isChild((BIFile)((BDirectory)target), (BIFile)value)) {
                return mark;
            }
            name = FileToFile.getUniqueFilename((BDirectory)((BDirectory)target), (String)name);
        }
        if (target instanceof BDirectory) {
            name = BOptionDialog.promptFileName((BWidget)owner, (String)TransferUtil.lex().getText("name"), (String)name);
        } else {
            name = BDialog.prompt((BWidget)owner, (String)TransferUtil.lex().getText("name"), (String)SlotPath.unescape((String)name), (int)30);
            if (name == null) {
                return null;
            }
            name = SlotPath.escape((String)name);
        }
        if (name == null) {
            return null;
        }
        return new Mark(value, name);
    }

    static boolean checkForMissingModules(BWidget owner, Mark mark, BObject target) throws Exception {
        try {
            BLabel prompt;
            String title;
            int r;
            BComponent firstObject;
            target = TransferStrategy.toActualTarget((BObject)target);
            if (!(target instanceof BComponent)) {
                return true;
            }
            BComponent c = target.asComponent();
            BComponentSpace componentSpace = c.getComponentSpace();
            if (componentSpace == null) {
                return true;
            }
            BObject[] newObjects = mark.getValues();
            if (newObjects.length > 0 && newObjects[0] instanceof BComponent && componentSpace == (firstObject = (BComponent)newObjects[0]).getComponentSpace()) {
                return true;
            }
            HashSet topDependencies = new HashSet();
            HashSet deepDependencies = new HashSet();
            for (int i = 0; i < newObjects.length; ++i) {
                TransferUtil.accumulateDependencies(newObjects[i], deepDependencies, topDependencies, true);
            }
            String missingModules = "";
            missingModules = TransferUtil.getMissingRemoteModules(topDependencies.toArray(), target);
            if (missingModules.length() > 0) {
                BDialog.error((BWidget)owner, (Object)TransferUtil.lex().getText("missingModules.error.prompt", new Object[]{missingModules}));
                return false;
            }
            missingModules = TransferUtil.getMissingRemoteModules(deepDependencies.toArray(), target);
            if (missingModules.length() > 0 && (r = BDialog.open((BWidget)owner, (String)(title = UiLexicon.bajaui().getText("missingModules.warning.title")), (Object)(prompt = new BLabel(UiLexicon.bajaui().getText("missingModules.warning.prompt", new Object[]{missingModules}), BHalign.left)), (int)3, (BImage)BDialog.QUESTION_ICON)) == 2) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    static String getMissingRemoteModules(Object[] modules, BObject target) {
        String missingModules = "";
        for (int i = 0; i < modules.length; ++i) {
            Version version = (Version)target.fw(404, (Object)modules[i].toString(), null, null, null);
            if (version == null || !version.equals((Object)Version.NULL)) continue;
            if (missingModules.length() > 0) {
                missingModules = missingModules + ", ";
            }
            missingModules = missingModules + modules[i];
        }
        return missingModules;
    }

    static void accumulateDependencies(BObject o, HashSet deepDependencies, HashSet topDependencies, boolean top) throws Exception {
        String moduleName = o.getType().getTypeInfo().getModuleName();
        if (top) {
            topDependencies.add(moduleName);
        } else if (!topDependencies.contains(moduleName)) {
            deepDependencies.add(moduleName);
        }
        if (o instanceof BComplex) {
            BComplex complex = o.asComplex();
            SlotCursor c = complex.getProperties();
            while (c.next()) {
                TransferUtil.accumulateDependencies((BObject)complex.get(c.property()), deepDependencies, topDependencies, false);
            }
        }
        if (o instanceof BBogFile) {
            Mark mark = null;
            try {
                mark = ((BBogFile)o).readComponents();
            }
            catch (Exception e) {
                return;
            }
            BObject[] newObjects = mark.getValues();
            for (int i = 0; i < newObjects.length; ++i) {
                TransferUtil.accumulateDependencies(newObjects[i], deepDependencies, topDependencies, top);
            }
        }
    }

    static boolean checkFileReplace(BWidget owner, Mark mark, BObject target) throws Exception {
        BLabel prompt;
        if (!TransferUtil.isFile(mark)) {
            return true;
        }
        if (!(target instanceof BIFile)) {
            return true;
        }
        if (!(target instanceof BDirectory)) {
            return true;
        }
        if (((BIFile)target).getFilePath().getBody().equals(TRASH_FILE_PATH)) {
            return true;
        }
        BDirectory dir = (BDirectory)target;
        String[] names = mark.getNames();
        BIFile[] newFiles = (BIFile[])mark.getValues((Object[])new BIFile[mark.size()]);
        HashMap<String, BIFile> curMap = new HashMap<String, BIFile>();
        BIFile[] curFiles = dir.listFiles();
        for (int i = 0; i < curFiles.length; ++i) {
            curMap.put(curFiles[i].getFileName(), curFiles[i]);
        }
        Array dupAcc = new Array(class$javax$baja$file$BIFile == null ? (class$javax$baja$file$BIFile = TransferUtil.class$("javax.baja.file.BIFile")) : class$javax$baja$file$BIFile);
        for (int i = 0; i < names.length; ++i) {
            BIFile dup = (BIFile)curMap.get(names[i]);
            if (dup == null) continue;
            dupAcc.add((Object)dup);
        }
        Object[] dups = (BIFile[])dupAcc.trim();
        if (dups.length == 0) {
            return true;
        }
        for (int i = 0; i < dups.length; ++i) {
            for (int j = 0; j < newFiles.length; ++j) {
                BIFile dup = dups[i];
                BIFile newFile = newFiles[j];
                if (!dup.equals((Object)newFile) && !TransferUtil.isDescendent(dup, newFile)) continue;
                BDialog.error((BWidget)owner, (Object)TransferUtil.lex().getText("file.replace.same", new Object[]{dups[i].getFileName()}));
                return false;
            }
        }
        if (dups.length == 1) {
            String label = TransferUtil.lex().getText("file.replace.one", new Object[]{dups[0].getFileName()});
            prompt = new BLabel(label, BHalign.left);
        } else {
            BList list = new BList();
            list.setRenderer(new ListRenderer(){

                public BBrush getSelectionForeground(ListRenderer.Item item) {
                    return this.getForeground(item);
                }

                public BBrush getSelectionBackground(ListRenderer.Item item) {
                    return this.getBackground(item);
                }
            });
            for (int i = 0; i < dups.length; ++i) {
                list.addItem((Object)dups[i].getFileName());
            }
            String label = TransferUtil.lex().getText("file.replace.multiple");
            BEdgePane edge = new BEdgePane();
            edge.setTop((BWidget)new BLabel(label, BHalign.left));
            edge.setCenter((BWidget)list);
            prompt = edge;
        }
        String title = TransferUtil.lex().getText("file.replace.title");
        int r = BDialog.open((BWidget)owner, (String)title, (Object)prompt, (int)3, (BImage)BDialog.QUESTION_ICON);
        if (r == 2) {
            return false;
        }
        Array markTemp = new Array(class$javax$baja$sys$BObject == null ? (class$javax$baja$sys$BObject = TransferUtil.class$("javax.baja.sys.BObject")) : class$javax$baja$sys$BObject);
        markTemp.addAll(dups);
        mark = new Mark((BObject[])markTemp.trim());
        TransferUtil.delete(owner, mark);
        return true;
    }

    static boolean isDescendent(BIFile dir, BIFile file) {
        String dirPath = dir.getFilePath().getBody();
        return file.getFilePath().getParent().getBody().startsWith(dirPath);
    }

    static boolean isChild(BIFile dir, BIFile file) {
        String dirPath = dir.getFilePath().getBody();
        return file.getFilePath().getParent().getBody().equals(dirPath);
    }

    public static CommandArtifact duplicate(BWidget owner, BObject object) throws Exception {
        if (object instanceof BComponent) {
            BComponent parent = (BComponent)object.asComponent().getParent();
            return TransferUtil.insert(owner, 16, new Mark(object), (BObject)parent, null, null);
        }
        if (object instanceof BIFile) {
            BIFile file = (BIFile)object;
            Mark mark = new Mark((BObject)file, file.getFileName());
            BDirectory parent = (BDirectory)file.getNavParent();
            return TransferUtil.insert(owner, 16, mark, (BObject)parent, null, null);
        }
        throw new UnsupportedOperationException("Don't know how to duplicate: " + object.getType());
    }

    public static CommandArtifact delete(BWidget owner, Mark mark) throws Exception {
        if (TransferUtil.isComplex(mark)) {
            return TransferUtil.deleteComponent(owner, mark);
        }
        if (TransferUtil.isFile(mark)) {
            return TransferUtil.deleteFile(owner, mark);
        }
        throw new UnsupportedOperationException("Don't know how to delete");
    }

    static CommandArtifact deleteComponent(BWidget owner, Mark mark) throws Exception {
        DeleteOp op = null;
        for (int i = 0; i < mark.size(); ++i) {
            if (!mark.getValue(i).isComponent()) continue;
            BComponent comp = mark.getValue(i).asComponent();
            BComponentSpace space = (BComponentSpace)comp.getSpace();
            op = (DeleteOp)space.fw(112, (Object)mark, null, null, null);
            break;
        }
        if (op == null) {
            op = DeleteOp.make((Mark)mark, null);
        }
        DeleteOpArtifact art = new DeleteOpArtifact(op);
        art.redo();
        return art;
    }

    static CommandArtifact deleteFile(BWidget owner, Mark mark) throws Exception {
        boolean allTrash = true;
        BIFile[] files = (BIFile[])mark.getValues((Object[])new BIFile[mark.size()]);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getFilePath().getBody().indexOf("trash/") >= 0) continue;
            allTrash = false;
            break;
        }
        if (allTrash) {
            int r = BDialog.confirm((BWidget)owner, (Object)TransferUtil.lex().getText("deleteTrash.confirm"));
            if (r == 8) {
                return null;
            }
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
            return null;
        }
        return TransferUtil.insert(owner, 32, mark, (BObject)TransferUtil.getTrash(), null, null);
    }

    public static BDirectory getTrash() throws Exception {
        BFileSystem fs = BFileSystem.INSTANCE;
        return fs.makeDir(new FilePath(TRASH_FILE_PATH));
    }

    public static CommandArtifact rename(BWidget owner, Mark mark) throws Exception {
        if (TransferUtil.isComponent(mark)) {
            return TransferUtil.renameComponent(owner, mark);
        }
        if (TransferUtil.isFile(mark)) {
            return TransferUtil.renameFile(owner, mark);
        }
        throw new UnsupportedOperationException("Don't know how to rename");
    }

    static CommandArtifact renameComponent(BWidget owner, Mark mark) throws Exception {
        int len = mark.size();
        BComponent[] components = (BComponent[])mark.getValues((Object[])new BComponent[len]);
        BComponent[] parents = new BComponent[len];
        Property[] slots = new Property[len];
        for (int i = 0; i < len; ++i) {
            parents[i] = (BComponent)components[i].getParent();
            slots[i] = components[i].getPropertyInParent();
        }
        ComponentRenameCommand cmd = new ComponentRenameCommand(owner, parents, slots, null);
        return cmd.doInvoke();
    }

    static CommandArtifact renameFile(BWidget owner, Mark mark) throws Exception {
        BIFile[] files = (BIFile[])mark.getValues((Object[])new BIFile[mark.size()]);
        FileRenameCommand cmd = new FileRenameCommand(owner, files);
        return cmd.doInvoke();
    }

    static UiLexicon lex() {
        return UiLexicon.bajaui();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DeleteOpArtifact
    implements CommandArtifact {
        DeleteOp op;

        DeleteOpArtifact(DeleteOp op) {
            this.op = op;
        }

        public void redo() {
            this.op = this.op.delete();
        }

        public void undo() {
            this.op = this.op.undelete();
        }
    }
}

