/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.synthetic;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import com.tridium.workbench.synthetic.BFrozenSlotDefaultValueFE;
import com.tridium.workbench.util.BFlagConfig;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class SyntheticModuleTypesSlotsTab {
    private BTable table;
    private BWidget content;
    private XElem root;
    private XElem moduleXml;
    private BWbPlugin parent;
    private BAbstractButton editButton;
    private BAbstractButton removeButton;
    private BAbstractButton addButton;
    static /* synthetic */ Class class$javax$baja$sys$BFacets;

    public SyntheticModuleTypesSlotsTab(BWbPlugin parent) {
        this.parent = parent;
        BBorderPane borderPane = new BBorderPane();
        borderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        BEdgePane edgePane = new BEdgePane();
        borderPane.setContent((BWidget)edgePane);
        this.table = new BTable((TableModel)new Model());
        this.table.setController((TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        edgePane.setCenter((BWidget)this.table);
        BBorderPane buttonBorder = new BBorderPane();
        buttonBorder.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        edgePane.setBottom((BWidget)buttonBorder);
        BGridPane buttonGrid = new BGridPane(3);
        buttonGrid.setColumnGap(20.0);
        this.addButton = BButton.make((Command)new AddCommand(parent));
        buttonGrid.add(null, (BValue)this.addButton);
        this.editButton = BButton.make((Command)new EditCommand(parent));
        buttonGrid.add(null, (BValue)this.editButton);
        this.removeButton = BButton.make((Command)new Command(parent, "Remove"){

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.std((String)"delete.png"));
            }

            public CommandArtifact doInvoke() throws Exception {
                int[] selected = SyntheticModuleTypesSlotsTab.this.table.getSelection().getRows();
                if (selected.length == 0) {
                    return null;
                }
                String prompt = "Remove slot '" + SyntheticModuleTypesSlotsTab.this.root.elem("slots").elems()[selected[0]].get("name") + "'?";
                int result = BOptionDialog.confirm((BWidget)this.getShell(), (String)this.getLabel(), (Object)prompt, (int)3);
                if (result == 1) {
                    SyntheticModuleTypesSlotsTab.this.root.elem("slots").removeContent(selected[0]);
                    SyntheticModuleTypesSlotsTab.this.setModified();
                    SyntheticModuleTypesSlotsTab.this.table.getModel().updateTable(false);
                }
                SyntheticModuleTypesSlotsTab.this.editButton.setEnabled(SyntheticModuleTypesSlotsTab.this.table.getModel().getRowCount() > 0);
                SyntheticModuleTypesSlotsTab.this.removeButton.setEnabled(SyntheticModuleTypesSlotsTab.this.table.getModel().getRowCount() > 0);
                return null;
            }
        });
        buttonGrid.add(null, (BValue)this.removeButton);
        buttonBorder.setContent((BWidget)buttonGrid);
        this.content = borderPane;
    }

    public void setModified() {
        this.parent.setModified();
    }

    public void loadValue(XElem root, XElem moduleXml, Context cx) {
        if (this.root != null) {
            this.saveValue(cx);
        }
        this.root = root;
        this.moduleXml = moduleXml;
        this.table.getModel().updateTable();
        this.table.getSelection().deselectAll();
        this.table.sizeColumnsToFit();
        this.editButton.setEnabled(this.table.getModel().getRowCount() > 0);
        this.removeButton.setEnabled(this.table.getModel().getRowCount() > 0);
    }

    public void saveValue(Context cx) {
    }

    public BWidget getContent() {
        return this.content;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getRowCount() {
            return SyntheticModuleTypesSlotsTab.this.root.elem("slots") == null ? 0 : SyntheticModuleTypesSlotsTab.this.root.elem("slots").elems("property").length;
        }

        public int getColumnCount() {
            return 7;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Slot";
            }
            if (col == 1) {
                return "#";
            }
            if (col == 2) {
                return "Name";
            }
            if (col == 3) {
                return "Flags";
            }
            if (col == 4) {
                return "Type";
            }
            if (col == 5) {
                return "Facets";
            }
            if (col == 6) {
                return "Default";
            }
            return "???";
        }

        public Object getSubject(int row) {
            return SyntheticModuleTypesSlotsTab.this.root.elem("slots").elems("property")[row];
        }

        public Object getValueAt(int row, int col) {
            XElem slot = SyntheticModuleTypesSlotsTab.this.root.elem("slots").elems("property")[row];
            if (col == 0) {
                if (slot.name().equals("property")) {
                    return "Property";
                }
                if (slot.name().equals("action")) {
                    return "Action";
                }
                if (slot.name().equals("topic")) {
                    return "Topic";
                }
            }
            if (col == 1) {
                return Integer.toString(row);
            }
            if (col == 2) {
                return slot.get("name");
            }
            if (col == 3) {
                return Flags.encodeToString((int)slot.geti("flags", 0));
            }
            if (col == 4) {
                if (slot.name().equals("property")) {
                    return slot.get("type");
                }
                if (slot.name().equals("action")) {
                    return slot.get("return", "void") + " (" + slot.get("type", "void") + ")";
                }
                if (slot.name().equals("topic")) {
                    return slot.get("type");
                }
            }
            if (col == 5) {
                try {
                    return ((BFacets)BFacets.DEFAULT.decodeFromString(slot.get("facets"))).toString();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return "?";
                }
            }
            if (col == 6) {
                if (slot.name().equals("property")) {
                    if (slot.get("value").length() == 0) {
                        return "empty";
                    }
                    Type type = BTypeSpec.make((String)slot.get("type")).getResolvedType();
                    try {
                        if (type.is(BIEncodable.TYPE)) {
                            return ((BIEncodable)type.getInstance()).decodeFromString(slot.get("value")).toString(null);
                        }
                        return ValueDocDecoder.unmarshal((String)slot.get("value")).toString(null);
                    }
                    catch (Exception e) {
                        return "?";
                    }
                }
                return "?";
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            XElem slot = SyntheticModuleTypesSlotsTab.this.root.elem("slots").elems("property")[row];
            if (slot.name().equals("property")) {
                return BImage.make((BIcon)BIcon.std((String)"shapes/circleBlue.png"));
            }
            if (slot.name().equals("action")) {
                return BImage.make((BIcon)BIcon.std((String)"action.png"));
            }
            if (slot.name().equals("topic")) {
                return BImage.make((BIcon)BIcon.std((String)"topic.png"));
            }
            return BImage.make((BIcon)BIcon.std((String)"questionMark.png"));
        }

        public boolean isColumnSortable(int col) {
            return false;
        }
    }

    private class Selection
    extends TableSelection {
        private Selection() {
        }

        private void updateButtons() {
            boolean isEmpty = this.isEmpty();
            SyntheticModuleTypesSlotsTab.this.editButton.setEnabled(!isEmpty);
            SyntheticModuleTypesSlotsTab.this.removeButton.setEnabled(!isEmpty);
        }

        public void deselect(int row) {
            super.deselect(row);
            this.updateButtons();
        }

        public void deselectAll() {
            super.deselectAll();
            this.updateButtons();
        }

        public void select(int row, boolean clear) {
            super.select(row, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, anchor, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead) {
            super.select(anchor, anchor);
            this.updateButtons();
        }

        public void select(int row) {
            super.select(row);
            this.updateButtons();
        }

        public void select(int[] rows) {
            super.select(rows[0]);
            this.updateButtons();
        }

        public void selectAll() {
            this.updateButtons();
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.getTable().getSelection().select(row, true);
            try {
                SyntheticModuleTypesSlotsTab.this.editButton.getCommand().doInvoke();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public int getTextSearchColumn() {
            return 2;
        }

        protected BMenu makePopup(TableSubject subject) {
            BMenu menu = new BMenu();
            menu.add("add", SyntheticModuleTypesSlotsTab.this.addButton.getCommand());
            if (subject.getRows().length > 0) {
                menu.add("edit", SyntheticModuleTypesSlotsTab.this.editButton.getCommand());
                menu.add("remove", SyntheticModuleTypesSlotsTab.this.removeButton.getCommand());
            }
            return menu;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand(BWidget owner) {
            super(owner, "Edit");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"edit.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            XElem slotXml = SyntheticModuleTypesSlotsTab.this.root.elem("slots").elems()[SyntheticModuleTypesSlotsTab.this.table.getSelection().getRow()];
            BTextField nameEditor = new BTextField(SlotPath.unescape((String)slotXml.get("name")), 25);
            BGridPane nameInner = new BGridPane(1);
            nameInner.setHalign(BHalign.left);
            nameInner.add(null, (BValue)nameEditor);
            BBorderPane namePane = new BBorderPane((BWidget)nameInner, "Name");
            BTypeSpecFE typeEditor = new BTypeSpecFE();
            BTypeSpec typeSpec = BTypeSpec.make((String)slotXml.get("type"));
            typeEditor.loadValue((BObject)typeSpec, (Context)BFacets.make((String)"showInterface", (BIDataValue)BBoolean.FALSE, (String)"targetType", (BIDataValue)BString.make((String)"baja:Value")));
            BGridPane typeInner = new BGridPane();
            typeInner.setHalign(BHalign.left);
            typeInner.add(null, (BValue)typeEditor);
            BBorderPane typePane = new BBorderPane((BWidget)typeInner, "Type");
            BFlagConfig flagEditor = new BFlagConfig(null, null);
            flagEditor.load(slotXml.geti("flags", 0));
            BGridPane flagInner = new BGridPane();
            flagInner.setHalign(BHalign.left);
            flagInner.add(null, (BValue)flagEditor);
            Class cls = Sys.loadClass((String)"wbutil", (String)"com.tridium.workbench.fieldeditors.facets.BFacetsEditor");
            BFacets facets = (BFacets)BFacets.DEFAULT.decodeFromString(slotXml.get("facets", ""));
            BWidget facetsEditor = (BWidget)cls.getConstructor(class$javax$baja$sys$BFacets == null ? (class$javax$baja$sys$BFacets = SyntheticModuleTypesSlotsTab.class$("javax.baja.sys.BFacets")) : class$javax$baja$sys$BFacets, Boolean.TYPE).newInstance(facets, Boolean.FALSE);
            BGridPane facetsInner = new BGridPane();
            facetsInner.setHalign(BHalign.left);
            facetsInner.setValign(BValign.top);
            facetsInner.add(null, (BValue)facetsEditor);
            BObject defaultValue = typeSpec.getResolvedType().getInstance();
            BFrozenSlotDefaultValueFE fieldEditor = new BFrozenSlotDefaultValueFE();
            if (slotXml.get("value").length() == 0) {
                fieldEditor.loadValue(defaultValue);
            } else if (typeSpec.getResolvedType().is(BIEncodable.TYPE)) {
                fieldEditor.loadValue(((BIEncodable)typeSpec.getResolvedType().getInstance()).decodeFromString(slotXml.get("value")));
            } else {
                BValue value = ValueDocDecoder.unmarshal((String)slotXml.get("value"));
                fieldEditor.loadValue((BObject)value);
            }
            fieldEditor.linkTo((BComponent)typeEditor, (Slot)BTypeSpecFE.pluginModified, (Slot)BFrozenSlotDefaultValueFE.update);
            BGridPane defaultInner = new BGridPane();
            defaultInner.setHalign(BHalign.left);
            defaultInner.setValign(BValign.top);
            defaultInner.add(null, (BValue)fieldEditor);
            BTabbedPane tabbedPane = new BTabbedPane();
            tabbedPane.addPane("Default Value", (BWidget)defaultInner);
            tabbedPane.addPane("Flags", (BWidget)flagInner);
            tabbedPane.addPane("Facets", (BWidget)facetsInner);
            BGridPane pane = new BGridPane(1);
            pane.setColumnAlign(BHalign.fill);
            pane.add(null, (BValue)namePane);
            pane.add(null, (BValue)typePane);
            pane.add(null, (BValue)tabbedPane);
            String title = this.getLabel();
            int buttons = 3;
            if (BDialog.open((BWidget)this.getOwner(), (String)title, (Object)pane, (int)buttons, null) == 2) {
                return null;
            }
            String name = SlotPath.escape((String)nameEditor.getText());
            typeSpec = (BTypeSpec)typeEditor.saveValue();
            int flags = flagEditor.save();
            facets = (BFacets)cls.getMethod("save", new Class[0]).invoke((Object)facetsEditor, new Object[0]);
            BValue value = (BValue)fieldEditor.saveValue();
            String valueEnc = value instanceof BIEncodable ? ((BIEncodable)value).encodeToString() : ValueDocEncoder.marshal((BValue)value);
            slotXml.setAttr("name", name);
            slotXml.setAttr("type", typeSpec.encodeToString());
            slotXml.setAttr("flags", Integer.toString(flags));
            slotXml.setAttr("facets", facets.encodeToString());
            slotXml.setAttr("value", valueEnc);
            SyntheticModuleTypesSlotsTab.this.setModified();
            SyntheticModuleTypesSlotsTab.this.table.getModel().updateTable(false);
            return null;
        }
    }

    private class AddCommand
    extends Command {
        String lastName = "";
        BTypeSpec lastType = BTypeSpec.make((String)"baja:Component");

        public AddCommand(BWidget owner) {
            super(owner, "Add");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"add.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BTypeSpec typeSpec;
            BTextField nameEditor = new BTextField(this.lastName, 25);
            BGridPane nameInner = new BGridPane(1);
            nameInner.setHalign(BHalign.left);
            nameInner.add(null, (BValue)nameEditor);
            BBorderPane namePane = new BBorderPane((BWidget)nameInner, "Name");
            BTypeSpecFE typeEditor = new BTypeSpecFE();
            typeEditor.loadValue((BObject)this.lastType, (Context)BFacets.make((String)"showInterface", (BIDataValue)BBoolean.FALSE, (String)"targetType", (BIDataValue)BString.make((String)"baja:Value")));
            BGridPane typeInner = new BGridPane();
            typeInner.setHalign(BHalign.left);
            typeInner.add(null, (BValue)typeEditor);
            BBorderPane typePane = new BBorderPane((BWidget)typeInner, "Type");
            BFlagConfig flagEditor = new BFlagConfig(null, null);
            BGridPane flagInner = new BGridPane();
            flagInner.setHalign(BHalign.left);
            flagInner.add(null, (BValue)flagEditor);
            Class cls = Sys.loadClass((String)"wbutil", (String)"com.tridium.workbench.fieldeditors.facets.BFacetsEditor");
            BWidget facetsEditor = (BWidget)cls.getConstructor(class$javax$baja$sys$BFacets == null ? (class$javax$baja$sys$BFacets = SyntheticModuleTypesSlotsTab.class$("javax.baja.sys.BFacets")) : class$javax$baja$sys$BFacets, Boolean.TYPE).newInstance(BFacets.DEFAULT, Boolean.FALSE);
            BGridPane facetsInner = new BGridPane();
            facetsInner.setHalign(BHalign.left);
            facetsInner.setValign(BValign.top);
            facetsInner.add(null, (BValue)facetsEditor);
            BObject defaultValue = ((BTypeSpec)typeEditor.saveValue()).getInstance();
            BFrozenSlotDefaultValueFE fieldEditor = new BFrozenSlotDefaultValueFE();
            fieldEditor.loadValue(defaultValue);
            fieldEditor.linkTo((BComponent)typeEditor, (Slot)BTypeSpecFE.pluginModified, (Slot)BFrozenSlotDefaultValueFE.update);
            BGridPane defaultInner = new BGridPane();
            defaultInner.setHalign(BHalign.left);
            defaultInner.setValign(BValign.top);
            defaultInner.add(null, (BValue)fieldEditor);
            BTabbedPane tabbedPane = new BTabbedPane();
            tabbedPane.addPane("Default Value", (BWidget)defaultInner);
            tabbedPane.addPane("Flags", (BWidget)flagInner);
            tabbedPane.addPane("Facets", (BWidget)facetsInner);
            BGridPane pane = new BGridPane(1);
            pane.setColumnAlign(BHalign.fill);
            pane.add(null, (BValue)namePane);
            pane.add(null, (BValue)typePane);
            pane.add(null, (BValue)tabbedPane);
            String title = this.getLabel();
            int buttons = 3;
            if (BDialog.open((BWidget)this.getOwner(), (String)title, (Object)pane, (int)buttons, null) == 2) {
                return null;
            }
            this.lastName = nameEditor.getText();
            String name = SlotPath.escape((String)nameEditor.getText());
            this.lastType = typeSpec = (BTypeSpec)typeEditor.saveValue();
            int flags = flagEditor.save();
            BFacets facets = (BFacets)cls.getMethod("save", new Class[0]).invoke((Object)facetsEditor, new Object[0]);
            if (name == null || name.length() == 0) {
                BDialog.error((BWidget)this.getOwner(), (String)"Invalid Slot", (Object)"Invalid slot name.", (Throwable)null);
                return null;
            }
            BValue value = (BValue)fieldEditor.saveValue();
            String valueEnc = value instanceof BIEncodable ? ((BIEncodable)value).encodeToString() : ValueDocEncoder.marshal((BValue)value);
            XElem slots = SyntheticModuleTypesSlotsTab.this.root.elem("slots");
            if (slots == null) {
                slots = new XElem("slots");
                SyntheticModuleTypesSlotsTab.this.root.addContent((XContent)slots);
            }
            XElem[] properties = slots.elems("property");
            for (int i = 0; i < properties.length; ++i) {
                if (!name.equalsIgnoreCase(properties[i].get("name"))) continue;
                BDialog.error((BWidget)SyntheticModuleTypesSlotsTab.this.parent, (String)"Duplicate slot", (Object)"A slot already exists with that name.");
                return null;
            }
            XElem slotElem = new XElem("property");
            slotElem.addAttr("name", name);
            slotElem.addAttr("type", typeSpec.encodeToString());
            slotElem.addAttr("flags", Integer.toString(flags));
            slotElem.addAttr("facets", facets.encodeToString());
            slotElem.addAttr("value", valueEnc);
            slots.addContent((XContent)slotElem);
            SyntheticModuleTypesSlotsTab.this.setModified();
            SyntheticModuleTypesSlotsTab.this.table.getModel().updateTable(true);
            SyntheticModuleTypesSlotsTab.this.editButton.setEnabled(SyntheticModuleTypesSlotsTab.this.table.getModel().getRowCount() > 0);
            SyntheticModuleTypesSlotsTab.this.removeButton.setEnabled(SyntheticModuleTypesSlotsTab.this.table.getModel().getRowCount() > 0);
            return null;
        }
    }
}

