/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.synthetic;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.fieldeditors.BPermissionsEditor;
import com.tridium.workbench.synthetic.BSyntheticTypeSpecFE;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class SyntheticModuleTypesAgentsTab {
    private BTable table;
    private BAbstractButton removeButton;
    private BAbstractButton addButton;
    private BAbstractButton editButton;
    private BWidget content;
    private XElem root;
    private XElem rootXml;
    private BWbPlugin parent;

    public SyntheticModuleTypesAgentsTab(BWbPlugin parent) {
        this.parent = parent;
        BBorderPane borderPane = new BBorderPane();
        borderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        BEdgePane edgePane = new BEdgePane();
        borderPane.setContent((BWidget)edgePane);
        this.table = new BTable((TableModel)new Model());
        this.table.setLayout(BLayout.FILL);
        this.table.setController((TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        edgePane.setCenter((BWidget)this.table);
        BBorderPane buttonBorder = new BBorderPane();
        buttonBorder.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        edgePane.setBottom((BWidget)buttonBorder);
        BGridPane buttonGrid = new BGridPane(3);
        buttonGrid.setColumnGap(20.0);
        this.addButton = BButton.make((Command)new AddCommand(parent));
        buttonGrid.add(null, (BValue)this.addButton);
        this.editButton = BButton.make((Command)new EditCommand(parent));
        buttonGrid.add(null, (BValue)this.editButton);
        this.removeButton = BButton.make((Command)new RemoveCommand(parent));
        buttonGrid.add(null, (BValue)this.removeButton);
        buttonBorder.setContent((BWidget)buttonGrid);
        this.content = borderPane;
    }

    public void loadValue(XElem typeXml, XElem rootXml, Context cx) {
        if (this.root != null) {
            this.saveValue(cx);
        }
        this.root = typeXml;
        this.rootXml = rootXml;
        this.table.getModel().updateTable();
        this.table.getSelection().deselectAll();
        this.table.sizeColumnsToFit();
    }

    public void saveValue(Context cx) {
    }

    public BWidget getContent() {
        return this.content;
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getRowCount() {
            if (SyntheticModuleTypesAgentsTab.this.root.elem("agent") != null) {
                return SyntheticModuleTypesAgentsTab.this.root.elems("agent").length;
            }
            return 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Type";
            }
            if (col == 1) {
                return "Permission";
            }
            return "???";
        }

        public Object getSubject(int row) {
            return SyntheticModuleTypesAgentsTab.this.root.elems("agent")[row];
        }

        public Object getValueAt(int row, int col) {
            XElem agent = SyntheticModuleTypesAgentsTab.this.root.elems("agent")[row];
            XElem agentOn = agent.elem("on");
            if (col == 0) {
                return agentOn.get("type");
            }
            if (col == 1) {
                return agent.get("requiredPermissions", "");
            }
            return "???";
        }

        public boolean isColumnSortable(int col) {
            return false;
        }
    }

    private class Selection
    extends TableSelection {
        private Selection() {
        }

        private void updateButtons() {
            boolean isEmpty = this.isEmpty();
            SyntheticModuleTypesAgentsTab.this.editButton.setEnabled(!isEmpty);
            SyntheticModuleTypesAgentsTab.this.removeButton.setEnabled(!isEmpty);
        }

        public void deselect(int row) {
            super.deselect(row);
            this.updateButtons();
        }

        public void deselectAll() {
            super.deselectAll();
            this.updateButtons();
        }

        public void select(int row, boolean clear) {
            super.select(row, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead) {
            super.select(anchor, lead);
            this.updateButtons();
        }

        public void select(int row) {
            super.select(row);
            this.updateButtons();
        }

        public void select(int[] rows) {
            super.select(rows);
            this.updateButtons();
        }

        public void selectAll() {
            super.selectAll();
            this.updateButtons();
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        public int getTextSearchColumn() {
            return 0;
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.getTable().getSelection().select(row, true);
            try {
                SyntheticModuleTypesAgentsTab.this.editButton.getCommand().doInvoke();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        protected BMenu makePopup(TableSubject subject) {
            BMenu menu = new BMenu();
            menu.add("add", SyntheticModuleTypesAgentsTab.this.addButton.getCommand());
            if (subject.getRows().length > 0) {
                menu.add("edit", SyntheticModuleTypesAgentsTab.this.editButton.getCommand());
                menu.add("remove", SyntheticModuleTypesAgentsTab.this.removeButton.getCommand());
            }
            return menu;
        }
    }

    private class RemoveCommand
    extends Command {
        public RemoveCommand(BWidget owner) {
            super(owner, "Remove");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"delete.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            XElem interfaceContainer;
            String prompt = "Remove as agent on type " + SyntheticModuleTypesAgentsTab.this.root.elems("agent")[SyntheticModuleTypesAgentsTab.this.table.getSelection().getRow()].elem("on").get("type") + "?";
            int result = BOptionDialog.confirm((BWidget)this.getShell(), (String)this.getLabel(), (Object)prompt, (int)3);
            if (result != 1) {
                return null;
            }
            SyntheticModuleTypesAgentsTab.this.root.removeContent((XContent)SyntheticModuleTypesAgentsTab.this.root.elems("agent")[SyntheticModuleTypesAgentsTab.this.table.getSelection().getRow()]);
            if (SyntheticModuleTypesAgentsTab.this.table.getModel().getRowCount() == 0 && (interfaceContainer = SyntheticModuleTypesAgentsTab.this.root.elem("interfaces")) != null) {
                XElem[] interfaces = interfaceContainer.elems("interface");
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!interfaces[i].get("class").equals("javax.baja.agent.BIAgent")) continue;
                    interfaceContainer.removeContent((XContent)interfaces[i]);
                }
                if (interfaceContainer.contentSize() == 0) {
                    SyntheticModuleTypesAgentsTab.this.root.removeContent((XContent)interfaceContainer);
                }
            }
            SyntheticModuleTypesAgentsTab.this.table.getModel().updateTable();
            ((Selection)SyntheticModuleTypesAgentsTab.this.table.getSelection()).updateButtons();
            SyntheticModuleTypesAgentsTab.this.parent.setModified();
            return null;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand(BWidget owner) {
            super(owner, "Edit");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"edit.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BPermissions permissions;
            XElem agentElem = SyntheticModuleTypesAgentsTab.this.root.elems("agent")[SyntheticModuleTypesAgentsTab.this.table.getSelection().getRow()];
            BGridPane gridPane = new BGridPane(1);
            gridPane.setHalign(BHalign.left);
            BSyntheticTypeSpecFE typeSpecFE = new BSyntheticTypeSpecFE();
            typeSpecFE.setModuleXml(SyntheticModuleTypesAgentsTab.this.rootXml);
            typeSpecFE.loadValue((BObject)BTypeSpec.make((String)agentElem.elem("on").get("type")));
            gridPane.add(null, (BValue)new BBorderPane((BWidget)typeSpecFE, new BLabel("Agent On")));
            BPermissionsEditor permissionsFE = new BPermissionsEditor();
            try {
                permissions = BPermissions.make((String)agentElem.get("requiredPermissions"));
            }
            catch (XException xe) {
                permissions = BPermissions.DEFAULT;
            }
            permissionsFE.loadValue((BObject)permissions);
            gridPane.add(null, (BValue)new BBorderPane((BWidget)permissionsFE, new BLabel("Permissions")));
            String title = this.getLabel();
            int buttons = 3;
            if (BDialog.open((BWidget)this.getOwner(), (String)title, (Object)gridPane, (int)buttons, null) == 2) {
                return null;
            }
            agentElem.elem("on").setAttr("type", typeSpecFE.saveValue().toString());
            permissions = (BPermissions)permissionsFE.saveValue();
            if (permissions != null) {
                agentElem.setAttr("requiredPermissions", permissionsFE.saveValue().toString());
            }
            SyntheticModuleTypesAgentsTab.this.table.getModel().updateTable();
            SyntheticModuleTypesAgentsTab.this.table.sizeColumnsToFit();
            SyntheticModuleTypesAgentsTab.this.parent.setModified();
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand(BWidget owner) {
            super(owner, "Add");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"add.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BGridPane gridPane = new BGridPane(1);
            gridPane.setHalign(BHalign.left);
            BSyntheticTypeSpecFE typeSpecFE = new BSyntheticTypeSpecFE();
            typeSpecFE.setModuleXml(SyntheticModuleTypesAgentsTab.this.rootXml);
            typeSpecFE.loadValue((BObject)BComponent.TYPE.getTypeSpec());
            SyntheticModuleTypesAgentsTab.this.root.dump();
            SyntheticModuleTypesAgentsTab.this.rootXml.dump();
            typeSpecFE.setFilter(new BSyntheticTypeSpecFE.Filter(){

                public boolean accept(String module, String type) {
                    if (!SyntheticModuleTypesAgentsTab.this.rootXml.get("name").equalsIgnoreCase(module)) {
                        return true;
                    }
                    return !SyntheticModuleTypesAgentsTab.this.root.get("name").equalsIgnoreCase(type);
                }
            });
            gridPane.add(null, (BValue)new BBorderPane((BWidget)typeSpecFE, new BLabel("Agent On")));
            BPermissionsEditor permissionsFE = new BPermissionsEditor();
            gridPane.add(null, (BValue)new BBorderPane((BWidget)permissionsFE, new BLabel("Permissions")));
            String title = this.getLabel();
            int buttons = 3;
            if (BDialog.open((BWidget)this.getOwner(), (String)title, (Object)gridPane, (int)buttons, null) == 2) {
                return null;
            }
            XElem agentElem = new XElem("agent");
            XElem agentOnElem = new XElem("on");
            agentElem.addContent((XContent)agentOnElem);
            agentOnElem.addAttr("type", typeSpecFE.saveValue().toString());
            BPermissions permissions = (BPermissions)permissionsFE.saveValue();
            if (permissions != null) {
                agentElem.addAttr("requiredPermissions", permissionsFE.saveValue().toString());
            }
            SyntheticModuleTypesAgentsTab.this.root.addContent((XContent)agentElem);
            XElem interfaceContainer = SyntheticModuleTypesAgentsTab.this.root.elem("interfaces");
            if (interfaceContainer == null) {
                interfaceContainer = new XElem("interfaces");
                SyntheticModuleTypesAgentsTab.this.root.addContent((XContent)interfaceContainer);
            }
            XElem[] interfaces = interfaceContainer.elems("interface");
            boolean isBIAgent = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].get("class").equals("javax.baja.agent.BIAgent")) continue;
                isBIAgent = true;
            }
            if (!isBIAgent) {
                XElem agentInterface = new XElem("interface");
                agentInterface.setAttr("class", "javax.baja.agent.BIAgent");
                interfaceContainer.addContent((XContent)agentInterface);
            }
            SyntheticModuleTypesAgentsTab.this.table.getModel().updateTable();
            SyntheticModuleTypesAgentsTab.this.table.sizeColumnsToFit();
            ((Selection)SyntheticModuleTypesAgentsTab.this.table.getSelection()).updateButtons();
            SyntheticModuleTypesAgentsTab.this.parent.setModified();
            return null;
        }
    }
}

