/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.synthetic;

import java.util.ArrayList;
import java.util.zip.ZipEntry;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipFileDirectory;
import javax.baja.file.zip.BZipFileEntry;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XElem;

public class SyntheticModuleFilesTab {
    BAbstractButton removeButton;
    BAbstractButton addButton;
    BAbstractButton newFolderButton;
    BAbstractButton openButton;
    OpenCommand openCommand;
    ArrayList deleted = new ArrayList();
    private ArrayList added = new ArrayList();
    BWidget content;
    BWbPlugin parent;
    BZipFile zip;
    BTreeTable table;
    static /* synthetic */ Class class$com$tridium$workbench$synthetic$SyntheticModuleFilesTab$Model$NavTreeTableNode;

    public SyntheticModuleFilesTab(BWbPlugin parent) {
        this.parent = parent;
        BBorderPane borderPane = new BBorderPane();
        borderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        BEdgePane edgePane = new BEdgePane();
        borderPane.setContent((BWidget)edgePane);
        this.table = new BTreeTable((TreeTableModel)new Model());
        this.table.setLayout(BLayout.FILL);
        this.table.setController((TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        edgePane.setCenter((BWidget)this.table);
        BBorderPane buttonBorder = new BBorderPane();
        buttonBorder.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        edgePane.setBottom((BWidget)buttonBorder);
        BGridPane buttonGrid = new BGridPane(4);
        buttonGrid.setColumnGap(20.0);
        this.addButton = BButton.make((Command)new AddCommand(parent));
        buttonGrid.add(null, (BValue)this.addButton);
        this.newFolderButton = BButton.make((Command)new NewFolderCommand(parent));
        buttonGrid.add(null, (BValue)this.newFolderButton);
        this.openButton = BButton.make((Command)new OpenCommand(parent));
        buttonGrid.add(null, (BValue)this.openButton);
        this.removeButton = BButton.make((Command)new RemoveCommand(parent));
        buttonGrid.add(null, (BValue)this.removeButton);
        buttonBorder.setContent((BWidget)buttonGrid);
        this.openButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.openCommand = new OpenCommand(parent);
        this.content = borderPane;
    }

    public void loadValue(XElem elem, BZipFile zip, Context cx) {
        this.zip = zip;
        this.table.getModel().updateTable();
        this.removeButton.setEnabled(!this.table.getSelection().isEmpty());
        this.openButton.setEnabled(!this.table.getSelection().isEmpty());
    }

    public void saveValue(Context cx) {
    }

    public BWidget getContent() {
        return this.content;
    }

    public BZipFileEntry[] getDeleted() {
        BZipFileEntry[] entryArray = new BZipFileEntry[this.deleted.size()];
        for (int i = 0; i < this.deleted.size(); ++i) {
            entryArray[i] = (BZipFileEntry)this.deleted.get(i);
        }
        return entryArray;
    }

    public AddEntry[] getAdded() {
        AddEntry[] entryArray = new AddEntry[this.added.size()];
        for (int i = 0; i < this.added.size(); ++i) {
            entryArray[i] = (AddEntry)this.added.get(i);
        }
        return entryArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Model
    extends TreeTableModel {
        NavTreeTableNode[] roots = null;

        protected Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Size";
                }
                case 2: {
                    return "Last Modified";
                }
            }
            return null;
        }

        public boolean isColumnSortable(int col) {
            return false;
        }

        public TreeTableNode getRoot(int index) {
            if (this.roots == null) {
                this.load();
            }
            return this.roots[index];
        }

        public int getRootCount() {
            if (this.roots == null) {
                this.load();
            }
            return this.roots.length;
        }

        public void addRoot(NavTreeTableNode node) {
            this.load();
            Array array = new Array((Object[])this.roots);
            array.add((Object)node);
            this.roots = (NavTreeTableNode[])array.trim();
            SyntheticModuleFilesTab.this.table.getModel().updateTable();
        }

        public void removeRoot(NavTreeTableNode node) {
            this.load();
            Array array = new Array((Object[])this.roots);
            array.remove((Object)node);
            this.roots = (NavTreeTableNode[])array.trim();
            SyntheticModuleFilesTab.this.table.getModel().updateTable();
        }

        private void load() {
            if (this.roots == null) {
                Array rootsArray = new Array(class$com$tridium$workbench$synthetic$SyntheticModuleFilesTab$Model$NavTreeTableNode == null ? (class$com$tridium$workbench$synthetic$SyntheticModuleFilesTab$Model$NavTreeTableNode = SyntheticModuleFilesTab.class$("com.tridium.workbench.synthetic.SyntheticModuleFilesTab$Model$NavTreeTableNode")) : class$com$tridium$workbench$synthetic$SyntheticModuleFilesTab$Model$NavTreeTableNode);
                BINavNode[] navChildren = SyntheticModuleFilesTab.this.zip.getZipSpace().getNavChildren();
                for (int i = 0; i < navChildren.length; ++i) {
                    if (navChildren[i].getNavName().equalsIgnoreCase("meta-inf")) continue;
                    rootsArray.add((Object)new NavTreeTableNode(navChildren[i], (TreeTableModel)this.getModel()));
                }
                this.roots = (NavTreeTableNode[])rootsArray.trim();
            }
        }

        class NavTreeTableNode
        extends TreeTableNode {
            NavTreeTableNode[] children = null;
            BINavNode navNode;
            NavTreeTableNode parent;
            int depth;

            public NavTreeTableNode(BINavNode navNode, TreeTableModel model) {
                super(model);
                this.navNode = navNode;
                this.parent = null;
                this.depth = 0;
            }

            public NavTreeTableNode(BINavNode navNode, NavTreeTableNode parent, TreeTableModel model) {
                super(model);
                this.navNode = navNode;
                this.parent = parent;
                this.depth = parent != null ? parent.getDepth() + 1 : 0;
            }

            public boolean isGroup() {
                return this.navNode instanceof BIDirectory;
            }

            public Object getValueAt(int col) {
                switch (col) {
                    case 0: {
                        return this.navNode.getNavDisplayName(null);
                    }
                    case 1: {
                        return this.navNode instanceof BIFile ? ((BIFile)this.navNode).getSize() / 1024L + " kb" : "";
                    }
                    case 2: {
                        return this.navNode instanceof BIFile ? ((BIFile)this.navNode).getLastModified().toString(null) : "";
                    }
                }
                return null;
            }

            public int getChildCount() {
                if (this.children == null) {
                    this.load();
                }
                return this.children.length;
            }

            public TreeTableNode getChild(int index) {
                if (this.children == null) {
                    this.load();
                }
                return this.children[index];
            }

            private void load() {
                if (this.children == null) {
                    if (this.navNode instanceof BIDirectory) {
                        BINavNode[] navChildren = this.navNode.getNavChildren();
                        this.children = new NavTreeTableNode[navChildren.length];
                        for (int i = 0; i < navChildren.length; ++i) {
                            this.children[i] = new NavTreeTableNode(navChildren[i], this, this.getModel());
                        }
                    } else {
                        this.children = new NavTreeTableNode[0];
                    }
                }
            }

            public void addChild(NavTreeTableNode node) {
                this.load();
                Array array = new Array((Object[])this.children);
                array.add((Object)node);
                this.children = (NavTreeTableNode[])array.trim();
                ((Model)Model.this).SyntheticModuleFilesTab.this.table.getModel().updateTable();
            }

            public void removeChild(NavTreeTableNode node) {
                this.load();
                Array array = new Array((Object[])this.children);
                array.remove((Object)node);
                this.children = (NavTreeTableNode[])array.trim();
                ((Model)Model.this).SyntheticModuleFilesTab.this.table.getModel().updateTable();
            }

            public TreeTableNode getParent() {
                return this.parent;
            }

            public int getDepth() {
                return this.depth;
            }

            public Object getSubject() {
                return this.navNode;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)this.navNode.getNavIcon());
            }
        }
    }

    protected class Controller
    extends TreeTableController {
        protected Controller() {
        }

        protected BMenu makePopup(TreeTableSubject subject) {
            BMenu menu = new BMenu();
            if (subject.getRows().length == 1) {
                Model model = (Model)SyntheticModuleFilesTab.this.table.getModel();
                Model.NavTreeTableNode node = (Model.NavTreeTableNode)model.rowToNode(subject.getRows()[0]);
                if (!((BIFile)node.navNode).isDirectory()) {
                    menu.add("open", (Command)SyntheticModuleFilesTab.this.openCommand);
                }
            }
            menu.add("add", SyntheticModuleFilesTab.this.addButton.getCommand());
            menu.add("newFolder", SyntheticModuleFilesTab.this.newFolderButton.getCommand());
            if (subject.getRows().length > 0) {
                menu.add("remove", SyntheticModuleFilesTab.this.removeButton.getCommand());
            }
            return menu;
        }
    }

    private class Selection
    extends TreeTableSelection {
        private Selection() {
        }

        private void updateButtons() {
            boolean isEmpty = this.isEmpty();
            SyntheticModuleFilesTab.this.removeButton.setEnabled(!isEmpty);
            SyntheticModuleFilesTab.this.openButton.setEnabled(!isEmpty && !((BIFile)((Model.NavTreeTableNode)this.getTreeTableModel().rowToNode((int)this.getRow())).navNode).isDirectory());
        }

        public void deselect(int row) {
            super.deselect(row);
            this.updateButtons();
        }

        public void deselectAll() {
            super.deselectAll();
            this.updateButtons();
        }

        public void select(int row, boolean clear) {
            super.select(row, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead) {
            super.select(anchor, lead);
            this.updateButtons();
        }

        public void select(int row) {
            super.select(row);
            this.updateButtons();
        }

        public void select(int[] rows) {
            super.select(rows);
            this.updateButtons();
        }

        public void selectAll() {
            super.selectAll();
            this.updateButtons();
        }
    }

    private class RemoveCommand
    extends Command {
        public RemoveCommand(BWidget owner) {
            super(owner, "Remove");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"delete.png"));
        }

        public synchronized boolean isEnabled() {
            return !SyntheticModuleFilesTab.this.table.getSelection().isEmpty();
        }

        public CommandArtifact doInvoke() throws Exception {
            int[] rows = SyntheticModuleFilesTab.this.table.getSelection().getRows();
            if (rows.length == 0) {
                return null;
            }
            Model model = (Model)SyntheticModuleFilesTab.this.table.getModel();
            for (int i = 0; i < rows.length; ++i) {
                this.deleteRow((BIFile)model.getSubject(rows[i]), (Model.NavTreeTableNode)model.rowToNode(rows[i]));
            }
            model.updateTreeTable(false);
            SyntheticModuleFilesTab.this.parent.setModified();
            return null;
        }

        private void deleteRow(BIFile file, Model.NavTreeTableNode node) {
            if (file.isDirectory()) {
                while (node.children.length > 0) {
                    this.deleteRow((BIFile)node.children[0].navNode, node.children[0]);
                }
                if (node.getParent() != null) {
                    ((Model.NavTreeTableNode)node.getParent()).removeChild(node);
                } else {
                    ((Model)SyntheticModuleFilesTab.this.table.getModel()).removeRoot(node);
                }
                return;
            }
            if (node.getParent() != null) {
                ((Model.NavTreeTableNode)node.getParent()).removeChild(node);
            } else {
                ((Model)SyntheticModuleFilesTab.this.table.getModel()).removeRoot(node);
            }
            if (file.getStore() instanceof BZipFileEntry) {
                BZipFileEntry entry = (BZipFileEntry)file.getStore();
                SyntheticModuleFilesTab.this.deleted.add(entry);
            }
            SyntheticModuleFilesTab.this.table.getSelection().deselectAll();
        }
    }

    private class OpenCommand
    extends Command {
        public OpenCommand(BWidget owner) {
            super(owner, "Open");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"views/view.png"));
        }

        public synchronized boolean isEnabled() {
            return !SyntheticModuleFilesTab.this.table.getSelection().isEmpty();
        }

        public CommandArtifact doInvoke() throws Exception {
            int row = SyntheticModuleFilesTab.this.table.getSelection().getRow();
            if (row == -1) {
                return null;
            }
            Model model = (Model)SyntheticModuleFilesTab.this.table.getModel();
            Model.NavTreeTableNode node = (Model.NavTreeTableNode)model.rowToNode(row);
            if (((BIFile)node.navNode).isDirectory()) {
                return null;
            }
            BIFile file = (BIFile)model.getSubject(row);
            BWbShell.getWbShell(SyntheticModuleFilesTab.this.parent).hyperlink(new HyperlinkInfo(file.getAbsoluteOrd(), BHyperlinkMode.newTab));
            return null;
        }
    }

    private class NewFolderCommand
    extends Command {
        public NewFolderCommand(BWidget owner) {
            super(owner, "New Folder");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"newFolder.png"));
        }

        public synchronized boolean isEnabled() {
            return !SyntheticModuleFilesTab.this.table.getSelection().isEmpty();
        }

        public CommandArtifact doInvoke() throws Exception {
            int row = SyntheticModuleFilesTab.this.table.getSelection().getRow();
            String folderName = BDialog.prompt((BWidget)SyntheticModuleFilesTab.this.parent, (String)"New Folder Name", (String)"Folder", (int)32);
            if (folderName == null) {
                return null;
            }
            if (folderName.length() == 0 || !FilePath.isValidName((String)folderName)) {
                BDialog.error((BWidget)SyntheticModuleFilesTab.this.parent, (Object)"Illegal name.");
                return null;
            }
            Model model = (Model)SyntheticModuleFilesTab.this.table.getModel();
            if (row != -1) {
                BIFile file = (BIFile)model.getSubject(row);
                Model.NavTreeTableNode node = (Model.NavTreeTableNode)model.rowToNode(row);
                if (!file.isDirectory()) {
                    if (node.getParent() == null) {
                        for (int i = 0; i < model.getRootCount(); ++i) {
                            if (!((Model.NavTreeTableNode)model.getRoot((int)i)).navNode.getNavName().equalsIgnoreCase(folderName)) continue;
                            BDialog.error((BWidget)SyntheticModuleFilesTab.this.parent, (Object)("Duplicate folder already exists called \"" + folderName + "\""));
                            return null;
                        }
                        FilePath newEntryPath = new FilePath(folderName);
                        BDirectory directory = new BDirectory((BIFileStore)new BZipFileDirectory(SyntheticModuleFilesTab.this.zip.getZipSpace(), newEntryPath));
                        Model model2 = model;
                        ((Object)((Object)model2)).getClass();
                        Model.NavTreeTableNode newNode = model2.new Model.NavTreeTableNode((BINavNode)directory, null, model);
                        model.addRoot(newNode);
                        model.updateTreeTable(false);
                        SyntheticModuleFilesTab.this.parent.setModified();
                        return null;
                    }
                    node = (Model.NavTreeTableNode)node.getParent();
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    if (!((Model.NavTreeTableNode)node.getChild((int)i)).navNode.getNavName().equalsIgnoreCase(folderName)) continue;
                    BDialog.error((BWidget)SyntheticModuleFilesTab.this.parent, (Object)("Duplicate folder already exists called \"" + folderName + "\""));
                    return null;
                }
                FilePath newEntryPath = ((BIFile)node.navNode).getFilePath().merge(folderName);
                BDirectory directory = new BDirectory((BIFileStore)new BZipFileDirectory(SyntheticModuleFilesTab.this.zip.getZipSpace(), newEntryPath));
                Model model3 = model;
                ((Object)((Object)model3)).getClass();
                Model.NavTreeTableNode newNode = model3.new Model.NavTreeTableNode((BINavNode)directory, node, model);
                node.setExpanded(true);
                node.addChild(newNode);
            } else {
                for (int i = 0; i < model.getRootCount(); ++i) {
                    if (!((Model.NavTreeTableNode)model.getRoot((int)i)).navNode.getNavName().equalsIgnoreCase(folderName)) continue;
                    BDialog.error((BWidget)SyntheticModuleFilesTab.this.parent, (Object)("Duplicate folder already exists called \"" + folderName + "\""));
                    return null;
                }
                FilePath newEntryPath = new FilePath(folderName);
                BDirectory directory = new BDirectory((BIFileStore)new BZipFileDirectory(SyntheticModuleFilesTab.this.zip.getZipSpace(), newEntryPath));
                Model model4 = model;
                ((Object)((Object)model4)).getClass();
                Model.NavTreeTableNode newNode = model4.new Model.NavTreeTableNode((BINavNode)directory, null, model);
                model.addRoot(newNode);
            }
            model.updateTreeTable(false);
            SyntheticModuleFilesTab.this.parent.setModified();
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand(BWidget owner) {
            super(owner, "Add File");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"add.png"));
        }

        public synchronized boolean isEnabled() {
            return !SyntheticModuleFilesTab.this.table.getSelection().isEmpty();
        }

        public CommandArtifact doInvoke() throws Exception {
            int row = SyntheticModuleFilesTab.this.table.getSelection().getRow();
            BOrd newFileOrd = BFileChooser.showOpen((BWidget)SyntheticModuleFilesTab.this.parent);
            if (newFileOrd == null || newFileOrd.isNull()) {
                return null;
            }
            BIFile newFile = (BIFile)newFileOrd.resolve().get();
            Model model = (Model)SyntheticModuleFilesTab.this.table.getModel();
            if (row != -1 && model.getRowCount() > 0) {
                BIFile file = (BIFile)model.getSubject(row);
                Model.NavTreeTableNode node = (Model.NavTreeTableNode)model.rowToNode(row);
                if (!file.isDirectory()) {
                    if (node.getParent() == null) {
                        Model model2 = model;
                        ((Object)((Object)model2)).getClass();
                        Model.NavTreeTableNode newNode = model2.new Model.NavTreeTableNode((BINavNode)newFile, null, model);
                        model.addRoot(newNode);
                        FilePath newEntryPath = new FilePath(newFile.getFileName());
                        SyntheticModuleFilesTab.this.added.add(new AddEntry(newFile, new BZipFileEntry(null, newFile.getFilePath(), new ZipEntry(newEntryPath.toString().substring(5)))));
                        model.updateTreeTable(model.getRowCount() == 1);
                        SyntheticModuleFilesTab.this.parent.setModified();
                        return null;
                    }
                    node = (Model.NavTreeTableNode)node.getParent();
                }
                Model model3 = model;
                ((Object)((Object)model3)).getClass();
                Model.NavTreeTableNode newNode = model3.new Model.NavTreeTableNode((BINavNode)newFile, node, model);
                node.addChild(newNode);
                node.setExpanded(true);
                FilePath newEntryPath = ((BIFile)node.navNode).getFilePath().merge(newFile.getFileName());
                BZipFileEntry newEntry = new BZipFileEntry(null, newFile.getFilePath(), new ZipEntry(newEntryPath.toString().substring(5)));
                SyntheticModuleFilesTab.this.added.add(new AddEntry(newFile, newEntry));
            } else {
                Model model4 = model;
                ((Object)((Object)model4)).getClass();
                Model.NavTreeTableNode newNode = model4.new Model.NavTreeTableNode((BINavNode)newFile, null, model);
                model.addRoot(newNode);
                FilePath newEntryPath = new FilePath(newFile.getFileName());
                BZipFileEntry newEntry = new BZipFileEntry(null, newFile.getFilePath(), new ZipEntry(newEntryPath.toString().substring(5)));
                SyntheticModuleFilesTab.this.added.add(new AddEntry(newFile, newEntry));
            }
            model.updateTreeTable(model.getRowCount() == 1);
            SyntheticModuleFilesTab.this.parent.setModified();
            return null;
        }
    }

    public static final class AddEntry {
        BZipFileEntry entry;
        BIFile file;

        public AddEntry(BIFile file, BZipFileEntry entry) {
            this.entry = entry;
            this.file = file;
        }
    }
}

