/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.synthetic;

import com.tridium.sys.NreLib;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.synthetic.SyntheticModuleDependenciesTab;
import com.tridium.workbench.synthetic.SyntheticModuleFilesTab;
import com.tridium.workbench.synthetic.SyntheticModuleTypesTab;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipFileEntry;
import javax.baja.file.zip.BZipSpace;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class BSyntheticModuleFileView
extends BWbView {
    public static final Action updateXml = BSyntheticModuleFileView.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action updateTabs = BSyntheticModuleFileView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$synthetic$BSyntheticModuleFileView == null ? (class$com$tridium$workbench$synthetic$BSyntheticModuleFileView = BSyntheticModuleFileView.class$("com.tridium.workbench.synthetic.BSyntheticModuleFileView")) : class$com$tridium$workbench$synthetic$BSyntheticModuleFileView));
    XElem root;
    SyntheticModuleTypesTab typesFE;
    SyntheticModuleDependenciesTab dependenciesFE;
    SyntheticModuleFilesTab filesFE;
    BTabbedPane tabbedPane;
    BLabel headerLabel;
    BStringFE nameFE;
    BStringFE descriptionFE;
    BStringFE vendorFE;
    BStringFE versionFE;
    BBorderPane buttonBorderPane;
    static /* synthetic */ Class class$com$tridium$workbench$synthetic$BSyntheticModuleFileView;

    public void updateXml(BWidgetEvent event) {
        this.invoke(updateXml, (BValue)event, null);
    }

    public void updateTabs() {
        this.invoke(updateTabs, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSyntheticModuleFileView() {
        BBorderPane borderPane = new BBorderPane();
        borderPane.setPadding(BInsets.make((double)0.0, (double)10.0, (double)10.0, (double)10.0));
        borderPane.setBorder(BBorder.make((double)0.0, (int)0, (BBrush)BColor.DEFAULT.toBrush()));
        this.setContent((BWidget)borderPane);
        BEdgePane edgePane = new BEdgePane();
        borderPane.setContent((BWidget)edgePane);
        BBorderPane topBorderPane = new BBorderPane();
        topBorderPane.setPadding(BInsets.make((double)10.0, (double)0.0, (double)10.0, (double)0.0));
        topBorderPane.setBorder(BBorder.make((double)0.0, (int)0, (BBrush)BColor.DEFAULT.toBrush()));
        edgePane.setTop((BWidget)topBorderPane);
        BGridPane topGridPane = new BGridPane(1);
        topGridPane.setHalign(BHalign.left);
        topGridPane.setColumnAlign(BHalign.left);
        topBorderPane.setContent((BWidget)topGridPane);
        BGridPane headerPane = new BGridPane();
        topGridPane.add(null, (BValue)headerPane);
        headerPane.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.make((String)"module://icons/x32/syntheticModule.png"))));
        this.headerLabel = new BLabel("Synthetic Module");
        this.headerLabel.setFont(BFont.make((String)BFont.DEFAULT.getName(), (double)(BFont.DEFAULT.getSize() * 1.5)));
        headerPane.add(null, (BValue)this.headerLabel);
        BGridPane modulePropertiesPane = new BGridPane();
        modulePropertiesPane.setColumnGap(25.0);
        topGridPane.add(null, (BValue)modulePropertiesPane);
        BGridPane moduleLeftPropertiesPane = new BGridPane();
        modulePropertiesPane.add(null, (BValue)moduleLeftPropertiesPane);
        moduleLeftPropertiesPane.add(null, (BValue)new BLabel("Name"));
        this.nameFE = new BStringFE();
        moduleLeftPropertiesPane.add(null, (BValue)this.nameFE);
        moduleLeftPropertiesPane.add(null, (BValue)new BLabel("Description"));
        this.descriptionFE = new BStringFE();
        moduleLeftPropertiesPane.add(null, (BValue)this.descriptionFE);
        BGridPane moduleRightPropertiesPane = new BGridPane();
        modulePropertiesPane.add(null, (BValue)moduleRightPropertiesPane);
        moduleRightPropertiesPane.add(null, (BValue)new BLabel("Vendor"));
        this.vendorFE = new BStringFE();
        moduleRightPropertiesPane.add(null, (BValue)this.vendorFE);
        moduleRightPropertiesPane.add(null, (BValue)new BLabel("Version"));
        this.versionFE = new BStringFE();
        moduleRightPropertiesPane.add(null, (BValue)this.versionFE);
        this.tabbedPane = new BTabbedPane();
        edgePane.setCenter((BWidget)this.tabbedPane);
        this.typesFE = new SyntheticModuleTypesTab(this);
        this.tabbedPane.addPane(new BLabelPane(new BLabel("Types"), this.typesFE.getContent()));
        this.dependenciesFE = new SyntheticModuleDependenciesTab(this);
        this.tabbedPane.addPane(new BLabelPane(new BLabel("Dependencies"), this.dependenciesFE.getContent()));
        this.filesFE = new SyntheticModuleFilesTab(this);
        this.tabbedPane.addPane(new BLabelPane(new BLabel("Files"), this.filesFE.getContent()));
        this.buttonBorderPane = new BBorderPane();
        this.buttonBorderPane.setBorder(BBorder.make((double)0.0, (int)0, (BBrush)BColor.DEFAULT.toBrush()));
        this.buttonBorderPane.setPadding(BInsets.make((double)20.0, (double)10.0, (double)0.0, (double)10.0));
        edgePane.setBottom((BWidget)this.buttonBorderPane);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.linkTo((BComponent)this, (Slot)BWbPlugin.pluginModified, (Slot)updateXml);
        this.linkTo((BComponent)this.tabbedPane, (Slot)BTabbedPane.selectionModified, (Slot)updateXml);
        BZipFile zipFile = (BZipFile)value;
        BZipSpace space = (BZipSpace)zipFile.open();
        BIFile zipEntry = space.findFile(new FilePath("META-INF/module.xml"));
        if (zipEntry == null) {
            zipEntry = space.findFile(new FilePath("meta-inf/module.xml"));
        }
        if (zipEntry == null) {
            throw new BajaRuntimeException("Module does not include manifest.");
        }
        this.root = XParser.make((InputStream)zipEntry.getInputStream()).parse();
        String moduleName = zipFile.getFileName().substring(0, zipFile.getFileName().lastIndexOf(46));
        this.nameFE.loadValue((BObject)BString.make((String)moduleName), context);
        if (this.root.get("description", null) != null) {
            this.descriptionFE.loadValue((BObject)BString.make((String)this.root.get("description")), context);
        } else {
            this.descriptionFE.loadValue((BObject)BString.DEFAULT, context);
        }
        this.vendorFE.loadValue((BObject)BString.make((String)this.root.get("vendor")), context);
        this.versionFE.loadValue((BObject)BString.make((String)this.root.get("vendorVersion")), context);
        this.headerLabel.setText("Module " + moduleName);
        this.linkTo((BComponent)this.nameFE, (Slot)BWbPlugin.pluginModified, (Slot)BWbView.setModified);
        this.linkTo((BComponent)this.descriptionFE, (Slot)BWbPlugin.pluginModified, (Slot)BWbView.setModified);
        this.linkTo((BComponent)this.vendorFE, (Slot)BWbPlugin.pluginModified, (Slot)BWbView.setModified);
        this.linkTo((BComponent)this.versionFE, (Slot)BWbPlugin.pluginModified, (Slot)BWbView.setModified);
        this.typesFE.loadValue(this.root, moduleName, context);
        this.dependenciesFE.loadValue(this.root, context);
        this.filesFE.loadValue(this.root, zipFile, context);
        BGridPane buttonGrid = new BGridPane();
        this.buttonBorderPane.setContent((BWidget)buttonGrid);
        buttonGrid.setColumnGap(20.0);
        try {
            buttonGrid.add(null, (BValue)BButton.make((Command)BNiagaraWbShell.getWbShell(this).getSaveCommand()));
            buttonGrid.add(null, (BValue)BButton.make((Command)BNiagaraWbShell.getWbShell(this).getRefreshCommand()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.doLoadValue(value, context);
    }

    public void doUpdateXml(BWidgetEvent event, Context cx) {
        try {
            String moduleName = this.nameFE.saveValue().toString(cx);
            this.root.setAttr("name", moduleName);
            this.root.setAttr("description", this.descriptionFE.saveValue().toString(cx));
            this.typesFE.saveValue(cx);
            this.dependenciesFE.updateDependencies();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        String moduleName = this.nameFE.saveValue().toString(cx);
        this.root.setAttr("name", moduleName);
        this.root.setAttr("description", this.descriptionFE.saveValue().toString(cx));
        this.root.setAttr("vendor", this.vendorFE.saveValue().toString(cx));
        this.root.setAttr("bajaVersion", "1.0");
        this.root.setAttr("preferredSymbol", this.root.get("preferredSymbol", moduleName));
        this.root.setAttr("bajaVersion", "1.0");
        this.root.setAttr("synthetic", "true");
        this.root.setAttr("buildDate", BAbsTime.now().toString(cx));
        this.root.setAttr("buildMillis", Long.toString(BAbsTime.now().getMillis()));
        this.root.setAttr("buildHost", NreLib.getLocalHost().getHostName());
        this.typesFE.saveValue(cx);
        this.doUpdateXml(null, cx);
        if (!this.versionFE.isModified()) {
            BGridPane pane = new BGridPane(1);
            pane.add(null, (BValue)new BLabel("Would you like to update the module version?"));
            BTextField field = new BTextField(this.root.get("vendorVersion"), 10);
            pane.add(null, (BValue)field);
            int result = BOptionDialog.open((BWidget)this, (String)"Module Version", (Object)pane, (int)12, (BImage)BOptionDialog.QUESTION_ICON);
            if (result == 4) {
                this.root.setAttr("vendorVersion", field.getText());
                this.versionFE.loadValue((BObject)BString.make((String)field.getText()), cx);
            }
        } else {
            this.root.setAttr("vendorVersion", this.versionFE.saveValue().toString(cx));
        }
        String sourceFileName = BFileSystem.INSTANCE.pathToLocalFile(((BZipFile)value).getFilePath()).getAbsolutePath();
        String targetFileName = BFileSystem.INSTANCE.pathToLocalFile(((BZipFile)value).getFilePath().getParent().merge(moduleName + ".sjar")).getAbsolutePath();
        File targetFile = new File(targetFileName);
        File sourceFile = new File(sourceFileName);
        if (sourceFileName.equals(targetFileName)) {
            File backupFile = new File(sourceFileName + ".old");
            FileOutputStream oldFileOutputStream = new FileOutputStream(backupFile);
            FileUtil.pipe((InputStream)new FileInputStream(sourceFile), (OutputStream)oldFileOutputStream);
            oldFileOutputStream.close();
            sourceFile = backupFile;
        } else {
            BZipFile zipFile = (BZipFile)this.getCurrentValue();
            if (zipFile != null) {
                zipFile.close();
            }
            sourceFile = new File(sourceFileName);
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetFile));
        out.putNextEntry(new ZipEntry("META-INF/module.xml"));
        XWriter writer = new XWriter((OutputStream)out);
        this.root.write(writer);
        writer.flush();
        SyntheticModuleFilesTab.AddEntry[] addedFiles = this.filesFE.getAdded();
        BZipFileEntry[] deletedFiles = this.filesFE.getDeleted();
        ZipFile zip = new ZipFile(sourceFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            int i;
            ZipEntry entry = entries.nextElement();
            if (entry.getName().equalsIgnoreCase("meta-inf/module.xml") || entry.getName().endsWith(".class")) continue;
            boolean deleted = false;
            for (i = 0; i < deletedFiles.length; ++i) {
                if (!entry.getName().equals(deletedFiles[i].getFilePath().toString().substring(5))) continue;
                deleted = true;
                break;
            }
            for (i = 0; i < addedFiles.length; ++i) {
                if (!entry.getName().equals(addedFiles[i].entry.getFilePath().toString().substring(5))) continue;
                deleted = true;
                break;
            }
            if (deleted) continue;
            out.putNextEntry(entry);
            FileUtil.pipe((InputStream)zip.getInputStream(entry), (OutputStream)out);
        }
        for (int i = 0; i < addedFiles.length; ++i) {
            out.putNextEntry(addedFiles[i].entry.getZipEntry());
            FileUtil.pipe((InputStream)addedFiles[i].file.getInputStream(), (OutputStream)out);
        }
        try {
            out.close();
            zip.close();
            if (!sourceFile.delete()) {
                throw new Exception("Unable to remove source file: " + sourceFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.doSaveValue(value, cx);
    }

    public void deactivated() {
        BZipFile zipFile = (BZipFile)this.getCurrentValue();
        if (zipFile != null) {
            zipFile.close();
        }
    }

    public void doUpdateTabs() {
        this.typesFE.updateTabs();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

