/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.slotsheet;

import com.tridium.util.ObjectUtil;
import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import com.tridium.workbench.slotsheet.BSlotSheet;
import com.tridium.workbench.slotsheet.ConfigFacetsCommand;
import com.tridium.workbench.util.BFlagConfig;
import com.tridium.workbench.util.ConfigFlagsCommand;
import com.tridium.workbench.util.WbUtil;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.SetDisplayNameCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.commands.ComponentRenameCommand;
import javax.baja.workbench.commands.ComponentReorderCommand;

public class SlotSheetCommands {
    static BTypeSpec lastType = BTypeSpec.make((String)"baja", (String)"String");
    final UiLexicon lex = UiLexicon.bajaui();
    static String lastName = "newSlot";
    public final BSlotSheet sheet;
    public AddCommand add;
    public CopyCommand copy;
    public DeleteCommand delete;
    public RenameCommand rename;
    public FlagsCommand flags;
    public FacetsCommand facets;
    public ReorderCommand reorder;
    public DisplayNameCommand displayName;
    public BajadocForTypeCommand bajadocForType;

    public SlotSheetCommands(BSlotSheet sheet) {
        this.sheet = sheet;
        this.add = new AddCommand();
        this.copy = new CopyCommand();
        this.delete = new DeleteCommand();
        this.rename = new RenameCommand();
        this.flags = new FlagsCommand();
        this.facets = new FacetsCommand();
        this.reorder = new ReorderCommand();
        this.displayName = new DisplayNameCommand();
        this.bajadocForType = new BajadocForTypeCommand();
        this.rename.setEnabled(false);
        this.flags.setEnabled(false);
    }

    public BMenu[] getViewMenus() {
        BMenu menu = UiLexicon.bajaui().buildMenu("slotsheet.menu.label");
        menu.add("add", (Command)this.add);
        menu.add("rename", (Command)this.rename);
        menu.add("flags", (Command)this.flags);
        menu.add("facets", (Command)this.facets);
        menu.add("reorder", (Command)this.reorder);
        menu.add("displayName", (Command)this.displayName);
        menu.add("sep0", (BValue)new BSeparator());
        menu.add("bajadocForType", (Command)this.bajadocForType);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        bar.add("add", (Command)this.add);
        bar.add("rename", (Command)this.rename);
        bar.add("flags", (Command)this.flags);
        bar.add("reorder", (Command)this.reorder);
        return bar;
    }

    public void updateCommands() {
        BIPropertyContainer component = this.sheet.component;
        Slot[] slots = this.sheet.getSelectedSlots();
        int count = slots.length;
        boolean allDynamics = count > 0;
        boolean allComponents = count > 0;
        for (int i = 0; i < slots.length; ++i) {
            Slot slot = slots[i];
            BValue value = null;
            if (slot.isProperty()) {
                value = component.get(slot.asProperty());
            }
            allDynamics &= slots[i].isDynamic();
            allComponents = allComponents && value instanceof BComponent;
        }
        this.delete.setEnabled(allDynamics);
        this.copy.setEnabled(allComponents);
        this.rename.setEnabled(allDynamics);
        this.facets.setEnabled(allDynamics);
        this.flags.setEnabled(count > 0);
        this.displayName.setEnabled(count == 1);
        this.bajadocForType.setEnabled(count == 1 && slots[0].isProperty());
        this.sheet.setCommandEnabled(1, this.copy.isEnabled());
        this.sheet.setCommandEnabled(4, this.delete.isEnabled());
        this.sheet.setCommandEnabled(5, this.rename.isEnabled());
    }

    private boolean forceUpdate() {
        if (this.sheet.component instanceof BComponent) {
            return !((BComponent)this.sheet.component).isMounted();
        }
        return true;
    }

    void delete(BIPropertyContainer c, Slot slot, Context tx) {
        if (slot.isFrozen()) {
            return;
        }
        c.remove(slot.asProperty(), tx);
    }

    static BNameMap buildNewNameMap(BIPropertyContainer c, String slotName, String newDisplay) {
        BNameMap existing = null;
        BValue x = c.get("displayNames");
        if (x instanceof BNameMap) {
            existing = (BNameMap)x;
        }
        HashMap<String, BFormat> map = new HashMap<String, BFormat>();
        Slot[] slots = c.getSlotsArray();
        for (int i = 0; i < slots.length; ++i) {
            BFormat old;
            Slot s = slots[i];
            String n = s.getName();
            if (n.equals(slotName)) {
                if (newDisplay.length() <= 0) continue;
                map.put(n, BFormat.make((String)newDisplay));
                continue;
            }
            if (existing == null || (old = existing.get(n)) == null) continue;
            map.put(n, old);
        }
        return BNameMap.make(map);
    }

    class BajadocForTypeCommand
    extends SlotSheetCommand {
        public BajadocForTypeCommand() {
            super("slotsheet.commands.bajadocForType");
        }

        public CommandArtifact doInvoke() throws Exception {
            Property prop = (Property)SlotSheetCommands.this.sheet.getSelectedSlots()[0];
            BValue value = SlotSheetCommands.this.sheet.component.get(prop);
            BOrd ord = ObjectUtil.getReferenceHelpOrd((BObject)value);
            BWidgetShell shell = this.getShell();
            if (shell instanceof BWbShell) {
                ((BWbShell)shell).hyperlink(ord);
            }
            return null;
        }
    }

    class DisplayNameCommand
    extends SlotSheetCommand {
        int row;

        public DisplayNameCommand() {
            super("slotsheet.commands.displayName");
        }

        public CommandArtifact doInvoke() throws Exception {
            BSlotSheet.SlotEntry se = SlotSheetCommands.this.sheet.getSelectedEntries()[0];
            Slot slot = se.slot;
            BIPropertyContainer comp = SlotSheetCommands.this.sheet.component;
            String newDisplayName = SetDisplayNameCommand.promptForNewDisplayName((BWidget)this.getOwner(), (BIPropertyContainer)comp, (String)se.toDisplayName());
            if (newDisplayName == null) {
                return null;
            }
            BNameMap newNameMap = SlotSheetCommands.buildNewNameMap(comp, slot.getName(), newDisplayName);
            Property prop = comp.getProperty("displayNames");
            if (newNameMap.isNull()) {
                if (prop != null) {
                    comp.remove(prop, null);
                }
            } else if (prop == null) {
                comp.add("displayNames", (BValue)newNameMap, 261, null, null);
            } else {
                comp.set(prop, (BValue)newNameMap, null);
            }
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return null;
        }
    }

    public class ReorderCommand
    extends SlotSheetCommand {
        public ReorderCommand() {
            super("commands.reorder");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer c = SlotSheetCommands.this.sheet.component;
            CommandArtifact result = new ComponentReorderCommand((BWidget)SlotSheetCommands.this.sheet, c).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return result;
        }
    }

    public class FacetsCommand
    extends SlotSheetCommand {
        public FacetsCommand() {
            super("commands.configFacets");
        }

        public CommandArtifact doInvoke() throws Exception {
            Slot[] slots = SlotSheetCommands.this.sheet.getSelectedSlots();
            Property[] props = new Property[slots.length];
            System.arraycopy(slots, 0, props, 0, props.length);
            BIPropertyContainer c = SlotSheetCommands.this.sheet.component;
            CommandArtifact result = new ConfigFacetsCommand((BWidget)SlotSheetCommands.this.sheet, c, props).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return result;
        }
    }

    public class FlagsCommand
    extends SlotSheetCommand {
        public FlagsCommand() {
            super("commands.configFlags");
        }

        public CommandArtifact doInvoke() throws Exception {
            Slot[] slots = SlotSheetCommands.this.sheet.getSelectedSlots();
            BIPropertyContainer c = SlotSheetCommands.this.sheet.component;
            CommandArtifact result = new ConfigFlagsCommand((BWidget)SlotSheetCommands.this.sheet, c, slots).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return result;
        }
    }

    public class RenameCommand
    extends SlotSheetCommand {
        public RenameCommand() {
            super("slotsheet.commands.rename");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer c = SlotSheetCommands.this.sheet.component;
            Slot[] slots = SlotSheetCommands.this.sheet.getSelectedSlots();
            BIPropertyContainer[] comps = new BIPropertyContainer[slots.length];
            Property[] props = new Property[slots.length];
            for (int i = 0; i < slots.length; ++i) {
                comps[i] = c;
                props[i] = (Property)slots[i];
            }
            CommandArtifact result = new ComponentRenameCommand((BWidget)SlotSheetCommands.this.sheet, comps, props, null).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return result;
        }
    }

    public class DeleteCommand
    extends SlotSheetCommand {
        public DeleteCommand() {
            super("commands.delete");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer component = SlotSheetCommands.this.sheet.component;
            boolean useTx = component instanceof BComponent;
            Context tx = useTx ? Transaction.start((BComponent)((BComponent)component), null) : null;
            Slot[] slots = SlotSheetCommands.this.sheet.getSelectedSlots();
            if (WbUtil.compositeDeletionWarning((BWidget)SlotSheetCommands.this.sheet, component, slots) == 2) {
                return null;
            }
            for (int i = 0; i < slots.length; ++i) {
                SlotSheetCommands.this.delete(component, slots[i], tx);
            }
            if (useTx) {
                Transaction.end((BComponent)((BComponent)component), (Context)tx);
            }
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return null;
        }
    }

    public class CopyCommand
    extends SlotSheetCommand {
        public CopyCommand() {
            super("commands.copy");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer component = SlotSheetCommands.this.sheet.component;
            Slot[] slots = SlotSheetCommands.this.sheet.getSelectedSlots();
            BComponent[] kids = new BComponent[slots.length];
            for (int i = 0; i < kids.length; ++i) {
                kids[i] = (BComponent)component.get(slots[i].asProperty());
            }
            Mark mark = new Mark((BObject[])kids);
            TransferEnvelope envelope = TransferEnvelope.make((Mark)mark);
            Clipboard.getDefault().setContents(envelope);
            Mark.setCurrent((Mark)mark);
            return null;
        }
    }

    public class AddCommand
    extends SlotSheetCommand
    implements ObjectUtil.NameContainer {
        public AddCommand() {
            super("slotsheet.commands.add");
        }

        public boolean contains(String name) {
            return SlotSheetCommands.this.sheet.component.getSlot(SlotPath.escape((String)name)) != null;
        }

        public CommandArtifact doInvoke() throws Exception {
            String name = ObjectUtil.generateUniqueSlotName((String)lastName, (ObjectUtil.NameContainer)this);
            BTextField nameEditor = new BTextField(name, 25);
            BGridPane nameInner = new BGridPane();
            nameInner.setHalign(BHalign.left);
            nameInner.add(null, (BValue)nameEditor);
            BBorderPane namePane = new BBorderPane((BWidget)nameInner, "Name");
            BTypeSpecFE typeEditor = new BTypeSpecFE();
            BFacets facets = BFacets.make((String)"allowNull", (BIDataValue)BBoolean.FALSE, (String)"targetType", (BIDataValue)BString.make((String)"baja:Value"), (String)"showAbstract", (BIDataValue)BBoolean.FALSE);
            typeEditor.loadValue((BObject)lastType, (Context)facets);
            BGridPane typeInner = new BGridPane();
            typeInner.setHalign(BHalign.left);
            typeInner.add(null, (BValue)typeEditor);
            BBorderPane typePane = new BBorderPane((BWidget)typeInner, "Type");
            BFlagConfig flagEditor = new BFlagConfig(SlotSheetCommands.this.sheet.component, null);
            BGridPane flagInner = new BGridPane();
            flagInner.setHalign(BHalign.left);
            flagInner.add(null, (BValue)flagEditor);
            BBorderPane flagPane = new BBorderPane((BWidget)flagInner, "Flags");
            BGridPane pane = new BGridPane(1);
            pane.setColumnAlign(BHalign.fill);
            pane.add(null, (BValue)namePane);
            pane.add(null, (BValue)typePane);
            pane.add(null, (BValue)flagPane);
            String title = this.getLabel();
            int buttons = 3;
            if (BDialog.open((BWidget)SlotSheetCommands.this.sheet, (String)title, (Object)pane, (int)buttons, null) == 2) {
                return null;
            }
            lastName = nameEditor.getText();
            name = SlotPath.escape((String)nameEditor.getText());
            BTypeSpec typeSpec = lastType = (BTypeSpec)typeEditor.saveValue();
            int flags = flagEditor.save();
            BValue value = (BValue)typeSpec.getInstance();
            SlotSheetCommands.this.sheet.component.add(name, value, flags, null, null);
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return null;
        }
    }

    public class SlotSheetCommand
    extends Command {
        public SlotSheetCommand(String keyBase) {
            super((BWidget)SlotSheetCommands.this.sheet, UiLexicon.bajaui().module, keyBase);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog.message((BWidget)SlotSheetCommands.this.sheet, (Object)("Incomplete: " + this.getLabel()));
            return null;
        }
    }
}

