/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.slotsheet;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.slotsheet.SlotSheetCommands;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.workbench.view.BWbComponentView;

public class BSlotSheet
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$slotsheet$BSlotSheet == null ? (class$com$tridium$workbench$slotsheet$BSlotSheet = BSlotSheet.class$("com.tridium.workbench.slotsheet.BSlotSheet")) : class$com$tridium$workbench$slotsheet$BSlotSheet));
    static BFont overrideFont = BFont.make((String)Theme.table().getCellFont().getName(), (double)Theme.table().getCellFont().getSize(), (int)1);
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexProperty = this.lex.getText("slotsheet.property");
    final String lexAction = this.lex.getText("slotsheet.action");
    final String lexTopic = this.lex.getText("slotsheet.topic");
    final String lexFrozen = this.lex.getText("slotsheet.frozen");
    final String lexDynamic = this.lex.getText("slotsheet.dynamic");
    final String lexSlot = this.lex.getText("slotsheet.slot");
    final String lexIndex = this.lex.getText("slotsheet.index");
    final String lexName = this.lex.getText("slotsheet.name");
    final String lexDisplayName = this.lex.getText("slotsheet.displayName");
    final String lexDefinition = this.lex.getText("slotsheet.definition");
    final String lexFlags = this.lex.getText("slotsheet.flags");
    final String lexType = this.lex.getText("slotsheet.type");
    final String lexFacets = this.lex.getText("slotsheet.facets");
    final String lexNameMap = this.lex.getText("slotsheet.nameMap");
    public static final BImage propertyIcon = BImage.make((String)"module://icons/x16/object.png");
    public static final BImage actionIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    public static final BImage topicIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");
    public final SlotSheetCommands commands = new SlotSheetCommands(this);
    Model model = new Model();
    BTable table;
    BIPropertyContainer component;
    SlotEntry[] slots = new SlotEntry[0];
    BNameMap displayNames = null;
    static /* synthetic */ Class class$com$tridium$workbench$slotsheet$BSlotSheet;

    public Type getType() {
        return TYPE;
    }

    public BSlotSheet() {
        this.autoRegisterForComponentEvents = false;
        UiLexicon lex = UiLexicon.bajaui();
        this.table = new BTable((TableModel)this.model);
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setSelection((TableSelection)new Selection());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    public void doLoadValue(BObject value, Context cx) {
        this.component = (BIPropertyContainer)value;
        if (this.component instanceof BComponent) {
            this.registerForComponentEvents((BComponent)this.component);
        }
        this.updateModels();
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        return value;
    }

    public CommandArtifact invokeCommand(int id) throws Exception {
        switch (id) {
            case 1: {
                return this.commands.copy.doInvoke();
            }
            case 4: {
                return this.commands.delete.doInvoke();
            }
            case 5: {
                return this.commands.rename.doInvoke();
            }
        }
        return super.invokeCommand(id);
    }

    public void handleComponentEvent(BComponentEvent event) {
        this.updateModels();
    }

    public Slot[] getSelectedSlots() {
        int[] rows = this.table.getSelection().getRows();
        Slot[] selected = new Slot[rows.length];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.slots[rows[i]].slot;
        }
        return selected;
    }

    public SlotEntry[] getSelectedEntries() {
        int[] rows = this.table.getSelection().getRows();
        SlotEntry[] selected = new SlotEntry[rows.length];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.slots[rows[i]];
        }
        return selected;
    }

    void updateModels() {
        if (this.component == null) {
            return;
        }
        Slot[] s = this.component.getSlotsArray();
        SlotEntry[] slots = new SlotEntry[s.length];
        BNameMap displayNames = null;
        for (int i = 0; i < s.length; ++i) {
            Property prop;
            BValue val;
            Slot slot = s[i];
            String name = slot.getName();
            slots[i] = new SlotEntry(this.component, i, slot);
            if (!slot.isProperty() || !name.equals("displayNames") || !((val = this.component.get(prop = slot.asProperty())) instanceof BNameMap)) continue;
            displayNames = (BNameMap)val;
        }
        this.table.relayout();
        this.slots = slots;
        this.displayNames = displayNames;
        this.commands.updateCommands();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SlotEntry {
        String summary;
        int index;
        BImage icon;
        Slot slot;
        String definition;
        int flags;
        String type;
        String facetsString;

        SlotEntry(BIPropertyContainer component, int index, Slot slot) {
            this.slot = slot;
            this.index = index;
            this.flags = component.getFlags(slot);
            this.facetsString = component.getSlotFacets(slot).toString();
            String string = this.definition = slot.isFrozen() ? BSlotSheet.this.lexFrozen : BSlotSheet.this.lexDynamic;
            if (slot.isAction()) {
                this.summary = BSlotSheet.this.lexAction;
                this.icon = actionIcon;
                this.type = this.typestr(slot.asAction().getReturnType()) + " (" + this.typestr(slot.asAction().getParameterType()) + ")";
            } else if (slot.isTopic()) {
                this.summary = BSlotSheet.this.lexTopic;
                this.icon = topicIcon;
                this.type = this.typestr(slot.asTopic().getEventType());
            } else {
                this.summary = BSlotSheet.this.lexProperty;
                this.icon = propertyIcon;
                this.type = slot.isFrozen() ? this.typestr(slot.asProperty().getType()) : component.get(slot.asProperty()).getType().toString();
            }
        }

        boolean isDisplayNameOverridden() {
            return BSlotSheet.this.displayNames != null && BSlotSheet.this.displayNames.get(this.slot.getName()) != null;
        }

        String toDisplayName() {
            BFormat format;
            if (BSlotSheet.this.displayNames != null && (format = BSlotSheet.this.displayNames.get(this.slot.getName())) != null) {
                return format.getFormat();
            }
            return BSlotSheet.this.component.getDisplayName(this.slot, null);
        }

        String typestr(Type type) {
            if (type == null) {
                return "void";
            }
            return type.toString();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BSlotSheet.this.slots.length;
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return BSlotSheet.this.lexSlot;
            }
            if (col == 1) {
                return BSlotSheet.this.lexIndex;
            }
            if (col == 2) {
                return BSlotSheet.this.lexName;
            }
            if (col == 3) {
                return BSlotSheet.this.lexDisplayName;
            }
            if (col == 4) {
                return BSlotSheet.this.lexDefinition;
            }
            if (col == 5) {
                return BSlotSheet.this.lexFlags;
            }
            if (col == 6) {
                return BSlotSheet.this.lexType;
            }
            if (col == 7) {
                return BSlotSheet.this.lexFacets;
            }
            return "???";
        }

        public Object getSubject(int row) {
            return BSlotSheet.this.slots[row];
        }

        public Object getValueAt(int row, int col) {
            SlotEntry se = BSlotSheet.this.slots[row];
            if (col == 0) {
                return se.summary;
            }
            if (col == 1) {
                return String.valueOf(se.index);
            }
            if (col == 2) {
                return se.slot.getName();
            }
            if (col == 3) {
                return se.toDisplayName();
            }
            if (col == 4) {
                return se.definition;
            }
            if (col == 5) {
                return Flags.encodeToString((int)se.flags);
            }
            if (col == 6) {
                return se.type;
            }
            if (col == 7) {
                return se.facetsString;
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            return BSlotSheet.this.slots[row].icon;
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Object[] keys = new Object[BSlotSheet.this.slots.length];
            block3: for (int i = 0; i < keys.length; ++i) {
                switch (col) {
                    case 1: {
                        keys[i] = new Integer(BSlotSheet.this.slots[i].index);
                        continue block3;
                    }
                    default: {
                        keys[i] = this.getValueAt(i, col).toString();
                    }
                }
            }
            SortUtil.sort((Object[])keys, (Object[])BSlotSheet.this.slots, (boolean)ascending);
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public BFont getFont(TableCellRenderer.Cell cell) {
            SlotEntry se;
            if (cell.column == 3 && (se = BSlotSheet.this.slots[cell.row]).isDisplayNameOverridden()) {
                return overrideFont;
            }
            return super.getFont(cell);
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BSlotSheet.this.commands.updateCommands();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void handleEnter(BKeyEvent event) {
            int select = this.getSelection().getRow();
            BSlotSheet.this.commands.displayName.invoke();
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BSlotSheet.this.commands.displayName.invoke();
        }

        public void popup(BMouseEvent event, int row, int col) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)BSlotSheet.this.commands.add);
            menu.add(null, (Command)BSlotSheet.this.commands.copy);
            menu.add(null, (Command)BSlotSheet.this.commands.delete);
            menu.add(null, (Command)BSlotSheet.this.commands.rename);
            menu.add(null, (Command)BSlotSheet.this.commands.flags);
            menu.add(null, (Command)BSlotSheet.this.commands.facets);
            menu.add(null, (Command)BSlotSheet.this.commands.reorder);
            menu.add(null, (Command)BSlotSheet.this.commands.displayName);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)BSlotSheet.this.commands.bajadocForType);
            menu.open(event);
        }

        public int getTextSearchColumn() {
            return 3;
        }
    }
}

