/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.sys.Nre;
import com.tridium.workbench.shell.BWbApplication;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.options.BUserOptions;
import javax.baja.ui.options.OptionsManager;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;

public class WbOptionsManager
extends Thread
implements OptionsManager {
    static final Log log = Log.getLog((String)"sys.options");
    private BWbApplication app;
    private HashMap keyToOptions = new HashMap();
    private HashMap optionsToKey = new HashMap();
    private HashMap toSave = new HashMap();

    WbOptionsManager(BWbApplication app) {
        super(Nre.mainThreadGroup, "Ui:OptionsManager");
        this.setDaemon(true);
        this.app = app;
        this.start();
    }

    public BOptions[] getLoaded() {
        return this.keyToOptions.values().toArray(new BOptions[this.keyToOptions.size()]);
    }

    public String toKey(BOptions options) {
        String key = (String)this.optionsToKey.get(options);
        if (key == null) {
            throw new IllegalStateException("Options not loaded " + options.getType());
        }
        return key;
    }

    public BOptions load(TypeInfo typeInfo) {
        return this.load(typeInfo.getTypeSpec().getResolvedType());
    }

    public BOptions load(Type type) {
        return this.load(type.toString(), type);
    }

    public synchronized BOptions load(String key, Type type) {
        if (type.is(BUserOptions.TYPE) && !key.equals(type.toString())) {
            throw new IllegalArgumentException("Key must be type.toString() for UserOptions: " + type);
        }
        BOptions options = (BOptions)this.keyToOptions.get(key);
        if (options == null) {
            try {
                File file = WbOptionsManager.keyToFile(key);
                if (file.exists()) {
                    if (log.isTraceOn()) {
                        log.trace("Load \"" + key + "\" from " + file.getName());
                    }
                    ValueDocDecoder decoder = new ValueDocDecoder(file);
                    options = (BOptions)decoder.decodeDocument();
                }
            }
            catch (Exception e) {
                log.error("Cannot load options \"" + key + "\": " + e);
            }
            if (options == null) {
                if (log.isTraceOn()) {
                    log.trace("Load \"" + key + "\" new");
                }
                options = (BOptions)type.getInstance();
            }
            this.keyToOptions.put(key, options);
            this.optionsToKey.put(options, key);
        }
        return options;
    }

    public void save(BOptions options) {
        this.saveAsync(options);
    }

    public void saveAll() {
        BOptions[] o = this.getLoaded();
        for (int i = 0; i < o.length; ++i) {
            this.saveSync(o[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsync(BOptions options) {
        HashMap hashMap = this.toSave;
        synchronized (hashMap) {
            this.toSave.put(options.getName(), options);
        }
    }

    public void saveSync(BOptions options) {
        try {
            String key = this.toKey(options);
            File file = WbOptionsManager.keyToFile(key);
            if (log.isTraceOn()) {
                log.trace("Save \"" + key + "\" to " + file.getName());
            }
            ValueDocEncoder encoder = new ValueDocEncoder(file);
            encoder.encodeDocument((BValue)options);
            encoder.close();
        }
        catch (Exception e) {
            log.error("Cannot save options", (Throwable)e);
        }
    }

    public static File keyToFile(String key) {
        File dir = new File(Sys.getUserHome(), "options");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        key = key.replace(':', '-');
        return new File(dir, key + ".options");
    }

    public static TypeInfo[] getAllUserOptions(BWbShell shell) {
        Array types = new Array((Object[])Sys.getRegistry().getConcreteTypes(BUserOptions.TYPE.getTypeInfo()));
        BWbProfile profile = shell.getProfile();
        for (int i = types.size() - 1; i >= 0; --i) {
            if (profile.hasUserOptions((TypeInfo)types.get(i))) continue;
            types.remove(i);
        }
        types.sort(new Comparator(){

            public int compare(Object a, Object b) {
                TypeInfo x = (TypeInfo)a;
                TypeInfo y = (TypeInfo)b;
                return x.getDisplayName(null).compareTo(y.getDisplayName(null));
            }
        });
        int general = -1;
        for (int i = 0; i < types.size(); ++i) {
            if (!types.get(i).toString().equals("workbench:GeneralOptions")) continue;
            general = i;
            break;
        }
        if (general != -1) {
            Object x = types.remove(general);
            types.add(0, x);
        }
        return (TypeInfo[])types.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        while (true) {
            try {
                block6: while (true) {
                    Thread.sleep(5000L);
                    var2_3 = this.toSave;
                    synchronized (var2_3) {
                        if (this.toSave.size() == 0) {
                            continue;
                        }
                        options = this.toSave.values().toArray(new BOptions[this.toSave.size()]);
                        this.toSave.clear();
                    }
                    i = 0;
                    while (true) {
                        if (i < options.length) ** break;
                        continue block6;
                        this.saveSync(options[i]);
                        ++i;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

