/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.session.Fox;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.theme.custom.CustomThemeModuleManager;
import com.tridium.util.CommandLineArguments;
import com.tridium.workbench.job.JobMonitor;
import com.tridium.workbench.nav.BSessionAgent;
import com.tridium.workbench.nav.NavMonitor;
import com.tridium.workbench.service.BWbServiceManager;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.WbState;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.gx.BSize;
import javax.baja.gx.IRectGeom;
import javax.baja.license.Feature;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BModule;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class WbMain {
    public static BICredentials kioskCredentials;
    public static final AgentFilter licenseFilter;
    private static String defaultBrandTitle;
    private static String defaultBrandSplash;
    private static String defaultBrandIcon;
    public static String brandTitle;
    public static String brandSplash;
    public static String brandIcon;
    public static Type defaultProfileType;
    static boolean licenseAdmin;
    static String licenseName;
    static String licenseCompany;
    static String licenseEmail;
    static String licenseInfo;
    private static int frameCount;
    private static Log logger;

    public static boolean isKiosk() {
        return Sys.getStation() != null;
    }

    public static boolean isKioskAccessible(BOrd ord) {
        if (!WbMain.isKiosk()) {
            return true;
        }
        String ordStr = ord.toString();
        return !ordStr.startsWith("local:") || ordStr.startsWith("local:|fox:") || ordStr.startsWith("local:|foxs:") || ordStr.startsWith("local:|platform:") || ordStr.startsWith("local:|platformssl:") || ordStr.startsWith("local:|sox:");
    }

    public static void open(BWbShell shell, BOrd ord, String target) {
        if (target.equals("_help")) {
            WbMain.openHelp(shell, ord);
        } else if (target.equals("_main")) {
            WbMain.openReuse(shell, ord, defaultProfileType);
        } else {
            shell.hyperlink(ord);
        }
    }

    public static void openHelp(BWbShell shell, BOrd ord) {
        if (WbMain.isKiosk()) {
            shell.hyperlink(ord);
            return;
        }
        Type helpProfile = shell.getProfile().getType();
        try {
            helpProfile = Sys.getType((String)"help:HelpProfile");
        }
        catch (Exception e) {
            System.out.println("WARNING:  Missing help:HelpProfile");
        }
        WbMain.openReuse(shell, ord, helpProfile);
    }

    public static void openReuse(BWbShell shell, BOrd ord, Type targetProfile) {
        AwtShellManager mgr = (AwtShellManager)shell.widgetSupport(null);
        mgr.clearTempFocus();
        BWidgetShell[] shells = BWidget.getApplication().getShells();
        for (int i = 0; i < shells.length; ++i) {
            BWbShell wbShell;
            if (!(shells[i] instanceof BWbShell) || !(wbShell = (BWbShell)shells[i]).getProfile().getType().is(targetProfile)) continue;
            wbShell.hyperlink(ord);
            mgr = (AwtShellManager)wbShell.widgetSupport(null);
            Frame frame = (Frame)mgr.getWindow();
            ((AwtUiEnv)AwtUiEnv.get()).setIconified(frame, false);
            frame.toFront();
            return;
        }
        BNiagaraWbFrame frame = null;
        if (shell instanceof BNiagaraWbFrame) {
            frame = (BNiagaraWbFrame)shell;
        }
        WbMain.openFrame(frame, ord, targetProfile);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrd ord, Type profileType) {
        return WbMain.openFrame(launcher, BOrdList.make((BOrd)ord), profileType, null, null);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrdList ord, Type profileType) {
        return WbMain.openFrame(launcher, ord, profileType, null, null);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrd ord, Type profileType, BPoint position, BSize size) {
        return WbMain.openFrame(launcher, BOrdList.make((BOrd)ord), profileType, position, size);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrdList ord, Type profileType, BPoint position, BSize size) {
        BNiagaraWbFrame shell = new BNiagaraWbFrame(profileType);
        if (launcher != null) {
            AwtShellManager mgr = (AwtShellManager)launcher.widgetSupport(null);
            mgr.clearTempFocus();
        }
        if (launcher != null) {
            WbState.save(launcher);
        }
        WbState.load(shell);
        if (position != null && size != null) {
            shell.frame.setBounds((int)position.x(), (int)position.y(), (int)size.width(), (int)size.height());
        } else if (launcher != null) {
            Rectangle a = launcher.frame.getBounds();
            Rectangle b = shell.frame.getBounds();
            if (a.x == b.x && a.y == b.y) {
                shell.frame.setBounds(b.x + 15, b.y + 15, b.width, b.height);
            }
        }
        if (WbMain.isKiosk()) {
            UiEnv.get().setKiosk((BWidgetShell)shell);
        }
        WbMain.validateBounds(shell);
        ++frameCount;
        if (ord == null) {
            ord = BOrdList.make((BOrd)shell.profile.getStartOrd());
        }
        shell.hyperlink(ord.get(0));
        int tabIndex = 0;
        for (int i = 1; i < ord.size(); ++i) {
            if (ord.get(i).toString().startsWith("tab:")) {
                tabIndex = Integer.parseInt(ord.get(i).toString().substring(4));
                continue;
            }
            shell.pane.views.addTab();
            shell.hyperlink(ord.get(i));
        }
        BViewTab[] tabs = shell.pane.views.getTabs();
        if (tabIndex < tabs.length && tabIndex > 0) {
            shell.pane.views.selectLabelPane(tabs[tabIndex]);
        }
        shell.open();
        shell.frame.toFront();
        return shell;
    }

    private static void validateBounds(BNiagaraWbFrame frame) {
        Rectangle frameBounds = frame.frame.getBounds();
        IRectGeom screen = UiEnv.get().getScreenBounds((BWidget)frame);
        if ((double)frameBounds.x - screen.x() > screen.width() || (double)frameBounds.x - screen.x() + (double)frameBounds.width > screen.width()) {
            frameBounds.x = (int)screen.x() + (int)screen.width() - frameBounds.width - 10;
        }
        if (frameBounds.x < 0) {
            frameBounds.x = 10;
            frameBounds.width = Math.min(frameBounds.width, (int)screen.width() - 20);
        }
        if ((double)frameBounds.y - screen.y() > screen.height() || (double)frameBounds.y - screen.y() + (double)frameBounds.height > screen.height()) {
            frameBounds.y = (int)screen.y() + (int)screen.height() - frameBounds.height - 10;
        }
        if ((double)frameBounds.y < screen.y()) {
            frameBounds.y = 10;
            frameBounds.height = Math.min(frameBounds.height, (int)screen.height() - 20);
        }
        frame.frame.setBounds(frameBounds);
    }

    public static void closeFrame(BNiagaraWbFrame shell) {
        if (frameCount == 1 && Sys.getStation() != null) {
            if (shell.getProfile().getType() == defaultProfileType) {
                return;
            }
            if (!shell.confirmClose()) {
                return;
            }
            shell.close();
            --frameCount;
            WbMain.openFrame(null, (BOrdList)null, defaultProfileType);
            return;
        }
        WbState.save(shell);
        if (frameCount <= 1) {
            WbMain.exit(shell);
            --frameCount;
        } else {
            if (!shell.confirmClose()) {
                return;
            }
            shell.close();
            --frameCount;
        }
    }

    public static void exit(BNiagaraWbFrame shell) {
        BWbApplication app = (BWbApplication)BWidget.getApplication();
        try {
            String title = UiLexicon.bajaui().getText("saveBeforeExit");
            int result = BSaveAllDialog.saveAll((BWidget)shell, title);
            if (result == 2) {
                return;
            }
            BWidgetShell[] shells = app.getShells();
            for (int i = 0; i < shells.length; ++i) {
                if (!(shells[i] instanceof BNiagaraWbFrame)) continue;
                BNiagaraWbFrame s = (BNiagaraWbFrame)shells[i];
                s.shutdownShell();
            }
            BWbServiceManager.make().shutdown();
            if (shell != null) {
                WbState.save(shell);
            }
            BNiagaraWbShell.history.save();
            WbMain.saveNavTree();
            WbMain.saveOptions();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!app.isApplet()) {
            System.exit(0);
        }
    }

    public static void initApplet() {
        if (frameCount <= 0) {
            frameCount = 1;
        }
    }

    public static void loadOptions() {
        BGeneralOptions options = BGeneralOptions.make();
        options.apply();
        CustomThemeModuleManager.installFromEnum((BDynamicEnum)options.getActiveTheme());
    }

    public static void saveOptions() {
        BOptions.getOptionsManager().saveAll();
    }

    public static void loadBrand() {
        File f = new File(Sys.getBajaHome(), "lib" + File.separator + "brand.properties");
        try {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(f);
            props.load(in);
            in.close();
            brandTitle = props.getProperty("workbench.title");
            brandSplash = props.getProperty("workbench.splash");
            brandIcon = props.getProperty("workbench.icon");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (brandTitle == null) {
            brandTitle = defaultBrandTitle;
        }
        if (brandSplash == null) {
            brandSplash = defaultBrandSplash;
        }
        if (brandIcon == null) {
            brandIcon = defaultBrandIcon;
        }
    }

    public static void loadNavTree() {
        try {
            File file = new File(Sys.getUserHome(), "navTree.xml");
            if (!file.exists()) {
                return;
            }
            XElem xml = XParser.make((File)file).parse();
            XElem[] xhosts = xml.elems("host");
            for (int i = 0; i < xhosts.length; ++i) {
                XElem xhost = xhosts[i];
                BOrd ord = BOrd.make((String)xhost.get("ord"));
                BHost host = (BHost)ord.get();
                XElem[] xsessions = xhost.elems("session");
                for (int j = 0; j < xsessions.length; ++j) {
                    XElem xsession = xsessions[j];
                    String sessionAgent = xsession.get("agent");
                    try {
                        Type type = Sys.getType((String)sessionAgent);
                        if (type == null) continue;
                        BSessionAgent agent = (BSessionAgent)type.getInstance();
                        agent.unpickle(host, xsession);
                        continue;
                    }
                    catch (ModuleNotFoundException e) {
                        logger.warning("Missing Module for session agent: " + sessionAgent);
                        continue;
                    }
                    catch (TypeNotFoundException e) {
                        logger.warning("Missing Type for session agent: " + sessionAgent);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveNavTree() {
        try {
            XElem xml = new XElem("navTree");
            BHost[] hosts = BHost.getAllHosts();
            for (int i = 0; i < hosts.length; ++i) {
                BHost host = hosts[i];
                XElem xhost = new XElem("host");
                xml.addContent((XContent)xhost);
                xhost.addAttr("ord", "" + host.getAbsoluteOrd());
                BISession[] sessions = host.getChildSessions();
                for (int j = 0; j < sessions.length; ++j) {
                    BISession session = sessions[j];
                    XElem xsession = new XElem("session");
                    xhost.addContent((XContent)xsession);
                    BSessionAgent agent = BSessionAgent.makeFor(session);
                    if (agent == null) continue;
                    xsession.addAttr("agent", agent.getType().toString());
                    agent.pickle(session, xsession);
                }
            }
            File file = new File(Sys.getUserHome(), "navTree.xml");
            xml.write(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRemoved(NavEvent event, BOrd activeOrd) {
        if (event.getId() != 2 && event.getId() != 5) {
            return false;
        }
        if (activeOrd == null) {
            return false;
        }
        String activeOrdStr = activeOrd.toString();
        String removedOrdStr = event.getOldChildOrd().toString();
        return (activeOrdStr = TextUtil.toLowerCase((String)activeOrdStr)).equals(removedOrdStr = TextUtil.toLowerCase((String)removedOrdStr)) || activeOrdStr.startsWith(removedOrdStr + "/") || activeOrdStr.startsWith(removedOrdStr + "|");
    }

    public static boolean getLicenseAdmin() {
        return licenseAdmin;
    }

    public static String getLicenseName() {
        return licenseName;
    }

    public static String getLicenseCompany() {
        return licenseCompany;
    }

    public static String getLicenseEmail() {
        return licenseEmail;
    }

    public static String getLicenseInfo() {
        return licenseInfo;
    }

    public static void checkWorkbenchLicense() {
        WbMain.checkLicense(true);
    }

    public static void checkLicense() {
        WbMain.checkLicense(false);
    }

    private static void checkLicense(boolean workbenchOnly) {
        Throwable ex = null;
        try {
            if (workbenchOnly) {
                Sys.getLicenseManager().checkFeature("Tridium", "workbench");
                Sys.getLicenseManager().checkFeature("Tridium", "nre");
            } else {
                WbMain.doCheckLicense();
            }
            return;
        }
        catch (LicenseDatabaseException e) {
            e.printStackTrace();
            Nre.licenseManager.dump();
            ex = e;
        }
        catch (LicenseException e) {
            e.printStackTrace();
            Nre.licenseManager.dump();
        }
        catch (Throwable e) {
            e.printStackTrace();
            ex = e;
        }
        if (ex == null) {
            try {
                WbMain.getLicenseFromPortal();
                if (workbenchOnly) {
                    Sys.getLicenseManager().checkFeature("Tridium", "workbench");
                    Sys.getLicenseManager().checkFeature("Tridium", "nre");
                } else {
                    WbMain.doCheckLicense();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                ex = e;
            }
        }
        String hostid = NreLib.getHostId();
        String title = UiLexicon.bajaui().getText("dialog.error");
        String msg = UiLexicon.bajaui().getText("license.error", new Object[]{hostid});
        BFrame frame = WbMain.makeLicenseFrame();
        frame.setContent((BWidget)new BLabel(defaultBrandTitle));
        frame.open();
        BDialog.error((BWidget)frame, (String)title, (Object)msg, (Throwable)ex);
        System.exit(0);
    }

    private static void getLicenseFromPortal() {
        try {
            BModule module = Sys.loadModule((String)"portalApi");
            Class cls = module.loadClass("com.tridium.portal.wb.LicenseProcedure");
            Method m = cls.getMethod("licenseMe", new Class[0]);
            m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static BFrame makeLicenseFrame() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int sw = screen.width;
        int sh = screen.height;
        int fw = 10;
        int fh = 10;
        BFrame frame = new BFrame(defaultBrandTitle);
        frame.setIconImage(BImage.make((String)defaultBrandIcon));
        frame.setScreenBounds(0.0, 0.0, (double)fw, (double)fh);
        frame.setBoundsCenteredOnScreen();
        return frame;
    }

    public static void doCheckLicense() throws Exception {
        Sys.getLicenseManager().checkFeature("Tridium", "nre");
        Feature wb = Sys.getLicenseManager().checkFeature("Tridium", "workbench");
        boolean profileLicensed = false;
        PatternFilter[] profiles = PatternFilter.parseList((String)wb.get("profiles", "*"), (String)";");
        for (int i = 0; i < profiles.length; ++i) {
            if (!profiles[i].accept(defaultProfileType.toString())) continue;
            profileLicensed = true;
            break;
        }
        if (!profileLicensed) {
            throw new LocalizableException("workbench", "profileNotLicensed", new Object[]{defaultProfileType});
        }
        licenseAdmin = wb.getb("admin", false);
        Feature about = Sys.getLicenseManager().getFeature("Tridium", "about");
        licenseName = about.get("project");
        licenseCompany = about.get("owner");
        licenseInfo = licenseName != null && licenseCompany != null ? licenseName + ", " + licenseCompany : (licenseName != null ? licenseName : (licenseCompany != null ? licenseCompany : null));
    }

    public static PatternFilter[] getLicensedProfiles() {
        Feature wb = Sys.getLicenseManager().checkFeature("Tridium", "workbench");
        return PatternFilter.parseList((String)wb.get("profiles", "*"), (String)";");
    }

    public static void usage() {
        System.out.println("usage:");
        System.out.println("  wb [options] <ord>");
        System.out.println("parameters:");
        System.out.println("  ord              ; delimited list of initial ords to display");
        System.out.println("options:");
        System.out.println("  -profile:<type>  workbench:WbProfile to use");
        System.out.println("  -file:ord        initial file to display");
        System.out.println("  -locale:<x>      set the default locale (en_US)");
        System.out.println("  -@<option>       pass option to Java VM");
    }

    public static void main(String[] strArgs) throws Exception {
        int i;
        PatternFilter[] licensedProfiles;
        CommandLineArguments args = new CommandLineArguments(strArgs);
        if (args.hasHelpOption()) {
            WbMain.usage();
            return;
        }
        WbMain.checkWorkbenchLicense();
        String profile = args.getOption("profile");
        if (profile == null && (licensedProfiles = WbMain.getLicensedProfiles()).length == 1 && !licensedProfiles[0].hasWildChars()) {
            profile = licensedProfiles[0].getPattern();
        }
        if (profile != null) {
            try {
                defaultProfileType = Sys.getType((String)profile);
                System.out.println("-- Default profile: " + profile);
            }
            catch (Exception e) {
                System.out.println("ERROR: Invalid profile: " + profile);
                e.printStackTrace();
            }
        }
        WbMain.checkLicense();
        BOrdList[] ords = new BOrdList[args.parameters.length];
        if (args.parameters.length > 0) {
            for (i = 0; i < args.parameters.length; ++i) {
                ords[i] = BOrdList.make((String)args.parameters[i].replace(';', '\n'));
            }
        } else if (args.hasOption("file")) {
            ords = new BOrdList[]{BOrdList.make((BOrd)BFileSystem.INSTANCE.localFileToOrd(new File(args.getOption("file"))))};
        }
        WbMain.boot();
        if (ords.length > 0) {
            for (i = 0; i < ords.length; ++i) {
                WbMain.openFrame(null, ords[i], defaultProfileType);
            }
        } else {
            WbMain.openFrame(null, (BOrdList)null, defaultProfileType);
        }
    }

    public static void boot() {
        if (!WbMain.isKiosk()) {
            WbMain.loadOptions();
            BNiagaraWbShell.history.load();
            WbMain.loadNavTree();
        }
        WbMain.loadBrand();
        Fox.hostName = Sys.getLocalHost().getHostName();
        Fox.hostAddress = Sys.getLocalHost().getHostAddress();
        Fox.appName = "Workbench";
        Fox.appVersion = "" + Sys.getBajaModule().getVendorVersion();
        JobMonitor.init();
        NavMonitor.init();
        BWbServiceManager.make().boot();
    }

    static {
        licenseFilter = new AgentFilter(){

            public boolean include(AgentInfo agent) {
                if (licenseAdmin) {
                    return true;
                }
                return !NAgentInfo.isAdmin((AgentInfo)agent);
            }
        };
        Spy.ROOT.add("workbench", (Spy)new Page());
        defaultBrandTitle = "Niagara Workbench";
        defaultBrandSplash = "module://workbench/com/tridium/workbench/media/splash_generic.png";
        defaultBrandIcon = "module://icons/x16/workbench.png";
        defaultProfileType = BWbProfile.TYPE;
        frameCount = 0;
        logger = Log.getLog((String)"com.tridium.workbench.shell");
    }

    static class Page
    extends Spy {
        Page() {
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps("Workbench");
            out.prop((Object)"brandTitle", (Object)brandTitle);
            out.prop((Object)"brandSplash", (Object)brandSplash);
            out.prop((Object)"brandIcon", (Object)brandIcon);
            out.prop((Object)"defaultProfileType", (Object)defaultProfileType);
            out.prop((Object)"licenseAdmin", licenseAdmin);
            out.prop((Object)"licenseName", (Object)licenseName);
            out.prop((Object)"licenseCompany", (Object)licenseCompany);
            out.prop((Object)"licenseEmail", (Object)licenseEmail);
            out.prop((Object)"licenseInfo", (Object)licenseInfo);
            out.prop((Object)"frameCount", frameCount);
            out.endProps();
        }
    }
}

