/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.user.BUserChannel;
import com.tridium.gx.awt.ImageManager;
import com.tridium.util.BSessionInfo;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.bookmark.BBookmarkMenu;
import com.tridium.workbench.file.BExportDialog;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BOptionsEditor;
import com.tridium.workbench.shell.BRecentList;
import com.tridium.workbench.shell.BRightClickButton;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BStationFinder;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.NHyperlinkInfo;
import com.tridium.workbench.shell.OpenUtil;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.util.BFileSearch;
import com.tridium.workbench.util.BGotoFile;
import com.tridium.workbench.util.BSessionInfoDialog;
import com.tridium.workbench.util.TypeInfoSpec;
import java.lang.reflect.Method;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BSubSpaceFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.sidebar.BWbSideBar;
import javax.baja.workbench.tool.BWbNavNodeTool;
import javax.baja.workbench.tool.BWbTool;
import javax.baja.workbench.view.BWbView;

public class WbCommands
extends BNiagaraWbShell.Support {
    public final boolean isKiosk;
    public final BToggleButton rightClickButton;
    public final Command newWindow = new NewWindowCommand();
    public final Command newTab = new NewTabCommand();
    public final Command closeTab = new CloseTabCommand(null);
    public final Command closeOtherTabs = new CloseOtherTabsCommand(null);
    public final Command nextTab = new NextTabCommand();
    public final Command prevTab = new PrevTabCommand();
    public final Command save = new SaveCommand();
    public final Command saveAll = new SaveAllCommand();
    public final Command saveBog = new SaveBogCommand();
    public final Command open = new OpenMenuCommand();
    public final Command openOrd = new OpenOrdCommand();
    public final Command openFile = new OpenFileCommand();
    public final Command openDir = new OpenDirCommand();
    public final Command openQuery = new OpenQueryCommand();
    public final Command findStations = new FindStationsCommand();
    public final Command print = new PrintCommand();
    public final ExportCommand export = new ExportCommand();
    public final Command back = new BackCommand(null);
    public final Command forward = new ForwardCommand(null);
    public final Command upLevel = new UpLevelCommand(null);
    public final Command recentOrds = new RecentOrdsCommand();
    public final Command refresh = new RefreshCommand();
    public final Command refreshTabs = new RefreshTabsCommand();
    public final Command sessionInfo = new SessionInfoCommand();
    public final Command home = new HomeCommand();
    public final Command logoff = new LogoffCommand();
    public final Command close = new CloseCommand();
    public final Command exit = new ExitCommand();
    public final Command cut = new PluginCommand(0);
    public final Command copy = new PluginCommand(1);
    public final Command paste = new PluginCommand(2);
    public final Command pasteSpecial = new PluginCommand(11);
    public final Command duplicate = new PluginCommand(3);
    public final Command delete = new PluginCommand(4);
    public final Command rename = new PluginCommand(5);
    public BActionMenuItem undoMenu;
    public BActionMenuItem redoMenu;
    public BButton undoButton;
    public BButton redoButton;
    public final Command find = new PluginCommand(6);
    public final Command findNext = new PluginCommand(8);
    public final Command findPrev = new PluginCommand(7);
    public final Command replace = new PluginCommand(9);
    public final Command goTo = new PluginCommand(10);
    public final Command gotoFile = new GotoFileCommand();
    public final Command findFiles = new FindFilesCommand();
    public final Command replaceInFiles = new ReplaceInFilesCommand();
    public final Command consolePrev = new ConsolePrevCommand();
    public final Command consoleNext = new ConsoleNextCommand();
    public final Command consoleKill = new ConsoleKillCommand();
    public final Command options = new OptionsCommand();
    public final Command[] tools = this.buildToolCommands();
    public final Command sideBarMenu = new SideBarMenuCommand();
    public final ToggleCommand showSideBar = new ShowSideBarCommand();
    public final Command[] sideBars = this.buildSideBarCommands();
    public final Command activePlugin = new ActivePlugin();
    public final ConsoleGroup consoleGroup;
    public final ConsoleToggle hideConsole;
    public final ConsoleToggle console;
    public final ToggleCommand pathBarUsesNavFile = new PathBarUsesNavFileCommand();
    public final Command helpContents = new HelpContentsCommand();
    public final Command helpOnView = new HelpOnViewCommand();
    public final Command helpGuideOnTarget = new HelpGuideOnTargetCommand();
    public final Command helpBajadocOnTarget = new HelpBajadocOnTargetCommand();
    public final Command helpFindBajadoc = new HelpFindBajadocCommand();
    public final Command about = new AboutCommand();
    static /* synthetic */ Class class$javax$baja$ui$Command;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;
    static /* synthetic */ Class class$java$lang$String;

    public WbCommands(BNiagaraWbShell shell) {
        super(shell);
        this.isKiosk = WbMain.isKiosk();
        this.rightClickButton = new BRightClickButton(shell);
        this.consoleGroup = new ConsoleGroup();
        this.hideConsole = new ConsoleToggle("commands.hideConsole");
        this.consoleGroup.add(this.hideConsole);
        this.console = new ConsoleToggle("commands.console");
        this.consoleGroup.add(this.console);
    }

    public BMenuBar makeMenuBar() {
        BBookmarkMenu bookmarkMenu = new BBookmarkMenu();
        BMenuBar bar = new BMenuBar();
        bar.add("file", (BValue)this.buildFileMenu());
        bar.add("edit", (BValue)this.buildEditMenu());
        bar.add("search", (BValue)this.buildSearchMenu());
        bar.add("bookmarks", (BValue)bookmarkMenu);
        bar.add("tools", (BValue)this.buildToolsMenu());
        bar.add("window", (BValue)this.buildWindowMenu());
        bar.add("help", (BValue)this.buildHelpMenu());
        return bar;
    }

    public BMenu makeOpenMenu() {
        BOrd fox = BOrd.make((String)"local:|fox:");
        BOrd foxs = BOrd.make((String)"local:|foxs:");
        boolean hasFox = this.shell.profile.canHyperlink(fox) || this.shell.profile.canHyperlink(foxs);
        BMenu open = UiLexicon.bajaui().buildMenu("menu.open.label");
        open.add("openOrd", this.openOrd);
        open.add("openFile", this.openFile);
        open.add("openDir", this.openDir);
        if (hasFox) {
            open.add("openQuery", this.openQuery);
        }
        open.add("sep0", (BValue)new BSeparator());
        Command[] sessionOpens = BCnxHandler.getCnxCommands((BWidget)this.shell, null);
        for (int i = 0; i < sessionOpens.length; ++i) {
            open.add(this.toSlotName(sessionOpens[i]), sessionOpens[i]);
        }
        if (hasFox) {
            open.add("sep1", (BValue)new BSeparator());
            open.add("findStations", this.findStations);
        }
        return open;
    }

    private BMenu buildFileMenu() {
        BSubMenuItem openItem = new BSubMenuItem(this.makeOpenMenu());
        openItem.setText(UiLexicon.bajaui().getText("commands.open.label"));
        openItem.setImage(BImage.make((String)"module://icons/x16/open.png"));
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.file.label");
        menu.add("open", (BValue)openItem);
        menu.add("sep0", (BValue)new BSeparator());
        if (!this.isKiosk) {
            menu.add("newWindow", this.newWindow);
        }
        menu.add("newTab", this.newTab);
        menu.add("closeTab", this.closeTab);
        menu.add("closeOtherTabs", this.closeOtherTabs);
        menu.add("nextTab", this.nextTab);
        menu.add("prevTab", this.prevTab);
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("save", this.save);
        menu.add("saveAll", this.saveAll);
        menu.add("saveBog", this.saveBog);
        menu.add("sep2", (BValue)new BSeparator());
        menu.add("export", (Command)this.export);
        menu.add("sep3", (BValue)new BSeparator());
        menu.add("back", this.back);
        menu.add("forward", this.forward);
        menu.add("upLevel", this.upLevel);
        menu.add("sep4", (BValue)new BSeparator());
        menu.add("recentOrds", this.recentOrds);
        menu.add("home", this.home);
        menu.add("refresh", this.refresh);
        menu.add("refreshtabs", this.refreshTabs);
        menu.add("sessionInfo", this.sessionInfo);
        menu.add("sep6", (BValue)new BSeparator());
        menu.add("logoff", this.logoff);
        if (!this.isKiosk) {
            menu.add("close", this.close);
            menu.add("exit", this.exit);
        }
        return menu;
    }

    private BMenu buildEditMenu() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.edit.label");
        menu.add("cut", this.cut);
        menu.add("copy", this.copy);
        menu.add("paste", this.paste);
        menu.add("pasteSpecial", this.pasteSpecial);
        menu.add("duplicate", this.duplicate);
        menu.add("delete", this.delete);
        menu.add("rename", this.rename);
        menu.add("sep2", (BValue)new BSeparator());
        menu.add("undo", this.shell.getUndoManager().getUndoCommand());
        menu.add("redo", this.shell.getUndoManager().getRedoCommand());
        this.undoMenu = (BActionMenuItem)menu.get("undo");
        this.redoMenu = (BActionMenuItem)menu.get("redo");
        return menu;
    }

    private BMenu buildSearchMenu() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.search.label");
        menu.add("find", this.find);
        menu.add("findPrev", this.findNext);
        menu.add("findNext", this.findPrev);
        menu.add("replace", this.replace);
        menu.add("goto", this.goTo);
        menu.add("sep0", (BValue)new BSeparator());
        menu.add("gotoFile", this.gotoFile);
        menu.add("findFiles", this.findFiles);
        menu.add("replaceInFiles", this.replaceInFiles);
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("consolePrev", this.consolePrev);
        menu.add("consoleNext", this.consoleNext);
        return menu;
    }

    private Command[] buildToolCommands() {
        Array acc = new Array(class$javax$baja$ui$Command == null ? (class$javax$baja$ui$Command = WbCommands.class$("javax.baja.ui.Command")) : class$javax$baja$ui$Command);
        if (this.profile.hasTools()) {
            TypeInfo[] t = BWbTool.getInstalled();
            for (int i = 0; i < t.length; ++i) {
                if (!this.profile.hasTool(t[i])) continue;
                acc.add((Object)new ToolCommand(t[i]));
            }
        }
        return (Command[])acc.trim();
    }

    private BMenu buildToolsMenu() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.tools.label");
        menu.add("options", this.options);
        if (this.tools.length > 0) {
            menu.add("sep", (BValue)new BSeparator());
            for (int i = 0; i < this.tools.length; ++i) {
                menu.add("t" + i, this.tools[i]);
            }
        }
        return menu;
    }

    private Command[] buildSideBarCommands() {
        Array acc = new Array(class$javax$baja$ui$Command == null ? (class$javax$baja$ui$Command = WbCommands.class$("javax.baja.ui.Command")) : class$javax$baja$ui$Command);
        if (this.profile.hasSideBar()) {
            TypeInfo[] t = BWbSideBar.getInstalled();
            for (int i = 0; i < t.length; ++i) {
                if (!this.profile.hasSideBar(t[i])) continue;
                acc.add((Object)new SideBarCommand(t[i]));
            }
        }
        return (Command[])acc.trim();
    }

    public BMenu buildSideBarMenu() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.sidebar.label");
        menu.add("show", (Command)this.showSideBar);
        if (this.sideBars.length > 0) {
            menu.add("sep0", (BValue)new BSeparator());
            for (int i = 0; i < this.sideBars.length; ++i) {
                menu.add("m" + i, this.sideBars[i]);
            }
        }
        return menu;
    }

    private BMenu buildWindowMenu() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.window.label");
        if (this.profile.hasSideBar()) {
            menu.add("sidebars", (BValue)new BSubMenuItem(this.buildSideBarMenu()));
            menu.add("sep0", (BValue)new BSeparator());
        }
        menu.add("pathBarUsesNavFile", (Command)this.pathBarUsesNavFile);
        menu.add("activePlugin", this.activePlugin);
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("hideConsole", (Command)this.hideConsole);
        menu.add("console", (Command)this.console);
        menu.add("consoleKill", this.consoleKill);
        return menu;
    }

    private BMenu buildHelpMenu() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.help.label");
        menu.add("contents", this.helpContents);
        menu.add("sep0", (BValue)new BSeparator());
        menu.add("onView", this.helpOnView);
        menu.add("guideOnTarget", this.helpGuideOnTarget);
        menu.add("bajadocOnTarget", this.helpBajadocOnTarget);
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("findBajadoc", this.helpFindBajadoc);
        menu.add("sep2", (BValue)new BSeparator());
        menu.add("about", this.about);
        return menu;
    }

    private String toSlotName(Command command) {
        StringBuffer s = new StringBuffer();
        String[] toks = TextUtil.split((String)command.getKeyBase(), (char)'.');
        for (int i = 0; i < toks.length; ++i) {
            String tok = toks[i];
            if (i == 0) {
                s.append(tok);
                continue;
            }
            s.append(TextUtil.capitalize((String)tok));
        }
        return s.toString();
    }

    public BToolBar makeToolBar() {
        BToolBar bar = new BToolBar();
        bar.add("back", this.back).setMenuController((BAbstractButton.MenuController)new BackMenuController());
        bar.add("forward", this.forward).setMenuController((BAbstractButton.MenuController)new ForwardMenuController());
        bar.add("upLevel", this.upLevel).setMenuController((BAbstractButton.MenuController)new UpLevelMenuController());
        bar.add("sep0", (BValue)new BSeparator(), null);
        if (this.profile.hasSideBar()) {
            bar.add("sideBar", this.sideBarMenu).setMenuController((BAbstractButton.MenuController)new SideBarMenuController());
        }
        bar.add("recentOrds", this.recentOrds);
        bar.add("home", this.home);
        bar.add("refresh", this.refresh);
        bar.add("refreshTabs", this.refreshTabs);
        bar.add("sessionInfo", this.sessionInfo);
        bar.add("sep2", (BValue)new BSeparator(), null);
        bar.add("open", this.open).setMenuController((BAbstractButton.MenuController)new OpenMenuController());
        bar.add("save", this.save);
        bar.add("saveBog", this.saveBog);
        bar.add("export", (Command)this.export);
        bar.add("sep3", (BValue)new BSeparator(), null);
        bar.add("cut", this.cut);
        bar.add("copy", this.copy);
        bar.add("paste", this.paste);
        bar.add("duplicate", this.duplicate);
        bar.add("delete", this.delete);
        bar.add("sep4", (BValue)new BSeparator(), null);
        bar.add("undo", this.shell.getUndoManager().getUndoCommand());
        bar.add("redo", this.shell.getUndoManager().getRedoCommand());
        this.undoButton = (BButton)bar.get("undo");
        this.redoButton = (BButton)bar.get("redo");
        return bar;
    }

    void updateTab(BViewTab tab) {
        this.back.setEnabled(tab.history.isBackEnabled());
        this.forward.setEnabled(tab.history.isForwardEnabled());
        this.upLevel.setEnabled(tab.hasParent);
        this.updateView(tab.view);
    }

    void updateView(BWbView view) {
        boolean vnn = view != null;
        this.cut.setEnabled(vnn && view.isCommandEnabled(0));
        this.copy.setEnabled(vnn && view.isCommandEnabled(1));
        this.paste.setEnabled(vnn && view.isCommandEnabled(2));
        this.pasteSpecial.setEnabled(vnn && view.isCommandEnabled(11));
        this.duplicate.setEnabled(vnn && view.isCommandEnabled(3));
        this.delete.setEnabled(vnn && view.isCommandEnabled(4));
        this.rename.setEnabled(vnn && view.isCommandEnabled(5));
        this.find.setEnabled(vnn && view.isCommandEnabled(6));
        this.findNext.setEnabled(vnn && view.isCommandEnabled(8));
        this.findPrev.setEnabled(vnn && view.isCommandEnabled(7));
        this.replace.setEnabled(vnn && view.isCommandEnabled(9));
        this.goTo.setEnabled(vnn && view.isCommandEnabled(10));
        this.consoleKill.setEnabled(vnn && this.shell.pane.console.inExec());
        this.helpOnView.setEnabled(vnn);
        this.helpGuideOnTarget.setEnabled(vnn);
        this.helpBajadocOnTarget.setEnabled(vnn);
        boolean connected = false;
        try {
            BISession session = this.shell.getActiveView().getCurrentValueSession();
            if (session != null && !(session instanceof BLocalHost) && session.isConnected()) {
                connected = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sessionInfo.setEnabled(vnn && connected);
        this.save.setEnabled(vnn && view.isModified());
        this.updateSaveBog();
    }

    public void updateSaveBog() {
        BComponent component;
        BComponentSpace space;
        BObject target;
        this.saveBog.setEnabled(false);
        if (this.shell.tab().view != null && (target = this.shell.tab().view.getCurrentValue()) instanceof BComponent && (space = (component = (BComponent)target).getComponentSpace()) != null && space.getNavParent() instanceof BSubSpaceFile) {
            BSubSpaceFile file = (BSubSpaceFile)space.getNavParent();
            this.saveBog.setEnabled(file.isModified());
        }
    }

    CloseTabCommand makeCloseTab(BViewTab tab) {
        return new CloseTabCommand(tab);
    }

    CloseOtherTabsCommand makeCloseOtherTabs(BViewTab tab) {
        return new CloseOtherTabsCommand(tab);
    }

    public BackMenuController makeBackMenuController() {
        return new BackMenuController();
    }

    public ForwardMenuController makeForwardMenuController() {
        return new ForwardMenuController();
    }

    public static BOrd getAboutOrd() {
        return BOrd.make((String)"workbench:/help/about.html");
    }

    public BOrd getHomeOrd() {
        BOrd ord = WbCommands.getAboutOrd();
        try {
            BWbView view = this.shell.getActiveView();
            BObject target = view.getCurrentValue();
            BISession session = BOrd.toSession((BObject)target);
            if (session instanceof BFoxSession) {
                BFoxSession foxSession = (BFoxSession)session;
                BFoxClientConnection conn = foxSession.getConnection();
                BUserChannel userChannel = conn.getChannels().getUserChannel();
                ord = userChannel.getHomePage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ord;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AboutCommand
    extends WbCommand {
        AboutCommand() {
            super("commands.help.about");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(BOrd.make((String)"workbench:/help/about.html"));
            return null;
        }
    }

    public class GotoFileCommand
    extends WbCommand {
        GotoFileCommand() {
            super("commands.gotoFile");
        }

        public CommandArtifact doInvoke() {
            BGotoFile.go(WbCommands.this.shell);
            return null;
        }
    }

    public class HelpFindBajadocCommand
    extends WbCommand {
        private Method helpSystemExists;
        private Method loadHelp;
        private Method findBajadocOrd;

        HelpFindBajadocCommand() {
            super("commands.help.findBajadoc");
        }

        public CommandArtifact doInvoke() {
            try {
                Class bajadocFinder = Sys.loadClass((String)"help", (String)"com.tridium.help.BajadocFinder");
                Class helpSystem = Sys.loadClass((String)"help", (String)"com.tridium.help.HelpSystem");
                Class helpSideBar = Sys.loadClass((String)"help", (String)"com.tridium.help.ui.BHelpSideBar");
                this.helpSystemExists = helpSystem.getMethod("exists", null);
                this.loadHelp = helpSideBar.getMethod("loadHelp", class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = WbCommands.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget);
                this.findBajadocOrd = bajadocFinder.getMethod("findBajadocOrd", class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = WbCommands.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget, class$java$lang$String == null ? (class$java$lang$String = WbCommands.class$("java.lang.String")) : class$java$lang$String);
                if (this.helpSystemExists()) {
                    this.find();
                } else {
                    this.loadHelp();
                    if (this.helpSystemExists()) {
                        this.find();
                    }
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            return null;
        }

        private void find() throws Exception {
            BMruTextDropDown field = new BMruTextDropDown("findBajadoc", 30);
            String selection = WbCommands.this.shell.getSelectedText();
            if (selection != null) {
                field.setText(selection);
            }
            BEdgePane edge = new BEdgePane();
            edge.setTop((BWidget)field);
            int r = BDialog.open((BWidget)WbCommands.this.shell, (String)this.getLabel(), (Object)edge, (int)3, (BImage)BDialog.QUESTION_ICON);
            if (r != 1) {
                return;
            }
            String pattern = field.getTextAndSave();
            BOrd ord = this.findBajadocOrd(pattern);
            if (ord != null) {
                WbMain.openHelp(WbCommands.this.shell, ord);
            } else {
                WbCommands.this.shell.showStatus("Not found: " + pattern);
            }
        }

        private void loadHelp() throws Exception {
            this.loadHelp.invoke(null, new Object[]{WbCommands.this.shell});
        }

        private boolean helpSystemExists() throws Exception {
            return (Boolean)this.helpSystemExists.invoke(null, null);
        }

        private BOrd findBajadocOrd(String pattern) throws Exception {
            return (BOrd)this.findBajadocOrd.invoke(null, new Object[]{WbCommands.this.shell, pattern});
        }
    }

    public static class HelpCommand
    extends Command {
        BOrd ord;

        public HelpCommand(BWidget widget, Lexicon lex, String key, BOrd ord) {
            super(widget, lex, key);
            this.ord = ord;
        }

        public HelpCommand(BWidget widget, String key, BOrd ord) {
            this(widget, (Lexicon)UiLexicon.bajaui(), key, ord);
        }

        public CommandArtifact doInvoke() {
            BWidgetShell shell = this.getShell();
            if (shell instanceof BWbShell) {
                WbMain.openHelp((BWbShell)shell, this.ord);
            }
            return null;
        }
    }

    public class HelpBajadocOnTargetCommand
    extends WbCommand {
        HelpBajadocOnTargetCommand() {
            super("commands.help.bajadocOnTarget");
        }

        public CommandArtifact doInvoke() {
            BWbView view = WbCommands.this.shell.getActiveView();
            BObject target = view.getCurrentValue();
            if (target != null) {
                BOrd ord = ObjectUtil.getReferenceHelpOrd((BObject)target);
                WbMain.openHelp(WbCommands.this.shell, ord);
            }
            return null;
        }
    }

    public class HelpGuideOnTargetCommand
    extends WbCommand {
        HelpGuideOnTargetCommand() {
            super("commands.help.guideOnTarget");
        }

        public CommandArtifact doInvoke() {
            BWbView view = WbCommands.this.shell.getActiveView();
            BObject target = view.getCurrentValue();
            if (target != null) {
                BOrd ord = ObjectUtil.getGuideHelpOrd((BObject)target);
                WbMain.openHelp(WbCommands.this.shell, ord);
            }
            return null;
        }
    }

    public class HelpOnViewCommand
    extends WbCommand {
        HelpOnViewCommand() {
            super("commands.help.onView");
        }

        public CommandArtifact doInvoke() {
            BWbView view = WbCommands.this.shell.getActiveView();
            BOrd ord = ObjectUtil.getGuideHelpOrd((BObject)view);
            WbMain.openHelp(WbCommands.this.shell, ord);
            return null;
        }
    }

    public class HelpContentsCommand
    extends WbCommand {
        HelpContentsCommand() {
            super("commands.help.contents");
        }

        public CommandArtifact doInvoke() {
            WbMain.openHelp(WbCommands.this.shell, BOrd.make((String)"workbench:/help/contents.html"));
            return null;
        }
    }

    public class PathBarUsesNavFileCommand
    extends WbToggleCommand {
        public PathBarUsesNavFileCommand() {
            super("commands.pathBarUsesNavFile");
            this.setSelected(true);
        }
    }

    public class ConsoleToggle
    extends WbToggleCommand {
        ConsoleToggle(String key) {
            super(key);
        }

        public CommandArtifact doInvoke() {
            if (this == WbCommands.this.console) {
                WbCommands.this.shell.pane.console.prime();
            }
            return null;
        }
    }

    public class ActivePlugin
    extends WbCommand {
        ActivePlugin() {
            super("commands.activePlugin");
        }

        public CommandArtifact doInvoke() {
            BWbView view = WbCommands.this.shell.getActiveView();
            if (view != null) {
                view.prime();
            }
            return null;
        }
    }

    public class ConsoleKillCommand
    extends WbCommand {
        public ConsoleKillCommand() {
            super("commands.consoleKill");
        }

        public CommandArtifact doInvoke() {
            if (WbCommands.this.shell.pane != null) {
                WbCommands.this.shell.pane.console.kill();
            }
            return null;
        }
    }

    public class ConsoleGroup
    extends ToggleCommandGroup {
        protected void selected(ToggleCommand cmd) {
            if (WbCommands.this.shell.pane != null) {
                WbCommands.this.shell.pane.setConsoleVisible(cmd == WbCommands.this.console);
                if (cmd == WbCommands.this.console) {
                    WbCommands.this.shell.pane.console.prime();
                } else {
                    WbCommands.this.activePlugin.invoke();
                }
            }
        }
    }

    public class SideBarCommand
    extends Command {
        TypeInfoSpec spec;

        SideBarCommand(TypeInfo info) {
            super((BWidget)WbCommands.this.shell, "SideBar");
            this.spec = new TypeInfoSpec(info);
            this.label = this.spec.label;
            this.icon = this.spec.icon;
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.sideBar.open(this.spec);
            return null;
        }
    }

    public class ShowSideBarCommand
    extends WbToggleCommand {
        public ShowSideBarCommand() {
            super("commands.showSideBar");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            WbCommands.this.shell.pane.setSideBarVisible(sel);
        }
    }

    public class SideBarMenuCommand
    extends WbToggleCommand {
        public SideBarMenuCommand() {
            super("commands.sideBarMenu");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    public class SideBarMenuController
    implements BAbstractButton.MenuController {
        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton b) {
            return WbCommands.this.buildSideBarMenu();
        }
    }

    public class ConsolePrevCommand
    extends WbCommand {
        public ConsolePrevCommand() {
            super("commands.consolePrev");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.console.prev();
            return null;
        }
    }

    public class ConsoleNextCommand
    extends WbCommand {
        public ConsoleNextCommand() {
            super("commands.consoleNext");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.console.next();
            return null;
        }
    }

    public class ReplaceInFilesCommand
    extends WbCommand {
        public ReplaceInFilesCommand() {
            super("commands.replaceInFiles");
        }

        public CommandArtifact doInvoke() {
            BFileSearch.replaceInFiles(WbCommands.this.shell);
            return null;
        }
    }

    public class FindFilesCommand
    extends WbCommand {
        public FindFilesCommand() {
            super("commands.findFiles");
        }

        public CommandArtifact doInvoke() {
            BFileSearch.findFiles(WbCommands.this.shell);
            return null;
        }
    }

    public class SaveBogCommand
    extends WbCommand {
        SaveBogCommand() {
            super("commands.saveBog");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (WbCommands.this.shell.tab().view == null) {
                return null;
            }
            BComponent target = (BComponent)WbCommands.this.shell.tab().view.getCurrentValue();
            if (target == null) {
                return null;
            }
            BComponentSpace space = target.getComponentSpace();
            if (space.getNavParent() instanceof BSubSpaceFile) {
                BSubSpaceFile file = (BSubSpaceFile)space.getNavParent();
                file.save();
                WbCommands.this.updateSaveBog();
            }
            return null;
        }
    }

    public class SaveCommand
    extends WbCommand {
        SaveCommand() {
            super("commands.save");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.save(WbCommands.this.shell.tab().view);
            return null;
        }
    }

    public class ToolCommand
    extends Command {
        TypeInfoSpec spec;

        ToolCommand(TypeInfo info) {
            super((BWidget)WbCommands.this.shell, "Tool");
            this.spec = new TypeInfoSpec(info);
            this.label = this.spec.label;
            this.icon = this.spec.icon;
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbTool tool = this.spec.info.is(BWbNavNodeTool.TYPE) ? BWbNavNodeTool.make(this.spec.info.toString()) : (BWbTool)this.spec.info.getInstance();
            return tool.invoke(WbCommands.this.shell);
        }
    }

    public class OptionsCommand
    extends WbCommand {
        OptionsCommand() {
            super("commands.options");
        }

        public CommandArtifact doInvoke() {
            BOptionsEditor.openInDialog(WbCommands.this.shell);
            return null;
        }
    }

    public class ExitCommand
    extends WbCommand {
        ExitCommand() {
            super("commands.exit");
        }

        public CommandArtifact doInvoke() {
            WbMain.exit((BNiagaraWbFrame)WbCommands.this.shell);
            return null;
        }
    }

    public class CloseCommand
    extends WbCommand {
        CloseCommand() {
            super("commands.close");
        }

        public CommandArtifact doInvoke() {
            WbMain.closeFrame((BNiagaraWbFrame)WbCommands.this.shell);
            return null;
        }
    }

    public class LogoffCommand
    extends WbCommand {
        LogoffCommand() {
            super("commands.logoff");
        }

        public CommandArtifact doInvoke() {
            BWbApplication.autoLogoff();
            return null;
        }
    }

    public class HomeCommand
    extends WbCommand {
        HomeCommand() {
            super("commands.home");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(WbCommands.this.profile.getHomeOrd());
            return null;
        }
    }

    public class RefreshTabsCommand
    extends WbCommand {
        public RefreshTabsCommand() {
            super("commands.refreshtabs");
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            if (event.isControlDown()) {
                ImageManager.trimAll();
            }
            BViewTab[] tabs = WbCommands.this.shell.pane.views.getTabs();
            BViewTab activeTab = WbCommands.this.shell.tab();
            int id = -1;
            for (int i = 0; i < tabs.length; ++i) {
                if (activeTab == tabs[i]) {
                    id = i;
                }
                BOrd ord = tabs[i].getOrd();
                tabs[i].closeTab();
                WbCommands.this.shell.hyperlink(new HyperlinkInfo(ord, BHyperlinkMode.newTab));
            }
            tabs = WbCommands.this.shell.pane.views.getTabs();
            if (id > -1) {
                WbCommands.this.shell.pane.views.selectLabelPane(tabs[id]);
            }
            return null;
        }
    }

    public class SessionInfoCommand
    extends WbCommand {
        SessionInfoCommand() {
            super("commands.sessionInfo");
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            try {
                BSessionInfoDialog dlg;
                BSession bsession;
                BSessionInfo info;
                BISession session = WbCommands.this.shell.getActiveView().getCurrentValueSession();
                if (session instanceof BSession && (info = (bsession = (BSession)session).getSessionInfo()) != null && (dlg = this.getDialog(info)) != null) {
                    dlg.show(info);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private final BSessionInfoDialog getDialog(BSessionInfo sessionInfo) {
            BSessionInfoDialog instance = null;
            AgentList list = Sys.getRegistry().getSpecificAgents(sessionInfo.getType().getTypeInfo());
            if (list == null || list.size() == 0) {
                return null;
            }
            AgentInfo info = list.get(0);
            instance = (BSessionInfoDialog)info.getInstance();
            return instance;
        }
    }

    public class RefreshCommand
    extends WbCommand {
        RefreshCommand() {
            super("commands.refresh");
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            if (event.isControlDown()) {
                ImageManager.trimAll();
            }
            WbCommands.this.shell.hyperlink(new NHyperlinkInfo(WbCommands.this.shell.getActiveOrd(), BHyperlinkMode.replace, false));
            return null;
        }
    }

    public class RecentOrdsCommand
    extends WbCommand {
        RecentOrdsCommand() {
            super("commands.recentOrds");
        }

        public CommandArtifact doInvoke() throws Exception {
            WbHistory.Entry[] recent = BNiagaraWbShell.history.recentList();
            BRecentList list = new BRecentList();
            list.load(recent);
            int r = BDialog.open((BWidget)WbCommands.this.shell, (String)this.getLabel(), (Object)((Object)list), (int)3);
            if (r == 2) {
                return null;
            }
            HyperlinkInfo info = list.result();
            if (info == null) {
                return null;
            }
            WbCommands.this.shell.hyperlink(info);
            return null;
        }
    }

    public class UpLevelCommand
    extends WbCommand {
        BOrd ord;

        UpLevelCommand(BOrd ord) {
            super("commands.upLevel");
            this.ord = ord;
            if (ord != null) {
                this.label = WbHistory.toName(ord);
                this.icon = null;
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() throws Exception {
            BOrd ord = this.ord;
            if (ord == null) {
                ord = WbCommands.this.shell.tab().ord.getParent();
            }
            if (ord != null) {
                WbCommands.this.shell.hyperlink(ord);
            }
            return null;
        }
    }

    class UpLevelMenuController
    implements BAbstractButton.MenuController {
        UpLevelMenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton b) {
            BMenu menu = new BMenu();
            for (BOrd ord = WbCommands.this.shell.tab().ord.getParent(); ord != null; ord = ord.getParent()) {
                menu.add(null, (Command)new UpLevelCommand(ord));
            }
            return menu;
        }
    }

    public class ForwardCommand
    extends WbCommand {
        BOrd ord;

        ForwardCommand(WbHistory.Entry entry) {
            super("commands.forward");
            if (entry != null) {
                this.ord = entry.ord;
                this.label = entry.name;
                this.icon = entry.icon;
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbApplet wbApplet;
            if (WbCommands.this.shell.isApplet() && (wbApplet = (BNiagaraWbApplet)WbCommands.this.shell).isAppletReloadOnHyperlink()) {
                wbApplet.browserForward();
                return null;
            }
            BOrd ord = this.ord;
            if (ord == null) {
                ord = WbCommands.this.shell.tab().history.forward();
            } else {
                BOrd test = WbCommands.this.shell.tab().history.forward();
                while (test != null && test != ord) {
                    test = WbCommands.this.shell.tab().history.forward();
                }
            }
            if (ord != null) {
                WbCommands.this.shell.hyperlink(new NHyperlinkInfo(ord, BHyperlinkMode.replace, false));
            }
            return null;
        }
    }

    class ForwardMenuController
    implements BAbstractButton.MenuController {
        ForwardMenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton b) {
            BMenu menu = new BMenu();
            WbHistory.Entry[] list = WbCommands.this.shell.tab().history.getForwardHistory();
            for (int i = 0; i < list.length && i < 10; ++i) {
                menu.add("forward" + i, (Command)new ForwardCommand(list[i]));
            }
            return menu;
        }
    }

    public class BackCommand
    extends WbCommand {
        BOrd ord;

        BackCommand(WbHistory.Entry entry) {
            super("commands.back");
            if (entry != null) {
                this.ord = entry.ord;
                this.label = entry.name;
                this.icon = entry.icon;
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbApplet wbApplet;
            if (WbCommands.this.shell.isApplet() && (wbApplet = (BNiagaraWbApplet)WbCommands.this.shell).isAppletReloadOnHyperlink()) {
                wbApplet.browserBack();
                return null;
            }
            BOrd ord = this.ord;
            if (ord == null) {
                ord = WbCommands.this.shell.tab().history.back();
            } else {
                BOrd test = WbCommands.this.shell.tab().history.back();
                while (test != null && test != ord) {
                    test = WbCommands.this.shell.tab().history.back();
                }
            }
            if (ord != null) {
                WbCommands.this.shell.hyperlink(new NHyperlinkInfo(ord, BHyperlinkMode.replace, false));
            }
            return null;
        }
    }

    class BackMenuController
    implements BAbstractButton.MenuController {
        BackMenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton b) {
            BMenu menu = new BMenu();
            WbHistory.Entry[] list = WbCommands.this.shell.tab().history.getBackHistory();
            for (int i = 0; i < list.length && i < 10; ++i) {
                menu.add("back" + i, (Command)new BackCommand(list[i]));
            }
            return menu;
        }
    }

    class ExportCommand
    extends WbCommand {
        ExportCommand() {
            super("commands.export");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BExportDialog.invoke(WbCommands.this.shell, false);
        }

        public void updateEnabled() {
            try {
                this.setEnabled(BExportDialog.hasExporters(WbCommands.this.shell, false));
            }
            catch (Exception e) {
                this.setEnabled(false);
            }
        }
    }

    class PrintCommand
    extends WbCommand {
        PrintCommand() {
            super("commands.print");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BExportDialog.invoke(WbCommands.this.shell, true);
        }
    }

    class SaveAllCommand
    extends WbCommand {
        SaveAllCommand() {
            super("commands.saveAll");
        }

        public CommandArtifact doInvoke() {
            BSaveAllDialog.saveAll((BWidget)WbCommands.this.shell, this.getLabel());
            return null;
        }
    }

    class PrevTabCommand
    extends WbCommand {
        PrevTabCommand() {
            super("commands.prevTab");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.views.selectPrevTab();
            return null;
        }
    }

    class NextTabCommand
    extends WbCommand {
        NextTabCommand() {
            super("commands.nextTab");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.views.selectNextTab();
            return null;
        }
    }

    class CloseOtherTabsCommand
    extends WbCommand {
        BViewTab tabToKeep;

        CloseOtherTabsCommand(BViewTab tabToKeep) {
            super("commands.closeOtherTabs");
            this.tabToKeep = tabToKeep;
            if (tabToKeep != null) {
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() {
            BViewTab tabToKeep = this.tabToKeep;
            if (tabToKeep == null) {
                tabToKeep = WbCommands.this.shell.tab();
            }
            BViewTab[] tabs = WbCommands.this.shell.pane.views.getTabs();
            for (int i = 0; i < tabs.length; ++i) {
                if (tabs[i] == tabToKeep) continue;
                tabs[i].closeTab();
            }
            return null;
        }
    }

    class CloseTabCommand
    extends WbCommand {
        BViewTab tab;

        CloseTabCommand(BViewTab tab) {
            super("commands.closeTab");
            this.tab = tab;
            this.setEnabled(tab != null);
            if (tab != null) {
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() {
            BViewTab tab = this.tab;
            if (tab == null) {
                tab = WbCommands.this.shell.tab();
            }
            tab.closeTab();
            return null;
        }
    }

    class NewTabCommand
    extends WbCommand {
        NewTabCommand() {
            super("commands.newTab");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(new HyperlinkInfo(WbCommands.this.shell.getActiveOrd(), BHyperlinkMode.newTab));
            return null;
        }
    }

    class NewWindowCommand
    extends WbCommand {
        NewWindowCommand() {
            super("commands.newWindow");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(new HyperlinkInfo(WbCommands.this.shell.getActiveOrd(), BHyperlinkMode.newShell));
            return null;
        }
    }

    public class FindStationsCommand
    extends WbCommand {
        FindStationsCommand() {
            super("commands.findStations");
        }

        public CommandArtifact doInvoke() throws Exception {
            BStationFinder finder = new BStationFinder();
            int r = BDialog.open((BWidget)WbCommands.this.shell, (String)this.getLabel(), (Object)finder, (int)3);
            if (r == 2) {
                return null;
            }
            BOrd ord = finder.result();
            if (ord == null) {
                return null;
            }
            WbCommands.this.shell.hyperlink(ord);
            return null;
        }
    }

    public class OpenQueryCommand
    extends WbCommand {
        OpenQueryCommand() {
            super("commands.open.query");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openQuery(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenDirCommand
    extends WbCommand {
        OpenDirCommand() {
            super("commands.open.dir");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openDir(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenFileCommand
    extends WbCommand {
        OpenFileCommand() {
            super("commands.open.file");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openFile(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenOrdCommand
    extends WbCommand {
        OpenOrdCommand() {
            super("commands.open.ord");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openOrd(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenMenuCommand
    extends WbToggleCommand {
        public OpenMenuCommand() {
            super("commands.open");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    public class OpenMenuController
    implements BAbstractButton.MenuController {
        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton b) {
            return WbCommands.this.makeOpenMenu();
        }
    }

    public class PluginCommand
    extends WbCommand {
        private int id;

        public PluginCommand(int id) {
            super("commands." + BWbView.commandIdToString(id));
            this.id = id;
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbView view = WbCommands.this.shell.getActiveView();
            if (view != null) {
                return view.invokeCommand(this.id);
            }
            return null;
        }
    }

    public class WbToggleCommand
    extends ToggleCommand {
        public WbToggleCommand(String keyBase) {
            super((BWidget)WbCommands.this.shell, UiLexicon.bajaui().module, keyBase);
        }
    }

    public class WbCommand
    extends Command {
        public WbCommand(String keyBase) {
            super((BWidget)WbCommands.this.shell, UiLexicon.bajaui().module, keyBase);
        }
    }
}

