/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.user.BUserChannel;
import com.tridium.ui.Binder;
import com.tridium.workbench.nav.BFileMenuAgent;
import com.tridium.workbench.pathbar.BNavFilePA;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BPasswordResetDialog;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.NoViewRegisteredException;
import com.tridium.workbench.shell.ViewRestrictedException;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import java.io.IOException;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BWbView;

public class NHyperlinkInfo
extends HyperlinkInfo {
    static final AgentFilter pathBarAgentFilter = AgentFilter.is((Type)BPathBarAgent.TYPE);
    static Log log = Log.getLog((String)"wb.hyperlink");
    static BPathBarAgent[] noPathBarAgents = new BPathBarAgent[0];
    BWbProfile profile;
    BOrd currentOrd;
    boolean appendToHistory;
    BICredentials credentials;
    BNiagaraWbShell shell;
    BViewTab tab;
    WbHistory.Entry historyEntry;
    BImage icon;
    OrdQuery[] queries;
    boolean hasParent;
    OrdTarget target;
    BPermissions permissions;
    AgentList viewAgents;
    AgentInfo agent;
    BWbView view;
    Context context;
    BPathBarAgent[] pathBarAgents;
    String fault;
    static /* synthetic */ Class class$com$tridium$workbench$pathbar$BPathBarAgent;

    public static NHyperlinkInfo make(HyperlinkInfo info) {
        if (info instanceof NHyperlinkInfo) {
            return (NHyperlinkInfo)info;
        }
        return new NHyperlinkInfo(info.getOrd(), info.getMode(), true, null);
    }

    public NHyperlinkInfo(BOrd ord, BHyperlinkMode mode, boolean appendToHistory) {
        this(ord, mode, appendToHistory, null);
    }

    public NHyperlinkInfo(BOrd ord, BHyperlinkMode mode, boolean appendToHistory, BICredentials credentials) {
        super(ord, mode);
        this.appendToHistory = appendToHistory;
        this.credentials = credentials;
        if (log.isTraceOn()) {
            log.trace("--- NHyperlinkInfo(" + ord + ", " + mode + ", " + appendToHistory + ", " + credentials + ") ---");
        }
    }

    public void hyperlink(BViewTab tab) throws Throwable {
        this.tab = tab;
        this.shell = tab.shell;
        this.profile = this.shell.profile;
        try {
            this.currentOrd = tab.ord;
            this.resetTab();
            this.ord = this.normalizeOrd();
            this.hasParent = this.hasParent();
            this.historyEntry = this.appendToHistory();
            this.queries = this.parseOrd();
            this.target = this.resolve();
            this.icon = this.getIcon();
            this.permissions = this.getPermissions();
            this.viewAgents = this.getViewAgentsList();
            this.agent = this.getAgent();
            this.view = this.getView();
            this.context = this.getContext();
            this.pathBarAgents = this.makePathBarAgents();
            this.fault = this.getFault();
            this.updateTab();
            this.installView();
            this.activateView();
            this.loadView();
            this.view = this.profile.customizeView(this.view);
            this.startBinder();
        }
        finally {
            try {
                if (tab != null) {
                    tab.ord = this.ord;
                    tab.updateShell();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void resetTab() {
        if (log.isTraceOn()) {
            log.trace("resetTab: " + (Object)((Object)this.tab));
        }
        this.tab.stopView(true);
    }

    private BOrd normalizeOrd() {
        BOrd oldOrd = this.ord;
        BOrd newOrd = this.ord;
        try {
            BOrd n = this.ord;
            if (this.currentOrd != null) {
                n = BOrd.make((BOrd)this.currentOrd, (BOrd)n);
            }
            newOrd = n.normalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (log.isTraceOn()) {
            log.trace("normalizeOrd: " + oldOrd + " -> " + newOrd);
        }
        return newOrd;
    }

    private boolean hasParent() {
        boolean hasParent = false;
        try {
            hasParent = this.ord.getParent() != null && !this.ord.toString().startsWith("workbench:/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (log.isTraceOn()) {
            log.trace("hasParent: " + hasParent);
        }
        return hasParent;
    }

    private WbHistory.Entry appendToHistory() throws Exception {
        if (log.isTraceOn()) {
            log.trace("appendToHistory");
        }
        WbHistory.Entry historyEntry = null;
        if (this.appendToHistory) {
            historyEntry = this.tab.history.append(this.ord);
            BNiagaraWbShell.history.recentAdd(historyEntry);
        } else {
            this.tab.history.recentTouch(this.ord);
            BNiagaraWbShell.history.recentTouch(this.ord);
        }
        return historyEntry;
    }

    private OrdQuery[] parseOrd() throws Exception {
        if (log.isTraceOn()) {
            log.trace("parseOrd");
        }
        try {
            return this.ord.parse();
        }
        catch (Exception e) {
            throw new LocalizableException("bajaui", "errorPanel.invalidOrd", (Throwable)e);
        }
    }

    private OrdTarget resolve() throws Exception {
        if (!WbMain.isKioskAccessible(this.ord)) {
            throw new UnresolvedException("Local access denied in kiosk mode");
        }
        OrdTarget target = this.shell.resolve(this.ord, this.credentials);
        if (log.isTraceOn()) {
            log.trace("resolved: " + target.get().toDebugString());
        }
        if (target.get() instanceof BComponent) {
            BComponent comp = (BComponent)target.get();
            comp.lease();
        }
        BFoxSession s = null;
        if (target.get() instanceof BComponent && ((BComponent)target.get()).getSession() instanceof BFoxSession) {
            s = (BFoxSession)((BComponent)target.get()).getSession();
        } else if (target.get() instanceof BFoxSession) {
            s = (BFoxSession)target.get();
        } else {
            try {
                BISession session;
                BSpace space = target.getSpace();
                if (space != null && (session = space.getSession()) instanceof BFoxSession) {
                    s = (BFoxSession)session;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (s != null) {
            BFoxClientConnection c = s.getConnection();
            FoxSession fs = c.session();
            FoxMessage m = fs.getRemoteWelcome();
            BAbsTime exp = BAbsTime.make((long)m.getTime("passwordExpires", BAbsTime.NULL.getMillis()));
            boolean resetPassword = m.getBoolean("forceReset", false);
            if (!resetPassword && !exp.isNull() && fs.promptForPasswordReset) {
                if (BDialog.open((BWidget)this.shell, (String)"Password Expiration", (Object)("Your password expires " + exp + ".  Would you like to reset it now?"), (int)12, (BImage)BImage.make((String)"module://icons/x32/keys.png")) == 4) {
                    resetPassword = true;
                } else {
                    fs.promptForPasswordReset = false;
                }
            }
            if (resetPassword && fs.promptForPasswordReset) {
                boolean passwordReset = false;
                String errMsg = null;
                int loopCount = 0;
                while (!passwordReset) {
                    try {
                        ++loopCount;
                        BUserChannel userChannel = ((BFoxConnection)fs.conn()).getChannels().getUserChannel();
                        userChannel.fetchPrefs();
                        BPassword password = BPasswordResetDialog.open((BWidget)this.shell, userChannel.getPasswordStrength(), errMsg);
                        if (password != null) {
                            userChannel.setPassword(password, true);
                            fs.promptForPasswordReset = false;
                            passwordReset = true;
                            continue;
                        }
                        passwordReset = true;
                        throw new AuthenticationException("password not changed as required");
                    }
                    catch (AuthenticationException ae) {
                        this.ensureDisconnect(s);
                        throw ae;
                    }
                    catch (IOException ioe) {
                        this.ensureDisconnect(s);
                        throw ioe;
                    }
                    catch (Exception e) {
                        errMsg = e.getLocalizedMessage();
                        if (loopCount <= 100) continue;
                        this.ensureDisconnect(s);
                        throw e;
                    }
                }
            }
        }
        return target;
    }

    private void ensureDisconnect(BFoxSession s) {
        block3: {
            try {
                if (s != null) {
                    s.disconnect();
                }
            }
            catch (Exception e) {
                if (!log.isTraceOn()) break block3;
                log.trace("Cannot disconnect", (Throwable)e);
            }
        }
    }

    private BImage getIcon() {
        try {
            BImage icon = BImage.make((BIcon)this.target.get().getIcon());
            if (this.historyEntry != null) {
                this.historyEntry.icon = icon;
            }
            return icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BPermissions getPermissions() throws Exception {
        BPermissions permissions = this.target.getPermissionsForTarget();
        if (log.isTraceOn()) {
            log.trace("getPermissions: " + permissions);
        }
        return permissions;
    }

    private AgentList getViewAgentsList() throws Exception {
        BObject obj = this.target.get();
        AgentFilter filter = WbSys.getViewsFilter((BWidget)this.shell, obj);
        if (BFileMenuAgent.disable) {
            filter = AgentFilter.and((AgentFilter)filter, (BPermissions)this.permissions);
        }
        AgentList list = this.profile.getAgents(obj).filter(filter);
        if (log.isTraceOn()) {
            log.trace("getAgents: " + list);
        }
        if (list.size() == 0) {
            AgentList agents = this.target.get().getAgents().filter(WbSys.getBaseViewsFilter());
            if (agents.size() > 0) {
                throw new ViewRestrictedException(obj.getType());
            }
            throw new NoViewRegisteredException(obj.getType());
        }
        return list;
    }

    private AgentInfo getAgent() throws Exception {
        OrdQuery lastQuery;
        String viewId = null;
        if (this.queries.length > 0 && (lastQuery = this.queries[this.queries.length - 1]) instanceof ViewQuery) {
            viewId = ((ViewQuery)lastQuery).getViewId();
        }
        AgentInfo agent = null;
        agent = viewId == null && this.viewAgents.size() > 0 ? this.viewAgents.getDefault() : this.viewAgents.get(viewId);
        if (this.historyEntry != null && viewId != null) {
            this.historyEntry.ordNoView = BOrd.make((OrdQuery[])this.queries, (int)0, (int)(this.queries.length - 1));
            this.historyEntry.viewId = viewId;
        }
        if (agent == null) {
            System.out.println("No views accessible:");
            System.out.println("  ord:         " + this.ord);
            System.out.println("  target.type: " + this.target.get().getType());
            System.out.println("  target:      " + this.target.get());
            if (viewId != null) {
                throw new LocalizableRuntimeException("bajaui", "errorPanel.invalidView", new Object[]{viewId});
            }
            throw new LocalizableRuntimeException("bajaui", "errorPanel.noViews");
        }
        if (!this.permissions.has(agent.getRequiredPermissions())) {
            throw new PermissionException(this.permissions + " < " + agent.getRequiredPermissions());
        }
        if (log.isTraceOn()) {
            log.trace("getAgent: " + agent);
        }
        return agent;
    }

    private BWbView getView() throws Exception {
        BObject view = this.agent.getInstance();
        if (log.isTraceOn()) {
            log.trace("getView: " + view.toDebugString());
        }
        if (view instanceof BWbView) {
            return (BWbView)view;
        }
        if (view instanceof BAbstractPxView) {
            BWbPxView adapter = new BWbPxView((BAbstractPxView)view);
            return adapter;
        }
        throw new LocalizableRuntimeException("bajaui", "errorPanel.notWbView");
    }

    private Context getContext() throws Exception {
        try {
            BISession session = BOrd.toSession((BObject)this.target.get());
            if (session != null) {
                return session.getSessionContext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private BPathBarAgent[] makePathBarAgents() throws Exception {
        if (this.shell.getProfile().makeLocatorBar() == null) {
            return noPathBarAgents;
        }
        try {
            BObject obj;
            BISession session;
            if (this.shell.commands.pathBarUsesNavFile.isSelected() && (session = BOrd.toSession((BObject)(obj = this.target.get()))) != null) {
                BINavNode nav = session.getNavChild("navfile");
                BPathBarAgent[] navAgents = null;
                if (nav != null && (navAgents = BNavFilePA.make((BNavFileSpace)nav, this.target)) != null) {
                    return navAgents;
                }
            }
            Array acc = new Array(class$com$tridium$workbench$pathbar$BPathBarAgent == null ? (class$com$tridium$workbench$pathbar$BPathBarAgent = NHyperlinkInfo.class$("com.tridium.workbench.pathbar.BPathBarAgent")) : class$com$tridium$workbench$pathbar$BPathBarAgent);
            for (int i = 0; i < this.queries.length; ++i) {
                BOrd base = i == 0 ? BOrd.NULL : this.ord.getSubOrd(0, i);
                BPathBarAgent agent = this.makePathBarAgent(this.queries[i]);
                if (agent == null) continue;
                if (i == this.queries.length - 1) {
                    agent.setAgentOrd(base, this.queries[i], this.target.get());
                } else {
                    agent.setAgentOrd(base, this.queries[i]);
                }
                BPathBarAgent[] kids = agent.explode();
                for (int j = 0; j < kids.length; ++j) {
                    acc.add((Object)kids[j]);
                }
            }
            return (BPathBarAgent[])acc.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BPathBarAgent makePathBarAgent(OrdQuery query) {
        BOrdScheme scheme = BOrdScheme.lookup((String)query.getScheme());
        if (scheme.getType().is(BViewScheme.TYPE)) {
            return null;
        }
        AgentList list = scheme.getAgents().filter(pathBarAgentFilter);
        if (list.size() == 0) {
            return null;
        }
        return (BPathBarAgent)list.getDefault().getInstance();
    }

    private String getFault() throws Exception {
        BISession session;
        if (log.isTraceOn()) {
            log.trace("getFault");
        }
        if ((session = BOrd.toSession((BObject)this.target.get())) instanceof BFoxSession) {
            return ((BFoxSession)session).getStationFault();
        }
        return null;
    }

    private void updateTab() throws Exception {
        if (log.isTraceOn()) {
            log.trace("updateTab");
        }
        this.tab.ord = this.ord;
        this.tab.hasParent = this.hasParent;
        this.tab.target = this.target;
        this.tab.agents = this.viewAgents;
        this.tab.agent = this.agent;
        this.tab.view = this.view;
        this.tab.pathBarAgents = this.pathBarAgents;
        this.tab.fault = this.fault;
    }

    private void installView() {
        String tabName = BViewTabbedPane.toTabName(this.ord, this.target);
        if (log.isTraceOn()) {
            log.trace("installView: " + tabName);
        }
        BImage tabIcon = this.icon;
        BLabel label = this.tab.getLabel();
        if (tabIcon != null) {
            label.setImage(tabIcon);
        }
        label.setText(tabName);
        this.tab.setContent(this.view);
    }

    private void activateView() {
        if (log.isTraceOn()) {
            log.trace("activateView");
        }
        this.tab.fireActivated();
    }

    private void loadView() throws Throwable {
        if (log.isTraceOn()) {
            log.trace("loadView");
        }
        this.view.fw(403);
        this.view.loadValue(this.target.get(), this.context);
        if (this.view.getLoadError() != null) {
            throw this.view.getLoadError();
        }
        this.view.prime();
        this.shell.relayout();
        this.view.relayout();
    }

    private void startBinder() throws Throwable {
        Binder binder = (Binder)this.view.fw(302);
        binder.start(this.target, this.context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

