/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbLocatorBar;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BScrollingToolbarPane;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbLocatorBar;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbStatusBar;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BWbPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BWbPane == null ? (class$com$tridium$workbench$shell$BWbPane = BWbPane.class$("com.tridium.workbench.shell.BWbPane")) : class$com$tridium$workbench$shell$BWbPane));
    private static final Property[] noMenus = new Property[0];
    final BNiagaraWbShell shell;
    final BWbProfile profile;
    private BWidget menuBar;
    private Property[] mergedMenus = noMenus;
    private BScrollingToolbarPane toolBarPane;
    private Property mergedToolBar;
    private BWbLocatorBar locatorBar;
    BViewTabbedPane views;
    BSideBarPane sideBar;
    BConsole console;
    private BSplitPane hSplitPane;
    private BSplitPane vSplitPane;
    private BWbStatusBar statusBar;
    private BWidget statusBarSupplement;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BWbPane;

    public Type getType() {
        return TYPE;
    }

    public BWbPane() {
        throw new IllegalStateException();
    }

    public BWbPane(BNiagaraWbShell shell) {
        this.shell = shell;
        this.profile = shell.profile;
        this.setTop((BWidget)new BEdgePane());
        this.buildMenuBar();
        this.buildToolBar();
        this.buildLocatorBar();
        this.buildContent();
        this.buildStatusBar();
    }

    public void update(BViewTab tab) {
        try {
            this.updateMenuBar(tab);
            this.updateToolBar(tab);
            this.updateLocatorBar(tab);
            this.updateSideBars(tab);
            this.updateStatusBar(tab);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasMenu(String menuPath) {
        if (this.menuBar == null) {
            return false;
        }
        String[] names = TextUtil.split((String)menuPath, (char)'|');
        BWidget p = this.menuBar;
        for (int i = 0; i < names.length; ++i) {
            BComponent c = (BComponent)p.get(names[i]);
            if (c instanceof BSubMenuItem) {
                c = ((BSubMenuItem)c).getMenu();
            }
            if (c == null) {
                return false;
            }
            p = c;
        }
        return true;
    }

    BWidget getMenuBar() {
        return this.menuBar;
    }

    private void buildMenuBar() {
        this.menuBar = this.profile.makeMenuBar();
        if (this.menuBar == null) {
            return;
        }
        BMenu[] menus = ((BMenuBar)this.menuBar).getMenus();
        for (int i = 0; i < menus.length; ++i) {
            menus[i].removeConsecutiveSeparators();
        }
        BEdgePane top = (BEdgePane)this.getTop();
        if (this.shell.isApplet()) {
            this.menuBar = this.menuBarToDropDown(this.menuBar);
            BButton b = new BButton(UiLexicon.bajaui().getText("menu"));
            b.setMenuController((BAbstractButton.MenuController)new AppletMenuController());
            b.setButtonStyle(BButtonStyle.toolBar);
            top.setLeft((BWidget)b);
        } else {
            top.setTop(this.menuBar);
        }
    }

    private BMenu menuBarToDropDown(BWidget menuBar) {
        BMenu dropDown = new BMenu();
        BMenu[] menus = ((BMenuBar)menuBar).getMenus();
        for (int i = 0; i < menus.length; ++i) {
            BMenu m = menus[i];
            String name = m.getName();
            menuBar.remove((BComplex)m);
            dropDown.add(name, (BValue)new BSubMenuItem(m));
        }
        return dropDown;
    }

    private void updateMenuBar(BViewTab tab) {
        if (this.menuBar == null) {
            return;
        }
        for (int i = 0; i < this.mergedMenus.length; ++i) {
            BWbPane.unregisterFromCommands((BWidget)this.menuBar.get(this.mergedMenus[i]));
            this.menuBar.remove(this.mergedMenus[i]);
        }
        this.mergedMenus = noMenus;
        BMenu[] menus = null;
        try {
            if (tab.view != null) {
                menus = tab.view.getViewMenus();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (menus == null) {
            this.mergedMenus = noMenus;
        } else {
            BValue help = this.menuBar.get("help");
            if (help != null) {
                this.menuBar.remove("help");
            }
            this.mergedMenus = new Property[menus.length];
            for (int i = 0; i < menus.length; ++i) {
                this.mergedMenus[i] = this.addMenu("merge" + i, menus[i]);
            }
            if (help != null) {
                this.menuBar.add("help", help);
            }
        }
    }

    private Property addMenu(String name, BMenu menu) {
        if (this.menuBar instanceof BMenuBar) {
            return this.menuBar.add(name, (BValue)menu);
        }
        return this.menuBar.add(name, (BValue)new BSubMenuItem(menu));
    }

    private void buildToolBar() {
        BToolBar toolBar = this.profile.makeToolBar();
        if (toolBar == null) {
            return;
        }
        toolBar.removeConsecutiveSeparators();
        this.toolBarPane = new BScrollingToolbarPane(10, toolBar);
        BEdgePane pane = new BEdgePane();
        StyleUtils.addStyleClass((IStylable)pane, (String)"toolbar-container");
        if (this.menuBar instanceof BMenuBar) {
            BSeparator sep = new BSeparator(BOrientation.horizontal);
            sep.setStyleClasses("below-menu-bar");
            pane.setTop((BWidget)sep);
        }
        pane.setCenter((BWidget)this.toolBarPane);
        BEdgePane top = (BEdgePane)this.getTop();
        top.setCenter((BWidget)pane);
    }

    private void updateToolBar(BViewTab tab) {
        if (this.toolBarPane == null) {
            return;
        }
        if (this.mergedToolBar != null) {
            BWbPane.unregisterFromCommands((BWidget)this.toolBarPane.get(this.mergedToolBar));
            this.toolBarPane.removeMergedToolbar(this.mergedToolBar);
            this.mergedToolBar = null;
        }
        BToolBar toolBar = null;
        try {
            if (tab.view != null) {
                toolBar = tab.view.getViewToolBar();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (toolBar != null) {
            this.mergedToolBar = this.toolBarPane.addMergedToolbar(toolBar);
        }
        this.shell.commands.export.updateEnabled();
        this.toolBarPane.relayout();
    }

    private void buildLocatorBar() {
        this.locatorBar = this.profile.makeLocatorBar();
        if (this.locatorBar == null) {
            return;
        }
        BBorderPane locatorPane = new BBorderPane((BWidget)this.locatorBar, 3.0, 0.0, 3.0, 0.0);
        BEdgePane top = (BEdgePane)this.getTop();
        top.setBottom((BWidget)locatorPane);
    }

    private void updateLocatorBar(BViewTab tab) {
        try {
            if (this.locatorBar == null) {
                return;
            }
            if (this.locatorBar instanceof BNiagaraWbLocatorBar) {
                ((BNiagaraWbLocatorBar)this.locatorBar).update(tab);
            } else {
                this.locatorBar.activeViewChanged();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public double getSplitPosition() {
        return this.hSplitPane.getDividerPosition();
    }

    public void setSplitPosition(double pos) {
        if (this.sideBar != null) {
            this.hSplitPane.setDividerPosition(pos);
        }
    }

    void setSideBarVisible(boolean visible) {
        if (this.sideBar != null) {
            this.sideBar.setVisible(visible);
            this.hSplitPane.relayout();
        }
    }

    void setConsoleVisible(boolean visible) {
        if (this.console != null) {
            this.console.setVisible(visible);
            this.vSplitPane.relayout();
        }
    }

    private void updateSideBars(BViewTab tab) {
        if (this.sideBar != null) {
            BWbSideBar[] bars = this.sideBar.list();
            for (int i = 0; i < bars.length; ++i) {
                try {
                    bars[i].activeViewChanged();
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void buildContent() {
        this.views = new BViewTabbedPane(this.shell, this);
        this.hSplitPane = new BSplitPane(BOrientation.horizontal, 30.0);
        if (this.profile.hasSideBar()) {
            this.sideBar = this.shell.makeSideBar();
            this.sideBar.shell = this.shell;
            this.sideBar.setVisible(false);
            this.hSplitPane.setWidget1((BWidget)this.sideBar);
        } else {
            this.hSplitPane.getWidget1().setVisible(false);
        }
        this.hSplitPane.setWidget2((BWidget)this.views);
        this.console = new BConsole(this.shell);
        this.console.setVisible(false);
        this.vSplitPane = new BSplitPane(BOrientation.vertical, 85.0);
        this.vSplitPane.setWidget1((BWidget)this.hSplitPane);
        this.vSplitPane.setWidget2((BWidget)this.console);
        StyleUtils.addStyleClass((IStylable)this.vSplitPane, (String)"lower-split");
        this.setCenter((BWidget)this.vSplitPane);
    }

    public void showStatus(String msg) {
        if (this.statusBar == null) {
            return;
        }
        this.statusBar.showStatus(msg);
        this.statusBar.repaint();
    }

    private void buildStatusBar() {
        this.statusBar = this.profile.makeStatusBar();
        if (this.statusBar == null) {
            return;
        }
        this.setBottom((BWidget)this.statusBar);
    }

    private void updateStatusBar(BViewTab tab) {
        if (this.statusBar == null) {
            return;
        }
        BWidget statusBarSupplement = null;
        if (tab.view != null) {
            statusBarSupplement = tab.view.getViewStatusBarSupplement();
        }
        if (statusBarSupplement == null) {
            statusBarSupplement = new BNullWidget();
        }
        this.statusBar.setSupplement(statusBarSupplement);
    }

    static void unregisterFromCommands(BWidget w) {
        if (w instanceof BAbstractButton) {
            ((BAbstractButton)w).setCommand(null, false, false);
        } else if (w instanceof BMenuItem) {
            ((BMenuItem)w).setCommand(null);
        }
        BWidget[] kids = w.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            BWbPane.unregisterFromCommands(kids[i]);
        }
    }

    public BSideBarPane getSideBar() {
        return this.sideBar;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AppletMenuController
    implements BAbstractButton.MenuController {
        AppletMenuController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton button) {
            return (BMenu)BWbPane.this.menuBar;
        }
    }
}

