/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.sys.Nre;
import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.util.CommandLineArguments;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.WbOptionsManager;
import javax.baja.naming.BHost;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.options.OptionsManager;

public class BWbApplication
extends BNiagaraWidgetApplication {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BWbApplication == null ? (class$com$tridium$workbench$shell$BWbApplication = BWbApplication.class$("com.tridium.workbench.shell.BWbApplication")) : class$com$tridium$workbench$shell$BWbApplication));
    static boolean needAutoLogoff = true;
    public static LogoffListener logOffListener;
    boolean applet;
    WbOptionsManager optionsManager = new WbOptionsManager(this);
    static /* synthetic */ Class class$com$tridium$workbench$shell$BWbApplication;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public boolean useAntiAlias() {
        return true;
    }

    public boolean isApplet() {
        return this.applet;
    }

    public void checkInputActivity(long inactivity) {
        super.checkInputActivity(inactivity);
        BGeneralOptions options = BGeneralOptions.make();
        boolean logoffEnabled = options.getAutoLogoffEnabled();
        long logoffPeriod = options.getAutoLogoffPeriod().getMillis();
        if (logoffEnabled && inactivity > logoffPeriod) {
            if (needAutoLogoff) {
                inputMonitorLog.message("Auto Logoff (" + logoffPeriod / 1000L + "sec)");
                needAutoLogoff = false;
                BWbApplication.autoLogoff();
            }
        } else {
            needAutoLogoff = true;
        }
    }

    public static void autoLogoff() {
        if (logOffListener != null) {
            logOffListener.logoff();
        }
        BHost[] hosts = BHost.getAllHosts();
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i].disconnect();
        }
        BWidgetShell[] shells = BWidget.getApplication().getShells();
        for (int i = 0; i < shells.length; ++i) {
            if (!(shells[i] instanceof BNiagaraWbShell)) continue;
            ((BNiagaraWbShell)shells[i]).autoLogoff();
        }
    }

    public void restart() {
        BWidgetShell[] shells = this.getShells();
        StringBuffer paramStr = new StringBuffer();
        for (int ixShell = 0; ixShell < shells.length; ++ixShell) {
            paramStr.append("\"");
            if (shells[ixShell] instanceof BNiagaraWbShell) {
                BViewTab[] tabs = ((BNiagaraWbShell)shells[ixShell]).pane.views.getTabs();
                int selectedIdx = 0;
                for (int i = 0; i < tabs.length; ++i) {
                    if (i > 0) {
                        paramStr.append(';');
                    }
                    paramStr.append(tabs[i].getOrd());
                    if (!tabs[i].isVisible()) continue;
                    selectedIdx = i;
                }
                if (selectedIdx > 0) {
                    paramStr.append(";tab:" + selectedIdx);
                }
            }
            paramStr.append("\" ");
        }
        this.restart(new String[0], paramStr.toString());
    }

    public void restart(String[] options, String params) {
        try {
            int i;
            if ((params == null || params.equals("")) && Nre.args.parameters.length > 0) {
                params = Nre.args.parameters[0];
            }
            if (params == null) {
                params = "";
            }
            CommandLineArguments opts = new CommandLineArguments(options);
            Array usedOpts = new Array(class$java$lang$String == null ? (class$java$lang$String = BWbApplication.class$("java.lang.String")) : class$java$lang$String);
            StringBuffer newOptions = new StringBuffer();
            String[] cmdLineOpts = Nre.args.options;
            for (i = 0; i < cmdLineOpts.length; ++i) {
                String optValue = opts.getOption(cmdLineOpts[i]);
                if (optValue == null) {
                    optValue = Nre.args.getOption(cmdLineOpts[i]);
                } else {
                    usedOpts.add((Object)cmdLineOpts[i]);
                }
                newOptions.append(" -" + cmdLineOpts[i] + ":" + optValue);
            }
            for (i = 0; i < opts.options.length; ++i) {
                if (usedOpts.contains((Object)opts.options[i])) continue;
                newOptions.append(" -" + opts.options[i] + ":" + opts.getOption(opts.options[i]));
            }
            Runtime.getRuntime().exec("wb " + newOptions.toString() + " " + params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public OptionsManager getOptionsManager() {
        return this.optionsManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface LogoffListener {
        public void logoff();
    }
}

